import * as React from 'react';
import { classNames, variationName } from '@shopify/react-utilities/styles';
import { withAppProvider } from '../AppProvider';
import VisuallyHidden from '../VisuallyHidden';
import styles from './Badge.scss';
export const PROGRESS_LABELS = {
    incomplete: 'incomplete',
    partiallyComplete: 'partiallyComplete',
    complete: 'complete',
};
export const STATUS_LABELS = {
    info: 'info',
    success: 'success',
    warning: 'warning',
    attention: 'attention',
    new: 'new',
};
const DEFAULT_SIZE = 'medium';
function Badge({ children, status, progress, size = DEFAULT_SIZE, polaris: { intl }, }) {
    const className = classNames(styles.Badge, status && styles[variationName('status', status)], progress && styles[variationName('progress', progress)], size && size !== DEFAULT_SIZE && styles[variationName('size', size)]);
    let progressMarkup;
    switch (progress) {
        case PROGRESS_LABELS.incomplete:
            progressMarkup = intl.translate('Polaris.Badge.PROGRESS_LABELS.incomplete');
            break;
        case PROGRESS_LABELS.partiallyComplete:
            progressMarkup = intl.translate('Polaris.Badge.PROGRESS_LABELS.partiallyComplete');
            break;
        case PROGRESS_LABELS.complete:
            progressMarkup = intl.translate('Polaris.Badge.PROGRESS_LABELS.complete');
            break;
    }
    const pipMarkup = progress ? (<span className={styles.Pip}>
      <VisuallyHidden>{progressMarkup}</VisuallyHidden>
    </span>) : null;
    let statusMarkup;
    switch (status) {
        case STATUS_LABELS.info:
            statusMarkup = intl.translate('Polaris.Badge.STATUS_LABELS.info');
            break;
        case STATUS_LABELS.success:
            statusMarkup = intl.translate('Polaris.Badge.STATUS_LABELS.success');
            break;
        case STATUS_LABELS.warning:
            statusMarkup = intl.translate('Polaris.Badge.STATUS_LABELS.warning');
            break;
        case STATUS_LABELS.attention:
            statusMarkup = intl.translate('Polaris.Badge.STATUS_LABELS.attention');
            break;
        case STATUS_LABELS.new:
            statusMarkup = intl.translate('Polaris.Badge.STATUS_LABELS.new');
            break;
    }
    const statusLabelMarkup = status ? (<VisuallyHidden>{statusMarkup}</VisuallyHidden>) : null;
    return (<span className={className}>
      {statusLabelMarkup}
      {pipMarkup}
      {children}
    </span>);
}
export default withAppProvider()(Badge);
