import * as React from 'react';
import { classNames } from '@shopify/react-utilities/styles';
import { elementChildren } from '@shopify/react-utilities';
import { Item } from './components';
import styles from './ButtonGroup.scss';
export default function ButtonGroup({ children, segmented, fullWidth, connectedTop, }) {
    const className = classNames(styles.ButtonGroup, segmented && styles.segmented, fullWidth && styles.fullWidth, connectedTop && styles.connectedTop);
    const contents = elementChildren(children).map((child, index) => (<Item button={child} key={index}/>));
    return <div className={className}>{contents}</div>;
}
