import * as React from 'react';
import { classNames } from '@shopify/react-utilities/styles';
import styles from '../../ButtonGroup.scss';
export default class Item extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.state = { focused: false };
        this.handleFocus = () => {
            this.setState({ focused: true });
        };
        this.handleBlur = () => {
            this.setState({ focused: false });
        };
    }
    render() {
        const { button } = this.props;
        const { focused } = this.state;
        const className = classNames(styles.Item, focused && styles['Item-focused'], button.props.plain && styles['Item-plain']);
        return (<div className={className} onFocus={this.handleFocus} onBlur={this.handleBlur}>
        {button}
      </div>);
    }
}
