import * as React from 'react';
import { classNames } from '@shopify/react-utilities/styles';
import { contentContextTypes } from '../../types';
import { buttonFrom } from '../Button';
import ButtonGroup from '../ButtonGroup';
import { Header, Section } from './components';
import styles from './Card.scss';
export default class Card extends React.PureComponent {
    getChildContext() {
        return {
            withinContentContainer: true,
        };
    }
    render() {
        const { children, title, subdued, sectioned, actions, primaryFooterAction, secondaryFooterAction, } = this.props;
        const className = classNames(styles.Card, subdued && styles.subdued);
        const headerMarkup = title || actions ? <Header actions={actions} title={title}/> : null;
        const content = sectioned ? <Section>{children}</Section> : children;
        const primaryFooterActionMarkup = primaryFooterAction
            ? buttonFrom(primaryFooterAction, { primary: true })
            : null;
        const secondaryFooterActionMarkup = secondaryFooterAction
            ? buttonFrom(secondaryFooterAction)
            : null;
        const footerMarkup = primaryFooterActionMarkup || secondaryFooterActionMarkup ? (<div className={styles.Footer}>
          <ButtonGroup>
            {secondaryFooterActionMarkup}
            {primaryFooterActionMarkup}
          </ButtonGroup>
        </div>) : null;
        return (<div className={className}>
        {headerMarkup}
        {content}
        {footerMarkup}
      </div>);
    }
}
Card.Section = Section;
Card.Header = Header;
Card.childContextTypes = contentContextTypes;
