import * as React from 'react';
import { classNames } from '@shopify/react-utilities/styles';
import styles from '../../Connected.scss';
export var ItemPosition;
(function (ItemPosition) {
    ItemPosition[ItemPosition["Left"] = 0] = "Left";
    ItemPosition[ItemPosition["Primary"] = 1] = "Primary";
    ItemPosition[ItemPosition["Right"] = 2] = "Right";
})(ItemPosition || (ItemPosition = {}));
export default class Item extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.state = { focused: false };
        this.handleBlur = () => {
            this.setState({ focused: false });
        };
        this.handleFocus = () => {
            this.setState({ focused: true });
        };
    }
    render() {
        const { focused } = this.state;
        const { children, position } = this.props;
        const className = classNames(styles.Item, focused && styles['Item-focused'], position === ItemPosition.Primary
            ? styles['Item-primary']
            : styles['Item-connection']);
        return (<div onBlur={this.handleBlur} onFocus={this.handleFocus} className={className}>
        {children}
      </div>);
    }
}
