import * as React from 'react';
import isEqual from 'lodash/isEqual';
import { frameContextTypes, } from '../Frame';
class ContextualSaveBar extends React.PureComponent {
    componentDidMount() {
        this.context.frame.setContextualSaveBar(this.props);
    }
    componentWillUnmount() {
        this.context.frame.removeContextualSaveBar();
    }
    componentDidUpdate(oldProps) {
        if (contextualSaveBarHasChanged(this.props, oldProps)) {
            this.context.frame.setContextualSaveBar(this.props);
        }
    }
    render() {
        return null;
    }
}
ContextualSaveBar.contextTypes = frameContextTypes;
function contextualSaveBarHasChanged({ message, saveAction, discardAction }, { message: oldMessage, saveAction: oldsaveAction, discardAction: oldDiscardAction, }) {
    return Boolean(message !== oldMessage ||
        !isEqual(saveAction, oldsaveAction) ||
        !isEqual(discardAction, oldDiscardAction));
}
export default ContextualSaveBar;
