import * as React from 'react';
import { ChevronLeftMinor, ChevronRightMinor } from '@shopify/polaris-icons';
import { classNames } from '@shopify/react-utilities/styles';
import { withAppProvider } from '../../../AppProvider';
import Button from '../../../Button';
import styles from '../../DataTable.scss';
function Navigation({ columnVisibilityData, isScrolledFarthestLeft, isScrolledFarthestRight, navigateTableLeft, navigateTableRight, polaris: { intl: { translate }, }, }) {
    const pipMarkup = columnVisibilityData.map((column, index) => {
        const className = classNames(styles.Pip, column.isVisible && styles['Pip-visible']);
        return <div className={className} key={`pip-${index}`}/>;
    });
    const leftA11yLabel = translate('Polaris.DataTable.navAccessibilityLabel', {
        direction: 'left',
    });
    const rightA11yLabel = translate('Polaris.DataTable.navAccessibilityLabel', {
        direction: 'right',
    });
    return (<div className={styles.Navigation}>
      <Button plain icon={ChevronLeftMinor} disabled={isScrolledFarthestLeft} accessibilityLabel={leftA11yLabel} onClick={navigateTableLeft}/>
      {pipMarkup}
      <Button plain icon={ChevronRightMinor} disabled={isScrolledFarthestRight} accessibilityLabel={rightA11yLabel} onClick={navigateTableRight}/>
    </div>);
}
export default withAppProvider()(Navigation);
