import * as React from 'react';
import { classNames, variationName } from '@shopify/react-utilities/styles';
import styles from './DisplayText.scss';
export default function DisplayText({ element: Element = 'p', children, size = 'medium', }) {
    const className = classNames(styles.DisplayText, size && styles[variationName('size', size)]);
    return <Element className={className}>{children}</Element>;
}
