import * as React from 'react';
import { classNames } from '@shopify/react-utilities/styles';
import Image from '../Image';
import { buttonFrom } from '../Button';
import Stack from '../Stack';
import TextContainer from '../TextContainer';
import DisplayText from '../DisplayText';
import styles from './EmptyState.scss';
export default class EmptyState extends React.PureComponent {
    render() {
        const { children, heading, image, largeImage, imageContained, action, secondaryAction, footerContent, } = this.props;
        const className = classNames(styles.EmptyState, imageContained && styles.imageContained);
        const imageMarkup = largeImage ? (<Image alt="" role="presentation" className={styles.Image} source={largeImage} sourceSet={[
            { source: image, descriptor: '568w' },
            { source: largeImage, descriptor: '1136w' },
        ]} sizes="(max-width: 568px) 60vw"/>) : (<Image role="presentation" alt="" className={styles.Image} source={image}/>);
        const secondaryActionMarkup = secondaryAction
            ? buttonFrom(secondaryAction, { plain: true })
            : null;
        const footerContentMarkup = footerContent ? (<div className={styles.FooterContent}>
        <TextContainer>{footerContent}</TextContainer>
      </div>) : null;
        return (<div className={className}>
        <div className={styles.Section}>
          <div className={styles.DetailsContainer}>
            <div className={styles.Details}>
              <TextContainer>
                <DisplayText size="medium">{heading}</DisplayText>
                <div className={styles.Content}>{children}</div>
              </TextContainer>

              <div className={styles.Actions}>
                <Stack alignment="center">
                  {buttonFrom(action, { primary: true, size: 'large' })}
                  {secondaryActionMarkup}
                </Stack>
              </div>
              {footerContentMarkup}
            </div>
          </div>

          <div className={styles.ImageContainer}>{imageMarkup}</div>
        </div>
      </div>);
    }
}
