import * as tslib_1 from "tslib";
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import isEqual from 'lodash/isEqual';
import { focusFirstFocusableNode } from '@shopify/javascript-utilities/focus';
export default class Focus extends React.PureComponent {
    componentDidMount() {
        this.handleSelfFocus();
    }
    componentDidUpdate(_a) {
        var { children: prevChildren } = _a, restPrevProps = tslib_1.__rest(_a, ["children"]);
        const _b = this.props, { children } = _b, restProps = tslib_1.__rest(_b, ["children"]);
        if (isEqual(restProps, restPrevProps)) {
            return;
        }
        this.handleSelfFocus();
    }
    handleSelfFocus() {
        if (this.props.disabled) {
            return;
        }
        const root = ReactDOM.findDOMNode(this);
        if (root) {
            if (!root.querySelector('[autofocus]')) {
                focusFirstFocusableNode(root, false);
            }
        }
    }
    render() {
        const { children } = this.props;
        return <React.Fragment>{children}</React.Fragment>;
    }
}
