import * as React from 'react';
import VisuallyHidden from '../VisuallyHidden';
export default class Form extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.handleSubmit = (event) => {
            const { preventDefault = true, onSubmit } = this.props;
            if (!preventDefault) {
                return;
            }
            event.preventDefault();
            onSubmit(event);
        };
    }
    render() {
        const { acceptCharset, action, autoComplete, children, encType, implicitSubmit = true, method = 'post', name, noValidate, target, } = this.props;
        const autoCompleteInputs = normalizeAutoComplete(autoComplete);
        const submitMarkup = implicitSubmit ? (<VisuallyHidden>
        <button type="submit" aria-hidden="true"/>
      </VisuallyHidden>) : null;
        return (<form acceptCharset={acceptCharset} action={action} autoComplete={autoCompleteInputs} encType={encType} method={method} name={name} noValidate={noValidate} target={target} onSubmit={this.handleSubmit}>
        {children}
        {submitMarkup}
      </form>);
    }
}
function normalizeAutoComplete(autoComplete) {
    if (autoComplete == null) {
        return autoComplete;
    }
    return autoComplete ? 'on' : 'off';
}
