import * as React from 'react';
import { withAppProvider, } from '../../../../../AppProvider';
import Modal from '../../../../../Modal';
function DiscardConfirmationModal({ open, onDiscard, onCancel, polaris: { intl }, }) {
    return (<Modal title={intl.translate('Polaris.DiscardConfirmationModal.title')} open={open} onClose={onCancel} primaryAction={{
        content: intl.translate('Polaris.DiscardConfirmationModal.primaryAction'),
        destructive: true,
        onAction: onDiscard,
    }} secondaryActions={[
        {
            content: intl.translate('Polaris.DiscardConfirmationModal.secondaryAction'),
            onAction: onCancel,
        },
    ]} sectioned>
      {intl.translate('Polaris.DiscardConfirmationModal.message')}
    </Modal>);
}
export default withAppProvider()(DiscardConfirmationModal);
