import * as React from 'react';
import { classNames, variationName } from '@shopify/react-utilities/styles';
import { PlusMinor, AlertMinor, ArrowDownMinor, ArrowLeftMinor, ArrowRightMinor, ArrowUpMinor, ArrowUpDownMinor, CalendarMinor, MobileCancelMajorMonotone, CancelSmallMinor, CaretDownMinor, CaretUpMinor, TickSmallMinor, ChevronDownMinor, ChevronLeftMinor, ChevronRightMinor, ChevronUpMinor, CircleCancelMinor, CircleChevronDownMinor, CircleChevronLeftMinor, CircleChevronRightMinor, CircleChevronUpMinor, CircleInformationMajorTwotone, CirclePlusMinor, CirclePlusOutlineMinor, ConversationMinor, DeleteMinor, CircleDisableMinor, DisputeMinor, DuplicateMinor, EmbedMinor, ExportMinor, ExternalMinor, QuestionMarkMajorTwotone, HomeMajorMonotone, HorizontalDotsMinor, ImportMinor, LogOutMinor, MobileHamburgerMajorMonotone, NoteMinor, NotificationMajorMonotone, OnlineStoreMajorTwotone, OrdersMajorTwotone, PrintMinor, ProductsMajorTwotone, ProfileMinor, MinusMinor, RefreshMinor, RiskMinor, SaveMinor, SearchMinor, ViewMinor, } from '@shopify/polaris-icons';
import { withAppProvider } from '../AppProvider';
import styles from './Icon.scss';
export const BUNDLED_ICONS = {
    add: PlusMinor,
    alert: AlertMinor,
    arrowDown: ArrowDownMinor,
    arrowLeft: ArrowLeftMinor,
    arrowRight: ArrowRightMinor,
    arrowUp: ArrowUpMinor,
    arrowUpDown: ArrowUpDownMinor,
    calendar: CalendarMinor,
    cancel: MobileCancelMajorMonotone,
    cancelSmall: CancelSmallMinor,
    caretDown: CaretDownMinor,
    caretUp: CaretUpMinor,
    checkmark: TickSmallMinor,
    chevronDown: ChevronDownMinor,
    chevronLeft: ChevronLeftMinor,
    chevronRight: ChevronRightMinor,
    chevronUp: ChevronUpMinor,
    circleCancel: CircleCancelMinor,
    circleChevronDown: CircleChevronDownMinor,
    circleChevronLeft: CircleChevronLeftMinor,
    circleChevronRight: CircleChevronRightMinor,
    circleChevronUp: CircleChevronUpMinor,
    circleInformation: CircleInformationMajorTwotone,
    circlePlus: CirclePlusMinor,
    circlePlusOutline: CirclePlusOutlineMinor,
    conversation: ConversationMinor,
    delete: DeleteMinor,
    disable: CircleDisableMinor,
    dispute: DisputeMinor,
    duplicate: DuplicateMinor,
    embed: EmbedMinor,
    export: ExportMinor,
    external: ExternalMinor,
    help: QuestionMarkMajorTwotone,
    home: HomeMajorMonotone,
    horizontalDots: HorizontalDotsMinor,
    import: ImportMinor,
    logOut: LogOutMinor,
    menu: MobileHamburgerMajorMonotone,
    notes: NoteMinor,
    notification: NotificationMajorMonotone,
    onlineStore: OnlineStoreMajorTwotone,
    orders: OrdersMajorTwotone,
    print: PrintMinor,
    products: ProductsMajorTwotone,
    profile: ProfileMinor,
    refresh: RefreshMinor,
    risk: RiskMinor,
    save: SaveMinor,
    search: SearchMinor,
    subtract: MinusMinor,
    view: ViewMinor,
};
const COLORS_WITH_BACKDROPS = [
    'teal',
    'tealDark',
    'greenDark',
    'redDark',
    'yellowDark',
    'ink',
    'inkLighter',
];
function Icon({ source, color, backdrop, accessibilityLabel, untrusted = false, polaris: { intl }, }) {
    if (color && backdrop && COLORS_WITH_BACKDROPS.indexOf(color) < 0) {
        // eslint-disable-next-line no-console
        console.warn(intl.translate('Polaris.Icon.backdropWarning', {
            color,
            colorsWithBackDrops: COLORS_WITH_BACKDROPS.join(', '),
        }));
    }
    const className = classNames(styles.Icon, color && styles[variationName('color', color)], color && color !== 'white' && styles.isColored, backdrop && styles.hasBackdrop);
    const defaultIconProps = {
        className: styles.Svg,
        focusable: 'false',
        'aria-hidden': 'true',
    };
    if (untrusted) {
        // eslint-disable-next-line no-console
        console.warn('Deprecation: The untrusted prop is no longer needed, all strings passed into the Icon component are rendered as unsafe');
    }
    let SourceComponent = source;
    let contentMarkup;
    if (source === 'placeholder') {
        contentMarkup = <div className={styles.Placeholder}/>;
    }
    else if (isBundledIcon(source)) {
        SourceComponent = BUNDLED_ICONS[source];
        contentMarkup = <SourceComponent {...defaultIconProps}/>;
    }
    else if (typeof source === 'function') {
        const sourceElement = <SourceComponent {...defaultIconProps}/>;
        if (React.isValidElement(sourceElement)) {
            contentMarkup = sourceElement;
        }
    }
    else if (React.isValidElement(source)) {
        // eslint-disable-next-line no-console
        console.warn('Deprecation: passing a React Element to the Icon component is deprecated and will be removed in the next major version. Pass a React Component instead.');
        contentMarkup = source;
    }
    else if (isUntrustedSVG(source)) {
        contentMarkup = (<img className={styles.Img} src={`data:image/svg+xml;utf8,${source}`} alt="" aria-hidden="true"/>);
    }
    else if (isSVGSource(source)) {
        contentMarkup = renderSVG(source);
    }
    return (<span className={className} aria-label={accessibilityLabel}>
      {contentMarkup}
    </span>);
}
function renderSVG(iconSource) {
    return (<svg className={styles.Svg} viewBox={iconSource.viewBox} dangerouslySetInnerHTML={{ __html: iconSource.body }} focusable="false" aria-hidden="true"/>);
}
function isBundledIcon(key) {
    return typeof key === 'string' && Object.keys(BUNDLED_ICONS).includes(key);
}
function isSVGSource(source) {
    return (source != null &&
        source.hasOwnProperty('viewBox') &&
        source.hasOwnProperty('body'));
}
function isUntrustedSVG(source) {
    return typeof source === 'string';
}
export default withAppProvider()(Icon);
