import * as React from 'react';
import { classNames } from '@shopify/react-utilities/styles';
import styles from './Label.scss';
export function labelID(id) {
    return `${id}Label`;
}
export default function Label({ children, id, hidden }) {
    const className = classNames(styles.Label, hidden && styles.hidden);
    return (<div className={className}>
      <label id={labelID(id)} htmlFor={id} className={styles.Text}>
        {children}
      </label>
    </div>);
}
