import * as React from 'react';
import { Loading as AppBridgeLoading } from '@shopify/app-bridge/actions';
import { frameContextTypes } from '../Frame';
import { withAppProvider } from '../AppProvider';
export class Loading extends React.PureComponent {
    componentDidMount() {
        const { appBridge } = this.props.polaris;
        if (appBridge == null) {
            this.context.frame.startLoading();
        }
        else {
            this.appBridgeLoading = AppBridgeLoading.create(appBridge);
            this.appBridgeLoading.dispatch(AppBridgeLoading.Action.START);
        }
    }
    componentWillUnmount() {
        const { appBridge } = this.props.polaris;
        if (appBridge == null) {
            this.context.frame.stopLoading();
        }
        else if (this.appBridgeLoading != null) {
            this.appBridgeLoading.dispatch(AppBridgeLoading.Action.STOP);
        }
    }
    render() {
        return null;
    }
}
Loading.contextTypes = frameContextTypes;
export default withAppProvider()(Loading);
