import * as React from 'react';
import Scrollable from '../Scrollable';
import { UserMenu, Section, Item } from './components';
import { contextTypes } from './types';
import styles from './Navigation.scss';
export default class Navigation extends React.Component {
    constructor(props) {
        super(props);
        if (props.userMenu) {
            // eslint-disable-next-line no-console
            console.warn('Deprecation: the `userMenu` prop is deprecated and will be removed in the next major version. Pass a user menu into <TopBar /> instead.');
        }
    }
    getChildContext() {
        return {
            location: this.props.location,
            onNavigationDismiss: this.props.onDismiss,
        };
    }
    render() {
        const { children, userMenu, contextControl } = this.props;
        const contextControlMarkup = contextControl && (<div className={styles.ContextControl}>{contextControl}</div>);
        return (<nav className={styles.Navigation}>
        {contextControlMarkup}
        <div className={styles.UserMenu}>{userMenu}</div>
        <Scrollable className={styles.PrimaryNavigation}>{children}</Scrollable>
      </nav>);
    }
}
Navigation.Item = Item;
Navigation.UserMenu = UserMenu;
Navigation.Section = Section;
Navigation.childContextTypes = contextTypes;
