import * as React from 'react';
import { createUniqueIDFactory } from '@shopify/javascript-utilities/other';
import Collapsible from '../../../../../Collapsible';
import styles from '../../../../Navigation.scss';
const createSecondaryNavigationId = createUniqueIDFactory('SecondaryNavigation');
export default function Secondary({ children, expanded }) {
    const secondaryNavigationId = createSecondaryNavigationId();
    return (<Collapsible id={secondaryNavigationId} open={expanded}>
      <ul className={styles.List}>{children}</ul>
    </Collapsible>);
}
