import * as React from 'react';
import { TickSmallMinor } from '@shopify/polaris-icons';
import { classNames } from '@shopify/react-utilities/styles';
import { createUniqueIDFactory } from '@shopify/javascript-utilities/other';
import Icon from '../../../Icon';
import styles from './Checkbox.scss';
const getUniqueID = createUniqueIDFactory('Checkbox');
export default function Checkbox({ id = getUniqueID(), checked = false, disabled, active, onChange, name, value, role, }) {
    const className = classNames(styles.Checkbox, active && styles.active);
    return (<div className={className}>
      <input id={id} name={name} value={value} type="checkbox" checked={checked} disabled={disabled} className={styles.Input} aria-checked={checked} onChange={onChange} role={role}/>
      <div className={styles.Backdrop}/>
      <div className={styles.Icon}>
        <Icon source={TickSmallMinor}/>
      </div>
    </div>);
}
