import * as tslib_1 from "tslib";
import * as React from 'react';
import isEqual from 'lodash/isEqual';
import { classNames } from '@shopify/react-utilities/styles';
import { Button as AppBridgeButton, TitleBar as AppBridgeTitleBar, } from '@shopify/app-bridge/actions';
import { transformActions, generateRedirect, } from '../../utilities/app-bridge-transformers';
import pick from '../../utilities/pick';
import { withAppProvider } from '../AppProvider';
import { Header } from './components';
import styles from './Page.scss';
const APP_BRIDGE_PROPS = [
    'title',
    'breadcrumbs',
    'secondaryActions',
    'actionGroups',
    'primaryAction',
];
export class Page extends React.PureComponent {
    componentDidMount() {
        if (this.delegateToAppbridge === false) {
            return;
        }
        this.titlebar = AppBridgeTitleBar.create(this.props.polaris.appBridge, this.transformProps());
    }
    componentDidUpdate(prevProps) {
        if (this.titlebar == null || this.delegateToAppbridge === false) {
            return;
        }
        const prevAppBridgeProps = pick(prevProps, APP_BRIDGE_PROPS);
        const currentAppBridgeProps = pick(this.props, APP_BRIDGE_PROPS);
        if (!isEqual(prevAppBridgeProps, currentAppBridgeProps)) {
            this.titlebar.unsubscribe();
            this.titlebar.set(this.transformProps());
        }
    }
    componentWillUnmount() {
        if (this.titlebar == null || this.delegateToAppbridge === false) {
            return;
        }
        this.titlebar.unsubscribe();
    }
    render() {
        const _a = this.props, { children, fullWidth, singleColumn } = _a, rest = tslib_1.__rest(_a, ["children", "fullWidth", "singleColumn"]);
        const className = classNames(styles.Page, fullWidth && styles.fullWidth, singleColumn && styles.singleColumn);
        const headerMarkup = this.delegateToAppbridge || this.hasHeaderContent() === false ? null : (<Header {...rest}/>);
        return (<div className={className}>
        {headerMarkup}
        <div className={styles.Content}>{children}</div>
      </div>);
    }
    get delegateToAppbridge() {
        const { polaris: { appBridge }, forceRender = false, } = this.props;
        return appBridge != null && forceRender === false;
    }
    hasHeaderContent() {
        const { title, primaryAction, secondaryActions, actionGroups, breadcrumbs, } = this.props;
        return ((title != null && title !== '') ||
            primaryAction != null ||
            (secondaryActions != null && secondaryActions.length > 0) ||
            (actionGroups != null && actionGroups.length > 0) ||
            (breadcrumbs != null && breadcrumbs.length > 0));
    }
    transformProps() {
        const { appBridge } = this.props.polaris;
        const { title, primaryAction, secondaryActions, actionGroups } = this.props;
        return {
            title,
            buttons: transformActions(appBridge, {
                primaryAction,
                secondaryActions,
                actionGroups,
            }),
            breadcrumbs: this.transformBreadcrumbs(),
        };
    }
    transformBreadcrumbs() {
        const { appBridge } = this.props.polaris;
        const { breadcrumbs } = this.props;
        if (breadcrumbs != null && breadcrumbs.length > 0) {
            const breadcrumb = breadcrumbs[breadcrumbs.length - 1];
            const button = AppBridgeButton.create(appBridge, {
                label: breadcrumb.content || '',
            });
            const callback = !('url' in breadcrumb)
                ? breadcrumb.onAction
                : generateRedirect(appBridge, breadcrumb.url, breadcrumb.target);
            if (callback != null) {
                button.subscribe(AppBridgeButton.Action.CLICK, callback);
            }
            return button;
        }
        else {
            return undefined;
        }
    }
}
export default withAppProvider()(Page);
