import * as tslib_1 from "tslib";
import * as React from 'react';
import { HorizontalDotsMinor } from '@shopify/polaris-icons';
import { classNames } from '@shopify/react-utilities/styles';
import ActionList from '../../../ActionList';
import Button, { buttonsFrom } from '../../../Button';
import Breadcrumbs from '../../../Breadcrumbs';
import DisplayText from '../../../DisplayText';
import Pagination from '../../../Pagination';
import Popover from '../../../Popover';
import { withAppProvider } from '../../../AppProvider';
import { Action, ActionGroup } from './components';
import styles from './Header.scss';
class Header extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.state = {
            rollupOpen: false,
        };
        this.renderRollupAction = () => {
            const { rollupOpen } = this.state;
            const { secondaryActions = [], actionGroups = [] } = this.props;
            const rollupMarkup = this.hasRollup ? (<div className={styles.Rollup}>
        <Popover active={rollupOpen} onClose={this.handleRollupToggle} activator={<Button plain icon={HorizontalDotsMinor} onClick={this.handleRollupToggle}/>}>
          <ActionList items={secondaryActions} sections={actionGroups.map(convertActionGroupToActionListSection)} onActionAnyItem={this.handleRollupToggle}/>
        </Popover>
      </div>) : null;
            return rollupMarkup;
        };
        this.renderSecondaryActions = () => {
            const { openActionGroup } = this.state;
            const { secondaryActions = [], actionGroups = [] } = this.props;
            if (secondaryActions.length === 0 && actionGroups.length === 0) {
                return null;
            }
            const secondaryActionMarkup = secondaryActions.length > 0
                ? secondaryActionsFrom(secondaryActions)
                : null;
            const actionGroupsMarkup = actionGroups.length > 0
                ? actionGroups.map(({ title, icon, actions, details }, index) => (<div className={styles.IndividualAction} key={`ActionGroup-${title}-${index}`}>
              <ActionGroup title={title} icon={icon} actions={actions} details={details} onOpen={this.handleActionGroupOpen} onClose={this.handleActionGroupClose} active={title === openActionGroup}/>
            </div>))
                : null;
            return (<div className={styles.SecondaryActions}>
        <div className={styles.IndividualActions}>
          {secondaryActionMarkup}
          {actionGroupsMarkup}
        </div>
      </div>);
        };
        this.handleRollupToggle = () => {
            this.setState(({ rollupOpen }) => ({ rollupOpen: !rollupOpen }));
        };
        this.handleActionGroupClose = (group) => {
            this.setState(({ openActionGroup }) => openActionGroup === group ? { openActionGroup: undefined } : {});
        };
        this.handleActionGroupOpen = (group) => {
            this.setState({ openActionGroup: group });
        };
    }
    render() {
        const { title, titleMetadata, breadcrumbs = [], titleHidden = false, primaryAction, pagination, separator, secondaryActions, icon, actionGroups, polaris: { intl }, } = this.props;
        if (icon) {
            // eslint-disable-next-line no-console
            console.warn(intl.translate('Polaris.Page.Header.iconWarningMessage'));
        }
        const className = classNames(styles.Header, titleHidden && styles['Title-hidden'], pagination && styles['Header-hasPagination'], separator && styles['Header-hasSeparator'], breadcrumbs && breadcrumbs.length && styles['Header-hasBreadcrumbs'], this.hasRollup && styles['Header-hasRollup'], secondaryActions &&
            secondaryActions.length &&
            styles['Header-hasSecondaryActions']);
        const breadcrumbMarkup = breadcrumbs.length > 0 ? <Breadcrumbs breadcrumbs={breadcrumbs}/> : null;
        const primary = primaryAction &&
            (primaryAction.primary === undefined ? true : primaryAction.primary);
        const primaryActionMarkup = primaryAction ? (<div className={styles.PrimaryAction}>
        {buttonsFrom(primaryAction, { primary })}
      </div>) : null;
        const paginationMarkup = pagination ? (<div className={styles.Pagination}>
        <Pagination {...pagination} plain/>
      </div>) : null;
        const rollupMarkup = this.renderRollupAction();
        const nonPrimaryActionsMarkup = this.renderSecondaryActions();
        const actionsMarkup = primaryAction || secondaryActions || actionGroups ? (<div className={styles.Actions}>
          {nonPrimaryActionsMarkup}
          {primaryActionMarkup}
        </div>) : null;
        const navigationMarkup = breadcrumbMarkup || paginationMarkup ? (<div className={styles.Navigation}>
          {breadcrumbMarkup}
          {paginationMarkup}
          {breadcrumbMarkup && rollupMarkup}
        </div>) : null;
        const titleMarkup = (<div className={styles.TitleAndRollup}>
        <div className={styles.Title}>
          
          <div>
            <DisplayText size="large" element="h1">
              {title}
            </DisplayText>
          </div>
          <div>{titleMetadata}</div>
        </div>
        {!breadcrumbMarkup && rollupMarkup}
      </div>);
        return primaryActionMarkup ? (<div className={className}>
        {navigationMarkup}
        <div className={styles.MainContent}>
          <div className={styles.TitleAndActions}>
            {titleMarkup}
            {actionsMarkup}
          </div>
          {primaryActionMarkup}
        </div>
      </div>) : (<div className={className}>
        {navigationMarkup}
        {titleMarkup}
        {actionsMarkup}
      </div>);
    }
    get hasRollup() {
        const { secondaryActions = [], actionGroups = [] } = this.props;
        return secondaryActions.length + actionGroups.length >= 1;
    }
}
function convertActionGroupToActionListSection({ title, actions, }) {
    return { title, items: actions };
}
function secondaryActionsFrom(actions) {
    return actions.map((_a, index) => {
        var { content } = _a, action = tslib_1.__rest(_a, ["content"]);
        return (<div className={styles.IndividualAction} key={`Action-${content || index}`}>
      <Action {...action}>{content}</Action>
    </div>);
    });
}
export default withAppProvider()(Header);
