import * as React from 'react';
import ActionList from '../../../../../ActionList';
import Popover from '../../../../../Popover';
import Action from '../Action';
import styles from './ActionGroup.scss';
class ActionGroup extends React.Component {
    constructor() {
        super(...arguments);
        this.handleClose = () => {
            const { title, onClose } = this.props;
            onClose(title);
        };
        this.handleOpen = () => {
            const { title, onOpen } = this.props;
            onOpen(title);
        };
    }
    render() {
        const { actions, details, title, icon, active } = this.props;
        const detailsMarkup = details && (<div className={styles.Details}>{details}</div>);
        return (<div className={styles.ActionGroup} key={`ActionGroup-${title}`}>
        <Popover key={title} active={active} onClose={this.handleClose} activator={<Action disclosure icon={icon} onAction={this.handleOpen}>
              {title}
            </Action>}>
          <ActionList items={actions} onActionAnyItem={this.handleClose}/>
          {detailsMarkup}
        </Popover>
      </div>);
    }
}
export default ActionGroup;
