import * as React from 'react';
import { ArrowLeftMinor, ArrowRightMinor } from '@shopify/polaris-icons';
import { classNames } from '@shopify/react-utilities';
import isInputFocused from '../../utilities/isInputFocused';
import { withAppProvider } from '../AppProvider';
import Icon from '../Icon';
import UnstyledLink from '../UnstyledLink';
import Tooltip from '../Tooltip';
import KeypressListener from '../KeypressListener';
import { handleMouseUpByBlurring } from '../../utilities/focus';
import styles from './Pagination.scss';
function Pagination({ hasNext, hasPrevious, nextURL, previousURL, onNext, onPrevious, nextTooltip, previousTooltip, nextKeys, previousKeys, plain, accessibilityLabel, polaris: { intl }, }) {
    const node = React.createRef();
    let label;
    if (accessibilityLabel) {
        label = accessibilityLabel;
    }
    else {
        label = intl.translate('Polaris.Pagination.pagination');
    }
    const className = classNames(styles.Pagination, plain && styles.plain);
    const previousButton = previousURL ? (<UnstyledLink className={styles.Button} url={previousURL} onMouseUp={handleMouseUpByBlurring} aria-label={intl.translate('Polaris.Pagination.previous')} id="previousURL">
      <Icon source={ArrowLeftMinor}/>
    </UnstyledLink>) : (<button onClick={onPrevious} type="button" onMouseUp={handleMouseUpByBlurring} className={styles.Button} aria-label={intl.translate('Polaris.Pagination.previous')} disabled={!hasPrevious}>
      <Icon source={ArrowLeftMinor}/>
    </button>);
    const nextButton = nextURL ? (<UnstyledLink className={styles.Button} url={nextURL} onMouseUp={handleMouseUpByBlurring} aria-label={intl.translate('Polaris.Pagination.next')} id="nextURL">
      <Icon source={ArrowRightMinor}/>
    </UnstyledLink>) : (<button onClick={onNext} type="button" onMouseUp={handleMouseUpByBlurring} className={styles.Button} aria-label={intl.translate('Polaris.Pagination.next')} disabled={!hasNext}>
      <Icon source={ArrowRightMinor}/>
    </button>);
    const constructedPrevious = previousTooltip ? (<Tooltip content={previousTooltip}>{previousButton}</Tooltip>) : (previousButton);
    const constructedNext = nextTooltip ? (<Tooltip content={nextTooltip}>{nextButton}</Tooltip>) : (nextButton);
    const previousButtonEvents = previousKeys &&
        (previousURL || onPrevious) &&
        hasPrevious &&
        previousKeys.map((key) => (<KeypressListener key={key} keyCode={key} handler={previousURL
            ? handleCallback(clickPaginationLink('previousURL', node))
            : handleCallback(onPrevious)}/>));
    const nextButtonEvents = nextKeys &&
        (nextURL || onNext) &&
        hasNext &&
        nextKeys.map((key) => (<KeypressListener key={key} keyCode={key} handler={nextURL
            ? handleCallback(clickPaginationLink('nextURL', node))
            : handleCallback(onNext)}/>));
    return (<nav className={className} aria-label={label} ref={node}>
      {previousButtonEvents}
      {constructedPrevious}
      {nextButtonEvents}
      {constructedNext}
    </nav>);
}
function clickPaginationLink(id, node) {
    return () => {
        if (node.current == null) {
            return;
        }
        const link = node.current.querySelector(`#${id}`);
        if (link) {
            link.click();
        }
    };
}
function handleCallback(fn) {
    return () => {
        if (isInputFocused()) {
            return;
        }
        fn();
    };
}
export default withAppProvider()(Pagination);
