import * as React from 'react';
import { createPortal } from 'react-dom';
import { createUniqueIDFactory, noop } from '@shopify/javascript-utilities/other';
const getUniqueID = createUniqueIDFactory('portal-');
export default class Portal extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.state = { isMounted: false };
        this.portalId = this.props.idPrefix !== ''
            ? `${this.props.idPrefix}-${getUniqueID()}`
            : getUniqueID();
    }
    componentDidMount() {
        this.portalNode = document.createElement('div');
        this.portalNode.setAttribute('data-portal-id', this.portalId);
        document.body.appendChild(this.portalNode);
        this.setState({ isMounted: true });
    }
    componentDidUpdate(_, prevState) {
        const { onPortalCreated = noop } = this.props;
        if (!prevState.isMounted && this.state.isMounted) {
            onPortalCreated();
        }
    }
    componentWillUnmount() {
        document.body.removeChild(this.portalNode);
    }
    render() {
        return this.state.isMounted
            ? createPortal(this.props.children, this.portalNode)
            : null;
    }
}
Portal.defaultProps = { idPrefix: '' };
