import * as React from 'react';
import { createUniqueIDFactory } from '@shopify/javascript-utilities/other';
import Choice, { helpTextID } from '../Choice';
import styles from './RadioButton.scss';
const getUniqueID = createUniqueIDFactory('RadioButton');
export default function RadioButton({ label, labelHidden, helpText, checked, disabled, onChange, onFocus, onBlur, id = getUniqueID(), name = id, value, }) {
    function handleChange({ currentTarget }) {
        if (onChange == null) {
            return;
        }
        onChange(currentTarget.checked, id);
    }
    const describedBy = helpText ? helpTextID(id) : undefined;
    return (<Choice label={label} labelHidden={labelHidden} disabled={disabled} id={id} helpText={helpText}>
      <span className={styles.RadioButton}>
        <input id={id} name={name} value={value} type="radio" checked={checked} disabled={disabled} className={styles.Input} onChange={handleChange} onFocus={onFocus} onBlur={onBlur} aria-describedby={describedBy}/>
        <span className={styles.Backdrop}/>
        <span className={styles.Icon}/>
      </span>
    </Choice>);
}
