import * as React from 'react';
import { classNames } from '@shopify/react-utilities/styles';
import Checkbox from '../../../Checkbox';
import { withAppProvider } from '../../../AppProvider';
import styles from './CheckableButton.scss';
function CheckableButton({ accessibilityLabel, label = '', onToggleAll, selected, selectMode, plain, measuring, disabled, }) {
    const className = plain
        ? classNames(styles.CheckableButton, styles['CheckableButton-plain'])
        : classNames(styles.CheckableButton, selectMode && styles['CheckableButton-selectMode'], selected && styles['CheckableButton-selected'], measuring && styles['CheckableButton-measuring']);
    return (<div className={className} onClick={onToggleAll}>
      <div className={styles.Checkbox}>
        <Checkbox label={accessibilityLabel} labelHidden checked={selected} disabled={disabled} onChange={onToggleAll}/>
      </div>
      <span className={styles.Label}>{label}</span>
    </div>);
}
export default withAppProvider()(CheckableButton);
