import * as React from 'react';
import Button from '../../../../../Button';
import Popover from '../../../../../Popover';
import Select from '../../../../../Select';
import FormLayout from '../../../../../FormLayout';
import Form from '../../../../../Form';
import { withAppProvider, } from '../../../../../AppProvider';
import FilterValueSelector from '../FilterValueSelector';
export class FilterCreator extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.state = {
            popoverActive: false,
        };
        this.node = null;
        this.handleButtonFocus = (...args) => {
            const event = args[0];
            if (!this.node && event) {
                this.node = event.target;
            }
        };
        this.togglePopover = () => {
            this.setState(({ popoverActive }) => ({ popoverActive: !popoverActive }));
        };
        this.handleFilterKeyChange = (filterKey) => {
            const { filters } = this.props;
            const foundFilter = filters.find((filter) => {
                const { minKey, maxKey, operatorText } = filter;
                if (minKey || maxKey) {
                    return (filter.key === filterKey ||
                        minKey === filterKey ||
                        maxKey === filterKey);
                }
                if (operatorText && typeof operatorText !== 'string') {
                    return (filter.key === filterKey ||
                        operatorText.filter(({ key }) => key === filterKey).length ===
                            1);
                }
                return filter.key === filterKey;
            });
            if (!foundFilter) {
                return;
            }
            this.setState({
                selectedFilter: foundFilter,
                selectedFilterKey: filterKey,
                selectedFilterValue: undefined,
            });
        };
        this.handleFilterValueChange = (filterValue) => {
            this.setState({ selectedFilterValue: filterValue });
        };
        this.handleAddFilter = () => {
            const { onAddFilter } = this.props;
            const { selectedFilterKey } = this.state;
            if (!onAddFilter || !this.canAddFilter || !selectedFilterKey) {
                return;
            }
            onAddFilter({
                key: selectedFilterKey,
                value: this.state.selectedFilterValue || '',
            });
            this.setState({
                popoverActive: false,
                selectedFilter: undefined,
                selectedFilterValue: undefined,
            });
            if (this.node != null) {
                this.node.focus();
            }
        };
    }
    get canAddFilter() {
        return Boolean(this.state.selectedFilter &&
            this.state.selectedFilterKey &&
            this.state.selectedFilterValue);
    }
    render() {
        const { filters, resourceName, disabled, polaris: { intl }, } = this.props;
        const { popoverActive, selectedFilter, selectedFilterKey, selectedFilterValue, } = this.state;
        const activator = (<Button onClick={this.togglePopover} disclosure testID="FilterCreator-FilterActivator" disabled={disabled} onFocus={this.handleButtonFocus}>
        {intl.translate('Polaris.ResourceList.FilterCreator.filterButtonLabel')}
      </Button>);
        const filterOptions = filters.map(({ key, label }) => ({
            value: key,
            label,
        }));
        const filterValueSelectionMarkup = selectedFilter ? (<FilterValueSelector filter={selectedFilter} filterKey={selectedFilterKey} value={selectedFilterValue} onFilterKeyChange={this.handleFilterKeyChange} onChange={this.handleFilterValueChange}/>) : null;
        const addFilterButtonMarkup = selectedFilter ? (<Button onClick={this.handleAddFilter} disabled={!this.canAddFilter} testID="FilterCreator-AddFilterButton">
        {intl.translate('Polaris.ResourceList.FilterCreator.addFilterButtonLabel')}
      </Button>) : null;
        return (<Popover active={popoverActive} activator={activator} onClose={this.togglePopover} sectioned fullHeight>
        <Form onSubmit={this.handleAddFilter}>
          <FormLayout>
            <Select label={intl.translate('Polaris.ResourceList.FilterCreator.showAllWhere', { resourceNamePlural: resourceName.plural.toLocaleLowerCase() })} placeholder={intl.translate('Polaris.ResourceList.FilterCreator.selectFilterKeyPlaceholder')} options={filterOptions} onChange={this.handleFilterKeyChange} value={selectedFilter && selectedFilter.key}/>
            {filterValueSelectionMarkup}
            {addFilterButtonMarkup}
          </FormLayout>
        </Form>
      </Popover>);
    }
}
export default withAppProvider()(FilterCreator);
