import * as React from 'react';
import isEqual from 'lodash/isEqual';
import { ResourcePicker as AppBridgeResourcePicker } from '@shopify/app-bridge/actions';
import { withAppProvider } from '../AppProvider';
export class ResourcePicker extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.focusReturnPoint = null;
    }
    componentDidMount() {
        if (this.props.polaris.appBridge == null) {
            return;
        }
        const { open, resourceType, initialQuery, showHidden = true, allowMultiple = true, showVariants = true, onSelection, onCancel, } = this.props;
        const { appBridge } = this.props.polaris;
        this.appBridgeResourcePicker = AppBridgeResourcePicker.create(appBridge, {
            resourceType: AppBridgeResourcePicker.ResourceType[resourceType],
            options: {
                initialQuery,
                showHidden,
                selectMultiple: allowMultiple,
                showVariants,
            },
        });
        if (onSelection != null) {
            this.appBridgeResourcePicker.subscribe(AppBridgeResourcePicker.Action.SELECT, ({ selection }) => {
                onSelection({ selection });
            });
        }
        if (onCancel != null) {
            this.appBridgeResourcePicker.subscribe(AppBridgeResourcePicker.Action.CANCEL, onCancel);
        }
        if (open) {
            this.focusReturnPoint = document.activeElement;
            this.appBridgeResourcePicker.dispatch(AppBridgeResourcePicker.Action.OPEN);
        }
    }
    componentDidUpdate(prevProps) {
        if (this.appBridgeResourcePicker == null) {
            return;
        }
        const { open, initialQuery, showHidden = false, allowMultiple = true, showVariants = true, } = this.props;
        const wasOpen = prevProps.open;
        if (!isEqual(prevProps, this.props)) {
            this.appBridgeResourcePicker.set({
                initialQuery,
                showHidden,
                selectMultiple: allowMultiple,
                showVariants,
            });
        }
        if (wasOpen !== open) {
            if (open) {
                this.appBridgeResourcePicker.dispatch(AppBridgeResourcePicker.Action.OPEN);
            }
            else {
                this.appBridgeResourcePicker.dispatch(AppBridgeResourcePicker.Action.CLOSE);
            }
        }
        if (!wasOpen && open) {
            this.focusReturnPoint = document.activeElement;
        }
        else if (wasOpen &&
            !open &&
            this.focusReturnPoint != null &&
            document.contains(this.focusReturnPoint)) {
            this.focusReturnPoint.focus();
            this.focusReturnPoint = null;
        }
    }
    componentWillUnmount() {
        if (this.appBridgeResourcePicker == null) {
            return;
        }
        this.appBridgeResourcePicker.unsubscribe();
    }
    render() {
        return null;
    }
}
export default withAppProvider()(ResourcePicker);
