import * as React from 'react';
import { classNames, variationName } from '@shopify/react-utilities/styles';
import { withAppProvider } from '../AppProvider';
import Image from '../Image';
import styles from './Spinner.scss';
import { spinnerLarge, spinnerSmall } from './images';
const COLORS_FOR_LARGE_SPINNER = ['teal', 'inkLightest'];
function Spinner({ size = 'large', color = 'teal', accessibilityLabel, polaris: { intl }, }) {
    if (size === 'large' && COLORS_FOR_LARGE_SPINNER.indexOf(color) < 0) {
        if (process.env.NODE_ENV === 'development') {
            // eslint-disable-next-line no-console
            console.warn(intl.translate('Polaris.Spinner.warningMessage', {
                color,
                size,
                colors: COLORS_FOR_LARGE_SPINNER.join(', '),
            }));
        }
        // eslint-disable-next-line no-param-reassign
        size = 'small';
    }
    const className = classNames(styles.Spinner, color && styles[variationName('color', color)], size && styles[variationName('size', size)]);
    const spinnerSVG = size === 'large' ? spinnerLarge : spinnerSmall;
    return (<Image alt="" source={spinnerSVG} className={className} draggable={false} role="status" aria-label={accessibilityLabel}/>);
}
export default withAppProvider()(Spinner);
