import * as React from 'react';
import { classNames, variationName } from '@shopify/react-utilities/styles';
import { elementChildren, wrapWithComponent } from '@shopify/react-utilities';
import { Item } from './components';
import styles from './Stack.scss';
export default class Stack extends React.PureComponent {
    render() {
        const { children, vertical, spacing, distribution, alignment, wrap, } = this.props;
        const className = classNames(styles.Stack, vertical && styles.vertical, spacing && styles[variationName('spacing', spacing)], distribution && styles[variationName('distribution', distribution)], alignment && styles[variationName('alignment', alignment)], wrap === false && styles.noWrap);
        const itemMarkup = elementChildren(children).map((child, index) => {
            const props = { key: index };
            return wrapWithComponent(child, Item, props);
        });
        return <div className={className}>{itemMarkup}</div>;
    }
}
Stack.Item = Item;
