import * as React from 'react';
import { noop } from '@shopify/javascript-utilities/other';
import styles from '../../Tabs.scss';
import UnstyledLink from '../../../UnstyledLink';
export default class Item extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.focusedNode = null;
        this.setFocusedNode = (node) => {
            this.focusedNode = node;
        };
    }
    componentDidMount() {
        const { focusedNode } = this;
        const { focused } = this.props;
        if (focusedNode && focusedNode instanceof HTMLElement && focused) {
            focusedNode.focus();
        }
    }
    componentDidUpdate() {
        const { focusedNode } = this;
        const { focused } = this.props;
        if (focusedNode && focusedNode instanceof HTMLElement && focused) {
            focusedNode.focus();
        }
    }
    render() {
        const { id, panelID, children, url, accessibilityLabel, onClick = noop, } = this.props;
        const sharedProps = {
            id,
            ref: this.setFocusedNode,
            onClick,
            className: styles.Item,
            'aria-controls': panelID,
            'aria-selected': false,
            'aria-label': accessibilityLabel,
        };
        const markup = url ? (React.createElement(UnstyledLink, Object.assign({ url }, sharedProps), children)) : (<button {...sharedProps} type="button">
        {children}
      </button>);
        return <li role="presentation">{markup}</li>;
    }
}
