import * as tslib_1 from "tslib";
import * as React from 'react';
import { noop } from '@shopify/javascript-utilities/other';
import Item from '../Item';
import styles from '../../Tabs.scss';
export default class List extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.handleKeypress = (event) => {
            const { onKeyPress = noop } = this.props;
            onKeyPress(event);
        };
    }
    render() {
        const { focusIndex, disclosureTabs, onClick = noop } = this.props;
        const tabs = disclosureTabs.map((_a, index) => {
            var { id, content } = _a, tabProps = tslib_1.__rest(_a, ["id", "content"]);
            return (<Item {...tabProps} key={id} id={id} focused={index === focusIndex} 
            // eslint-disable-next-line react/jsx-no-bind
            onClick={onClick.bind(null, id)}>
          {content}
        </Item>);
        });
        return (<ul className={styles.List} onKeyDown={handleKeyDown} onKeyUp={this.handleKeypress}>
        {tabs}
      </ul>);
    }
}
function handleKeyDown(event) {
    const { key } = event;
    if (key === 'ArrowUp' ||
        key === 'ArrowDown' ||
        key === 'ArrowLeft' ||
        key === 'ArrowRight') {
        event.preventDefault();
        event.stopPropagation();
    }
}
