export function getVisibleAndHiddenTabIndices(tabs, selected, disclosureWidth, tabWidths, containerWidth) {
    const sumTabWidths = tabWidths.reduce((sum, width) => sum + width, 0);
    const arrayOfTabIndices = tabs.map((_, index) => {
        return index;
    });
    const visibleTabs = [];
    const hiddenTabs = [];
    if (containerWidth > sumTabWidths) {
        visibleTabs.push(...arrayOfTabIndices);
    }
    else {
        visibleTabs.push(selected);
        let newTabWidth = tabWidths[selected];
        arrayOfTabIndices.forEach((index) => {
            if (index !== selected) {
                if (newTabWidth + tabWidths[index] > containerWidth - disclosureWidth) {
                    hiddenTabs.push(index);
                    return;
                }
                visibleTabs.push(index);
                newTabWidth += tabWidths[index];
            }
        });
    }
    return {
        visibleTabs,
        hiddenTabs,
    };
}
