import * as tslib_1 from "tslib";
import * as React from 'react';
import isEqual from 'lodash/isEqual';
import { setColors } from './utils';
import { THEME_CONTEXT_TYPES } from './types';
const defaultTheme = {
    '--top-bar-background': '#00848e',
    '--top-bar-color': '#f9fafb',
    '--top-bar-background-lighter': '#1d9ba4',
};
export default class ThemeProvider extends React.Component {
    constructor(props) {
        super(props);
        this.subscriptions = [];
        this.subscribe = (callback) => {
            this.subscriptions.push(callback);
        };
        this.unsubscribe = (callback) => {
            this.subscriptions = this.subscriptions.filter((subscription) => subscription !== callback);
        };
        this.themeContext = setThemeContext(this.props.theme, this.subscribe, this.unsubscribe);
        this.colors = setColors(props.theme);
    }
    componentWillReceiveProps({ theme }) {
        if (isEqual(theme, this.props.theme)) {
            return;
        }
        this.themeContext = setThemeContext(theme, this.subscribe, this.unsubscribe);
        this.subscriptions.forEach((subscriberCallback) => subscriberCallback());
        this.colors = setColors(theme);
    }
    getChildContext() {
        return this.themeContext;
    }
    render() {
        const styles = this.createStyles() || defaultTheme;
        return <div style={styles}>{React.Children.only(this.props.children)}</div>;
    }
    createStyles() {
        return this.colors
            ? this.colors.reduce((state, [key, value]) => (Object.assign({}, state, { [key]: value })), {})
            : null;
    }
}
ThemeProvider.childContextTypes = THEME_CONTEXT_TYPES;
function setThemeContext(ctx, subscribe, unsubscribe) {
    const { colors, logo = null } = ctx, rest = tslib_1.__rest(ctx, ["colors", "logo"]);
    return { polarisTheme: Object.assign({ logo, subscribe, unsubscribe }, rest) };
}
