import * as React from 'react';
import { classNames, variationName } from '@shopify/react-utilities/styles';
import Image from '../Image';
import styles from './Thumbnail.scss';
export default function Thumbnail({ source, alt, size = 'medium' }) {
    const className = classNames(styles.Thumbnail, size && styles[variationName('size', size)]);
    return (<span className={className}>
      <Image alt={alt} source={source} className={styles.Image}/>
    </span>);
}
