import * as React from 'react';
import { createUniqueIDFactory } from '@shopify/javascript-utilities/other';
import { Toast as AppBridgeToast } from '@shopify/app-bridge/actions';
import { DEFAULT_TOAST_DURATION, frameContextTypes, } from '../Frame';
import { withAppProvider } from '../AppProvider';
const createId = createUniqueIDFactory('Toast');
export class Toast extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.id = createId();
    }
    componentDidMount() {
        const { context, id, props } = this;
        const { error, content, duration = DEFAULT_TOAST_DURATION, onDismiss, } = props;
        const { appBridge } = props.polaris;
        if (appBridge == null) {
            context.frame.showToast(Object.assign({ id }, props));
        }
        else {
            this.appBridgeToast = AppBridgeToast.create(appBridge, {
                message: content,
                duration,
                isError: error,
            });
            this.appBridgeToast.subscribe(AppBridgeToast.Action.CLEAR, onDismiss);
            this.appBridgeToast.dispatch(AppBridgeToast.Action.SHOW);
        }
    }
    componentWillUnmount() {
        const { appBridge } = this.props.polaris;
        if (appBridge == null) {
            this.context.frame.hideToast({ id: this.id });
        }
        else if (this.appBridgeToast != null) {
            this.appBridgeToast.unsubscribe();
        }
    }
    render() {
        return null;
    }
}
Toast.contextTypes = frameContextTypes;
export default withAppProvider()(Toast);
