import * as React from 'react';
import { MobileHamburgerMajorMonotone } from '@shopify/polaris-icons';
import { classNames } from '@shopify/react-utilities/styles';
import { getWidth } from '../../utilities/getWidth';
import { withAppProvider } from '../AppProvider';
import Icon from '../Icon';
import Image from '../Image';
import UnstyledLink from '../UnstyledLink';
import { SearchField, UserMenu, Search, Menu } from './components';
import styles from './TopBar.scss';
export class TopBar extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.state = {
            focused: false,
        };
        this.handleFocus = () => {
            this.setState({ focused: true });
        };
        this.handleBlur = () => {
            this.setState({ focused: false });
        };
    }
    render() {
        const { showNavigationToggle, userMenu, searchResults, searchField, secondaryMenu, searchResultsVisible, onNavigationToggle, onSearchResultsDismiss, contextControl, polaris: { theme: { logo }, }, } = this.props;
        const { focused } = this.state;
        const className = classNames(styles.NavigationIcon, focused && styles.focused);
        const navigationButtonMarkup = showNavigationToggle ? (<button type="button" className={className} onClick={onNavigationToggle} onFocus={this.handleFocus} onBlur={this.handleBlur} aria-label="Toggle menu">
        <Icon source={MobileHamburgerMajorMonotone} color="white"/>
      </button>) : null;
        const width = getWidth(logo, 104);
        let contextMarkup;
        if (contextControl) {
            contextMarkup = (<div testID="ContextControl" className={styles.ContextControl}>
          {contextControl}
        </div>);
        }
        else if (logo) {
            contextMarkup = (<div className={styles.LogoContainer}>
          <UnstyledLink url={logo.url || ''} className={styles.LogoLink} style={{ width }}>
            <Image source={logo.topBarSource || ''} alt={logo.accessibilityLabel || ''} className={styles.Logo} style={{ width }}/>
          </UnstyledLink>
        </div>);
        }
        const searchResultsMarkup = searchResults && searchResultsVisible ? (<Search visible={searchResultsVisible} onDismiss={onSearchResultsDismiss}>
          {searchResults}
        </Search>) : null;
        const searchMarkup = searchField ? (<React.Fragment>
        {searchField}
        {searchResultsMarkup}
      </React.Fragment>) : null;
        return (<div className={styles.TopBar}>
        {navigationButtonMarkup}
        {contextMarkup}
        <div className={styles.Contents}>
          <div className={styles.SearchField}>{searchMarkup}</div>
          <div className={styles.SecondaryMenu}>{secondaryMenu}</div>
          {userMenu}
        </div>
      </div>);
    }
}
TopBar.UserMenu = UserMenu;
TopBar.SearchField = SearchField;
TopBar.Menu = Menu;
export default withAppProvider()(TopBar);
