import * as React from 'react';
import { CircleCancelMinor, SearchMinor } from '@shopify/polaris-icons';
import { classNames } from '@shopify/react-utilities/styles';
import { noop } from '../../../../utilities/other';
import Icon from '../../../Icon';
import styles from './SearchField.scss';
export default class SearchField extends React.Component {
    constructor() {
        super(...arguments);
        this.input = React.createRef();
        this.handleFocus = () => {
            const { onFocus } = this.props;
            if (onFocus) {
                onFocus();
            }
        };
        this.handleBlur = () => {
            const { onBlur } = this.props;
            if (onBlur) {
                onBlur();
            }
        };
        this.handleClear = () => {
            const { onCancel = noop, onChange } = this.props;
            const { input: { current: input }, } = this;
            onCancel();
            if (input != null) {
                input.value = '';
                onChange('');
                input.focus();
            }
        };
        this.handleChange = ({ currentTarget, }) => {
            const { onChange } = this.props;
            onChange(currentTarget.value);
        };
    }
    componentDidMount() {
        const { focused } = this.props;
        const { input: { current: input }, } = this;
        if (input && focused) {
            input.focus();
        }
    }
    componentDidUpdate({ focused: wasFocused }) {
        const { input: { current: input }, } = this;
        if (input == null) {
            return;
        }
        const { focused } = this.props;
        if (focused && !wasFocused) {
            input.focus();
        }
        else if (!focused && wasFocused) {
            input.blur();
        }
    }
    render() {
        const { value, focused, active, placeholder } = this.props;
        const clearMarkup = value !== '' && (<button type="button" aria-label="Clear" className={styles.Clear} onClick={this.handleClear}>
        <Icon source={CircleCancelMinor}/>
      </button>);
        const className = classNames(styles.SearchField, (focused || active) && styles.focused);
        return (<div className={className} onFocus={this.handleFocus} onBlur={this.handleBlur}>
        <input className={styles.Input} placeholder={placeholder} type="search" autoCapitalize="off" autoComplete="off" autoCorrect="off" ref={this.input} value={value} onChange={this.handleChange} onKeyDown={preventDefault}/>
        <span className={styles.Icon}>
          <Icon source={SearchMinor}/>
        </span>

        {clearMarkup}
        <div className={styles.Backdrop}/>
      </div>);
    }
}
function preventDefault(event) {
    if (event.key === 'Enter') {
        event.preventDefault();
    }
}
