import * as React from 'react';
import isEqual from 'lodash/isEqual';
import UserMenuContext from './context';
class Provider extends React.Component {
    static getDerivedStateFromProps({ mobileView: nextMobileView }, { mobileView }) {
        if (nextMobileView !== mobileView) {
            return { mobileView: nextMobileView };
        }
        return null;
    }
    constructor(props) {
        super(props);
        this.setMobileUserMenuProps = this.setMobileUserMenuProps.bind(this);
        this.state = {
            // eslint-disable-next-line react/no-unused-state
            mobileView: props.mobileView,
            mobileUserMenuProps: undefined,
            // eslint-disable-next-line react/no-unused-state
            setMobileUserMenuProps: this.setMobileUserMenuProps,
        };
    }
    render() {
        const { state } = this;
        const { children } = this.props;
        return (<UserMenuContext.Provider value={state}>
        {children}
      </UserMenuContext.Provider>);
    }
    setMobileUserMenuProps(mobileUserMenuProps) {
        const { mobileUserMenuProps: prevMobileUserMenuProps } = this.state;
        if (isEqual(mobileUserMenuProps, prevMobileUserMenuProps)) {
            return;
        }
        this.setState({ mobileUserMenuProps });
    }
}
export default Provider;
