import * as tslib_1 from "tslib";
import * as React from 'react';
import { unstyled } from '../shared';
import { withAppProvider } from '../AppProvider/utilities';
import compose from '../../utilities/react-compose';
import withRef from '../WithRef';
export class UnstyledLink extends React.PureComponent {
    render() {
        const _a = this.props, { polaris, external, url } = _a, rest = tslib_1.__rest(_a, ["polaris", "external", "url"]);
        if (polaris && polaris.link) {
            const LinkComponent = polaris.link.getLinkComponent();
            if (LinkComponent) {
                const _b = this.props, { polaris } = _b, rest = tslib_1.__rest(_b, ["polaris"]);
                return <LinkComponent {...unstyled.props} {...rest}/>;
            }
        }
        const target = external ? '_blank' : undefined;
        const rel = external ? 'noopener noreferrer' : undefined;
        return (<a target={target} {...rest} href={url} rel={rel} {...unstyled.props}/>);
    }
}
export default compose(withAppProvider(), withRef())(UnstyledLink);
