import * as tslib_1 from "tslib";
import * as React from 'react';
import hoistStatics from 'hoist-non-react-statics';
export default function withContext(Consumer) {
    return function addContext(WrappedComponent) {
        // eslint-disable-next-line react/prefer-stateless-function
        class WithContext extends React.Component {
            render() {
                return (<Consumer>
            
            {(ctx) => {
                    const _a = this.props, { context } = _a, rest = tslib_1.__rest(_a, ["context"]);
                    return (<WrappedComponent {...rest} context={Object.assign({}, context, ctx)}/>);
                }}
          </Consumer>);
            }
        }
        const FinalComponent = hoistStatics(WithContext, WrappedComponent);
        return FinalComponent;
    };
}
