import * as React from 'react';
import hoistStatics from 'hoist-non-react-statics';
import { Consumer } from './components';
export default function withRef() {
    return function addForwardRef(WrappedComponent) {
        class WithRef extends React.Component {
            render() {
                return (<Consumer>
            {(ctx) => (<WrappedComponent {...this.props} ref={ctx.forwardedRef}/>)}
          </Consumer>);
            }
        }
        const FinalComponent = hoistStatics(WithRef, WrappedComponent);
        return FinalComponent;
    };
}
