export function lightenColor(color, lighten = 0) {
    if (typeof color === 'string') {
        return color;
    }
    const { lightness } = color;
    const nextLightness = lightness + lighten;
    return Object.assign({}, color, { lightness: nextLightness });
}
export function darkenColor(color, lighten = 0) {
    if (typeof color === 'string') {
        return color;
    }
    const { lightness } = color;
    const nextLightness = lightness - lighten;
    return Object.assign({}, color, { lightness: nextLightness });
}
export function saturateColor(color, saturate = 0) {
    if (typeof color === 'string') {
        return color;
    }
    const { saturation } = color;
    const nextSaturation = saturation + saturate;
    return Object.assign({}, color, { saturation: nextSaturation });
}
export function createDarkColor(color, darkness, saturation) {
    const darkenedColor = darkenColor(color, darkness);
    const saturatedColor = saturateColor(darkenedColor, saturation);
    return saturatedColor;
}
export function createLightColor(color, lightness, saturation) {
    const lightenedColor = lightenColor(color, lightness);
    const saturatedColor = saturateColor(lightenedColor, -saturation);
    return saturatedColor;
}
