import * as React from 'react';
import reactCompose from '@shopify/react-compose';
// eslint-disable-next-line shopify/strict-component-boundaries
import { Provider as RefProvider } from '../components/WithRef';
export default function compose(...wrappingFunctions) {
    return function wrapComponent(OriginalComponent) {
        const Result = reactCompose(...wrappingFunctions)(OriginalComponent);
        // eslint-disable-next-line react/display-name
        return React.forwardRef((props, ref) => {
            return (<RefProvider value={{ forwardedRef: ref }}>
            <Result {...props}/>
          </RefProvider>);
        });
    };
}
