'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var PropTypes = require('prop-types');
var React = require('react');
var target = require('@shopify/react-utilities/target');
var styles = require('@shopify/react-utilities/styles');
var hoistStatics = _interopDefault(require('hoist-non-react-statics'));
var tslib_1 = require('tslib');
var isEqual = _interopDefault(require('lodash/isEqual'));
var tokens = require('@shopify/polaris-tokens');
var tokens__default = _interopDefault(tokens);
var other = require('@shopify/javascript-utilities/other');
var math = require('@shopify/javascript-utilities/math');
var debounce = _interopDefault(require('lodash/debounce'));
var geometry = require('@shopify/javascript-utilities/geometry');
var events = require('@shopify/javascript-utilities/events');
var createApp = require('@shopify/app-bridge');
var createApp__default = _interopDefault(createApp);
var polarisIcons = require('@shopify/polaris-icons');
var reactUtilities = require('@shopify/react-utilities');
var compose = _interopDefault(require('@shopify/react-compose'));
var dom = require('@shopify/javascript-utilities/dom');
var focus = require('@shopify/javascript-utilities/focus');
var ReactDOM = require('react-dom');
var fastdom = require('@shopify/javascript-utilities/fastdom');
var reactTransitionGroup = require('react-transition-group');
var actions = require('@shopify/app-bridge/actions');
var dates = require('@shopify/javascript-utilities/dates');

if (typeof window !== 'undefined') {
  window.Polaris = window.Polaris || {};
  window.Polaris.VERSION = '3.13.0';
}

var polarisVersion = '3.13.0';

(function (Key) {
  Key[Key["Backspace"] = 8] = "Backspace";
  Key[Key["Tab"] = 9] = "Tab";
  Key[Key["Enter"] = 13] = "Enter";
  Key[Key["Shift"] = 16] = "Shift";
  Key[Key["Ctrl"] = 17] = "Ctrl";
  Key[Key["Alt"] = 18] = "Alt";
  Key[Key["Pause"] = 19] = "Pause";
  Key[Key["CapsLock"] = 20] = "CapsLock";
  Key[Key["Escape"] = 27] = "Escape";
  Key[Key["Space"] = 32] = "Space";
  Key[Key["PageUp"] = 33] = "PageUp";
  Key[Key["PageDown"] = 34] = "PageDown";
  Key[Key["End"] = 35] = "End";
  Key[Key["Home"] = 36] = "Home";
  Key[Key["LeftArrow"] = 37] = "LeftArrow";
  Key[Key["UpArrow"] = 38] = "UpArrow";
  Key[Key["RightArrow"] = 39] = "RightArrow";
  Key[Key["DownArrow"] = 40] = "DownArrow";
  Key[Key["Insert"] = 45] = "Insert";
  Key[Key["Delete"] = 46] = "Delete";
  Key[Key["Key0"] = 48] = "Key0";
  Key[Key["Key1"] = 49] = "Key1";
  Key[Key["Key2"] = 50] = "Key2";
  Key[Key["Key3"] = 51] = "Key3";
  Key[Key["Key4"] = 52] = "Key4";
  Key[Key["Key5"] = 53] = "Key5";
  Key[Key["Key6"] = 54] = "Key6";
  Key[Key["Key7"] = 55] = "Key7";
  Key[Key["Key8"] = 56] = "Key8";
  Key[Key["Key9"] = 57] = "Key9";
  Key[Key["KeyA"] = 65] = "KeyA";
  Key[Key["KeyB"] = 66] = "KeyB";
  Key[Key["KeyC"] = 67] = "KeyC";
  Key[Key["KeyD"] = 68] = "KeyD";
  Key[Key["KeyE"] = 69] = "KeyE";
  Key[Key["KeyF"] = 70] = "KeyF";
  Key[Key["KeyG"] = 71] = "KeyG";
  Key[Key["KeyH"] = 72] = "KeyH";
  Key[Key["KeyI"] = 73] = "KeyI";
  Key[Key["KeyJ"] = 74] = "KeyJ";
  Key[Key["KeyK"] = 75] = "KeyK";
  Key[Key["KeyL"] = 76] = "KeyL";
  Key[Key["KeyM"] = 77] = "KeyM";
  Key[Key["KeyN"] = 78] = "KeyN";
  Key[Key["KeyO"] = 79] = "KeyO";
  Key[Key["KeyP"] = 80] = "KeyP";
  Key[Key["KeyQ"] = 81] = "KeyQ";
  Key[Key["KeyR"] = 82] = "KeyR";
  Key[Key["KeyS"] = 83] = "KeyS";
  Key[Key["KeyT"] = 84] = "KeyT";
  Key[Key["KeyU"] = 85] = "KeyU";
  Key[Key["KeyV"] = 86] = "KeyV";
  Key[Key["KeyW"] = 87] = "KeyW";
  Key[Key["KeyX"] = 88] = "KeyX";
  Key[Key["KeyY"] = 89] = "KeyY";
  Key[Key["KeyZ"] = 90] = "KeyZ";
  Key[Key["LeftMeta"] = 91] = "LeftMeta";
  Key[Key["RightMeta"] = 92] = "RightMeta";
  Key[Key["Select"] = 93] = "Select";
  Key[Key["Numpad0"] = 96] = "Numpad0";
  Key[Key["Numpad1"] = 97] = "Numpad1";
  Key[Key["Numpad2"] = 98] = "Numpad2";
  Key[Key["Numpad3"] = 99] = "Numpad3";
  Key[Key["Numpad4"] = 100] = "Numpad4";
  Key[Key["Numpad5"] = 101] = "Numpad5";
  Key[Key["Numpad6"] = 102] = "Numpad6";
  Key[Key["Numpad7"] = 103] = "Numpad7";
  Key[Key["Numpad8"] = 104] = "Numpad8";
  Key[Key["Numpad9"] = 105] = "Numpad9";
  Key[Key["Multiply"] = 106] = "Multiply";
  Key[Key["Add"] = 107] = "Add";
  Key[Key["Subtract"] = 109] = "Subtract";
  Key[Key["Decimal"] = 110] = "Decimal";
  Key[Key["Divide"] = 111] = "Divide";
  Key[Key["F1"] = 112] = "F1";
  Key[Key["F2"] = 113] = "F2";
  Key[Key["F3"] = 114] = "F3";
  Key[Key["F4"] = 115] = "F4";
  Key[Key["F5"] = 116] = "F5";
  Key[Key["F6"] = 117] = "F6";
  Key[Key["F7"] = 118] = "F7";
  Key[Key["F8"] = 119] = "F8";
  Key[Key["F9"] = 120] = "F9";
  Key[Key["F10"] = 121] = "F10";
  Key[Key["F11"] = 122] = "F11";
  Key[Key["F12"] = 123] = "F12";
  Key[Key["NumLock"] = 144] = "NumLock";
  Key[Key["ScrollLock"] = 145] = "ScrollLock";
  Key[Key["Semicolon"] = 186] = "Semicolon";
  Key[Key["Equals"] = 187] = "Equals";
  Key[Key["Comma"] = 188] = "Comma";
  Key[Key["Dash"] = 189] = "Dash";
  Key[Key["Period"] = 190] = "Period";
  Key[Key["ForwardSlash"] = 191] = "ForwardSlash";
  Key[Key["GraveAccent"] = 192] = "GraveAccent";
  Key[Key["OpenBracket"] = 219] = "OpenBracket";
  Key[Key["BackSlash"] = 220] = "BackSlash";
  Key[Key["CloseBracket"] = 221] = "CloseBracket";
  Key[Key["SingleQuote"] = 222] = "SingleQuote";
})(exports.Key || (exports.Key = {}));

var contentContextTypes = {
  withinContentContainer: PropTypes.bool
};

(function (TypeOf) {
  TypeOf["Undefined"] = "undefined";
  TypeOf["Object"] = "object";
  TypeOf["Boolean"] = "boolean";
  TypeOf["Number"] = "number";
  TypeOf["String"] = "string";
  TypeOf["Symbol"] = "symbol";
  TypeOf["Function"] = "function";
})(exports.TypeOf || (exports.TypeOf = {}));

function _typeof(obj) {
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function (obj) {
      return typeof obj;
    };
  } else {
    _typeof = function (obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperties(target$$1, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target$$1, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}

function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

function _possibleConstructorReturn(self, call) {
  if (call && (typeof call === "object" || typeof call === "function")) {
    return call;
  }

  return _assertThisInitialized(self);
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  }
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArray(iter) {
  if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
}

function _iterableToArrayLimit(arr, i) {
  var _arr = [];
  var _n = true;
  var _d = false;
  var _e = undefined;

  try {
    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance");
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance");
}

var OBJECT_NOTATION_MATCHER = /\[(.*?)\]|(\w+)/g;
function get(obj, keypath, defaultValue) {
  if (obj == null) return undefined;
  var keys = Array.isArray(keypath) ? keypath : getKeypath(keypath);
  var acc = obj;

  for (var i = 0; i < keys.length; i++) {
    var val = acc[keys[i]];
    if (val === undefined) return defaultValue;
    acc = val;
  }

  return acc;
}

function getKeypath(str) {
  var path = [];
  var result;

  while (result = OBJECT_NOTATION_MATCHER.exec(str)) {
    var _result = result,
        _result2 = _slicedToArray(_result, 3),
        first = _result2[1],
        second = _result2[2];

    path.push(first || second);
  }

  return path;
}

var Polaris = {
	Avatar: {
		label: "Avatar",
		labelWithInitials: "Avatar with initials {initials}"
	},
	Autocomplete: {
		spinnerAccessibilityLabel: "Loading"
	},
	Badge: {
		PROGRESS_LABELS: {
			incomplete: "Incomplete",
			partiallyComplete: "Partially complete",
			complete: "Complete"
		},
		STATUS_LABELS: {
			info: "Info",
			success: "Success",
			warning: "Warning",
			attention: "Attention",
			"new": "New"
		}
	},
	Button: {
		spinnerAccessibilityLabel: "Loading"
	},
	Common: {
		checkbox: "checkbox",
		undo: "Undo",
		cancel: "Cancel",
		newWindowAccessibilityHint: "(opens a new window)"
	},
	ContextualSaveBar: {
		save: "Save",
		discard: "Discard"
	},
	DataTable: {
		sortAccessibilityLabel: "sort {direction} by",
		navAccessibilityLabel: "Scroll table {direction} one column",
		totalsRowHeading: "Totals"
	},
	DatePicker: {
		previousMonth: "Show previous month, {previousMonthName} {showPreviousYear}",
		nextMonth: "Show next month, {nextMonth} {nextYear}",
		today: "Today ",
		months: {
			january: "January",
			february: "February",
			march: "March",
			april: "April",
			may: "May",
			june: "June",
			july: "July",
			august: "August",
			september: "September",
			october: "October",
			november: "November",
			december: "December"
		},
		daysAbbreviated: {
			monday: "Mo",
			tuesday: "Tu",
			wednesday: "We",
			thursday: "Th",
			friday: "Fr",
			saturday: "Sa",
			sunday: "Su"
		}
	},
	DiscardConfirmationModal: {
		title: "Discard all unsaved changes",
		message: "If you discard changes, you’ll delete any edits you made since you last saved.",
		primaryAction: "Discard changes",
		secondaryAction: "Continue editing"
	},
	DropZone: {
		overlayTextFile: "Drop file to upload",
		overlayTextImage: "Drop image to upload",
		errorOverlayTextFile: "File type is not valid",
		errorOverlayTextImage: "Image type is not valid",
		FileUpload: {
			actionTitleFile: "Add file",
			actionTitleImage: "Add image",
			actionHintFile: "or drop files to upload",
			actionHintImage: "or drop images to upload"
		}
	},
	EmptySearchResult: {
		altText: "Empty search results"
	},
	Frame: {
		skipToContent: "Skip to content",
		Navigation: {
			closeMobileNavigationLabel: "Close navigation"
		}
	},
	Icon: {
		backdropWarning: "The {color} icon doesn’t accept backdrops. The icon colors that have backdrops are: {colorsWithBackDrops}"
	},
	Modal: {
		iFrameTitle: "body markup",
		modalWarning: "These required properties are missing from Modal: {missingProps}"
	},
	Page: {
		Header: {
			iconWarningMessage: "The icon prop has been removed from Page. Upload an application icon in the Shopify Partners Dashboard 'App setup' section instead."
		}
	},
	Pagination: {
		previous: "Previous",
		next: "Next",
		pagination: "Pagination"
	},
	ProgressBar: {
		negativeWarningMessage: "Values passed to the progress prop shouldn’t be negative. Resetting {progress} to 0.",
		exceedWarningMessage: "Values passed to the progress prop shouldn’t exceed 100. Setting {progress} to 100."
	},
	ResourceList: {
		sortingLabel: "Sort by",
		defaultItemSingular: "item",
		defaultItemPlural: "items",
		showing: "Showing {itemsCount} {resource}",
		loading: "Loading {resource}",
		selected: "{selectedItemsCount} selected",
		allItemsSelected: "All {itemsLength}+ {resourceNamePlural} in your store are selected.",
		selectAllItems: "Select all {itemsLength}+ {resourceNamePlural} in your store",
		emptySearchResultTitle: "No {resourceNamePlural} found",
		emptySearchResultDescription: "Try changing the filters or search term",
		selectButtonText: "Select",
		a11yCheckboxDeselectAllSingle: "Deselect {resourceNameSingular}",
		a11yCheckboxSelectAllSingle: "Select {resourceNameSingular}",
		a11yCheckboxDeselectAllMultiple: "Deselect all {itemsLength} {resourceNamePlural}",
		a11yCheckboxSelectAllMultiple: "Select all {itemsLength} {resourceNamePlural}",
		ariaLiveSingular: "{itemsLength} item",
		ariaLivePlural: "{itemsLength} items",
		Item: {
			selectItem: "Select: {accessibilityLabel}",
			deselectItem: "Deselect: {accessibilityLabel}",
			actionsDropdown: "Actions dropdown"
		},
		BulkActions: {
			actionsActivatorLabel: "Actions",
			moreActionsActivatorLabel: "More actions",
			warningMessage: "To provide a better user experience. There should only be a maximum of {maxPromotedActions} promoted actions."
		},
		FilterCreator: {
			filterButtonLabel: "Filter",
			selectFilterKeyPlaceholder: "Select a filter…",
			addFilterButtonLabel: "Add filter",
			showAllWhere: "Show all {resourceNamePlural} where:"
		},
		FilterControl: {
			textFieldLabel: "Search {resourceNamePlural}"
		},
		FilterValueSelector: {
			selectFilterValuePlaceholder: "Select a filter…"
		},
		DateSelector: {
			dateFilterLabel: "Select a value",
			dateValueLabel: "Date",
			dateValueError: "Match YYYY-MM-DD format",
			dateValuePlaceholder: "YYYY-MM-DD",
			SelectOptions: {
				PastWeek: "in the last week",
				PastMonth: "in the last month",
				PastQuarter: "in the last 3 months",
				PastYear: "in the last year",
				ComingWeek: "next week",
				ComingMonth: "next month",
				ComingQuarter: "in the next 3 months",
				ComingYear: "in the next year",
				OnOrBefore: "on or before",
				OnOrAfter: "on or after"
			},
			FilterLabelForValue: {
				past_week: "in the last week",
				past_month: "in the last month",
				past_quarter: "in the last 3 months",
				past_year: "in the last year",
				coming_week: "next week",
				coming_month: "next month",
				coming_quarter: "in the next 3 months",
				coming_year: "in the next year",
				on_or_before: "before {date}",
				on_or_after: "after {date}"
			}
		}
	},
	Spinner: {
		warningMessage: "The color {color} is not meant to be used on {size} spinners. The colors available on large spinners are: {colors}"
	},
	Tag: {
		ariaLabel: "Remove {children}"
	},
	TextField: {
		characterCount: "{count} characters",
		characterCountWithMaxLength: "{count} of {limit} characters used"
	}
};
var en = {
	Polaris: Polaris
};

function merge() {
  var final = {};

  for (var _len = arguments.length, objs = new Array(_len), _key = 0; _key < _len; _key++) {
    objs[_key] = arguments[_key];
  }

  for (var _i = 0; _i < objs.length; _i++) {
    var obj = objs[_i];
    mergeRecursively(final, obj);
  }

  return final;
}

function mergeRecursively(objA, objB) {
  for (var key in objB) {
    if (!objB.hasOwnProperty(key)) {
      continue;
    } else if (isMergeableValue(objB[key]) && isMergeableValue(objA[key])) {
      objA[key] = mergeRecursively(objA[key], objB[key]);
    } else {
      objA[key] = objB[key];
    }
  }

  return objA;
}

function isMergeableValue(value) {
  return value !== null && _typeof(value) === 'object';
}

var REPLACE_REGEX = /{([^}]*)}/g;
function translate(id, translations, replacements) {
  var text = get(translations, id);

  if (!text) {
    return '';
  }

  if (replacements) {
    return text.replace(REPLACE_REGEX, function (match) {
      var replacement = match.substring(1, match.length - 1);

      if (!replacements.hasOwnProperty(replacement)) {
        throw new Error("No replacement found for key '".concat(replacement, "'. The following replacements were passed: ").concat(Object.keys(replacements).map(function (key) {
          return "'".concat(key, "'");
        }).join(', ')));
      }

      return replacements[replacement];
    });
  }

  return text;
}

var Intl =
/*#__PURE__*/
function () {
  function Intl(translation) {
    var _this = this;

    _classCallCheck(this, Intl);

    this.translation = translation;

    this.translate = function (id, replacements) {
      return translate(id, _this.translation, replacements);
    };

    this.setTranslation(translation);
  }

  _createClass(Intl, [{
    key: "setTranslation",
    value: function setTranslation(translation) {
      var i18n = Array.isArray(translation) ? merge.apply(void 0, _toConsumableArray(translation)) : translation;
      this.translation = i18n ? merge(en, i18n) : en;
    }
  }, {
    key: "translationKeyExists",
    value: function translationKeyExists(path) {
      return Boolean(get(this.translation, path));
    }
  }]);

  return Intl;
}();

var needsVariantList = ['topBar'];

function compose$1() {
  for (var _len = arguments.length, fns = new Array(_len), _key = 0; _key < _len; _key++) {
    fns[_key] = arguments[_key];
  }

  return fns.reduce(function (func, group) {
    return function () {
      return func(group.apply(void 0, arguments));
    };
  });
}

function rgbString(color) {
  var red = color.red,
      green = color.green,
      blue = color.blue;

  if (color.hasOwnProperty('alpha')) {
    return "rgba(".concat(red, ", ").concat(green, ", ").concat(blue, ", ").concat(color.alpha, ")");
  } else {
    return "rgb(".concat(red, ", ").concat(green, ", ").concat(blue, ")");
  }
}
var rgbaString = rgbString;
function rgbToHex(_ref) {
  var red = _ref.red,
      green = _ref.green,
      blue = _ref.blue;
  return "#".concat(componentToHex(red)).concat(componentToHex(green)).concat(componentToHex(blue));
}

function componentToHex(component) {
  var hex = component.toString(16);
  return hex.length === 1 ? "0".concat(hex) : hex;
}

function hsbToHex(color) {
  return rgbToHex(hsbToRgb(color));
}

function rgbFromHueAndChroma(hue, chroma) {
  var huePrime = hue / 60;
  var hueDelta = 1 - Math.abs(huePrime % 2 - 1);
  var intermediateValue = chroma * hueDelta;
  var red = 0;
  var green = 0;
  var blue = 0;

  if (huePrime >= 0 && huePrime <= 1) {
    red = chroma;
    green = intermediateValue;
    blue = 0;
  }

  if (huePrime >= 1 && huePrime <= 2) {
    red = intermediateValue;
    green = chroma;
    blue = 0;
  }

  if (huePrime >= 2 && huePrime <= 3) {
    red = 0;
    green = chroma;
    blue = intermediateValue;
  }

  if (huePrime >= 3 && huePrime <= 4) {
    red = 0;
    green = intermediateValue;
    blue = chroma;
  }

  if (huePrime >= 4 && huePrime <= 5) {
    red = intermediateValue;
    green = 0;
    blue = chroma;
  }

  if (huePrime >= 5 && huePrime <= 6) {
    red = chroma;
    green = 0;
    blue = intermediateValue;
  }

  return {
    red: red,
    green: green,
    blue: blue
  };
}

function hsbToRgb(color) {
  var hue = color.hue,
      saturation = color.saturation,
      brightness = color.brightness,
      _color$alpha = color.alpha,
      alpha = _color$alpha === void 0 ? 1 : _color$alpha;
  var chroma = brightness * saturation;

  var _rgbFromHueAndChroma = rgbFromHueAndChroma(hue, chroma),
      red = _rgbFromHueAndChroma.red,
      green = _rgbFromHueAndChroma.green,
      blue = _rgbFromHueAndChroma.blue;

  var chromaBrightnessDelta = brightness - chroma;
  red += chromaBrightnessDelta;
  green += chromaBrightnessDelta;
  blue += chromaBrightnessDelta;
  return {
    red: Math.round(red * 255),
    green: Math.round(green * 255),
    blue: Math.round(blue * 255),
    alpha: alpha
  };
}
function hslToRgb(color) {
  var hue = color.hue,
      saturation = color.saturation,
      lightness = color.lightness,
      _color$alpha2 = color.alpha,
      alpha = _color$alpha2 === void 0 ? 1 : _color$alpha2;
  var chroma = (1 - Math.abs(2 * (lightness / 100) - 1)) * (saturation / 100);

  var _rgbFromHueAndChroma2 = rgbFromHueAndChroma(hue, chroma),
      red = _rgbFromHueAndChroma2.red,
      green = _rgbFromHueAndChroma2.green,
      blue = _rgbFromHueAndChroma2.blue;

  var lightnessVal = lightness / 100 - chroma / 2;
  red += lightnessVal;
  green += lightnessVal;
  blue += lightnessVal;
  return {
    red: Math.round(red * 255),
    green: Math.round(green * 255),
    blue: Math.round(blue * 255),
    alpha: alpha
  };
} // ref https://en.wikipedia.org/wiki/HSL_and_HSV

function rgbToHsbl(color) {
  var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'b';
  var r = color.red,
      g = color.green,
      b = color.blue,
      _color$alpha3 = color.alpha,
      alpha = _color$alpha3 === void 0 ? 1 : _color$alpha3;
  var red = r / 255;
  var green = g / 255;
  var blue = b / 255;
  var largestComponent = Math.max(red, green, blue);
  var smallestComponent = Math.min(red, green, blue);
  var delta = largestComponent - smallestComponent;
  var lightness = (largestComponent + smallestComponent) / 2;
  var saturation = 0;

  if (largestComponent === 0) {
    saturation = 0;
  } else if (type === 'b') {
    saturation = delta / largestComponent;
  } else if (type === 'l') {
    saturation = lightness > 0.5 ? delta / (2 - largestComponent - smallestComponent) : delta / (largestComponent + smallestComponent);
  }

  var huePercentage = 0;

  switch (largestComponent) {
    case red:
      huePercentage = (green - blue) / delta + (green < blue ? 6 : 0);
      break;

    case green:
      huePercentage = (blue - red) / delta + 2;
      break;

    case blue:
      huePercentage = (red - green) / delta + 4;
  }

  var hue = Math.round(huePercentage / 6 * 360);
  return {
    hue: math.clamp(hue, 0, 360) || 0,
    saturation: parseFloat(math.clamp(saturation, 0, 1).toFixed(2)),
    brightness: parseFloat(math.clamp(largestComponent, 0, 1).toFixed(2)),
    lightness: parseFloat(lightness.toFixed(2)),
    alpha: parseFloat(alpha.toFixed(2))
  };
}

function rgbToHsb(color) {
  var _rgbToHsbl = rgbToHsbl(color, 'b'),
      hue = _rgbToHsbl.hue,
      saturation = _rgbToHsbl.saturation,
      brightness = _rgbToHsbl.brightness,
      alpha = _rgbToHsbl.alpha;

  return {
    hue: hue,
    saturation: saturation,
    brightness: brightness,
    alpha: alpha
  };
}
function rgbToHsl(color) {
  var _rgbToHsbl2 = rgbToHsbl(color, 'l'),
      hue = _rgbToHsbl2.hue,
      rawSaturation = _rgbToHsbl2.saturation,
      rawLightness = _rgbToHsbl2.lightness,
      alpha = _rgbToHsbl2.alpha;

  var saturation = rawSaturation * 100;
  var lightness = rawLightness * 100;
  return {
    hue: hue,
    saturation: saturation,
    lightness: lightness,
    alpha: alpha
  };
}

function hexToRgb(color) {
  if (color.length === 4) {
    var repeatHex = function repeatHex(hex1, hex2) {
      return color.slice(hex1, hex2).repeat(2);
    };

    var _red = parseInt(repeatHex(1, 2), 16);

    var _green = parseInt(repeatHex(2, 3), 16);

    var _blue = parseInt(repeatHex(3, 4), 16);

    return {
      red: _red,
      green: _green,
      blue: _blue
    };
  }

  var red = parseInt(color.slice(1, 3), 16);
  var green = parseInt(color.slice(3, 5), 16);
  var blue = parseInt(color.slice(5, 7), 16);
  return {
    red: red,
    green: green,
    blue: blue
  };
}

var ColorType;

(function (ColorType) {
  ColorType["Hex"] = "hex";
  ColorType["Rgb"] = "rgb";
  ColorType["Rgba"] = "rgba";
  ColorType["Hsl"] = "hsl";
  ColorType["Hsla"] = "hsla";
  ColorType["Default"] = "default";
})(ColorType || (ColorType = {}));

function getColorType(color) {
  if (color.includes('#')) {
    return ColorType.Hex;
  } else if (color.includes('rgb')) {
    return ColorType.Rgb;
  } else if (color.includes('rgba')) {
    return ColorType.Rgba;
  } else if (color.includes('hsl')) {
    return ColorType.Hsl;
  } else if (color.includes('hsla')) {
    return ColorType.Hsla;
  } else {
    if (process.env.NODE_ENV === 'development') {
      /* eslint-disable-next-line no-console */
      console.warn('Accepted colors formats are: hex, rgb, rgba, hsl and hsla');
    }

    return ColorType.Default;
  }
}

function hslToString(hslColor) {
  if (typeof hslColor === 'string') {
    return hslColor;
  }

  var _hslColor$alpha = hslColor.alpha,
      alpha = _hslColor$alpha === void 0 ? 1 : _hslColor$alpha,
      hue = hslColor.hue,
      lightness = hslColor.lightness,
      saturation = hslColor.saturation;
  return "hsl(".concat(hue, ", ").concat(saturation, "%, ").concat(lightness, "%, ").concat(alpha, ")");
}

function rgbToObject(color) {
  var colorMatch = color.match(/\(([^)]+)\)/);

  if (!colorMatch) {
    return {
      red: 0,
      green: 0,
      blue: 0,
      alpha: 0
    };
  }

  var _colorMatch$1$split = colorMatch[1].split(','),
      _colorMatch$1$split2 = _slicedToArray(_colorMatch$1$split, 4),
      red = _colorMatch$1$split2[0],
      green = _colorMatch$1$split2[1],
      blue = _colorMatch$1$split2[2],
      alpha = _colorMatch$1$split2[3];

  var objColor = {
    red: parseInt(red, 10),
    green: parseInt(green, 10),
    blue: parseInt(blue, 10),
    alpha: parseInt(alpha, 10) || 1
  };
  return objColor;
}

var hexToHsl = compose$1(rgbToHsl, hexToRgb);
var rbgStringToHsl = compose$1(rgbToHsl, rgbToObject);
function colorToHsla(color) {
  var type = getColorType(color);

  switch (type) {
    case ColorType.Hex:
      return hexToHsl(color);

    case ColorType.Rgb:
    case ColorType.Rgba:
      return rbgStringToHsl(color);

    case ColorType.Hsl:
    case ColorType.Hsla:
    default:
      return color;
  }
}

// implements: https://www.w3.org/WAI/ER/WD-AERT/#color-contrast
function isLight(_ref) {
  var red = _ref.red,
      green = _ref.green,
      blue = _ref.blue;
  var contrast = (red * 299 + green * 587 + blue * 114) / 1000;
  return contrast > 125;
}

function normalizeName(name) {
  return name.split(/(?=[A-Z])/).join('-').toLowerCase();
}
function constructColorName(baseName, property, suffix) {
  var name = normalizeName(baseName);
  var propertyName = property ? "-".concat(normalizeName(property)) : '';
  var constructedSuffix = suffix ? "-".concat(suffix) : '';
  return "--".concat(name).concat(propertyName).concat(constructedSuffix);
}

function lightenColor(color) {
  var lighten = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

  if (typeof color === 'string') {
    return color;
  }

  var lightness = color.lightness;
  var nextLightness = lightness + lighten;
  return Object.assign({}, color, {
    lightness: nextLightness
  });
}
function saturateColor(color) {
  var saturate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

  if (typeof color === 'string') {
    return color;
  }

  var saturation = color.saturation;
  var nextSaturation = saturation + saturate;
  return Object.assign({}, color, {
    saturation: nextSaturation
  });
}
function createLightColor(color, lightness, saturation) {
  var lightenedColor = lightenColor(color, lightness);
  var saturatedColor = saturateColor(lightenedColor, -saturation);
  return saturatedColor;
}

function setColors(theme) {
  var colorPairs;

  if (theme && theme.colors) {
    Object.entries(theme.colors).forEach(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          colorKey = _ref2[0],
          pairs = _ref2[1];

      var colorKeys = Object.keys(pairs);

      if (colorKey === 'topBar' && colorKeys.length > 1) {
        colorPairs = colorKeys.map(function (key) {
          var colors = theme.colors.topBar;
          return [constructColorName(colorKey, key), colors[key]];
        });
      } else {
        colorPairs = parseColors([colorKey, pairs]);
      }
    });
  }

  return colorPairs;
}
function needsVariant(name) {
  return needsVariantList.indexOf(name) !== -1;
}
var lightenToString = compose$1(hslToString, createLightColor);
function setTextColor(name) {
  var variant = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'dark';

  if (variant === 'light') {
    return [name, tokens__default.colorInk];
  }

  return [name, tokens__default.colorWhite];
}
function setTheme(color, baseName, key, variant) {
  var colorPairs = [];

  switch (variant) {
    case 'light':
      colorPairs.push(setTextColor(constructColorName(baseName, null, 'color'), 'light'));
      colorPairs.push([constructColorName(baseName, key, 'lighter'), lightenToString(color, 7, -10)]);
      break;

    case 'dark':
      colorPairs.push(setTextColor(constructColorName(baseName, null, 'color'), 'dark'));
      colorPairs.push([constructColorName(baseName, key, 'lighter'), lightenToString(color, 15, 15)]);
      break;

    default:
  }

  return colorPairs;
}

function parseColors(_ref3) {
  var _ref4 = _slicedToArray(_ref3, 2),
      baseName = _ref4[0],
      colors = _ref4[1];

  var keys = Object.keys(colors);
  var colorPairs = [];

  for (var i = 0; i < keys.length; i++) {
    colorPairs.push([constructColorName(baseName, keys[i]), colors[keys[i]]]);

    if (needsVariant(baseName)) {
      var hslColor = colorToHsla(colors[keys[i]]);

      if (typeof hslColor === 'string') {
        return colorPairs;
      }

      var rgbColor = hslToRgb(hslColor);

      if (isLight(rgbColor)) {
        colorPairs.push.apply(colorPairs, _toConsumableArray(setTheme(hslColor, baseName, keys[i], 'light')));
      } else {
        colorPairs.push.apply(colorPairs, _toConsumableArray(setTheme(hslColor, baseName, keys[i], 'dark')));
      }
    }
  }

  return colorPairs;
}

function createThemeContext(theme) {
  if (!theme) {
    return {
      polarisTheme: {
        logo: null,
        subscribe: other.noop,
        unsubscribe: other.noop
      }
    };
  }

  var _theme$logo = theme.logo,
      logo = _theme$logo === void 0 ? null : _theme$logo,
      _theme$subscribe = theme.subscribe,
      subscribe = _theme$subscribe === void 0 ? other.noop : _theme$subscribe,
      _theme$unsubscribe = theme.unsubscribe,
      unsubscribe = _theme$unsubscribe === void 0 ? other.noop : _theme$unsubscribe;
  return {
    polarisTheme: {
      logo: logo,
      subscribe: subscribe,
      unsubscribe: unsubscribe
    }
  };
}

var THEME_CONTEXT_TYPES = {
  polarisTheme: PropTypes.any
};

var defaultTheme = {
  '--top-bar-background': '#00848e',
  '--top-bar-color': '#f9fafb',
  '--top-bar-background-lighter': '#1d9ba4'
};

var ThemeProvider =
/*#__PURE__*/
function (_React$Component) {
  _inherits(ThemeProvider, _React$Component);

  function ThemeProvider(props) {
    var _this;

    _classCallCheck(this, ThemeProvider);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ThemeProvider).call(this, props));
    _this.subscriptions = [];

    _this.subscribe = function (callback) {
      _this.subscriptions.push(callback);
    };

    _this.unsubscribe = function (callback) {
      _this.subscriptions = _this.subscriptions.filter(function (subscription) {
        return subscription !== callback;
      });
    };

    _this.themeContext = setThemeContext(_this.props.theme, _this.subscribe, _this.unsubscribe);
    _this.colors = setColors(props.theme);
    return _this;
  }

  _createClass(ThemeProvider, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(_ref) {
      var theme = _ref.theme;

      if (isEqual(theme, this.props.theme)) {
        return;
      }

      this.themeContext = setThemeContext(theme, this.subscribe, this.unsubscribe);
      this.subscriptions.forEach(function (subscriberCallback) {
        return subscriberCallback();
      });
      this.colors = setColors(theme);
    }
  }, {
    key: "getChildContext",
    value: function getChildContext() {
      return this.themeContext;
    }
  }, {
    key: "render",
    value: function render() {
      var styles$$1 = this.createStyles() || defaultTheme;
      return React.createElement("div", {
        style: styles$$1
      }, React.Children.only(this.props.children));
    }
  }, {
    key: "createStyles",
    value: function createStyles() {
      return this.colors ? this.colors.reduce(function (state, _ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
            key = _ref3[0],
            value = _ref3[1];

        return Object.assign({}, state, _defineProperty({}, key, value));
      }, {}) : null;
    }
  }]);

  return ThemeProvider;
}(React.Component);
ThemeProvider.childContextTypes = THEME_CONTEXT_TYPES;

function setThemeContext(ctx, subscribe, unsubscribe) {
  var colors = ctx.colors,
      _ctx$logo = ctx.logo,
      logo = _ctx$logo === void 0 ? null : _ctx$logo,
      rest = tslib_1.__rest(ctx, ["colors", "logo"]);

  return {
    polarisTheme: Object.assign({
      logo: logo,
      subscribe: subscribe,
      unsubscribe: unsubscribe
    }, rest)
  };
}

var polarisAppProviderContextTypes = Object.assign({
  polaris: PropTypes.any
}, THEME_CONTEXT_TYPES);

var Breakpoints = {
  navigationBarCollapsed: '769px',
  stackedContent: '1043px'
};
var noWindowMatches = {
  media: '',
  addListener: other.noop,
  removeListener: other.noop,
  matches: false,
  onchange: other.noop,
  addEventListener: other.noop,
  removeEventListener: other.noop,
  dispatchEvent: function dispatchEvent(_) {
    return true;
  }
};
function navigationBarCollapsed() {
  return typeof window === 'undefined' ? noWindowMatches : window.matchMedia("(max-width: ".concat(Breakpoints.navigationBarCollapsed, ")"));
}
function stackedContent() {
  return typeof window === 'undefined' ? noWindowMatches : window.matchMedia("(max-width: ".concat(Breakpoints.stackedContent, ")"));
}

var scrollable = {
  props: {
    'data-polaris-scrollable': true
  },
  selector: '[data-polaris-scrollable]'
};
var overlay = {
  props: {
    'data-polaris-overlay': true
  },
  selector: '[data-polaris-overlay]'
};
var layer = {
  props: {
    'data-polaris-layer': true
  },
  selector: '[data-polaris-layer]'
};
var unstyled = {
  props: {
    'data-polaris-unstyled': true
  },
  selector: '[data-polaris-unstyled]'
};
var dataPolarisTopBar = {
  props: {
    'data-polaris-top-bar': true
  },
  selector: '[data-polaris-top-bar]'
};
var headerCell = {
  props: {
    'data-polaris-header-cell': true
  },
  selector: '[data-polaris-header-cell]'
};
var DATA_ATTRIBUTE = {
  overlay: overlay,
  layer: layer
}; // these match our values in duration.scss

var Duration;

(function (Duration) {
  Duration[Duration["Instant"] = 0] = "Instant";
  Duration[Duration["Fast"] = 100] = "Fast";
  Duration[Duration["Base"] = 200] = "Base";
  Duration[Duration["Slow"] = 300] = "Slow";
  Duration[Duration["Slower"] = 400] = "Slower";
  Duration[Duration["Slowest"] = 500] = "Slowest";
})(Duration || (Duration = {}));

var StickyManager =
/*#__PURE__*/
function () {
  function StickyManager(container) {
    var _this = this;

    _classCallCheck(this, StickyManager);

    this.stickyItems = [];
    this.stuckItems = [];
    this.topBarOffset = 0;
    this.handleResize = debounce(function () {
      _this.manageStickyItems();
    }, 40, {
      leading: true,
      trailing: true,
      maxWait: 40
    });
    this.handleScroll = debounce(function () {
      _this.manageStickyItems();
    }, 40, {
      leading: true,
      trailing: true,
      maxWait: 40
    });

    if (container) {
      this.setContainer(container);
    }
  }

  _createClass(StickyManager, [{
    key: "registerStickyItem",
    value: function registerStickyItem(stickyItem) {
      this.stickyItems.push(stickyItem);
    }
  }, {
    key: "unregisterStickyItem",
    value: function unregisterStickyItem(nodeToRemove) {
      var nodeIndex = this.stickyItems.findIndex(function (_ref) {
        var stickyNode = _ref.stickyNode;
        return nodeToRemove === stickyNode;
      });
      this.stickyItems.splice(nodeIndex, 1);
    }
  }, {
    key: "setContainer",
    value: function setContainer(el) {
      this.container = el;

      if (isDocument(el)) {
        this.setTopBarOffset();
      }

      events.addEventListener(this.container, 'scroll', this.handleScroll);
      events.addEventListener(window, 'resize', this.handleResize);
      this.manageStickyItems();
    }
  }, {
    key: "removeScrollListener",
    value: function removeScrollListener() {
      if (this.container) {
        events.removeEventListener(this.container, 'scroll', this.handleScroll);
        events.removeEventListener(window, 'resize', this.handleResize);
      }
    }
  }, {
    key: "manageStickyItems",
    value: function manageStickyItems() {
      var _this2 = this;

      if (this.stickyItems.length <= 0) {
        return;
      }

      var scrollTop = scrollTopFor(this.container);
      var containerTop = geometry.getRectForNode(this.container).top + this.topBarOffset;
      this.stickyItems.forEach(function (stickyItem) {
        var handlePositioning = stickyItem.handlePositioning;

        var _this2$evaluateSticky = _this2.evaluateStickyItem(stickyItem, scrollTop, containerTop),
            sticky = _this2$evaluateSticky.sticky,
            top = _this2$evaluateSticky.top,
            left = _this2$evaluateSticky.left,
            width = _this2$evaluateSticky.width;

        _this2.updateStuckItems(stickyItem, sticky);

        handlePositioning(sticky, top, left, width);
      });
    }
  }, {
    key: "evaluateStickyItem",
    value: function evaluateStickyItem(stickyItem, scrollTop, containerTop) {
      var stickyNode = stickyItem.stickyNode,
          placeHolderNode = stickyItem.placeHolderNode,
          boundingElement = stickyItem.boundingElement,
          offset = stickyItem.offset,
          disableWhenStacked = stickyItem.disableWhenStacked;

      if (disableWhenStacked && stackedContent().matches) {
        return {
          sticky: false,
          top: 0,
          left: 0,
          width: 'auto'
        };
      }

      var stickyOffset = offset ? this.getOffset(stickyNode) + parseInt(tokens__default.spacingLoose, 10) : this.getOffset(stickyNode);
      var scrollPosition = scrollTop + stickyOffset;
      var placeHolderNodeCurrentTop = placeHolderNode.getBoundingClientRect().top - containerTop + scrollTop;
      var top = containerTop + stickyOffset;
      var width = placeHolderNode.getBoundingClientRect().width;
      var left = placeHolderNode.getBoundingClientRect().left;
      var sticky;

      if (boundingElement == null) {
        sticky = scrollPosition >= placeHolderNodeCurrentTop;
      } else {
        var stickyItemHeight = stickyNode.getBoundingClientRect().height;
        var stickyItemBottomPosition = boundingElement.getBoundingClientRect().bottom - stickyItemHeight + scrollTop - containerTop;
        sticky = scrollPosition >= placeHolderNodeCurrentTop && scrollPosition < stickyItemBottomPosition;
      }

      return {
        sticky: sticky,
        top: top,
        left: left,
        width: width
      };
    }
  }, {
    key: "updateStuckItems",
    value: function updateStuckItems(item, sticky) {
      var stickyNode = item.stickyNode;

      if (sticky && !this.isNodeStuck(stickyNode)) {
        this.addStuckItem(item);
      } else if (!sticky && this.isNodeStuck(stickyNode)) {
        this.removeStuckItem(item);
      }
    }
  }, {
    key: "addStuckItem",
    value: function addStuckItem(stickyItem) {
      this.stuckItems.push(stickyItem);
    }
  }, {
    key: "removeStuckItem",
    value: function removeStuckItem(stickyItem) {
      var nodeToRemove = stickyItem.stickyNode;
      var nodeIndex = this.stuckItems.findIndex(function (_ref2) {
        var stickyNode = _ref2.stickyNode;
        return nodeToRemove === stickyNode;
      });
      this.stuckItems.splice(nodeIndex, 1);
    }
  }, {
    key: "getOffset",
    value: function getOffset(node) {
      if (this.stuckItems.length === 0) {
        return 0;
      }

      var offset = 0;
      var count = 0;
      var stuckNodesLength = this.stuckItems.length;
      var nodeRect = geometry.getRectForNode(node);

      while (count < stuckNodesLength) {
        var stuckNode = this.stuckItems[count].stickyNode;

        if (stuckNode !== node) {
          var stuckNodeRect = geometry.getRectForNode(stuckNode);

          if (!horizontallyOverlaps(nodeRect, stuckNodeRect)) {
            offset += geometry.getRectForNode(stuckNode).height;
          }
        } else {
          break;
        }

        count++;
      }

      return offset;
    }
  }, {
    key: "isNodeStuck",
    value: function isNodeStuck(node) {
      var nodeFound = this.stuckItems.findIndex(function (_ref3) {
        var stickyNode = _ref3.stickyNode;
        return node === stickyNode;
      });
      return nodeFound >= 0;
    }
  }, {
    key: "setTopBarOffset",
    value: function setTopBarOffset() {
      var topbarElement = this.container.querySelector(":not(".concat(scrollable.selector, ") ").concat(dataPolarisTopBar.selector));
      this.topBarOffset = topbarElement ? topbarElement.clientHeight : 0;
    }
  }]);

  return StickyManager;
}();

function isDocument(node) {
  return node === document;
}

function scrollTopFor(container) {
  return isDocument(container) ? document.body.scrollTop || document.documentElement.scrollTop : container.scrollTop;
}

function horizontallyOverlaps(rect1, rect2) {
  var rect1Left = rect1.left;
  var rect1Right = rect1.left + rect1.width;
  var rect2Left = rect2.left;
  var rect2Right = rect2.left + rect2.width;
  return rect2Right < rect1Left || rect1Right < rect2Left;
}

function withSticky() {
  return function addStickyManager(WrappedComponent) {
    // eslint-disable-next-line shopify/react-initialize-state
    var WithStickyManager =
    /*#__PURE__*/
    function (_React$Component) {
      _inherits(WithStickyManager, _React$Component);

      function WithStickyManager(props, context) {
        var _this;

        _classCallCheck(this, WithStickyManager);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(WithStickyManager).call(this, props));
        _this.stickyManager = new StickyManager();
        var polaris = context.polaris;
        _this.polarisContext = Object.assign({}, polaris, {
          stickyManager: _this.stickyManager
        });
        return _this;
      }

      _createClass(WithStickyManager, [{
        key: "getChildContext",
        value: function getChildContext() {
          return {
            polaris: this.polarisContext
          };
        }
      }, {
        key: "render",
        value: function render() {
          return React.createElement(WrappedComponent, Object.assign({}, this.props, {
            polaris: this.polarisContext
          }));
        }
      }]);

      return WithStickyManager;
    }(React.Component);

    WithStickyManager.childContextTypes = polarisAppProviderContextTypes;
    WithStickyManager.contextTypes = WrappedComponent.contextTypes ? merge(WrappedComponent.contextTypes, polarisAppProviderContextTypes) : polarisAppProviderContextTypes;
    var FinalComponent = hoistStatics(WithStickyManager, WrappedComponent);
    return FinalComponent;
  };
}

var SCROLL_LOCKING_ATTRIBUTE = 'data-lock-scrolling';
var SCROLL_LOCKING_WRAPPER_ATTRIBUTE = 'data-lock-scrolling-wrapper';
var scrollPosition = 0;

var ScrollLockManager =
/*#__PURE__*/
function () {
  function ScrollLockManager() {
    _classCallCheck(this, ScrollLockManager);

    this.scrollLocks = 0;
    this.locked = false;
  }

  _createClass(ScrollLockManager, [{
    key: "registerScrollLock",
    value: function registerScrollLock() {
      this.scrollLocks += 1;
      this.handleScrollLocking();
    }
  }, {
    key: "unregisterScrollLock",
    value: function unregisterScrollLock() {
      this.scrollLocks -= 1;
      this.handleScrollLocking();
    }
  }, {
    key: "handleScrollLocking",
    value: function handleScrollLocking() {
      if (target.isServer) return;
      var scrollLocks = this.scrollLocks;
      var _document = document,
          body = _document.body;
      var wrapper = body.firstElementChild;

      if (scrollLocks === 0) {
        body.removeAttribute(SCROLL_LOCKING_ATTRIBUTE);

        if (wrapper) {
          wrapper.removeAttribute(SCROLL_LOCKING_WRAPPER_ATTRIBUTE);
        }

        window.scroll(0, scrollPosition);
        this.locked = false;
      } else if (scrollLocks > 0 && !this.locked) {
        scrollPosition = window.pageYOffset;
        body.setAttribute(SCROLL_LOCKING_ATTRIBUTE, '');

        if (wrapper) {
          wrapper.setAttribute(SCROLL_LOCKING_WRAPPER_ATTRIBUTE, '');
          wrapper.scrollTop = scrollPosition;
        }

        this.locked = true;
      }
    }
  }, {
    key: "resetScrollPosition",
    value: function resetScrollPosition() {
      scrollPosition = 0;
    }
  }]);

  return ScrollLockManager;
}();

var Link =
/*#__PURE__*/
function () {
  function Link(linkComponent) {
    _classCallCheck(this, Link);

    this.linkComponent = linkComponent;
  }

  _createClass(Link, [{
    key: "setLinkComponent",
    value: function setLinkComponent(link) {
      this.linkComponent = link;
    }
  }, {
    key: "getLinkComponent",
    value: function getLinkComponent() {
      return this.linkComponent;
    }
  }]);

  return Link;
}();

function createAppProviderContext() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      i18n = _ref.i18n,
      linkComponent = _ref.linkComponent,
      apiKey = _ref.apiKey,
      shopOrigin = _ref.shopOrigin,
      forceRedirect = _ref.forceRedirect,
      stickyManager = _ref.stickyManager,
      scrollLockManager = _ref.scrollLockManager,
      _ref$subscribe = _ref.subscribe,
      subscribe = _ref$subscribe === void 0 ? other.noop : _ref$subscribe,
      _ref$unsubscribe = _ref.unsubscribe,
      unsubscribe = _ref$unsubscribe === void 0 ? other.noop : _ref$unsubscribe;

  var intl = new Intl(i18n);
  var link = new Link(linkComponent);
  var appBridge = apiKey ? createApp__default({
    apiKey: apiKey,
    shopOrigin: shopOrigin || createApp.getShopOrigin(),
    forceRedirect: forceRedirect
  }) : undefined;

  if (appBridge && appBridge.hooks) {
    appBridge.hooks.set(createApp.LifecycleHook.DispatchAction, setClientInterfaceHook);
  }

  return {
    polaris: {
      intl: intl,
      link: link,
      stickyManager: stickyManager || new StickyManager(),
      scrollLockManager: scrollLockManager || new ScrollLockManager(),
      subscribe: subscribe,
      unsubscribe: unsubscribe,
      appBridge: appBridge
    }
  };
}
var setClientInterfaceHook = function setClientInterfaceHook(next) {
  return function (action) {
    action.clientInterface = {
      name: '@shopify/polaris',
      version: polarisVersion
    };
    return next(action);
  };
};

function createPolarisContext(contextOne, contextTwo) {
  var appProviderContext;
  var themeContext;

  if (contextOne && 'logo' in contextOne) {
    themeContext = contextOne;
    appProviderContext = contextTwo;
  } else {
    appProviderContext = contextOne;
    themeContext = contextTwo;
  }

  var appProvider = appProviderContext ? createAppProviderContext(appProviderContext) : createAppProviderContext();
  var theme = themeContext ? createThemeContext(themeContext) : createThemeContext();
  return Object.assign({}, appProvider, theme);
}

function withAppProvider() {
  return function addProvider(WrappedComponent) {
    var WithProvider =
    /*#__PURE__*/
    function (_React$Component) {
      _inherits(WithProvider, _React$Component);

      function WithProvider() {
        var _this;

        _classCallCheck(this, WithProvider);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(WithProvider).apply(this, arguments));

        _this.handleContextUpdate = function () {
          _this.forceUpdate();
        };

        return _this;
      }

      _createClass(WithProvider, [{
        key: "componentDidMount",
        value: function componentDidMount() {
          var _this$context = this.context,
              subscribeToPolaris = _this$context.polaris.subscribe,
              subscribeToTheme = _this$context.polarisTheme.subscribe;

          if (subscribeToPolaris) {
            subscribeToPolaris(this.handleContextUpdate);
          }

          if (subscribeToTheme) {
            subscribeToTheme(this.handleContextUpdate);
          }
        }
      }, {
        key: "componentWillUnmount",
        value: function componentWillUnmount() {
          var _this$context2 = this.context,
              unsubscribeToPolaris = _this$context2.polaris.unsubscribe,
              unsubscribeToTheme = _this$context2.polarisTheme.unsubscribe;

          if (unsubscribeToPolaris) {
            unsubscribeToPolaris(this.handleContextUpdate);
          }

          if (unsubscribeToTheme) {
            unsubscribeToTheme(this.handleContextUpdate);
          }
        }
      }, {
        key: "render",
        value: function render() {
          var _this$context3 = this.context,
              polaris = _this$context3.polaris,
              polarisTheme = _this$context3.polarisTheme;
          var polarisContext = Object.assign({}, polaris, {
            theme: polarisTheme
          });

          if (!polaris) {
            throw new Error("The <AppProvider> component is required as of v2.0 of Polaris React. See\n            https://polaris.shopify.com/components/structure/app-provider for implementation\n            instructions.");
          }

          return React.createElement(WrappedComponent, Object.assign({}, this.props, {
            polaris: polarisContext
          }));
        }
      }]);

      return WithProvider;
    }(React.Component);

    WithProvider.contextTypes = WrappedComponent.contextTypes ? merge(WrappedComponent.contextTypes, polarisAppProviderContextTypes) : polarisAppProviderContextTypes;
    var FinalComponent = hoistStatics(WithProvider, WrappedComponent);
    return FinalComponent;
  };
}

var AppProvider =
/*#__PURE__*/
function (_React$Component) {
  _inherits(AppProvider, _React$Component);

  function AppProvider(props) {
    var _this;

    _classCallCheck(this, AppProvider);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AppProvider).call(this, props));
    _this.subscriptions = [];

    _this.subscribe = function (callback) {
      _this.subscriptions.push(callback);
    };

    _this.unsubscribe = function (callback) {
      _this.subscriptions = _this.subscriptions.filter(function (subscription) {
        return subscription !== callback;
      });
    };

    _this.stickyManager = new StickyManager();
    _this.scrollLockManager = new ScrollLockManager();

    var _a = _this.props,
        theme = _a.theme,
        children = _a.children,
        rest = tslib_1.__rest(_a, ["theme", "children"]);

    _this.polarisContext = createAppProviderContext(Object.assign({}, rest, {
      stickyManager: _this.stickyManager,
      scrollLockManager: _this.scrollLockManager,
      subscribe: _this.subscribe,
      unsubscribe: _this.unsubscribe
    }));
    return _this;
  }

  _createClass(AppProvider, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (document != null) {
        this.stickyManager.setContainer(document);
      }
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(_ref) {
      var i18n = _ref.i18n,
          linkComponent = _ref.linkComponent,
          apiKey = _ref.apiKey,
          shopOrigin = _ref.shopOrigin,
          forceRedirect = _ref.forceRedirect;

      if (i18n !== this.props.i18n || linkComponent !== this.props.linkComponent || apiKey !== this.props.apiKey || shopOrigin !== this.props.shopOrigin || forceRedirect !== this.props.forceRedirect) {
        var stickyManager = this.stickyManager;
        this.polarisContext = createAppProviderContext({
          i18n: i18n,
          linkComponent: linkComponent,
          apiKey: apiKey,
          shopOrigin: shopOrigin,
          forceRedirect: forceRedirect,
          stickyManager: stickyManager,
          subscribe: this.subscribe,
          unsubscribe: this.unsubscribe
        });
      }

      this.subscriptions.forEach(function (subscriberCallback) {
        return subscriberCallback();
      });
    }
  }, {
    key: "getChildContext",
    value: function getChildContext() {
      return this.polarisContext;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props$theme = this.props.theme,
          theme = _this$props$theme === void 0 ? {
        logo: null
      } : _this$props$theme;
      return React.createElement(ThemeProvider, {
        theme: theme
      }, React.Children.only(this.props.children));
    }
  }]);

  return AppProvider;
}(React.Component);
AppProvider.childContextTypes = polarisAppProviderContextTypes;

function Image(_a) {
  var sourceSet = _a.sourceSet,
      source = _a.source,
      crossOrigin = _a.crossOrigin,
      rest = tslib_1.__rest(_a, ["sourceSet", "source", "crossOrigin"]);

  var finalSourceSet = sourceSet ? sourceSet.map(function (_ref) {
    var subSource = _ref.source,
        descriptor = _ref.descriptor;
    return "".concat(subSource, " ").concat(descriptor);
  }).join(',') : null;
  return finalSourceSet ? // eslint-disable-next-line jsx-a11y/alt-text
  React.createElement("img", Object.assign({
    src: source,
    srcSet: finalSourceSet,
    crossOrigin: crossOrigin
  }, rest)) : // eslint-disable-next-line jsx-a11y/alt-text
  React.createElement("img", Object.assign({
    src: source
  }, rest, {
    crossOrigin: crossOrigin
  }));
}

var styles$1 = {
  "Avatar": "Polaris-Avatar",
  "hidden": "Polaris-Avatar--hidden",
  "sizeSmall": "Polaris-Avatar--sizeSmall",
  "sizeMedium": "Polaris-Avatar--sizeMedium",
  "sizeLarge": "Polaris-Avatar--sizeLarge",
  "styleOne": "Polaris-Avatar--styleOne",
  "styleTwo": "Polaris-Avatar--styleTwo",
  "styleThree": "Polaris-Avatar--styleThree",
  "styleFour": "Polaris-Avatar--styleFour",
  "styleFive": "Polaris-Avatar--styleFive",
  "styleSix": "Polaris-Avatar--styleSix",
  "hasImage": "Polaris-Avatar--hasImage",
  "Image": "Polaris-Avatar__Image",
  "Initials": "Polaris-Avatar__Initials",
  "Svg": "Polaris-Avatar__Svg",
};

var avatar1 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBmaWxsPSIjMjQ1YjQ4IiBkPSJNMCAwaDEwMHYxMDBIMHoiLz48cGF0aCBmaWxsPSIjMmRiMTY3IiBkPSJNNjkgMHY2NS42NWwtMi0uMDF2MTkuODVsMiAuMDJWMTAwSDBWMGg2OXoiLz48cGF0aCBmaWxsPSIjZmZmIiBkPSJNNjcgNjUuNjR2MTkuODVsLTI1LjU3LS4xOUMzMiA4NS4yMiAyNS42IDgxLjQ2IDI1LjY4IDcyLjA2cy4yNS02Ljc0LjI1LTYuNzR6Ii8+PHBhdGggZmlsbD0iIzhkYzk1OCIgZD0iTTg2Ljk5IDU4SDY5VjBoMTAuOTNsNy4wNiA1OHoiLz48cGF0aCBmaWxsPSIjZWJlZGYxIiBkPSJNMjQuNTMgNDAuMjlhMTIuMjMgMTIuMjMgMCAwIDEgMjQuNDYgMCIgb3BhY2l0eT0iLjIiLz48cGF0aCBmaWxsPSIjOGRjOTU4IiBkPSJNNTkuNjIgNThBMTAuNjkgMTAuNjkgMCAwIDEgODEgNTh6Ii8+PC9zdmc+Cg==';

var avatar2 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBmaWxsPSIjMWUyNjVjIiBkPSJNLS4wMSAwaDEwMHYxMDBoLTEwMHoiLz48cGF0aCBmaWxsPSIjNWQ2Y2MxIiBkPSJNLS4wMSAwaDY5LjAydjEwMEgtLjAxeiIvPjxwYXRoIGZpbGw9IiNmZmYiIGQ9Ik02OC45MyA2NS44OGwtMjQuNDQtLjE5LS4wNSA2LjA5YzAgNS4yMiAzLjQ4IDkuNDcgOC42OSA5LjUybDE1LjguMTJ6Ii8+PHBhdGggZmlsbD0iI2ZmYzA0ZCIgZD0iTTY4LjkxIDExLjNsMTkuMTcgNDYuMjktMTkuMTctLjE2VjExLjN6Ii8+PHBhdGggZmlsbD0iI2ZmZiIgc3Ryb2tlPSIjZmZmIiBzdHJva2UtbWl0ZXJsaW1pdD0iMTAiIGQ9Ik0yMy4yNSAzNi40M2EzLjIyIDMuMjIgMCAxIDAgMCA2LjQ0bTIxLjAxLTYuNDRhMy4yMiAzLjIyIDAgMCAwIDAgNi40NG0tMTMuNTUgMy43NGEzLjIyIDMuMjIgMCAxIDAgMCA2LjQ0bTMuMjItMjUuNTFhMy4yMiAzLjIyIDAgMCAwIDAgNi40NCIvPjwvc3ZnPgo=';

var avatar3 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBmaWxsPSIjNWQ2Y2MxIiBkPSJNLS4wMiAwaDEwMHYxMDBoLTEwMHoiLz48cGF0aCBmaWxsPSIjNmRjYWNlIiBkPSJNLjM5IDBoNjkuMDJ2MTAwSC4zOXoiLz48cGF0aCBmaWxsPSJub25lIiBzdHJva2U9IiNmZmYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLW1pdGVybGltaXQ9IjEwIiBzdHJva2Utd2lkdGg9IjUiIGQ9Ik0yNC4xOCAzMS4yMXYzLjQ3QTEwLjQzIDEwLjQzIDAgMCAwIDM0LjQgNDUuMjFhMTAuNDMgMTAuNDMgMCAwIDAgMTAuMjItMTAuNTN2LTMuNDciLz48cGF0aCBmaWxsPSIjZWJlZGYxIiBkPSJNMjAuMTEgNDkuMDdhMTYuMjIgMTYuMjIgMCAxIDEgMCAzMi40NCIgb3BhY2l0eT0iLjIiLz48cGF0aCBkPSJNNjkuNDQgMTguODNMOTAgNzFINjkuNDRWMTguODN6IiBmaWxsPSIjZmZmIi8+PHBhdGggZD0iTTU3LjU5IDcxYTYgNiAwIDAgMSAxMiAweiIgZmlsbD0iI2ZmZiIvPjwvc3ZnPgo=';

var avatar4 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBmaWxsPSIjZmZlMGMzIiBkPSJNMC0uMDFoMTAwdjEwMEgweiIvPjxwYXRoIGZpbGw9IiM1ZDZjYzEiIGQ9Ik0wIDBoNjkuMDJ2MTAwSDB6Ii8+PHBhdGggZD0iTTY5LjAyIDBsMjQuMDMgNjEuNjlINjkuMDJWMHoiIGZpbGw9IiNmZjk2N2QiLz48cGF0aCBmaWxsPSJub25lIiBzdHJva2U9IiNmZmYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLW1pdGVybGltaXQ9IjEwIiBzdHJva2Utd2lkdGg9IjUiIGQ9Ik0zMC42OSAzMS45MXYtM2MwLTQuNzggMy40Ni04LjY1IDgtOC42NXM4IDMuODcgOCA4LjY1djMiLz48cGF0aCBmaWxsPSIjZWJlZGYxIiBkPSJNMTIuNzYgNTYuMDZhMTMuMzYgMTMuMzYgMCAxIDEgMjYuNzIgMCIgb3BhY2l0eT0iLjIiLz48cGF0aCBkPSJNODAgNjEuNDZsLTI5LjM0LjIzdi03LjMzYzAtNi4yOCA0LjA3LTExLjM2IDEwLjM0LTExLjQ0bDE5LS4xNHoiIGZpbGw9IiNmZjk2N2QiLz48L3N2Zz4K';

var avatar5 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBmaWxsPSIjOGRjOTU4IiBkPSJNMCAwaDcwLjAydjEwMEgweiIvPjxwYXRoIGQ9Ik02OS45MiAwdjU2LjMyTDQ5IDY3bC0uMyAyNS4wN1YxMDBIMTAwVjB6IiBmaWxsPSIjMmRiMTY3Ii8+PHBhdGggZmlsbD0iIzI0NWI0OCIgZD0iTTU5LjI3IDU4LjI5YTUuMjIgNS4yMiAwIDAgMC05LjQzIDQuNDgiLz48cGF0aCBkPSJNMjcuMTIgOS4zM2g0NC41M3YyLjE5SDI3LjEyem0tMTIuNDEgOS40OWg1Ni45NHYyLjE5SDE0LjcxeiIgZmlsbD0iIzJkYjE2NyIvPjxjaXJjbGUgY3g9IjE5LjY2IiBjeT0iNDQuOCIgcj0iMTEuMjIiIGZpbGw9IiNlYmVkZjEiIG9wYWNpdHk9Ii4yIi8+PC9zdmc+Cg==';

var avatar6 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBkPSJNLS4wMi0uMDFoMTAwdjEwMGgtMTAweiIgZmlsbD0iI2ZmZTBjMyIvPjxwYXRoIGZpbGw9IiNmZjk2N2QiIGQ9Ik0wIDBoNjkuNDF2MTAwSDB6Ii8+PHBhdGggZD0iTTY5LjkyIDB2NDQuMzJMNTEuMzQgNTV2NDVIMTAwVjB6IiBmaWxsPSIjZmZlMGMzIi8+PHBhdGggZmlsbD0iIzMyY2FjNiIgZD0iTTM5LjMyIDc2YTExLjg1IDExLjg1IDAgMCAwIDEyIDExLjYyVjc2Ii8+PHBhdGggZmlsbD0iIzAwOTc5NiIgZD0iTTM5LjMyIDc2YTEyIDEyIDAgMCAxIDEyLTExLjgyVjc2Ii8+PHBhdGggZmlsbD0ibm9uZSIgc3Ryb2tlPSIjZmZmIiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1taXRlcmxpbWl0PSIxMCIgc3Ryb2tlLXdpZHRoPSI1IiBkPSJNNDMuNzQgMTkuODNhMTIuODIgMTIuODIgMCAxIDEtMjUuNjQgMCIvPjxwYXRoIGZpbGw9Im5vbmUiIHN0cm9rZT0iI2ZmZiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbWl0ZXJsaW1pdD0iMTAiIHN0cm9rZS13aWR0aD0iNCIgZD0iTTI3LjM5IDMxLjZsLTEuNTggNS45Nm05LjM3LTUuNzJsMi41NSA1LjQ3bTQuMjYtOS44NWwzLjUzIDQuNW0tMjUuNDMtNC41bC0zLjUzIDQuNSIvPjwvc3ZnPgo=';

var avatar7 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBkPSJNMCAwaDEwMHYxMDAuNDhIMHoiIGZpbGw9IiM4ZGM5NTgiLz48cGF0aCBmaWxsPSIjMmRiMTY3IiBkPSJNODMgNjh2MzJsLTE0LS4xNnYuMTZIMFYwaDY5djY4aDE0eiIvPjxwYXRoIGQ9Ik02OS4yOSA0MS42OUgyMC42NnMtLjA5LTMtLjE3IDcuMTUgNyAxOC41MSAxNy4zNSAxOC41OWwzMS40NS41N3oiIGZpbGw9IiM4ZGM5NTgiLz48cGF0aCBkPSJNNjguNyAxMi40bDExLjU0IDI5LjI5SDY4LjdWMTIuNHoiIGZpbGw9IiNmZmYiLz48cGF0aCBkPSJNNjIuMjIgNDEuNjlhMy4zNCAzLjM0IDAgMSAxIDYuNjkgMHoiIGZpbGw9IiNmZmYiLz48cGF0aCBmaWxsPSIjMjQ1YjQ4IiBkPSJNNDEuNDUgMTguMDZhMi41NyAyLjU3IDAgMCAwLTUuMTQgME0zMy4zMyAyNGEyLjU3IDIuNTcgMCAxIDAtNS4xNCAwbTIwLjM2IDIuNThhMi41NyAyLjU3IDAgMSAwLTUuMTQgMCIvPjwvc3ZnPgo=';

var avatar8 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBmaWxsPSIjZmZlZGI5IiBkPSJNMCAwaDEwMHYxMDBIMHoiLz48cGF0aCBkPSJNNjQuNjMgMTcuMzNhMTcgMTcgMCAwIDEgNSAyOS43MiAxNi43NSAxNi43NSAwIDAgMS01IDIuNjIiIGZpbGw9Im5vbmUiIHN0cm9rZT0iI2ZmZiIgc3Ryb2tlLW1pdGVybGltaXQ9IjEwIiBzdHJva2Utd2lkdGg9IjUiLz48cGF0aCBmaWxsPSIjZmZjMDRkIiBkPSJNMCAwaDY5LjAydjEwMEgweiIvPjxjaXJjbGUgY3g9IjQ1LjExIiBjeT0iMzMuNDkiIHI9IjE2Ljk4IiBmaWxsPSJub25lIiBzdHJva2U9IiNmZmYiIHN0cm9rZS1taXRlcmxpbWl0PSIxMCIgc3Ryb2tlLXdpZHRoPSI1IiB0cmFuc2Zvcm09InJvdGF0ZSgtMzcuMDIgNDUuMTI0IDMzLjQ5MykiLz48cGF0aCBmaWxsPSIjNWQ2Y2MxIiBkPSJNNjkuMDIgMzQuNDhsMTkuNDcgMzguNzQtMTkuNDcgMS41M1YzNC40OHoiLz48cGF0aCBkPSJNNjEuNiAzMy42N2ExMC4xNyAxMC4xNyAwIDAgMSAxNS40LjA4IiBmaWxsPSJub25lIiBzdHJva2U9IiNmZmYiIHN0cm9rZS1taXRlcmxpbWl0PSIxMCIgc3Ryb2tlLXdpZHRoPSI1Ii8+PC9zdmc+Cg==';

var avatar9 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBkPSJNMCAwaDEwMHYxMDBIMHoiIGZpbGw9IiNmZmMwNGQiLz48cGF0aCBkPSJNMCAwaDY5LjQxdjEwMEgweiIgZmlsbD0iIzVkNmNjMSIvPjxwYXRoIGQ9Ik03MC4yMSA4MC44OGgtMTUuMWMtNC44MSAwLTUuNjgtNS44NC01LjY4LTUuODRoMjAuNzgiIGZpbGw9IiNmZmMwNGQiLz48cGF0aCBkPSJNODIgNjAuNDhsLTE0IC4yNVYwaDEwLjE3QzgwLjU5IDIwLjE0IDgyIDYwLjQ4IDgyIDYwLjQ4eiIgZmlsbD0iIzVkNmNjMSIvPjxwYXRoIGZpbGw9IiM0MTIzNmUiIGQ9Ik01Ny43MSA2MC40OGE1LjQ0IDUuNDQgMCAxIDEgMTAuODcgMCIvPjxjaXJjbGUgY3g9IjI0Ljc3IiBjeT0iNDAuMTkiIHI9IjExLjIyIiBmaWxsPSIjZWJlZGYxIiBvcGFjaXR5PSIuMiIvPjwvc3ZnPgo=';



var avatars = /*#__PURE__*/Object.freeze({
    avatarOne: avatar1,
    avatarTwo: avatar2,
    avatarThree: avatar3,
    avatarFour: avatar4,
    avatarFive: avatar5,
    avatarSix: avatar6,
    avatarSeven: avatar7,
    avatarEight: avatar8,
    avatarNine: avatar9
});

var STYLE_CLASSES = ['one', 'two', 'three', 'four', 'five', 'six'];
var AVATAR_IMAGES = Object.keys(avatars).map( // import/namespace does not allow computed values by default
// eslint-disable-next-line import/namespace
function (key) {
  return avatars[key];
});
var Avatar =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Avatar, _React$PureComponent);

  function Avatar() {
    var _this;

    _classCallCheck(this, Avatar);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Avatar).apply(this, arguments));
    _this.state = {
      hasError: false,
      hasLoaded: false
    };

    _this.handleError = function () {
      _this.setState({
        hasError: true,
        hasLoaded: false
      });
    };

    _this.handleLoad = function () {
      _this.setState({
        hasLoaded: true,
        hasError: false
      });
    };

    return _this;
  }

  _createClass(Avatar, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          name = _this$props.name,
          source = _this$props.source,
          initials = _this$props.initials,
          customer = _this$props.customer,
          _this$props$size = _this$props.size,
          size = _this$props$size === void 0 ? 'medium' : _this$props$size,
          accessibilityLabel = _this$props.accessibilityLabel,
          intl = _this$props.polaris.intl;
      var _this$state = this.state,
          hasError = _this$state.hasError,
          hasLoaded = _this$state.hasLoaded;
      var hasImage = (source || customer) && !hasError;
      var nameString = name || initials;
      var finalSource;
      var label;

      if (accessibilityLabel) {
        label = accessibilityLabel;
      } else if (name) {
        label = name;
      } else if (initials) {
        var splitInitials = initials.split('').join(' ');
        label = intl.translate('Polaris.Avatar.labelWithInitials', {
          initials: splitInitials
        });
      } else {
        label = intl.translate('Polaris.Avatar.label');
      }

      if (source) {
        finalSource = source;
      } else if (customer) {
        finalSource = customerPlaceholder(nameString);
      }

      var className = styles.classNames(styles$1.Avatar, styles$1[styles.variationName('style', styleClass(nameString))], size && styles$1[styles.variationName('size', size)], hasImage && !hasLoaded && styles$1.hidden, hasImage && styles$1.hasImage);
      var imageMarkUp = finalSource && !target.isServer && !hasError ? React.createElement(Image, {
        className: styles$1.Image,
        source: finalSource,
        alt: "",
        role: "presentation",
        onLoad: this.handleLoad,
        onError: this.handleError
      }) : null; // Use `dominant-baseline: central` instead of `dy` when Edge supports it.

      var verticalOffset = '0.35em';
      var initialsMarkup = initials && !hasImage ? React.createElement("span", {
        className: styles$1.Initials
      }, React.createElement("svg", {
        className: styles$1.Svg,
        viewBox: "0 0 48 48"
      }, React.createElement("text", {
        x: "50%",
        y: "50%",
        dy: verticalOffset,
        fill: "currentColor",
        fontSize: "26",
        textAnchor: "middle"
      }, initials))) : null;
      return React.createElement("span", {
        "aria-label": label,
        role: "img",
        className: className
      }, initialsMarkup, imageMarkUp);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (props.source !== state.prevSource) {
        return {
          prevSource: props.source,
          hasError: false,
          hasLoaded: false
        };
      }

      return null;
    }
  }]);

  return Avatar;
}(React.PureComponent);

function styleClass(name) {
  return name ? STYLE_CLASSES[name.charCodeAt(0) % STYLE_CLASSES.length] : STYLE_CLASSES[0];
}

function customerPlaceholder(name) {
  return name ? AVATAR_IMAGES[name.charCodeAt(0) % AVATAR_IMAGES.length] : AVATAR_IMAGES[0];
}

var Avatar$1 = withAppProvider()(Avatar);

function handleMouseUpByBlurring(_ref) {
  var currentTarget = _ref.currentTarget;
  currentTarget.blur();
}

var _React$createContext = React.createContext({
  forwardedRef: null
}),
    Provider = _React$createContext.Provider,
    Consumer = _React$createContext.Consumer;

function withRef() {
  return function addForwardRef(WrappedComponent) {
    var WithRef =
    /*#__PURE__*/
    function (_React$Component) {
      _inherits(WithRef, _React$Component);

      function WithRef() {
        _classCallCheck(this, WithRef);

        return _possibleConstructorReturn(this, _getPrototypeOf(WithRef).apply(this, arguments));
      }

      _createClass(WithRef, [{
        key: "render",
        value: function render() {
          var _this = this;

          return React.createElement(Consumer, null, function (ctx) {
            return React.createElement(WrappedComponent, Object.assign({}, _this.props, {
              ref: ctx.forwardedRef
            }));
          });
        }
      }]);

      return WithRef;
    }(React.Component);

    var FinalComponent = hoistStatics(WithRef, WrappedComponent);
    return FinalComponent;
  };
}

function compose$2() {
  for (var _len = arguments.length, wrappingFunctions = new Array(_len), _key = 0; _key < _len; _key++) {
    wrappingFunctions[_key] = arguments[_key];
  }

  return function wrapComponent(OriginalComponent) {
    var Result = compose.apply(void 0, wrappingFunctions)(OriginalComponent); // eslint-disable-next-line react/display-name

    return React.forwardRef(function (props, ref) {
      return React.createElement(Provider, {
        value: {
          forwardedRef: ref
        }
      }, React.createElement(Result, props));
    });
  };
}

var UnstyledLink =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(UnstyledLink, _React$PureComponent);

  function UnstyledLink() {
    _classCallCheck(this, UnstyledLink);

    return _possibleConstructorReturn(this, _getPrototypeOf(UnstyledLink).apply(this, arguments));
  }

  _createClass(UnstyledLink, [{
    key: "render",
    value: function render() {
      var _a = this.props,
          polaris = _a.polaris,
          external = _a.external,
          url = _a.url,
          rest = tslib_1.__rest(_a, ["polaris", "external", "url"]);

      if (polaris && polaris.link) {
        var LinkComponent = polaris.link.getLinkComponent();

        if (LinkComponent) {
          var _b = this.props,
              _polaris = _b.polaris,
              _rest = tslib_1.__rest(_b, ["polaris"]);

          return React.createElement(LinkComponent, Object.assign({}, unstyled.props, _rest));
        }
      }

      var target$$1 = external ? '_blank' : undefined;
      var rel = external ? 'noopener noreferrer' : undefined;
      return React.createElement("a", Object.assign({
        target: target$$1
      }, rest, {
        href: url,
        rel: rel
      }, unstyled.props));
    }
  }]);

  return UnstyledLink;
}(React.PureComponent);
var UnstyledLink$1 = compose$2(withAppProvider(), withRef())(UnstyledLink);

var styles$2 = {
  "Icon": "Polaris-Icon",
  "hasBackdrop": "Polaris-Icon--hasBackdrop",
  "isColored": "Polaris-Icon--isColored",
  "colorWhite": "Polaris-Icon--colorWhite",
  "colorBlack": "Polaris-Icon--colorBlack",
  "colorSkyLighter": "Polaris-Icon--colorSkyLighter",
  "colorSkyLight": "Polaris-Icon--colorSkyLight",
  "colorSky": "Polaris-Icon--colorSky",
  "colorSkyDark": "Polaris-Icon--colorSkyDark",
  "colorInkLightest": "Polaris-Icon--colorInkLightest",
  "colorInkLighter": "Polaris-Icon--colorInkLighter",
  "colorInkLight": "Polaris-Icon--colorInkLight",
  "colorInk": "Polaris-Icon--colorInk",
  "colorBlueLighter": "Polaris-Icon--colorBlueLighter",
  "colorBlueLight": "Polaris-Icon--colorBlueLight",
  "colorBlue": "Polaris-Icon--colorBlue",
  "colorBlueDark": "Polaris-Icon--colorBlueDark",
  "colorBlueDarker": "Polaris-Icon--colorBlueDarker",
  "colorIndigoLighter": "Polaris-Icon--colorIndigoLighter",
  "colorIndigoLight": "Polaris-Icon--colorIndigoLight",
  "colorIndigo": "Polaris-Icon--colorIndigo",
  "colorIndigoDark": "Polaris-Icon--colorIndigoDark",
  "colorIndigoDarker": "Polaris-Icon--colorIndigoDarker",
  "colorTealLighter": "Polaris-Icon--colorTealLighter",
  "colorTealLight": "Polaris-Icon--colorTealLight",
  "colorTeal": "Polaris-Icon--colorTeal",
  "colorTealDark": "Polaris-Icon--colorTealDark",
  "colorTealDarker": "Polaris-Icon--colorTealDarker",
  "colorGreenLighter": "Polaris-Icon--colorGreenLighter",
  "colorGreen": "Polaris-Icon--colorGreen",
  "colorGreenDark": "Polaris-Icon--colorGreenDark",
  "colorYellowLighter": "Polaris-Icon--colorYellowLighter",
  "colorYellow": "Polaris-Icon--colorYellow",
  "colorYellowDark": "Polaris-Icon--colorYellowDark",
  "colorOrange": "Polaris-Icon--colorOrange",
  "colorOrangeDark": "Polaris-Icon--colorOrangeDark",
  "colorRedLighter": "Polaris-Icon--colorRedLighter",
  "colorRed": "Polaris-Icon--colorRed",
  "colorRedDark": "Polaris-Icon--colorRedDark",
  "colorPurple": "Polaris-Icon--colorPurple",
  "Svg": "Polaris-Icon__Svg",
  "Img": "Polaris-Icon__Img",
  "Placeholder": "Polaris-Icon__Placeholder",
};

var BUNDLED_ICONS = {
  add: polarisIcons.PlusMinor,
  alert: polarisIcons.AlertMinor,
  arrowDown: polarisIcons.ArrowDownMinor,
  arrowLeft: polarisIcons.ArrowLeftMinor,
  arrowRight: polarisIcons.ArrowRightMinor,
  arrowUp: polarisIcons.ArrowUpMinor,
  arrowUpDown: polarisIcons.ArrowUpDownMinor,
  calendar: polarisIcons.CalendarMinor,
  cancel: polarisIcons.MobileCancelMajorMonotone,
  cancelSmall: polarisIcons.CancelSmallMinor,
  caretDown: polarisIcons.CaretDownMinor,
  caretUp: polarisIcons.CaretUpMinor,
  checkmark: polarisIcons.TickSmallMinor,
  chevronDown: polarisIcons.ChevronDownMinor,
  chevronLeft: polarisIcons.ChevronLeftMinor,
  chevronRight: polarisIcons.ChevronRightMinor,
  chevronUp: polarisIcons.ChevronUpMinor,
  circleCancel: polarisIcons.CircleCancelMinor,
  circleChevronDown: polarisIcons.CircleChevronDownMinor,
  circleChevronLeft: polarisIcons.CircleChevronLeftMinor,
  circleChevronRight: polarisIcons.CircleChevronRightMinor,
  circleChevronUp: polarisIcons.CircleChevronUpMinor,
  circleInformation: polarisIcons.CircleInformationMajorTwotone,
  circlePlus: polarisIcons.CirclePlusMinor,
  circlePlusOutline: polarisIcons.CirclePlusOutlineMinor,
  conversation: polarisIcons.ConversationMinor,
  delete: polarisIcons.DeleteMinor,
  disable: polarisIcons.CircleDisableMinor,
  dispute: polarisIcons.DisputeMinor,
  duplicate: polarisIcons.DuplicateMinor,
  embed: polarisIcons.EmbedMinor,
  export: polarisIcons.ExportMinor,
  external: polarisIcons.ExternalMinor,
  help: polarisIcons.QuestionMarkMajorTwotone,
  home: polarisIcons.HomeMajorMonotone,
  horizontalDots: polarisIcons.HorizontalDotsMinor,
  import: polarisIcons.ImportMinor,
  logOut: polarisIcons.LogOutMinor,
  menu: polarisIcons.MobileHamburgerMajorMonotone,
  notes: polarisIcons.NoteMinor,
  notification: polarisIcons.NotificationMajorMonotone,
  onlineStore: polarisIcons.OnlineStoreMajorTwotone,
  orders: polarisIcons.OrdersMajorTwotone,
  print: polarisIcons.PrintMinor,
  products: polarisIcons.ProductsMajorTwotone,
  profile: polarisIcons.ProfileMinor,
  refresh: polarisIcons.RefreshMinor,
  risk: polarisIcons.RiskMinor,
  save: polarisIcons.SaveMinor,
  search: polarisIcons.SearchMinor,
  subtract: polarisIcons.MinusMinor,
  view: polarisIcons.ViewMinor
};
var COLORS_WITH_BACKDROPS = ['teal', 'tealDark', 'greenDark', 'redDark', 'yellowDark', 'ink', 'inkLighter'];

function Icon(_ref) {
  var source = _ref.source,
      color = _ref.color,
      backdrop = _ref.backdrop,
      accessibilityLabel = _ref.accessibilityLabel,
      _ref$untrusted = _ref.untrusted,
      untrusted = _ref$untrusted === void 0 ? false : _ref$untrusted,
      intl = _ref.polaris.intl;

  if (color && backdrop && COLORS_WITH_BACKDROPS.indexOf(color) < 0) {
    // eslint-disable-next-line no-console
    console.warn(intl.translate('Polaris.Icon.backdropWarning', {
      color: color,
      colorsWithBackDrops: COLORS_WITH_BACKDROPS.join(', ')
    }));
  }

  var className = styles.classNames(styles$2.Icon, color && styles$2[styles.variationName('color', color)], color && color !== 'white' && styles$2.isColored, backdrop && styles$2.hasBackdrop);
  var defaultIconProps = {
    className: styles$2.Svg,
    focusable: 'false',
    'aria-hidden': 'true'
  };

  if (untrusted) {
    // eslint-disable-next-line no-console
    console.warn('Deprecation: The untrusted prop is no longer needed, all strings passed into the Icon component are rendered as unsafe');
  }

  var SourceComponent = source;
  var contentMarkup;

  if (source === 'placeholder') {
    contentMarkup = React.createElement("div", {
      className: styles$2.Placeholder
    });
  } else if (isBundledIcon(source)) {
    SourceComponent = BUNDLED_ICONS[source];
    contentMarkup = React.createElement(SourceComponent, defaultIconProps);
  } else if (typeof source === 'function') {
    var sourceElement = React.createElement(SourceComponent, defaultIconProps);

    if (React.isValidElement(sourceElement)) {
      contentMarkup = sourceElement;
    }
  } else if (React.isValidElement(source)) {
    // eslint-disable-next-line no-console
    console.warn('Deprecation: passing a React Element to the Icon component is deprecated and will be removed in the next major version. Pass a React Component instead.');
    contentMarkup = source;
  } else if (isUntrustedSVG(source)) {
    contentMarkup = React.createElement("img", {
      className: styles$2.Img,
      src: "data:image/svg+xml;utf8,".concat(source),
      alt: "",
      "aria-hidden": "true"
    });
  } else if (isSVGSource(source)) {
    contentMarkup = renderSVG(source);
  }

  return React.createElement("span", {
    className: className,
    "aria-label": accessibilityLabel
  }, contentMarkup);
}

function renderSVG(iconSource) {
  return React.createElement("svg", {
    className: styles$2.Svg,
    viewBox: iconSource.viewBox,
    dangerouslySetInnerHTML: {
      __html: iconSource.body
    },
    focusable: "false",
    "aria-hidden": "true"
  });
}

function isBundledIcon(key) {
  return typeof key === 'string' && Object.keys(BUNDLED_ICONS).includes(key);
}

function isSVGSource(source) {
  return source != null && source.hasOwnProperty('viewBox') && source.hasOwnProperty('body');
}

function isUntrustedSVG(source) {
  return typeof source === 'string';
}

var Icon$1 = withAppProvider()(Icon);

var styles$3 = {
  "Spinner": "Polaris-Spinner",
  "loading": "Polaris-Spinner--loading",
  "sizeSmall": "Polaris-Spinner--sizeSmall",
  "sizeLarge": "Polaris-Spinner--sizeLarge",
  "colorWhite": "Polaris-Spinner--colorWhite",
  "colorTeal": "Polaris-Spinner--colorTeal",
  "colorInkLightest": "Polaris-Spinner--colorInkLightest",
};

var spinnerLarge = 'data:image/svg+xml;base64,PHN2ZyB2aWV3Qm94PSIwIDAgNDQgNDQiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTE1LjU0MiAxLjQ4N0EyMS41MDcgMjEuNTA3IDAgMCAwIC41IDIyYzAgMTEuODc0IDkuNjI2IDIxLjUgMjEuNSAyMS41IDkuODQ3IDAgMTguMzY0LTYuNjc1IDIwLjgwOS0xNi4wNzJhMS41IDEuNSAwIDAgMC0yLjkwNC0uNzU2QzM3LjgwMyAzNC43NTUgMzAuNDczIDQwLjUgMjIgNDAuNSAxMS43ODMgNDAuNSAzLjUgMzIuMjE3IDMuNSAyMmMwLTguMTM3IDUuMy0xNS4yNDcgMTIuOTQyLTE3LjY1YTEuNSAxLjUgMCAxIDAtLjktMi44NjN6IiBmaWxsPSIjOTE5RUFCIi8+PC9zdmc+Cg==';

var spinnerSmall = 'data:image/svg+xml;base64,PHN2ZyB2aWV3Qm94PSIwIDAgMjAgMjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTcuMjI5IDEuMTczYTkuMjUgOS4yNSAwIDEgMCAxMS42NTUgMTEuNDEyIDEuMjUgMS4yNSAwIDEgMC0yLjQtLjY5OCA2Ljc1IDYuNzUgMCAxIDEtOC41MDYtOC4zMjkgMS4yNSAxLjI1IDAgMSAwLS43NS0yLjM4NXoiIGZpbGw9IiM5MTlFQUIiLz48L3N2Zz4K';

var COLORS_FOR_LARGE_SPINNER = ['teal', 'inkLightest'];

function Spinner(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'large' : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'teal' : _ref$color,
      accessibilityLabel = _ref.accessibilityLabel,
      intl = _ref.polaris.intl;

  if (size === 'large' && COLORS_FOR_LARGE_SPINNER.indexOf(color) < 0) {
    if (process.env.NODE_ENV === 'development') {
      // eslint-disable-next-line no-console
      console.warn(intl.translate('Polaris.Spinner.warningMessage', {
        color: color,
        size: size,
        colors: COLORS_FOR_LARGE_SPINNER.join(', ')
      }));
    } // eslint-disable-next-line no-param-reassign


    size = 'small';
  }

  var className = styles.classNames(styles$3.Spinner, color && styles$3[styles.variationName('color', color)], size && styles$3[styles.variationName('size', size)]);
  var spinnerSVG = size === 'large' ? spinnerLarge : spinnerSmall;
  return React.createElement(Image, {
    alt: "",
    source: spinnerSVG,
    className: className,
    draggable: false,
    role: "status",
    "aria-label": accessibilityLabel
  });
}

var Spinner$1 = withAppProvider()(Spinner);

var styles$4 = {
  "Button": "Polaris-Button",
  "disabled": "Polaris-Button--disabled",
  "Content": "Polaris-Button__Content",
  "Icon": "Polaris-Button__Icon",
  "Spinner": "Polaris-Button__Spinner",
  "primary": "Polaris-Button--primary",
  "destructive": "Polaris-Button--destructive",
  "outline": "Polaris-Button--outline",
  "loading": "Polaris-Button--loading",
  "plain": "Polaris-Button--plain",
  "iconOnly": "Polaris-Button--iconOnly",
  "fullWidth": "Polaris-Button--fullWidth",
  "sizeSlim": "Polaris-Button--sizeSlim",
  "sizeLarge": "Polaris-Button--sizeLarge",
  "monochrome": "Polaris-Button--monochrome",
  "Text": "Polaris-Button__Text",
};

var DEFAULT_SIZE = 'medium';

function Button(_ref) {
  var id = _ref.id,
      url = _ref.url,
      disabled = _ref.disabled,
      loading = _ref.loading,
      children = _ref.children,
      accessibilityLabel = _ref.accessibilityLabel,
      ariaControls = _ref.ariaControls,
      ariaExpanded = _ref.ariaExpanded,
      ariaPressed = _ref.ariaPressed,
      onClick = _ref.onClick,
      onFocus = _ref.onFocus,
      onBlur = _ref.onBlur,
      onKeyDown = _ref.onKeyDown,
      onKeyPress = _ref.onKeyPress,
      onKeyUp = _ref.onKeyUp,
      external = _ref.external,
      download = _ref.download,
      icon = _ref.icon,
      primary = _ref.primary,
      outline = _ref.outline,
      destructive = _ref.destructive,
      disclosure = _ref.disclosure,
      plain = _ref.plain,
      monochrome = _ref.monochrome,
      submit = _ref.submit,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? DEFAULT_SIZE : _ref$size,
      fullWidth = _ref.fullWidth,
      intl = _ref.polaris.intl;
  var isDisabled = disabled || loading;
  var className = reactUtilities.classNames(styles$4.Button, primary && styles$4.primary, outline && styles$4.outline, destructive && styles$4.destructive, isDisabled && styles$4.disabled, loading && styles$4.loading, plain && styles$4.plain, monochrome && styles$4.monochrome, size && size !== DEFAULT_SIZE && styles$4[reactUtilities.variationName('size', size)], fullWidth && styles$4.fullWidth, icon && children == null && styles$4.iconOnly);
  var disclosureIconMarkup = disclosure ? React.createElement(IconWrapper, null, React.createElement(Icon$1, {
    source: loading ? 'placeholder' : polarisIcons.CaretDownMinor
  })) : null;
  var iconMarkup;

  if (icon) {
    var iconInner = isIconSource(icon) ? React.createElement(Icon$1, {
      source: loading ? 'placeholder' : icon
    }) : icon;
    iconMarkup = React.createElement(IconWrapper, null, iconInner);
  }

  var childMarkup = children ? React.createElement("span", {
    className: styles$4.Text
  }, children) : null;
  var spinnerColor = primary || destructive ? 'white' : 'inkLightest';
  var spinnerSVGMarkup = loading ? React.createElement("span", {
    className: styles$4.Spinner
  }, React.createElement(Spinner$1, {
    size: "small",
    color: spinnerColor,
    accessibilityLabel: intl.translate('Polaris.Button.spinnerAccessibilityLabel')
  })) : null;
  var content = iconMarkup || disclosureIconMarkup ? React.createElement("span", {
    className: styles$4.Content
  }, spinnerSVGMarkup, iconMarkup, childMarkup, disclosureIconMarkup) : React.createElement("span", {
    className: styles$4.Content
  }, spinnerSVGMarkup, childMarkup);
  var type = submit ? 'submit' : 'button';

  if (url) {
    return isDisabled ? // Render an `<a>` so toggling disabled/enabled state changes only the
    // `href` attribute instead of replacing the whole element.
    // eslint-disable-next-line jsx-a11y/anchor-is-valid
    React.createElement("a", {
      id: id,
      className: className,
      "aria-label": accessibilityLabel
    }, content) : React.createElement(UnstyledLink$1, {
      id: id,
      url: url,
      external: external,
      download: download,
      onClick: onClick,
      onFocus: onFocus,
      onBlur: onBlur,
      onMouseUp: handleMouseUpByBlurring,
      className: className,
      "aria-label": accessibilityLabel
    }, content);
  }

  return React.createElement("button", {
    id: id,
    type: type,
    onClick: onClick,
    onFocus: onFocus,
    onBlur: onBlur,
    onKeyDown: onKeyDown,
    onKeyUp: onKeyUp,
    onKeyPress: onKeyPress,
    onMouseUp: handleMouseUpByBlurring,
    className: className,
    disabled: isDisabled,
    "aria-label": accessibilityLabel,
    "aria-controls": ariaControls,
    "aria-expanded": ariaExpanded,
    "aria-pressed": ariaPressed,
    role: loading ? 'alert' : undefined,
    "aria-busy": loading ? true : undefined
  }, content);
}

function IconWrapper(_ref2) {
  var children = _ref2.children;
  return React.createElement("span", {
    className: styles$4.Icon
  }, children);
}

function isIconSource(x) {
  return typeof x === 'string' || _typeof(x) === 'object' && x.body || typeof x === 'function';
}

var Button$1 = withAppProvider()(Button);

function buttonsFrom(actions$$1) {
  var overrides = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  if (Array.isArray(actions$$1)) {
    return actions$$1.map(function (action, index) {
      return buttonFrom(action, overrides, index);
    });
  } else {
    var action = actions$$1;
    return buttonFrom(action, overrides);
  }
}
function buttonFrom(_a, overrides, key) {
  var content = _a.content,
      onAction = _a.onAction,
      action = tslib_1.__rest(_a, ["content", "onAction"]);

  return React.createElement(Button$1, Object.assign({
    key: key,
    onClick: onAction
  }, action, overrides), content);
}

var styles$5 = {
  "ButtonGroup": "Polaris-ButtonGroup",
  "Item": "Polaris-ButtonGroup__Item",
  "Item-plain": "Polaris-ButtonGroup__Item--plain",
  "segmented": "Polaris-ButtonGroup--segmented",
  "Item-focused": "Polaris-ButtonGroup__Item--focused",
  "fullWidth": "Polaris-ButtonGroup--fullWidth",
  "connectedTop": "Polaris-ButtonGroup--connectedTop",
};

var Item =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Item, _React$PureComponent);

  function Item() {
    var _this;

    _classCallCheck(this, Item);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Item).apply(this, arguments));
    _this.state = {
      focused: false
    };

    _this.handleFocus = function () {
      _this.setState({
        focused: true
      });
    };

    _this.handleBlur = function () {
      _this.setState({
        focused: false
      });
    };

    return _this;
  }

  _createClass(Item, [{
    key: "render",
    value: function render() {
      var button = this.props.button;
      var focused = this.state.focused;
      var className = styles.classNames(styles$5.Item, focused && styles$5['Item-focused'], button.props.plain && styles$5['Item-plain']);
      return React.createElement("div", {
        className: className,
        onFocus: this.handleFocus,
        onBlur: this.handleBlur
      }, button);
    }
  }]);

  return Item;
}(React.PureComponent);

function ButtonGroup(_ref) {
  var children = _ref.children,
      segmented = _ref.segmented,
      fullWidth = _ref.fullWidth,
      connectedTop = _ref.connectedTop;
  var className = styles.classNames(styles$5.ButtonGroup, segmented && styles$5.segmented, fullWidth && styles$5.fullWidth, connectedTop && styles$5.connectedTop);
  var contents = reactUtilities.elementChildren(children).map(function (child, index) {
    return React.createElement(Item, {
      button: child,
      key: index
    });
  });
  return React.createElement("div", {
    className: className
  }, contents);
}

var styles$6 = {
  "Stack": "Polaris-Stack",
  "Item": "Polaris-Stack__Item",
  "noWrap": "Polaris-Stack--noWrap",
  "spacingNone": "Polaris-Stack--spacingNone",
  "spacingExtraTight": "Polaris-Stack--spacingExtraTight",
  "spacingTight": "Polaris-Stack--spacingTight",
  "spacingLoose": "Polaris-Stack--spacingLoose",
  "spacingExtraLoose": "Polaris-Stack--spacingExtraLoose",
  "distributionLeading": "Polaris-Stack--distributionLeading",
  "distributionTrailing": "Polaris-Stack--distributionTrailing",
  "distributionCenter": "Polaris-Stack--distributionCenter",
  "distributionEqualSpacing": "Polaris-Stack--distributionEqualSpacing",
  "distributionFill": "Polaris-Stack--distributionFill",
  "distributionFillEvenly": "Polaris-Stack--distributionFillEvenly",
  "alignmentLeading": "Polaris-Stack--alignmentLeading",
  "alignmentTrailing": "Polaris-Stack--alignmentTrailing",
  "alignmentCenter": "Polaris-Stack--alignmentCenter",
  "alignmentFill": "Polaris-Stack--alignmentFill",
  "alignmentBaseline": "Polaris-Stack--alignmentBaseline",
  "vertical": "Polaris-Stack--vertical",
  "Item-fill": "Polaris-Stack__Item--fill",
};

function Item$1(_ref) {
  var children = _ref.children,
      fill = _ref.fill;
  var className = styles.classNames(styles$6.Item, fill && styles$6['Item-fill']);
  return React.createElement("div", {
    className: className
  }, children);
}

var Stack =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Stack, _React$PureComponent);

  function Stack() {
    _classCallCheck(this, Stack);

    return _possibleConstructorReturn(this, _getPrototypeOf(Stack).apply(this, arguments));
  }

  _createClass(Stack, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          vertical = _this$props.vertical,
          spacing = _this$props.spacing,
          distribution = _this$props.distribution,
          alignment = _this$props.alignment,
          wrap = _this$props.wrap;
      var className = styles.classNames(styles$6.Stack, vertical && styles$6.vertical, spacing && styles$6[styles.variationName('spacing', spacing)], distribution && styles$6[styles.variationName('distribution', distribution)], alignment && styles$6[styles.variationName('alignment', alignment)], wrap === false && styles$6.noWrap);
      var itemMarkup = reactUtilities.elementChildren(children).map(function (child, index) {
        var props = {
          key: index
        };
        return reactUtilities.wrapWithComponent(child, Item$1, props);
      });
      return React.createElement("div", {
        className: className
      }, itemMarkup);
    }
  }]);

  return Stack;
}(React.PureComponent);
Stack.Item = Item$1;

var styles$7 = {
  "Heading": "Polaris-Heading",
};

function Heading(_ref) {
  var _ref$element = _ref.element,
      Element = _ref$element === void 0 ? 'h2' : _ref$element,
      children = _ref.children;
  return React.createElement(Element, {
    className: styles$7.Heading
  }, children);
}

var styles$8 = {
  "Card": "Polaris-Card",
  "subdued": "Polaris-Card--subdued",
  "Header": "Polaris-Card__Header",
  "Section": "Polaris-Card__Section",
  "Section-fullWidth": "Polaris-Card__Section--fullWidth",
  "Section-subdued": "Polaris-Card__Section--subdued",
  "SectionHeader": "Polaris-Card__SectionHeader",
  "Footer": "Polaris-Card__Footer",
};

function Header(_ref) {
  var children = _ref.children,
      title = _ref.title,
      actions$$1 = _ref.actions;
  var actionMarkup = actions$$1 ? React.createElement(ButtonGroup, null, buttonsFrom(actions$$1, {
    plain: true
  })) : null;
  var titleMarkup = React.isValidElement(title) ? title : React.createElement(Heading, null, title);
  var headingMarkup = actionMarkup || children ? React.createElement(Stack, {
    alignment: "baseline"
  }, React.createElement(Stack.Item, {
    fill: true
  }, titleMarkup), actionMarkup, children) : titleMarkup;
  return React.createElement("div", {
    className: styles$8.Header
  }, headingMarkup);
}

var styles$9 = {
  "Subheading": "Polaris-Subheading",
};

function Subheading(_ref) {
  var _ref$element = _ref.element,
      Element = _ref$element === void 0 ? 'h3' : _ref$element,
      children = _ref.children;
  var ariaLabel = typeof children === 'string' ? children : undefined;
  return React.createElement(Element, {
    "aria-label": ariaLabel,
    className: styles$9.Subheading
  }, children);
}

function Section(_ref) {
  var children = _ref.children,
      title = _ref.title,
      subdued = _ref.subdued,
      fullWidth = _ref.fullWidth;
  var className = styles.classNames(styles$8.Section, subdued && styles$8['Section-subdued'], fullWidth && styles$8['Section-fullWidth']);
  var headerMarkup = null;

  if (title) {
    var headerContent = typeof title === 'string' ? React.createElement(Subheading, null, title) : title;
    headerMarkup = React.createElement("div", {
      className: styles$8.SectionHeader
    }, headerContent);
  }

  return React.createElement("div", {
    className: className
  }, headerMarkup, children);
}

var Card =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Card, _React$PureComponent);

  function Card() {
    _classCallCheck(this, Card);

    return _possibleConstructorReturn(this, _getPrototypeOf(Card).apply(this, arguments));
  }

  _createClass(Card, [{
    key: "getChildContext",
    value: function getChildContext() {
      return {
        withinContentContainer: true
      };
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          title = _this$props.title,
          subdued = _this$props.subdued,
          sectioned = _this$props.sectioned,
          actions$$1 = _this$props.actions,
          primaryFooterAction = _this$props.primaryFooterAction,
          secondaryFooterAction = _this$props.secondaryFooterAction;
      var className = styles.classNames(styles$8.Card, subdued && styles$8.subdued);
      var headerMarkup = title || actions$$1 ? React.createElement(Header, {
        actions: actions$$1,
        title: title
      }) : null;
      var content = sectioned ? React.createElement(Section, null, children) : children;
      var primaryFooterActionMarkup = primaryFooterAction ? buttonFrom(primaryFooterAction, {
        primary: true
      }) : null;
      var secondaryFooterActionMarkup = secondaryFooterAction ? buttonFrom(secondaryFooterAction) : null;
      var footerMarkup = primaryFooterActionMarkup || secondaryFooterActionMarkup ? React.createElement("div", {
        className: styles$8.Footer
      }, React.createElement(ButtonGroup, null, secondaryFooterActionMarkup, primaryFooterActionMarkup)) : null;
      return React.createElement("div", {
        className: className
      }, headerMarkup, content, footerMarkup);
    }
  }]);

  return Card;
}(React.PureComponent);
Card.Section = Section;
Card.Header = Header;
Card.childContextTypes = contentContextTypes;

var styles$a = {
  "variationPositive": "Polaris-TextStyle--variationPositive",
  "variationNegative": "Polaris-TextStyle--variationNegative",
  "variationCode": "Polaris-TextStyle--variationCode",
  "variationStrong": "Polaris-TextStyle--variationStrong",
  "variationSubdued": "Polaris-TextStyle--variationSubdued",
};

var VariationValue;

(function (VariationValue) {
  VariationValue["Positive"] = "positive";
  VariationValue["Negative"] = "negative";
  VariationValue["Strong"] = "strong";
  VariationValue["Subdued"] = "subdued";
  VariationValue["Code"] = "code";
})(VariationValue || (VariationValue = {}));

function TextStyle(_ref) {
  var variation = _ref.variation,
      children = _ref.children;
  var className = styles.classNames(variation && styles$a[styles.variationName('variation', variation)], variation === VariationValue.Code && styles$a.code);
  var Element = variationElement(variation);
  return React.createElement(Element, {
    className: className
  }, children);
}

function variationElement(variation) {
  return variation === VariationValue.Code ? 'code' : 'span';
}

var styles$b = {
  "SettingAction": "Polaris-SettingAction",
  "Setting": "Polaris-SettingAction__Setting",
  "Action": "Polaris-SettingAction__Action",
};

function SettingAction(_ref) {
  var action = _ref.action,
      children = _ref.children;
  return React.createElement("div", {
    className: styles$b.SettingAction
  }, React.createElement("div", {
    className: styles$b.Setting
  }, children), React.createElement("div", {
    className: styles$b.Action
  }, action));
}

var styles$c = {
  "TermsOfService": "Polaris-AccountConnection__TermsOfService",
  "Content": "Polaris-AccountConnection__Content",
};

function AccountConnection(_ref) {
  var _ref$connected = _ref.connected,
      connected = _ref$connected === void 0 ? false : _ref$connected,
      action = _ref.action,
      avatarUrl = _ref.avatarUrl,
      _ref$accountName = _ref.accountName,
      accountName = _ref$accountName === void 0 ? '' : _ref$accountName,
      title = _ref.title,
      details = _ref.details,
      termsOfService = _ref.termsOfService;
  var initials = accountName ? accountName.split(/\s+/).map(function (name) {
    return name[0];
  }).join('') : undefined;
  var avatarMarkup = connected ? React.createElement(Avatar$1, {
    accessibilityLabel: "",
    name: accountName,
    initials: initials,
    source: avatarUrl
  }) : null;
  var titleMarkup = null;

  if (title) {
    titleMarkup = React.createElement("div", null, title);
  } else if (accountName) {
    titleMarkup = React.createElement("div", null, accountName);
  }

  var detailsMarkup = details ? React.createElement("div", null, React.createElement(TextStyle, {
    variation: "subdued"
  }, details)) : null;
  var termsOfServiceMarkup = termsOfService ? React.createElement("div", {
    className: styles$c.TermsOfService
  }, termsOfService) : null;
  var actionElement = action ? buttonFrom(action, {
    primary: !connected
  }) : null;
  return React.createElement(Card, {
    sectioned: true
  }, React.createElement(SettingAction, {
    action: actionElement
  }, React.createElement(Stack, null, avatarMarkup, React.createElement(Stack.Item, {
    fill: true
  }, React.createElement("div", {
    className: styles$c.Content
  }, titleMarkup, detailsMarkup)))), termsOfServiceMarkup);
}

var contextTypes = {
  scrollToPosition: PropTypes.func
};

var ScrollTo =
/*#__PURE__*/
function (_React$Component) {
  _inherits(ScrollTo, _React$Component);

  function ScrollTo() {
    var _this;

    _classCallCheck(this, ScrollTo);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ScrollTo).apply(this, arguments));
    _this.ref = React.createRef();
    return _this;
  }

  _createClass(ScrollTo, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var scrollToPosition = this.context.scrollToPosition;

      if (!scrollToPosition || !this.ref.current) {
        return;
      }

      scrollToPosition(this.ref.current.offsetTop);
    }
  }, {
    key: "render",
    value: function render() {
      var getUniqueId = other.createUniqueIDFactory("ScrollTo"); // eslint-disable-next-line jsx-a11y/anchor-is-valid

      return React.createElement("a", {
        id: getUniqueId(),
        ref: this.ref
      });
    }
  }]);

  return ScrollTo;
}(React.Component);
ScrollTo.contextTypes = contextTypes;

var styles$d = {
  "Scrollable": "Polaris-Scrollable",
  "horizontal": "Polaris-Scrollable--horizontal",
  "vertical": "Polaris-Scrollable--vertical",
  "hasTopShadow": "Polaris-Scrollable--hasTopShadow",
  "hasBottomShadow": "Polaris-Scrollable--hasBottomShadow",
};

var MAX_SCROLL_DISTANCE = 100;
var DELTA_THRESHOLD = 0.2;
var DELTA_PERCENTAGE = 0.2;
var EVENTS_TO_LOCK = ['scroll', 'touchmove', 'wheel'];
var PREFERS_REDUCED_MOTION = prefersReducedMotion();

var Scrollable =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Scrollable, _React$Component);

  function Scrollable() {
    var _this;

    _classCallCheck(this, Scrollable);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Scrollable).apply(this, arguments));
    _this.state = {
      topShadow: false,
      bottomShadow: false,
      scrollPosition: 0
    };
    _this.handleResize = debounce(function () {
      _this.handleScroll();
    }, 50, {
      trailing: true
    });

    _this.setScrollArea = function (scrollArea) {
      _this.scrollArea = scrollArea;
    };

    _this.handleScroll = function () {
      var _assertThisInitialize = _assertThisInitialized(_assertThisInitialized(_this)),
          scrollArea = _assertThisInitialize.scrollArea;

      var _this$props = _this.props,
          shadow = _this$props.shadow,
          onScrolledToBottom = _this$props.onScrolledToBottom;

      if (scrollArea == null) {
        return;
      }

      var scrollTop = scrollArea.scrollTop,
          clientHeight = scrollArea.clientHeight,
          scrollHeight = scrollArea.scrollHeight;
      var shouldBottomShadow = Boolean(shadow && !(scrollTop + clientHeight >= scrollHeight));
      var shouldTopShadow = Boolean(shadow && scrollTop > 0);
      var canScroll = scrollHeight > clientHeight;
      var hasScrolledToBottom = scrollHeight - scrollTop === clientHeight;

      if (canScroll && hasScrolledToBottom && onScrolledToBottom) {
        onScrolledToBottom();
      }

      _this.setState({
        topShadow: shouldTopShadow,
        bottomShadow: shouldBottomShadow,
        scrollPosition: scrollTop
      });
    };

    _this.scrollHint = function () {
      var _assertThisInitialize2 = _assertThisInitialized(_assertThisInitialized(_this)),
          scrollArea = _assertThisInitialize2.scrollArea;

      if (scrollArea == null) {
        return;
      }

      var clientHeight = scrollArea.clientHeight,
          scrollHeight = scrollArea.scrollHeight;

      if (PREFERS_REDUCED_MOTION || _this.state.scrollPosition > 0 || scrollHeight <= clientHeight) {
        return;
      }

      var scrollDistance = scrollHeight - clientHeight;

      _this.toggleLock();

      _this.setState({
        scrollPosition: scrollDistance > MAX_SCROLL_DISTANCE ? MAX_SCROLL_DISTANCE : scrollDistance
      }, function () {
        window.requestAnimationFrame(_this.scrollStep);
      });
    };

    _this.scrollStep = function () {
      _this.setState(function (_ref) {
        var scrollPosition = _ref.scrollPosition;
        var delta = scrollPosition * DELTA_PERCENTAGE;
        return {
          scrollPosition: delta < DELTA_THRESHOLD ? 0 : scrollPosition - delta
        };
      }, function () {
        if (_this.state.scrollPosition > 0) {
          window.requestAnimationFrame(_this.scrollStep);
        } else {
          _this.toggleLock(false);
        }
      });
    };

    _this.scrollToPosition = function (scrollY) {
      _this.setState({
        scrollPosition: scrollY
      });
    };

    return _this;
  }

  _createClass(Scrollable, [{
    key: "getChildContext",
    value: function getChildContext() {
      return {
        scrollToPosition: this.scrollToPosition
      };
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      var polaris = this.props.polaris;

      if (this.scrollArea == null) {
        return;
      }

      polaris.stickyManager.setContainer(this.scrollArea);
      events.addEventListener(this.scrollArea, 'scroll', function () {
        window.requestAnimationFrame(_this2.handleScroll);
      });
      events.addEventListener(window, 'resize', this.handleResize);
      window.requestAnimationFrame(function () {
        _this2.handleScroll();

        if (_this2.props.hint) {
          _this2.scrollHint();
        }
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var polaris = this.props.polaris;

      if (this.scrollArea == null) {
        return;
      }

      events.removeEventListener(this.scrollArea, 'scroll', this.handleScroll);
      events.removeEventListener(window, 'resize', this.handleResize);
      polaris.stickyManager.removeScrollListener();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var scrollPosition = this.state.scrollPosition;

      if (scrollPosition && this.scrollArea && scrollPosition > 0) {
        this.scrollArea.scrollTop = scrollPosition;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state = this.state,
          topShadow = _this$state.topShadow,
          bottomShadow = _this$state.bottomShadow;

      var _a = this.props,
          children = _a.children,
          className = _a.className,
          horizontal = _a.horizontal,
          _a$vertical = _a.vertical,
          vertical = _a$vertical === void 0 ? true : _a$vertical,
          shadow = _a.shadow,
          hint = _a.hint,
          onScrolledToBottom = _a.onScrolledToBottom,
          polaris = _a.polaris,
          rest = tslib_1.__rest(_a, ["children", "className", "horizontal", "vertical", "shadow", "hint", "onScrolledToBottom", "polaris"]);

      var finalClassName = styles.classNames(className, styles$d.Scrollable, vertical && styles$d.vertical, horizontal && styles$d.horizontal, topShadow && styles$d.hasTopShadow, bottomShadow && styles$d.hasBottomShadow);
      return React.createElement("div", Object.assign({
        className: finalClassName
      }, scrollable.props, rest, {
        ref: this.setScrollArea
      }), children);
    }
  }, {
    key: "toggleLock",
    value: function toggleLock() {
      var shouldLock = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      var scrollArea = this.scrollArea;

      if (scrollArea == null) {
        return;
      }

      EVENTS_TO_LOCK.forEach(function (eventName) {
        if (shouldLock) {
          events.addEventListener(scrollArea, eventName, prevent);
        } else {
          events.removeEventListener(scrollArea, eventName, prevent);
        }
      });
    }
  }], [{
    key: "forNode",
    value: function forNode(node) {
      return dom.closest(node, scrollable.selector) || document;
    }
  }]);

  return Scrollable;
}(React.Component);

Scrollable.childContextTypes = contextTypes;
Scrollable.ScrollTo = ScrollTo;

function prevent(evt) {
  evt.preventDefault();
}

function prefersReducedMotion() {
  try {
    return window.matchMedia('(prefers-reduced-motion: reduce)').matches;
  } catch (err) {
    return false;
  }
}

var Scrollable$1 = withSticky()(Scrollable);

var styles$e = {
  "VisuallyHidden": "Polaris-VisuallyHidden",
};

function VisuallyHidden(_ref) {
  var children = _ref.children;
  return React.createElement("span", {
    className: styles$e.VisuallyHidden
  }, children);
}

var styles$f = {
  "Badge": "Polaris-Badge",
  "Pip": "Polaris-Badge__Pip",
  "sizeSmall": "Polaris-Badge--sizeSmall",
  "statusSuccess": "Polaris-Badge--statusSuccess",
  "statusInfo": "Polaris-Badge--statusInfo",
  "statusAttention": "Polaris-Badge--statusAttention",
  "statusWarning": "Polaris-Badge--statusWarning",
  "statusNew": "Polaris-Badge--statusNew",
  "progressIncomplete": "Polaris-Badge--progressIncomplete",
  "progressPartiallyComplete": "Polaris-Badge--progressPartiallyComplete",
  "progressComplete": "Polaris-Badge--progressComplete",
};

var PROGRESS_LABELS = {
  incomplete: 'incomplete',
  partiallyComplete: 'partiallyComplete',
  complete: 'complete'
};
var STATUS_LABELS = {
  info: 'info',
  success: 'success',
  warning: 'warning',
  attention: 'attention',
  new: 'new'
};
var DEFAULT_SIZE$1 = 'medium';

function Badge(_ref) {
  var children = _ref.children,
      status = _ref.status,
      progress = _ref.progress,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? DEFAULT_SIZE$1 : _ref$size,
      intl = _ref.polaris.intl;
  var className = styles.classNames(styles$f.Badge, status && styles$f[styles.variationName('status', status)], progress && styles$f[styles.variationName('progress', progress)], size && size !== DEFAULT_SIZE$1 && styles$f[styles.variationName('size', size)]);
  var progressMarkup;

  switch (progress) {
    case PROGRESS_LABELS.incomplete:
      progressMarkup = intl.translate('Polaris.Badge.PROGRESS_LABELS.incomplete');
      break;

    case PROGRESS_LABELS.partiallyComplete:
      progressMarkup = intl.translate('Polaris.Badge.PROGRESS_LABELS.partiallyComplete');
      break;

    case PROGRESS_LABELS.complete:
      progressMarkup = intl.translate('Polaris.Badge.PROGRESS_LABELS.complete');
      break;
  }

  var pipMarkup = progress ? React.createElement("span", {
    className: styles$f.Pip
  }, React.createElement(VisuallyHidden, null, progressMarkup)) : null;
  var statusMarkup;

  switch (status) {
    case STATUS_LABELS.info:
      statusMarkup = intl.translate('Polaris.Badge.STATUS_LABELS.info');
      break;

    case STATUS_LABELS.success:
      statusMarkup = intl.translate('Polaris.Badge.STATUS_LABELS.success');
      break;

    case STATUS_LABELS.warning:
      statusMarkup = intl.translate('Polaris.Badge.STATUS_LABELS.warning');
      break;

    case STATUS_LABELS.attention:
      statusMarkup = intl.translate('Polaris.Badge.STATUS_LABELS.attention');
      break;

    case STATUS_LABELS.new:
      statusMarkup = intl.translate('Polaris.Badge.STATUS_LABELS.new');
      break;
  }

  var statusLabelMarkup = status ? React.createElement(VisuallyHidden, null, statusMarkup) : null;
  return React.createElement("span", {
    className: className
  }, statusLabelMarkup, pipMarkup, children);
}

var Badge$1 = withAppProvider()(Badge);

var styles$g = {
  "ActionList": "Polaris-ActionList",
  "Section-withoutTitle": "Polaris-ActionList__Section--withoutTitle",
  "Actions": "Polaris-ActionList__Actions",
  "Section": "Polaris-ActionList__Section",
  "Title": "Polaris-ActionList__Title",
  "Item": "Polaris-ActionList__Item",
  "active": "Polaris-ActionList--active",
  "destructive": "Polaris-ActionList--destructive",
  "disabled": "Polaris-ActionList--disabled",
  "Image": "Polaris-ActionList__Image",
  "Content": "Polaris-ActionList__Content",
  "Text": "Polaris-ActionList__Text",
  "BadgeWrapper": "Polaris-ActionList__BadgeWrapper",
};

function Item$2(_ref) {
  var id = _ref.id,
      badge = _ref.badge,
      content = _ref.content,
      helpText = _ref.helpText,
      url = _ref.url,
      onAction = _ref.onAction,
      icon = _ref.icon,
      image = _ref.image,
      disabled = _ref.disabled,
      external = _ref.external,
      destructive = _ref.destructive,
      ellipsis = _ref.ellipsis,
      active = _ref.active,
      role = _ref.role;
  var className = reactUtilities.classNames(styles$g.Item, disabled && styles$g.disabled, destructive && styles$g.destructive, active && styles$g.active);
  var imageElement = null;

  if (icon) {
    imageElement = React.createElement("div", {
      className: styles$g.Image
    }, React.createElement(Icon$1, {
      source: icon
    }));
  } else if (image) {
    imageElement = React.createElement("div", {
      role: "presentation",
      className: styles$g.Image,
      style: {
        backgroundImage: "url(".concat(image)
      }
    });
  }

  var contentText = ellipsis && content ? "".concat(content, "\u2026") : content;
  var contentMarkup = helpText ? React.createElement("div", null, React.createElement("div", null, contentText), React.createElement(TextStyle, {
    variation: "subdued"
  }, helpText)) : contentText;
  var badgeMarkup = badge && React.createElement("span", {
    className: styles$g.BadgeWrapper
  }, React.createElement(Badge$1, {
    status: badge.status
  }, badge.content));
  var textMarkup = imageElement ? React.createElement("div", {
    className: styles$g.Text
  }, contentMarkup) : contentMarkup;
  var contentElement = React.createElement("div", {
    className: styles$g.Content
  }, imageElement, textMarkup, badgeMarkup);
  var scrollMarkup = active ? React.createElement(Scrollable$1.ScrollTo, null) : null;
  var control = url ? React.createElement(UnstyledLink$1, {
    id: id,
    url: url,
    onClick: onAction,
    className: className,
    external: external
  }, contentElement) : React.createElement("button", {
    id: id,
    onClick: onAction,
    className: className,
    disabled: disabled,
    type: "button"
  }, contentElement);
  return React.createElement("li", {
    role: role,
    "aria-selected": active
  }, scrollMarkup, control);
}

function Section$1(_ref) {
  var section = _ref.section,
      hasMultipleSections = _ref.hasMultipleSections,
      actionRole = _ref.actionRole,
      onActionAnyItem = _ref.onActionAnyItem;

  var handleAction = function handleAction(itemOnAction) {
    return function () {
      if (itemOnAction) {
        itemOnAction();
      }

      if (onActionAnyItem) {
        onActionAnyItem();
      }
    };
  };

  var actionMarkup = section.items.map(function (_a, index) {
    var content = _a.content,
        helpText = _a.helpText,
        onAction = _a.onAction,
        item = tslib_1.__rest(_a, ["content", "helpText", "onAction"]);

    return React.createElement(Item$2, Object.assign({
      key: "".concat(content, "-").concat(index),
      content: content,
      helpText: helpText,
      role: actionRole,
      onAction: handleAction(onAction)
    }, item));
  });
  var className = section.title ? undefined : styles$g['Section-withoutTitle'];
  var titleMarkup = section.title ? React.createElement("p", {
    className: styles$g.Title
  }, section.title) : null;
  var sectionRole = actionRole === 'option' ? 'presentation' : undefined;
  var sectionMarkup = React.createElement("div", {
    className: className
  }, titleMarkup, React.createElement("ul", {
    className: styles$g.Actions,
    role: sectionRole
  }, actionMarkup));
  return hasMultipleSections ? React.createElement("li", {
    className: styles$g.Section
  }, sectionMarkup) : sectionMarkup;
}

function ActionList(_ref) {
  var items = _ref.items,
      _ref$sections = _ref.sections,
      sections = _ref$sections === void 0 ? [] : _ref$sections,
      actionRole = _ref.actionRole,
      onActionAnyItem = _ref.onActionAnyItem;
  var finalSections = [];

  if (items) {
    finalSections = [{
      items: items
    }].concat(_toConsumableArray(sections));
  } else if (sections) {
    finalSections = sections;
  }

  var hasMultipleSections = finalSections.length > 1;
  var Element = hasMultipleSections ? 'ul' : 'div';
  var sectionMarkup = finalSections.map(function (section, index) {
    return React.createElement(Section$1, {
      key: section.title || index,
      section: section,
      onActionAnyItem: onActionAnyItem,
      hasMultipleSections: hasMultipleSections,
      actionRole: actionRole
    });
  });
  return React.createElement(Element, {
    className: styles$g.ActionList
  }, sectionMarkup);
}

function arraysAreEqual(firstArray, secondArray, comparator) {
  if (firstArray.length !== secondArray.length) {
    return false;
  }

  return firstArray.every(function (firstItem, index) {
    var secondItem = secondArray[index];

    if (comparator != null) {
      return comparator(firstItem, secondItem);
    }

    return firstItem === secondItem;
  });
}

var styles$h = {
  "Checkbox": "Polaris-OptionList-Checkbox",
  "Input": "Polaris-OptionList-Checkbox__Input",
  "Backdrop": "Polaris-OptionList-Checkbox__Backdrop",
  "Icon": "Polaris-OptionList-Checkbox__Icon",
  "active": "Polaris-OptionList-Checkbox--active",
};

var getUniqueID = other.createUniqueIDFactory('Checkbox');
function Checkbox(_ref) {
  var _ref$id = _ref.id,
      id = _ref$id === void 0 ? getUniqueID() : _ref$id,
      _ref$checked = _ref.checked,
      checked = _ref$checked === void 0 ? false : _ref$checked,
      disabled = _ref.disabled,
      active = _ref.active,
      onChange = _ref.onChange,
      name = _ref.name,
      value = _ref.value,
      role = _ref.role;
  var className = styles.classNames(styles$h.Checkbox, active && styles$h.active);
  return React.createElement("div", {
    className: className
  }, React.createElement("input", {
    id: id,
    name: name,
    value: value,
    type: "checkbox",
    checked: checked,
    disabled: disabled,
    className: styles$h.Input,
    "aria-checked": checked,
    onChange: onChange,
    role: role
  }), React.createElement("div", {
    className: styles$h.Backdrop
  }), React.createElement("div", {
    className: styles$h.Icon
  }, React.createElement(Icon$1, {
    source: polarisIcons.TickSmallMinor
  })));
}

var styles$i = {
  "Option": "Polaris-OptionList-Option",
  "SingleSelectOption": "Polaris-OptionList-Option__SingleSelectOption",
  "disabled": "Polaris-OptionList-Option--disabled",
  "Media": "Polaris-OptionList-Option__Media",
  "Label": "Polaris-OptionList-Option__Label",
  "Checkbox": "Polaris-OptionList-Option__Checkbox",
  "focused": "Polaris-OptionList-Option--focused",
  "select": "Polaris-OptionList-Option--select",
  "active": "Polaris-OptionList-Option--active",
};

var Option =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Option, _React$Component);

  function Option() {
    var _this;

    _classCallCheck(this, Option);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Option).apply(this, arguments));
    _this.state = {
      focused: false
    };

    _this.handleClick = function () {
      var _this$props = _this.props,
          onClick = _this$props.onClick,
          section = _this$props.section,
          index = _this$props.index,
          disabled = _this$props.disabled;

      if (disabled) {
        return;
      }

      onClick(section, index);
    };

    _this.toggleFocus = function () {
      _this.setState(function (prevState) {
        return {
          focused: !prevState.focused
        };
      });
    };

    return _this;
  }

  _createClass(Option, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          label = _this$props2.label,
          value = _this$props2.value,
          id = _this$props2.id,
          select = _this$props2.select,
          active = _this$props2.active,
          allowMultiple = _this$props2.allowMultiple,
          disabled = _this$props2.disabled,
          role = _this$props2.role,
          media = _this$props2.media;
      var focused = this.state.focused;
      var mediaMarkup = media ? React.createElement("div", {
        className: styles$i.Media
      }, media) : null;
      var singleSelectClassName = styles.classNames(styles$i.SingleSelectOption, focused && styles$i.focused, disabled && styles$i.disabled, select && styles$i.select, active && styles$i.active);
      var multiSelectClassName = styles.classNames(styles$i.Label, active && styles$i.active);
      var checkBoxRole = role === 'option' ? 'presentation' : undefined;
      var optionMarkup = allowMultiple ? React.createElement("label", {
        htmlFor: id,
        className: multiSelectClassName
      }, React.createElement("div", {
        className: styles$i.Checkbox
      }, React.createElement(Checkbox, {
        id: id,
        value: value,
        checked: select,
        active: active,
        disabled: disabled,
        onChange: this.handleClick,
        role: checkBoxRole
      })), mediaMarkup, label) : React.createElement("button", {
        id: id,
        type: "button",
        className: singleSelectClassName,
        onClick: this.handleClick,
        disabled: disabled,
        onFocus: this.toggleFocus,
        onBlur: this.toggleFocus
      }, mediaMarkup, label);
      var scrollMarkup = active ? React.createElement(Scrollable$1.ScrollTo, null) : null;
      return React.createElement("li", {
        key: id,
        className: styles$i.Option,
        tabIndex: -1,
        "aria-selected": active,
        role: role
      }, scrollMarkup, optionMarkup);
    }
  }]);

  return Option;
}(React.Component);

var styles$j = {
  "OptionList": "Polaris-OptionList",
  "Options": "Polaris-OptionList__Options",
  "Title": "Polaris-OptionList__Title",
};

var getUniqueId = other.createUniqueIDFactory('OptionList');
var OptionList =
/*#__PURE__*/
function (_React$Component) {
  _inherits(OptionList, _React$Component);

  function OptionList() {
    var _this;

    _classCallCheck(this, OptionList);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(OptionList).apply(this, arguments));
    _this.state = {
      normalizedOptions: createNormalizedOptions(_this.props.options, _this.props.sections, _this.props.title)
    };
    _this.id = _this.props.id || getUniqueId();

    _this.handleClick = function (sectionIndex, optionIndex) {
      var _this$props = _this.props,
          selected = _this$props.selected,
          onChange = _this$props.onChange,
          allowMultiple = _this$props.allowMultiple;
      var selectedValue = _this.state.normalizedOptions[sectionIndex].options[optionIndex].value;
      var foundIndex = selected.indexOf(selectedValue);

      if (allowMultiple) {
        var newSelection = foundIndex === -1 ? [selectedValue].concat(_toConsumableArray(selected)) : [].concat(_toConsumableArray(selected.slice(0, foundIndex)), _toConsumableArray(selected.slice(foundIndex + 1, selected.length)));
        onChange(newSelection);
        return;
      }

      onChange([selectedValue]);
    };

    return _this;
  }

  _createClass(OptionList, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(_ref) {
      var _ref$options = _ref.options,
          nextOptions = _ref$options === void 0 ? [] : _ref$options,
          _ref$sections = _ref.sections,
          nextSections = _ref$sections === void 0 ? [] : _ref$sections,
          nextID = _ref.id,
          nextTitle = _ref.title;
      var _this$props2 = this.props,
          _this$props2$options = _this$props2.options,
          options = _this$props2$options === void 0 ? [] : _this$props2$options,
          _this$props2$sections = _this$props2.sections,
          sections = _this$props2$sections === void 0 ? [] : _this$props2$sections,
          id = _this$props2.id,
          title = _this$props2.title;

      if (id !== nextID) {
        this.id = nextID || this.id;
      }

      var optionsChanged = !arraysAreEqual(nextOptions, options);
      var sectionsChanged = !arraysAreEqual(nextSections, sections, testSectionsPropEquality);
      var titleChanged = title !== nextTitle;

      if (optionsChanged || sectionsChanged || titleChanged) {
        this.setState({
          normalizedOptions: createNormalizedOptions(nextOptions, nextSections, nextTitle)
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var normalizedOptions = this.state.normalizedOptions;
      var _this$props3 = this.props,
          selected = _this$props3.selected,
          allowMultiple = _this$props3.allowMultiple,
          role = _this$props3.role,
          optionRole = _this$props3.optionRole;
      var optionsExist = normalizedOptions.length > 0;
      var optionsMarkup = optionsExist ? normalizedOptions.map(function (_ref2, sectionIndex) {
        var title = _ref2.title,
            options = _ref2.options;
        var titleMarkup = title ? React.createElement("p", {
          className: styles$j.Title,
          role: role
        }, title) : null;
        var optionsMarkup = options && options.map(function (option, optionIndex) {
          var isSelected = selected.includes(option.value);
          var id = option.id || "".concat(_this2.id, "-").concat(sectionIndex, "-").concat(optionIndex);
          return React.createElement(Option, Object.assign({}, option, {
            key: id,
            id: id,
            section: sectionIndex,
            index: optionIndex,
            onClick: _this2.handleClick,
            select: isSelected,
            allowMultiple: allowMultiple,
            role: optionRole
          }));
        });
        return React.createElement("li", {
          key: title || "noTitle-".concat(sectionIndex)
        }, titleMarkup, React.createElement("ul", {
          className: styles$j.Options,
          id: _this2.id,
          role: role,
          "aria-multiselectable": allowMultiple
        }, optionsMarkup));
      }) : null;
      return React.createElement("ul", {
        className: styles$j.OptionList,
        role: role
      }, optionsMarkup);
    }
  }]);

  return OptionList;
}(React.Component);

function createNormalizedOptions(options, sections, title) {
  if (options == null) {
    var section = {
      options: [],
      title: title
    };
    return sections == null ? [] : [section].concat(_toConsumableArray(sections));
  }

  if (sections == null) {
    return [{
      title: title,
      options: options
    }];
  }

  return [{
    title: title,
    options: options
  }].concat(_toConsumableArray(sections));
}

function testSectionsPropEquality(previousSection, currentSection) {
  var previousOptions = previousSection.options;
  var currentOptions = currentSection.options;
  var optionsAreEqual = arraysAreEqual(previousOptions, currentOptions);
  var titlesAreEqual = previousSection.title === currentSection.title;
  return optionsAreEqual && titlesAreEqual;
}

var OptionList$1 = withAppProvider()(OptionList);

var getUniqueID$1 = other.createUniqueIDFactory('portal-');

var Portal =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Portal, _React$PureComponent);

  function Portal() {
    var _this;

    _classCallCheck(this, Portal);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Portal).apply(this, arguments));
    _this.state = {
      isMounted: false
    };
    _this.portalId = _this.props.idPrefix !== '' ? "".concat(_this.props.idPrefix, "-").concat(getUniqueID$1()) : getUniqueID$1();
    return _this;
  }

  _createClass(Portal, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.portalNode = document.createElement('div');
      this.portalNode.setAttribute('data-portal-id', this.portalId);
      document.body.appendChild(this.portalNode);
      this.setState({
        isMounted: true
      });
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_, prevState) {
      var _this$props$onPortalC = this.props.onPortalCreated,
          onPortalCreated = _this$props$onPortalC === void 0 ? other.noop : _this$props$onPortalC;

      if (!prevState.isMounted && this.state.isMounted) {
        onPortalCreated();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.body.removeChild(this.portalNode);
    }
  }, {
    key: "render",
    value: function render() {
      return this.state.isMounted ? ReactDOM.createPortal(this.props.children, this.portalNode) : null;
    }
  }]);

  return Portal;
}(React.PureComponent);
Portal.defaultProps = {
  idPrefix: ''
};

var styles$k = {
  "Popover": "Polaris-Popover",
  "fullWidth": "Polaris-Popover--fullWidth",
  "Content": "Polaris-Popover__Content",
  "measuring": "Polaris-Popover--measuring",
  "exiting": "Polaris-Popover--exiting",
  "positionedAbove": "Polaris-Popover--positionedAbove",
  "Wrapper": "Polaris-Popover__Wrapper",
  "Content-fullHeight": "Polaris-Popover__Content--fullHeight",
  "Pane": "Polaris-Popover__Pane",
  "Pane-fixed": "Polaris-Popover__Pane--fixed",
  "Section": "Polaris-Popover__Section",
  "FocusTracker": "Polaris-Popover__FocusTracker",
};

function Section$2(_ref) {
  var children = _ref.children;
  return React.createElement("div", {
    className: styles$k.Section
  }, children);
}

function Pane(_ref) {
  var fixed = _ref.fixed,
      sectioned = _ref.sectioned,
      children = _ref.children,
      onScrolledToBottom = _ref.onScrolledToBottom;
  var className = styles.classNames(styles$k.Pane, fixed && styles$k['Pane-fixed']);
  var content = sectioned ? reactUtilities.wrapWithComponent(children, Section$2) : children;
  return fixed ? React.createElement("div", {
    className: className
  }, content) : React.createElement(Scrollable$1, {
    hint: true,
    shadow: true,
    className: className,
    onScrolledToBottom: onScrolledToBottom
  }, content);
}

var EventListener =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(EventListener, _React$PureComponent);

  function EventListener() {
    _classCallCheck(this, EventListener);

    return _possibleConstructorReturn(this, _getPrototypeOf(EventListener).apply(this, arguments));
  }

  _createClass(EventListener, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.attachListener();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_a) {
      var passive = _a.passive,
          detachProps = tslib_1.__rest(_a, ["passive"]);

      this.detachListener(detachProps);
      this.attachListener();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.detachListener();
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }, {
    key: "attachListener",
    value: function attachListener() {
      var _this$props = this.props,
          event = _this$props.event,
          handler = _this$props.handler,
          capture = _this$props.capture,
          passive = _this$props.passive;
      events.addEventListener(window, event, handler, {
        capture: capture,
        passive: passive
      });
    }
  }, {
    key: "detachListener",
    value: function detachListener(prevProps) {
      var _ref = prevProps || this.props,
          event = _ref.event,
          handler = _ref.handler,
          capture = _ref.capture;

      events.removeEventListener(window, event, handler, capture);
    }
  }]);

  return EventListener;
}(React.PureComponent);

var KeypressListener =
/*#__PURE__*/
function (_React$Component) {
  _inherits(KeypressListener, _React$Component);

  function KeypressListener() {
    var _this;

    _classCallCheck(this, KeypressListener);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(KeypressListener).apply(this, arguments));

    _this.handleKeyEvent = function (event) {
      var _this$props = _this.props,
          keyCode = _this$props.keyCode,
          handler = _this$props.handler;

      if (event.keyCode === keyCode) {
        handler(event);
      }
    };

    return _this;
  }

  _createClass(KeypressListener, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      events.addEventListener(document, 'keyup', this.handleKeyEvent);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      events.removeEventListener(document, 'keyup', this.handleKeyEvent);
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);

  return KeypressListener;
}(React.Component);

function calculateVerticalPosition(activatorRect, overlayRect, overlayMargins, scrollableContainerRect, containerRect, preferredPosition, fixed) {
  var activatorTop = activatorRect.top;
  var activatorBottom = activatorTop + activatorRect.height;
  var spaceAbove = activatorRect.top;
  var spaceBelow = containerRect.height - activatorRect.top - activatorRect.height;
  var desiredHeight = overlayRect.height;
  var verticalMargins = overlayMargins.activator + overlayMargins.container;
  var minimumSpaceToScroll = overlayMargins.container;
  var distanceToTopScroll = activatorRect.top - Math.max(scrollableContainerRect.top, 0);
  var distanceToBottomScroll = containerRect.top + Math.min(containerRect.height, scrollableContainerRect.top + scrollableContainerRect.height) - (activatorRect.top + activatorRect.height);
  var enoughSpaceFromTopScroll = distanceToTopScroll >= minimumSpaceToScroll;
  var enoughSpaceFromBottomScroll = distanceToBottomScroll >= minimumSpaceToScroll;
  var heightIfBelow = Math.min(spaceBelow, desiredHeight);
  var heightIfAbove = Math.min(spaceAbove, desiredHeight);
  var containerRectTop = fixed ? 0 : containerRect.top;
  var positionIfAbove = {
    height: heightIfAbove - verticalMargins,
    top: activatorTop + containerRectTop - heightIfAbove,
    positioning: 'above'
  };
  var positionIfBelow = {
    height: heightIfBelow - verticalMargins,
    top: activatorBottom + containerRectTop,
    positioning: 'below'
  };

  if (preferredPosition === 'above') {
    return (enoughSpaceFromTopScroll || distanceToTopScroll >= distanceToBottomScroll && !enoughSpaceFromBottomScroll) && (spaceAbove > desiredHeight || spaceAbove > spaceBelow) ? positionIfAbove : positionIfBelow;
  }

  if (preferredPosition === 'below') {
    return (enoughSpaceFromBottomScroll || distanceToBottomScroll >= distanceToTopScroll && !enoughSpaceFromTopScroll) && (spaceBelow > desiredHeight || spaceBelow > spaceAbove) ? positionIfBelow : positionIfAbove;
  }

  if (enoughSpaceFromTopScroll && enoughSpaceFromBottomScroll) {
    return spaceAbove > spaceBelow ? positionIfAbove : positionIfBelow;
  }

  return distanceToTopScroll > minimumSpaceToScroll ? positionIfAbove : positionIfBelow;
}
function calculateHorizontalPosition(activatorRect, overlayRect, containerRect, overlayMargins, preferredAlignment) {
  var maximum = containerRect.width - overlayRect.width;

  if (preferredAlignment === 'left') {
    return Math.min(maximum, Math.max(0, activatorRect.left - overlayMargins.horizontal));
  } else if (preferredAlignment === 'right') {
    var activatorRight = activatorRect.left + activatorRect.width;
    return Math.min(maximum, Math.max(0, activatorRight - overlayRect.width + overlayMargins.horizontal));
  }

  return Math.min(maximum, Math.max(0, activatorRect.center.x - overlayRect.width / 2));
}
function rectIsOutsideOfRect(inner, outer) {
  var center = inner.center;
  return center.y < outer.top || center.y > outer.top + outer.height;
}

var styles$l = {
  "PositionedOverlay": "Polaris-PositionedOverlay",
  "fixed": "Polaris-PositionedOverlay--fixed",
  "calculating": "Polaris-PositionedOverlay--calculating",
};

var PositionedOverlay =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(PositionedOverlay, _React$PureComponent);

  function PositionedOverlay() {
    var _this;

    _classCallCheck(this, PositionedOverlay);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(PositionedOverlay).apply(this, arguments));
    _this.state = {
      measuring: true,
      activatorRect: geometry.getRectForNode(_this.props.activator),
      left: 0,
      top: 0,
      height: 0,
      width: null,
      positioning: 'below',
      zIndex: null,
      outsideScrollableContainer: false,
      lockPosition: false
    };
    _this.overlay = null;
    _this.scrollableContainer = null;

    _this.overlayDetails = function () {
      var _this$state = _this.state,
          measuring = _this$state.measuring,
          left = _this$state.left,
          positioning = _this$state.positioning,
          height = _this$state.height,
          activatorRect = _this$state.activatorRect;
      return {
        measuring: measuring,
        left: left,
        desiredHeight: height,
        positioning: positioning,
        activatorRect: activatorRect
      };
    };

    _this.setOverlay = function (node) {
      _this.overlay = node;
    };

    _this.handleMeasurement = function () {
      var _this$state2 = _this.state,
          lockPosition = _this$state2.lockPosition,
          top = _this$state2.top;

      _this.setState({
        left: 0,
        top: lockPosition ? top : 0,
        height: 0,
        positioning: 'below',
        measuring: true
      }, function () {
        if (_this.overlay == null || _this.scrollableContainer == null) {
          return;
        }

        var _this$props = _this.props,
            activator = _this$props.activator,
            _this$props$preferred = _this$props.preferredPosition,
            preferredPosition = _this$props$preferred === void 0 ? 'below' : _this$props$preferred,
            _this$props$preferred2 = _this$props.preferredAlignment,
            preferredAlignment = _this$props$preferred2 === void 0 ? 'center' : _this$props$preferred2,
            onScrollOut = _this$props.onScrollOut,
            fullWidth = _this$props.fullWidth,
            fixed = _this$props.fixed;
        var textFieldActivator = activator.querySelector('input');
        var activatorRect = textFieldActivator != null ? geometry.getRectForNode(textFieldActivator) : geometry.getRectForNode(activator);
        var currentOverlayRect = geometry.getRectForNode(_this.overlay);
        var scrollableElement = isDocument$1(_this.scrollableContainer) ? document.body : _this.scrollableContainer;
        var scrollableContainerRect = geometry.getRectForNode(scrollableElement);
        var overlayRect = fullWidth ? Object.assign({}, currentOverlayRect, {
          width: activatorRect.width
        }) : currentOverlayRect; // If `body` is 100% height, it still acts as though it were not constrained to that size. This adjusts for that.

        if (scrollableElement === document.body) {
          scrollableContainerRect.height = document.body.scrollHeight;
        }

        var overlayMargins = _this.overlay.firstElementChild ? getMarginsForNode(_this.overlay.firstElementChild) : {
          activator: 0,
          container: 0,
          horizontal: 0
        };
        var containerRect = windowRect();
        var zIndexForLayer = getZIndexForLayerFromNode(activator);
        var zIndex = zIndexForLayer == null ? zIndexForLayer : zIndexForLayer + 1;
        var verticalPosition = calculateVerticalPosition(activatorRect, overlayRect, overlayMargins, scrollableContainerRect, containerRect, preferredPosition, fixed);
        var horizontalPosition = calculateHorizontalPosition(activatorRect, overlayRect, containerRect, overlayMargins, preferredAlignment);

        _this.setState({
          measuring: false,
          activatorRect: geometry.getRectForNode(activator),
          left: horizontalPosition,
          top: lockPosition ? top : verticalPosition.top,
          lockPosition: Boolean(fixed),
          height: verticalPosition.height || 0,
          width: fullWidth ? overlayRect.width : null,
          positioning: verticalPosition.positioning,
          outsideScrollableContainer: onScrollOut != null && rectIsOutsideOfRect(activatorRect, intersectionWithViewport(scrollableContainerRect)),
          zIndex: zIndex
        });
      });
    };

    return _this;
  }

  _createClass(PositionedOverlay, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.scrollableContainer = Scrollable$1.forNode(this.props.activator);

      if (this.scrollableContainer && !this.props.fixed) {
        this.scrollableContainer.addEventListener('scroll', this.handleMeasurement);
      }

      this.handleMeasurement();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.scrollableContainer && !this.props.fixed) {
        this.scrollableContainer.removeEventListener('scroll', this.handleMeasurement);
      }
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps() {
      this.handleMeasurement();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var _this$state3 = this.state,
          outsideScrollableContainer = _this$state3.outsideScrollableContainer,
          top = _this$state3.top;
      var _this$props2 = this.props,
          onScrollOut = _this$props2.onScrollOut,
          active = _this$props2.active;

      if (active && onScrollOut != null && top !== 0 && outsideScrollableContainer) {
        onScrollOut();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state4 = this.state,
          left = _this$state4.left,
          top = _this$state4.top,
          zIndex = _this$state4.zIndex,
          width = _this$state4.width;
      var _this$props3 = this.props,
          render = _this$props3.render,
          fixed = _this$props3.fixed;
      var style = {
        top: top == null || isNaN(top) ? undefined : top,
        left: left == null || isNaN(left) ? undefined : left,
        width: width == null || isNaN(width) ? undefined : width,
        zIndex: zIndex == null || isNaN(zIndex) ? undefined : zIndex
      };
      var className = styles.classNames(styles$l.PositionedOverlay, fixed && styles$l.fixed);
      return React.createElement("div", {
        className: className,
        style: style,
        ref: this.setOverlay
      }, React.createElement(EventListener, {
        event: "resize",
        handler: this.handleMeasurement
      }), render(this.overlayDetails()));
    }
  }]);

  return PositionedOverlay;
}(React.PureComponent);
function intersectionWithViewport(rect) {
  var viewport = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : windowRect();
  var top = Math.max(rect.top, 0);
  var left = Math.max(rect.left, 0);
  var bottom = Math.min(rect.top + rect.height, viewport.height);
  var right = Math.min(rect.left + rect.width, viewport.width);
  return new geometry.Rect({
    top: top,
    left: left,
    height: bottom - top,
    width: right - left
  });
}

function getMarginsForNode(node) {
  var nodeStyles = window.getComputedStyle(node);
  return {
    activator: parseFloat(nodeStyles.marginTop || ''),
    container: parseFloat(nodeStyles.marginBottom || ''),
    horizontal: parseFloat(nodeStyles.marginLeft || '')
  };
}

function getZIndexForLayerFromNode(node) {
  var layerNode = dom.closest(node, layer.selector) || document.body;
  var zIndex = layerNode === document.body ? 'auto' : parseInt(window.getComputedStyle(layerNode).zIndex || '0', 10);
  return zIndex === 'auto' || isNaN(zIndex) ? null : zIndex;
}

function windowRect() {
  return new geometry.Rect({
    top: window.scrollY,
    left: window.scrollX,
    height: window.innerHeight,
    width: window.innerWidth
  });
}

function isDocument$1(node) {
  return node === document;
}

(function (CloseSource) {
  CloseSource[CloseSource["Click"] = 0] = "Click";
  CloseSource[CloseSource["EscapeKeypress"] = 1] = "EscapeKeypress";
  CloseSource[CloseSource["FocusOut"] = 2] = "FocusOut";
  CloseSource[CloseSource["ScrollOut"] = 3] = "ScrollOut";
})(exports.PopoverCloseSource || (exports.PopoverCloseSource = {}));

var PopoverOverlay =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(PopoverOverlay, _React$PureComponent);

  function PopoverOverlay() {
    var _this;

    _classCallCheck(this, PopoverOverlay);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(PopoverOverlay).apply(this, arguments));
    _this.contentNode = React.createRef();
    _this.transitionStatus = null;

    _this.renderOverlay = function (transitionStatus) {
      var _this$props = _this.props,
          active = _this$props.active,
          activator = _this$props.activator,
          fullWidth = _this$props.fullWidth,
          _this$props$preferred = _this$props.preferredPosition,
          preferredPosition = _this$props$preferred === void 0 ? 'below' : _this$props$preferred,
          _this$props$preferred2 = _this$props.preferredAlignment,
          preferredAlignment = _this$props$preferred2 === void 0 ? 'center' : _this$props$preferred2,
          fixed = _this$props.fixed;
      return React.createElement(PositionedOverlay, {
        fullWidth: fullWidth,
        active: active,
        activator: activator,
        preferredPosition: preferredPosition,
        preferredAlignment: preferredAlignment // eslint-disable-next-line react/jsx-no-bind
        ,
        render: _this.renderPopover.bind(_assertThisInitialized(_assertThisInitialized(_this)), transitionStatus),
        fixed: fixed,
        onScrollOut: _this.handleScrollOut
      });
    };

    _this.renderPopover = function (transitionStatus, overlayDetails) {
      var measuring = overlayDetails.measuring,
          desiredHeight = overlayDetails.desiredHeight,
          positioning = overlayDetails.positioning;
      var _this$props2 = _this.props,
          id = _this$props2.id,
          children = _this$props2.children,
          sectioned = _this$props2.sectioned,
          fullWidth = _this$props2.fullWidth,
          fullHeight = _this$props2.fullHeight;
      var className = styles.classNames(styles$k.Popover, transitionStatus && animationVariations(transitionStatus), positioning === 'above' && styles$k.positionedAbove, fullWidth && styles$k.fullWidth, measuring && styles$k.measuring);
      _this.transitionStatus = transitionStatus;
      var contentStyles = measuring ? undefined : {
        height: desiredHeight
      };
      var contentClassNames = styles.classNames(styles$k.Content, fullHeight && styles$k['Content-fullHeight']);
      var content = React.createElement("div", {
        id: id,
        tabIndex: -1,
        className: contentClassNames,
        style: contentStyles,
        ref: _this.contentNode
      }, renderPopoverContent(children, {
        sectioned: sectioned
      }));
      return React.createElement("div", Object.assign({
        className: className
      }, overlay.props), React.createElement(EventListener, {
        event: "click",
        handler: _this.handleClick
      }), React.createElement(EventListener, {
        event: "touchstart",
        handler: _this.handleClick
      }), React.createElement(KeypressListener, {
        keyCode: exports.Key.Escape,
        handler: _this.handleEscape
      }), React.createElement("div", {
        className: styles$k.FocusTracker // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
        ,
        tabIndex: 0,
        onFocus: _this.handleFocusFirstItem
      }), React.createElement("div", {
        className: styles$k.Wrapper
      }, content), React.createElement("div", {
        className: styles$k.FocusTracker // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
        ,
        tabIndex: 0,
        onFocus: _this.handleFocusLastItem
      }));
    };

    _this.handleClick = function (event) {
      var target$$1 = event.target;

      var _assertThisInitialize = _assertThisInitialized(_assertThisInitialized(_this)),
          contentNode = _assertThisInitialize.contentNode,
          _assertThisInitialize2 = _assertThisInitialize.props,
          activator = _assertThisInitialize2.activator,
          onClose = _assertThisInitialize2.onClose;

      var isDescendant = contentNode.current != null && dom.nodeContainsDescendant(contentNode.current, target$$1);
      var isActivatorDescendant = dom.nodeContainsDescendant(activator, target$$1);

      if (isDescendant || isActivatorDescendant || _this.transitionStatus !== 'entered') {
        return;
      }

      onClose(exports.PopoverCloseSource.Click);
    };

    _this.handleScrollOut = function () {
      _this.props.onClose(exports.PopoverCloseSource.ScrollOut);
    };

    _this.handleEscape = function () {
      _this.props.onClose(exports.PopoverCloseSource.EscapeKeypress);
    };

    _this.handleFocusFirstItem = function () {
      _this.props.onClose(exports.PopoverCloseSource.FocusOut);
    };

    _this.handleFocusLastItem = function () {
      _this.props.onClose(exports.PopoverCloseSource.FocusOut);
    };

    return _this;
  }

  _createClass(PopoverOverlay, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.active) {
        this.focusContent();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(oldProps) {
      if (this.props.active && !oldProps.active) {
        this.focusContent();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var active = this.props.active;
      return React.createElement(reactTransitionGroup.Transition, {
        in: active,
        timeout: tokens.durationBase,
        mountOnEnter: true,
        unmountOnExit: true
      }, this.renderOverlay);
    }
  }, {
    key: "focusContent",
    value: function focusContent() {
      var _this2 = this;

      if (this.props.preventAutofocus) {
        return;
      }

      if (this.contentNode == null) {
        return;
      }

      fastdom.write(function () {
        if (_this2.contentNode.current == null) {
          return;
        }

        _this2.contentNode.current.focus();
      });
    }
  }]);

  return PopoverOverlay;
}(React.PureComponent);

function renderPopoverContent(children, props) {
  var childrenArray = React.Children.toArray(children);

  if (reactUtilities.isElementOfType(childrenArray[0], Pane)) {
    return childrenArray;
  }

  return reactUtilities.wrapWithComponent(childrenArray, Pane, props);
}

function animationVariations(status) {
  switch (status) {
    case 'exiting':
      return styles$k.exiting;

    default:
      return null;
  }
}

var getUniqueID$2 = other.createUniqueIDFactory('Popover');

var Popover =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Popover, _React$PureComponent);

  function Popover() {
    var _this;

    _classCallCheck(this, Popover);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Popover).apply(this, arguments));
    _this.state = {
      activatorNode: null
    };
    _this.activatorContainer = null;
    _this.id = getUniqueID$2();

    _this.handleClose = function (source) {
      _this.props.onClose(source);

      if (_this.activatorContainer == null) {
        return;
      }

      if (source === exports.PopoverCloseSource.FocusOut || source === exports.PopoverCloseSource.EscapeKeypress) {
        focus.focusFirstFocusableNode(_this.activatorContainer, false);
      }
    };

    _this.setActivator = function (node) {
      if (node == null) {
        _this.activatorContainer = null;

        _this.setState({
          activatorNode: null
        });

        return;
      }

      _this.setState({
        activatorNode: node.firstElementChild
      });

      _this.activatorContainer = node;
    };

    return _this;
  }

  _createClass(Popover, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setAccessibilityAttributes();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      if (this.activatorContainer && this.state.activatorNode && !this.activatorContainer.contains(this.state.activatorNode)) {
        this.setActivator(this.activatorContainer);
      }

      this.setAccessibilityAttributes();
    }
  }, {
    key: "render",
    value: function render() {
      var _a = this.props,
          _a$activatorWrapper = _a.activatorWrapper,
          WrapperComponent = _a$activatorWrapper === void 0 ? 'div' : _a$activatorWrapper,
          children = _a.children,
          onClose = _a.onClose,
          activator = _a.activator,
          active = _a.active,
          fixed = _a.fixed,
          rest = tslib_1.__rest(_a, ["activatorWrapper", "children", "onClose", "activator", "active", "fixed"]);

      var activatorNode = this.state.activatorNode;
      var portal = activatorNode ? React.createElement(Portal, {
        idPrefix: "popover"
      }, React.createElement(PopoverOverlay, Object.assign({
        id: this.id,
        activator: activatorNode,
        onClose: this.handleClose,
        active: active,
        fixed: fixed
      }, rest), children)) : null;
      return React.createElement(WrapperComponent, {
        ref: this.setActivator
      }, React.Children.only(this.props.activator), portal);
    }
  }, {
    key: "setAccessibilityAttributes",
    value: function setAccessibilityAttributes() {
      var id = this.id,
          activatorContainer = this.activatorContainer;

      if (activatorContainer == null) {
        return;
      }

      var firstFocusable = focus.findFirstFocusableNode(activatorContainer);
      var focusableActivator = firstFocusable || activatorContainer;
      focusableActivator.tabIndex = focusableActivator.tabIndex || 0;
      focusableActivator.setAttribute('aria-controls', id);
      focusableActivator.setAttribute('aria-owns', id);
      focusableActivator.setAttribute('aria-haspopup', 'true');
      focusableActivator.setAttribute('aria-expanded', String(this.props.active));
    }
  }]);

  return Popover;
}(React.PureComponent);
Popover.Pane = Pane;
Popover.Section = Section$2;

var contextTypes$1 = {
  selectedOptionId: PropTypes.string,
  comboBoxId: PropTypes.string,
  subscribe: PropTypes.func,
  unsubscribe: PropTypes.func
};

var styles$m = {
  "Label": "Polaris-Label",
  "hidden": "Polaris-Label--hidden",
  "Text": "Polaris-Label__Text",
};

function labelID(id) {
  return "".concat(id, "Label");
}
function Label(_ref) {
  var children = _ref.children,
      id = _ref.id,
      hidden = _ref.hidden;
  var className = styles.classNames(styles$m.Label, hidden && styles$m.hidden);
  return React.createElement("div", {
    className: className
  }, React.createElement("label", {
    id: labelID(id),
    htmlFor: id,
    className: styles$m.Text
  }, children));
}

var styles$n = {
  "InlineError": "Polaris-InlineError",
  "Icon": "Polaris-InlineError__Icon",
};

function InlineError(_ref) {
  var message = _ref.message,
      fieldID = _ref.fieldID;

  if (!message) {
    return null;
  }

  return React.createElement("div", {
    id: "".concat(fieldID, "Error"),
    className: styles$n.InlineError
  }, React.createElement("div", {
    className: styles$n.Icon
  }, React.createElement(Icon$1, {
    source: polarisIcons.AlertMinor
  })), message);
}

var styles$o = {
  "hidden": "Polaris-Labelled--hidden",
  "LabelWrapper": "Polaris-Labelled__LabelWrapper",
  "HelpText": "Polaris-Labelled__HelpText",
  "Error": "Polaris-Labelled__Error",
  "Action": "Polaris-Labelled__Action",
};

function Labelled(_a) {
  var id = _a.id,
      label = _a.label,
      error = _a.error,
      action = _a.action,
      helpText = _a.helpText,
      children = _a.children,
      labelHidden = _a.labelHidden,
      rest = tslib_1.__rest(_a, ["id", "label", "error", "action", "helpText", "children", "labelHidden"]);

  var className = styles.classNames(labelHidden && styles$o.hidden);
  var actionMarkup = action ? React.createElement("div", {
    className: styles$o.Action
  }, buttonFrom(action, {
    plain: true
  })) : null;
  var helpTextMarkup = helpText ? React.createElement("div", {
    className: styles$o.HelpText,
    id: helpTextID(id)
  }, helpText) : null;
  var errorMarkup = error && typeof error !== 'boolean' && React.createElement("div", {
    className: styles$o.Error
  }, React.createElement(InlineError, {
    message: error,
    fieldID: id
  }));
  var labelMarkup = label ? React.createElement("div", {
    className: styles$o.LabelWrapper
  }, React.createElement(Label, Object.assign({
    id: id
  }, rest, {
    hidden: false
  }), label), actionMarkup) : null;
  return React.createElement("div", {
    className: className
  }, labelMarkup, children, errorMarkup, helpTextMarkup);
}
function helpTextID(id) {
  return "".concat(id, "HelpText");
}

var styles$p = {
  "Connected": "Polaris-Connected",
  "Item": "Polaris-Connected__Item",
  "Item-primary": "Polaris-Connected__Item--primary",
  "Item-connection": "Polaris-Connected__Item--connection",
  "Item-focused": "Polaris-Connected__Item--focused",
};

var ItemPosition;

(function (ItemPosition) {
  ItemPosition[ItemPosition["Left"] = 0] = "Left";
  ItemPosition[ItemPosition["Primary"] = 1] = "Primary";
  ItemPosition[ItemPosition["Right"] = 2] = "Right";
})(ItemPosition || (ItemPosition = {}));

var Item$3 =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Item, _React$PureComponent);

  function Item() {
    var _this;

    _classCallCheck(this, Item);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Item).apply(this, arguments));
    _this.state = {
      focused: false
    };

    _this.handleBlur = function () {
      _this.setState({
        focused: false
      });
    };

    _this.handleFocus = function () {
      _this.setState({
        focused: true
      });
    };

    return _this;
  }

  _createClass(Item, [{
    key: "render",
    value: function render() {
      var focused = this.state.focused;
      var _this$props = this.props,
          children = _this$props.children,
          position = _this$props.position;
      var className = styles.classNames(styles$p.Item, focused && styles$p['Item-focused'], position === ItemPosition.Primary ? styles$p['Item-primary'] : styles$p['Item-connection']);
      return React.createElement("div", {
        onBlur: this.handleBlur,
        onFocus: this.handleFocus,
        className: className
      }, children);
    }
  }]);

  return Item;
}(React.PureComponent);

function Connected(_ref) {
  var children = _ref.children,
      left = _ref.left,
      right = _ref.right;

  if (left == null && right == null) {
    return React.Children.only(children);
  }

  var leftConnectionMarkup = left ? React.createElement(Item$3, {
    position: ItemPosition.Left
  }, left) : null;
  var rightConnectionMarkup = right ? React.createElement(Item$3, {
    position: ItemPosition.Right
  }, right) : null;
  return React.createElement("div", {
    className: styles$p.Connected
  }, leftConnectionMarkup, React.createElement(Item$3, {
    position: ItemPosition.Primary
  }, children), rightConnectionMarkup);
}

var styles$q = {
  "TextField": "Polaris-TextField",
  "multiline": "Polaris-TextField--multiline",
  "Input": "Polaris-TextField__Input",
  "hasValue": "Polaris-TextField--hasValue",
  "focus": "Polaris-TextField--focus",
  "Backdrop": "Polaris-TextField__Backdrop",
  "error": "Polaris-TextField--error",
  "readOnly": "Polaris-TextField--readOnly",
  "disabled": "Polaris-TextField--disabled",
  "Prefix": "Polaris-TextField__Prefix",
  "Input-suffixed": "Polaris-TextField__Input--suffixed",
  "Suffix": "Polaris-TextField__Suffix",
  "CharacterCount": "Polaris-TextField__CharacterCount",
  "AlignFieldBottom": "Polaris-TextField__AlignFieldBottom",
  "Spinner": "Polaris-TextField__Spinner",
  "SpinnerIcon": "Polaris-TextField__SpinnerIcon",
  "Resizer": "Polaris-TextField__Resizer",
  "DummyInput": "Polaris-TextField__DummyInput",
  "Segment": "Polaris-TextField__Segment",
};

var Resizer =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Resizer, _React$PureComponent);

  function Resizer() {
    var _this;

    _classCallCheck(this, Resizer);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Resizer).apply(this, arguments));
    _this.contentNode = React.createRef();
    _this.minimumLinesNode = React.createRef();
    _this.animationFrame = null;

    _this.handleHeightCheck = function () {
      if (_this.animationFrame) {
        cancelAnimationFrame(_this.animationFrame);
      }

      _this.animationFrame = requestAnimationFrame(function () {
        var contentNode = _this.contentNode.current;
        var minimumLinesNode = _this.minimumLinesNode.current;

        if (!contentNode || !minimumLinesNode) {
          return;
        }

        var newHeight = Math.max(contentNode.offsetHeight, minimumLinesNode.offsetHeight);
        var _this$props = _this.props,
            currentHeight = _this$props.currentHeight,
            onHeightChange = _this$props.onHeightChange;

        if (newHeight !== currentHeight) {
          onHeightChange(newHeight);
        }
      });
    };

    return _this;
  }

  _createClass(Resizer, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.handleHeightCheck();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.handleHeightCheck();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.animationFrame) {
        cancelAnimationFrame(this.animationFrame);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          contents = _this$props2.contents,
          minimumLines = _this$props2.minimumLines;
      var minimumLinesMarkup = minimumLines ? React.createElement("div", {
        ref: this.minimumLinesNode,
        className: styles$q.DummyInput,
        dangerouslySetInnerHTML: {
          __html: getContentsForMinimumLines(minimumLines)
        }
      }) : null;
      return React.createElement("div", {
        "aria-hidden": true,
        className: styles$q.Resizer
      }, React.createElement(EventListener, {
        event: "resize",
        handler: this.handleHeightCheck
      }), React.createElement("div", {
        ref: this.contentNode,
        className: styles$q.DummyInput,
        dangerouslySetInnerHTML: {
          __html: getFinalContents(contents)
        }
      }), minimumLinesMarkup);
    }
  }]);

  return Resizer;
}(React.PureComponent);
var ENTITIES_TO_REPLACE = {
  '&': '&amp;',
  '<': '&lt;',
  '>': '&gt;',
  '\n': '<br>',
  '\r': ''
};
var REPLACE_REGEX$1 = new RegExp("[".concat(Object.keys(ENTITIES_TO_REPLACE).join(), "]"), 'g');

function replaceEntity(entity) {
  return ENTITIES_TO_REPLACE[entity];
}

function getContentsForMinimumLines(minimumLines) {
  var content = '';

  for (var line = 0; line < minimumLines; line++) {
    content += '<br>';
  }

  return content;
}

function getFinalContents(contents) {
  return contents ? "".concat(contents.replace(REPLACE_REGEX$1, replaceEntity), "<br>") : '<br>';
}

function Spinner$2(_ref) {
  var onChange = _ref.onChange,
      onClick = _ref.onClick,
      onMouseDown = _ref.onMouseDown,
      onMouseUp = _ref.onMouseUp;

  function handleStep(step) {
    return function () {
      return onChange(step);
    };
  }

  function handleMouseDown(onChange) {
    return function (event) {
      if (event.button !== 0) return;
      onMouseDown(onChange);
    };
  }

  return React.createElement("div", {
    className: styles$q.Spinner,
    onClick: onClick,
    "aria-hidden": true
  }, React.createElement("div", {
    role: "button",
    className: styles$q.Segment,
    tabIndex: -1,
    onClick: handleStep(1),
    onMouseDown: handleMouseDown(handleStep(1)),
    onMouseUp: onMouseUp
  }, React.createElement("div", {
    className: styles$q.SpinnerIcon
  }, React.createElement(Icon$1, {
    source: polarisIcons.CaretUpMinor
  }))), React.createElement("div", {
    role: "button",
    className: styles$q.Segment,
    tabIndex: -1,
    onClick: handleStep(-1),
    onMouseDown: handleMouseDown(handleStep(-1)),
    onMouseUp: onMouseUp
  }, React.createElement("div", {
    className: styles$q.SpinnerIcon
  }, React.createElement(Icon$1, {
    source: polarisIcons.CaretDownMinor
  }))));
}

var getUniqueID$3 = other.createUniqueIDFactory('TextField');

var TextField =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(TextField, _React$PureComponent);

  function TextField(props) {
    var _this;

    _classCallCheck(this, TextField);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(TextField).call(this, props));

    _this.setInput = function (input) {
      _this.input = input;
    };

    _this.handleNumberChange = function (steps) {
      var _this$props = _this.props,
          onChange = _this$props.onChange,
          value = _this$props.value,
          _this$props$step = _this$props.step,
          step = _this$props$step === void 0 ? 1 : _this$props$step,
          _this$props$min = _this$props.min,
          min = _this$props$min === void 0 ? -Infinity : _this$props$min,
          _this$props$max = _this$props.max,
          max = _this$props$max === void 0 ? Infinity : _this$props$max;

      if (onChange == null) {
        return;
      } // Returns the length of decimal places in a number


      var dpl = function dpl(num) {
        return (num.toString().split('.')[1] || []).length;
      };

      var numericValue = value ? parseFloat(value) : 0;

      if (isNaN(numericValue)) {
        return;
      } // Making sure the new value has the same length of decimal places as the
      // step / value has.


      var decimalPlaces = Math.max(dpl(numericValue), dpl(step));
      var newValue = Math.min(max, Math.max(numericValue + steps * step, min));
      onChange(String(newValue.toFixed(decimalPlaces)), _this.state.id);
    };

    _this.handleExpandingResize = function (height) {
      _this.setState({
        height: height
      });
    };

    _this.handleKeyPress = function (event) {
      var key = event.key,
          which = event.which;
      var type = _this.props.type;
      var numbersSpec = /[\d.eE+-]$/;

      if (type !== 'number' || which === exports.Key.Enter || key.match(numbersSpec)) {
        return;
      }

      event.preventDefault();
    };

    _this.handleChange = function (event) {
      var onChange = _this.props.onChange;

      if (onChange == null) {
        return;
      }

      onChange(event.currentTarget.value, _this.state.id);
    };

    _this.handleFocus = function () {
      _this.setState({
        focus: true
      });
    };

    _this.handleBlur = function () {
      _this.setState({
        focus: false
      });
    };

    _this.handleClick = function () {
      _this.input.focus();
    };

    _this.handleButtonPress = function (onChange) {
      var minInterval = 50;
      var decrementBy = 10;
      var interval = 200;

      var onChangeInterval = function onChangeInterval() {
        if (interval > minInterval) interval -= decrementBy;
        onChange();
        _this.buttonPressTimer = window.setTimeout(onChangeInterval, interval);
      };

      _this.buttonPressTimer = window.setTimeout(onChangeInterval, interval);
      events.addEventListener(document, 'mouseup', _this.handleButtonRelease, {
        once: true
      });
    };

    _this.handleButtonRelease = function () {
      clearTimeout(_this.buttonPressTimer);
    };

    _this.state = {
      height: null,
      focus: props.focused || false,
      id: props.id || getUniqueID$3()
    };
    return _this;
  }

  _createClass(TextField, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (!this.props.focused) {
        return;
      }

      this.input.focus();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_ref) {
      var wasFocused = _ref.focused;
      var focused = this.props.focused;

      if (!wasFocused && focused) {
        this.input.focus();
      } else if (wasFocused && !focused) {
        this.input.blur();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          _this$props2$id = _this$props2.id,
          id = _this$props2$id === void 0 ? this.state.id : _this$props2$id,
          value = _this$props2.value,
          placeholder = _this$props2.placeholder,
          disabled = _this$props2.disabled,
          readOnly = _this$props2.readOnly,
          role = _this$props2.role,
          autoFocus = _this$props2.autoFocus,
          type = _this$props2.type,
          name = _this$props2.name,
          error = _this$props2.error,
          multiline = _this$props2.multiline,
          connectedRight = _this$props2.connectedRight,
          connectedLeft = _this$props2.connectedLeft,
          label = _this$props2.label,
          labelAction = _this$props2.labelAction,
          labelHidden = _this$props2.labelHidden,
          helpText = _this$props2.helpText,
          prefix = _this$props2.prefix,
          suffix = _this$props2.suffix,
          onFocus = _this$props2.onFocus,
          onBlur = _this$props2.onBlur,
          autoComplete = _this$props2.autoComplete,
          min = _this$props2.min,
          max = _this$props2.max,
          step = _this$props2.step,
          minLength = _this$props2.minLength,
          maxLength = _this$props2.maxLength,
          spellCheck = _this$props2.spellCheck,
          pattern = _this$props2.pattern,
          ariaOwns = _this$props2.ariaOwns,
          ariaActiveDescendant = _this$props2.ariaActiveDescendant,
          ariaAutocomplete = _this$props2.ariaAutocomplete,
          ariaControls = _this$props2.ariaControls,
          showCharacterCount = _this$props2.showCharacterCount,
          intl = _this$props2.polaris.intl;
      var normalizedValue = value != null ? value : '';
      var height = this.state.height;
      var className = styles.classNames(styles$q.TextField, Boolean(normalizedValue) && styles$q.hasValue, disabled && styles$q.disabled, readOnly && styles$q.readOnly, error && styles$q.error, multiline && styles$q.multiline, this.state.focus && styles$q.focus);
      var inputType = type === 'currency' ? 'text' : type;
      var prefixMarkup = prefix ? React.createElement("div", {
        className: styles$q.Prefix,
        id: "".concat(id, "Prefix")
      }, prefix) : null;
      var suffixMarkup = suffix ? React.createElement("div", {
        className: styles$q.Suffix,
        id: "".concat(id, "Suffix")
      }, suffix) : null;
      var characterCount = normalizedValue.length;
      var characterCountLabel = intl.translate(maxLength ? 'Polaris.TextField.characterCountWithMaxLength' : 'Polaris.TextField.characterCount', {
        count: characterCount,
        limit: maxLength
      });
      var characterCountClassName = styles.classNames(styles$q.CharacterCount, multiline && styles$q.AlignFieldBottom);
      var characterCountText = !maxLength ? characterCount : "".concat(characterCount, "/").concat(maxLength);
      var characterCountMarkup = showCharacterCount ? React.createElement("div", {
        id: "".concat(id, "CharacterCounter"),
        className: characterCountClassName,
        "aria-label": characterCountLabel,
        "aria-live": "polite",
        "aria-atomic": "true"
      }, characterCountText) : null;
      var spinnerMarkup = type === 'number' && !disabled && !readOnly ? React.createElement(Spinner$2, {
        onChange: this.handleNumberChange,
        onMouseDown: this.handleButtonPress,
        onMouseUp: this.handleButtonRelease
      }) : null;
      var style = multiline && height ? {
        height: height
      } : null;
      var resizer = multiline ? React.createElement(Resizer, {
        contents: normalizedValue || placeholder,
        currentHeight: height,
        minimumLines: typeof multiline === 'number' ? multiline : 1,
        onHeightChange: this.handleExpandingResize
      }) : null;
      var describedBy = [];

      if (error) {
        describedBy.push("".concat(id, "Error"));
      }

      if (helpText) {
        describedBy.push(helpTextID(id));
      }

      if (showCharacterCount) {
        describedBy.push("".concat(id, "CharacterCounter"));
      }

      var labelledBy = [labelID(id)];

      if (prefix) {
        labelledBy.push("".concat(id, "Prefix"));
      }

      if (suffix) {
        labelledBy.push("".concat(id, "Suffix"));
      }

      var inputClassName = styles.classNames(styles$q.Input, suffix && styles$q['Input-suffixed']);
      var input = React.createElement(multiline ? 'textarea' : 'input', {
        name: name,
        id: id,
        disabled: disabled,
        readOnly: readOnly,
        role: role,
        autoFocus: autoFocus,
        value: normalizedValue,
        placeholder: placeholder,
        onFocus: onFocus,
        onBlur: onBlur,
        onKeyPress: this.handleKeyPress,
        style: style,
        autoComplete: normalizeAutoComplete(autoComplete),
        className: inputClassName,
        onChange: this.handleChange,
        ref: this.setInput,
        min: min,
        max: max,
        step: step,
        minLength: minLength,
        maxLength: maxLength,
        spellCheck: spellCheck,
        pattern: pattern,
        type: inputType,
        'aria-describedby': describedBy.length ? describedBy.join(' ') : undefined,
        'aria-label': label,
        'aria-labelledby': labelledBy.join(' '),
        'aria-invalid': Boolean(error),
        'aria-owns': ariaOwns,
        'aria-activedescendant': ariaActiveDescendant,
        'aria-autocomplete': ariaAutocomplete,
        'aria-controls': ariaControls,
        'aria-multiline': multiline
      });
      return React.createElement(Labelled, {
        label: label,
        id: id,
        error: error,
        action: labelAction,
        labelHidden: labelHidden,
        helpText: helpText
      }, React.createElement(Connected, {
        left: connectedLeft,
        right: connectedRight
      }, React.createElement("div", {
        className: className,
        onFocus: this.handleFocus,
        onBlur: this.handleBlur,
        onClick: this.handleClick
      }, prefixMarkup, input, suffixMarkup, characterCountMarkup, spinnerMarkup, React.createElement("div", {
        className: styles$q.Backdrop
      }), resizer)));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      return {
        id: nextProps.id || prevState.id
      };
    }
  }]);

  return TextField;
}(React.PureComponent);

function normalizeAutoComplete(autoComplete) {
  if (autoComplete == null) {
    return autoComplete;
  } else if (autoComplete === true) {
    return 'on';
  } else if (autoComplete === false) {
    return 'off';
  } else {
    return autoComplete;
  }
}

var TextField$1 = withAppProvider()(TextField);

var TextField$2 =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(TextField, _React$PureComponent);

  function TextField() {
    var _this;

    _classCallCheck(this, TextField);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(TextField).apply(this, arguments));

    _this.handleContextUpdate = function () {
      _this.forceUpdate();
    };

    return _this;
  }

  _createClass(TextField, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var subscribe = this.context.subscribe;
      subscribe(this.handleContextUpdate);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$context = this.context,
          selectedOptionId = _this$context.selectedOptionId,
          comboBoxId = _this$context.comboBoxId;
      return React.createElement(TextField$1, Object.assign({}, this.props, {
        autoComplete: false,
        ariaAutocomplete: "list",
        ariaActiveDescendant: selectedOptionId,
        ariaControls: comboBoxId
      }));
    }
  }]);

  return TextField;
}(React.PureComponent);
TextField$2.contextTypes = contextTypes$1;

var styles$r = {
  "EmptyState": "Polaris-Autocomplete-ComboBox__EmptyState",
};

var getUniqueId$1 = other.createUniqueIDFactory('ComboBox');

var ComboBox =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(ComboBox, _React$PureComponent);

  function ComboBox() {
    var _this;

    _classCallCheck(this, ComboBox);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ComboBox).apply(this, arguments));
    _this.state = {
      comboBoxId: _this.getComboBoxId(),
      selectedOption: undefined,
      selectedIndex: -1,
      selectedOptions: _this.props.selected,
      navigableOptions: [],
      popoverActive: false,
      popoverWasActive: false
    };
    _this.subscriptions = [];

    _this.subscribe = function (callback) {
      _this.subscriptions.push(callback);
    };

    _this.unsubscribe = function (callback) {
      _this.subscriptions = _this.subscriptions.filter(function (subscription) {
        return subscription !== callback;
      });
    };

    _this.handleDownArrow = function () {
      _this.selectNextOption();

      _this.handlePopoverOpen;
    };

    _this.handleUpArrow = function () {
      _this.selectPreviousOption();

      _this.handlePopoverOpen;
    };

    _this.handleEnter = function () {
      var selectedOption = _this.state.selectedOption;

      if (_this.state.popoverActive && selectedOption) {
        if (isOption(selectedOption)) {
          _this.handleSelection(selectedOption.value);
        } else {
          selectedOption.onAction && selectedOption.onAction();
        }
      }

      _this.handlePopoverOpen;
    };

    _this.handleFocus = function () {
      _this.setState({
        popoverActive: true,
        popoverWasActive: true
      });
    };

    _this.handleBlur = function () {
      _this.setState({
        popoverActive: false,
        popoverWasActive: false
      }, function () {
        _this.resetVisuallySelectedOptions();
      });
    };

    _this.handleClick = function () {
      !_this.state.popoverActive && _this.setState({
        popoverActive: true
      });
    };

    _this.handleSelection = function (newSelected) {
      var _this$props = _this.props,
          selected = _this$props.selected,
          allowMultiple = _this$props.allowMultiple;
      var newlySelectedOptions = selected;

      if (selected.includes(newSelected)) {
        newlySelectedOptions.splice(newlySelectedOptions.indexOf(newSelected), 1);
      } else if (allowMultiple) {
        newlySelectedOptions.push(newSelected);
      } else {
        newlySelectedOptions = [newSelected];
      }

      _this.selectOptions(newlySelectedOptions);
    };

    _this.selectOptions = function (selected) {
      var _this$props2 = _this.props,
          onSelect = _this$props2.onSelect,
          allowMultiple = _this$props2.allowMultiple;
      selected && onSelect(selected);

      if (!allowMultiple) {
        _this.resetVisuallySelectedOptions();

        _this.setState({
          popoverActive: false,
          popoverWasActive: false
        });
      }
    };

    _this.updateIndexOfSelectedOption = function (newOptions) {
      var _this$state = _this.state,
          selectedIndex = _this$state.selectedIndex,
          selectedOption = _this$state.selectedOption;

      if (selectedOption && newOptions.includes(selectedOption)) {
        _this.selectOptionAtIndex(newOptions.indexOf(selectedOption));
      } else if (selectedIndex > newOptions.length - 1) {
        _this.resetVisuallySelectedOptions();
      } else {
        _this.selectOptionAtIndex(selectedIndex);
      }
    };

    _this.resetVisuallySelectedOptions = function () {
      var navigableOptions = _this.state.navigableOptions;

      _this.setState({
        selectedOption: undefined,
        selectedIndex: -1
      });

      navigableOptions && navigableOptions.forEach(function (option) {
        option.active = false;
      });
    };

    _this.handlePopoverClose = function () {
      _this.setState({
        popoverActive: false,
        popoverWasActive: false
      });
    };

    _this.handlePopoverOpen = function () {
      var _this$state2 = _this.state,
          popoverActive = _this$state2.popoverActive,
          navigableOptions = _this$state2.navigableOptions;
      !popoverActive && navigableOptions && navigableOptions.length > 0 && _this.setState({
        popoverActive: true,
        popoverWasActive: true
      });
    };

    _this.selectNextOption = function () {
      var _this$state3 = _this.state,
          selectedIndex = _this$state3.selectedIndex,
          navigableOptions = _this$state3.navigableOptions;

      if (!navigableOptions || navigableOptions.length === 0) {
        return;
      }

      var newIndex = selectedIndex;

      if (selectedIndex + 1 >= navigableOptions.length) {
        newIndex = 0;
      } else {
        newIndex++;
      }

      _this.selectOptionAtIndex(newIndex);
    };

    _this.selectPreviousOption = function () {
      var _this$state4 = _this.state,
          selectedIndex = _this$state4.selectedIndex,
          navigableOptions = _this$state4.navigableOptions;

      if (!navigableOptions || navigableOptions.length === 0) {
        return;
      }

      var newIndex = selectedIndex;

      if (selectedIndex <= 0) {
        newIndex = navigableOptions.length - 1;
      } else {
        newIndex--;
      }

      _this.selectOptionAtIndex(newIndex);
    };

    _this.selectOptionAtIndex = function (newOptionIndex) {
      var _this$state5 = _this.state,
          navigableOptions = _this$state5.navigableOptions,
          oldSelectedOption = _this$state5.selectedOption;

      if (!navigableOptions || navigableOptions.length === 0) {
        return;
      }

      var newSelectedOption = navigableOptions[newOptionIndex];

      _this.setState({
        selectedOption: newSelectedOption,
        selectedIndex: newOptionIndex
      }, function () {
        _this.visuallyUpdateSelectedOption(newSelectedOption, oldSelectedOption);
      });
    };

    _this.visuallyUpdateSelectedOption = function (newOption, oldOption) {
      if (oldOption) {
        oldOption.active = false;
      }

      if (newOption) {
        newOption.active = true;
      }
    };

    return _this;
  }

  _createClass(ComboBox, [{
    key: "getChildContext",
    value: function getChildContext() {
      return {
        comboBoxId: this.state.comboBoxId,
        selectedOptionId: this.selectedOptionId,
        subscribe: this.subscribe,
        unsubscribe: this.unsubscribe
      };
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props3 = this.props,
          options = _this$props3.options,
          actionsBefore = _this$props3.actionsBefore,
          actionsAfter = _this$props3.actionsAfter;
      var comboBoxId = this.getComboBoxId();
      var navigableOptions = [];

      if (actionsBefore) {
        navigableOptions = navigableOptions.concat(actionsBefore);
      }

      if (options) {
        navigableOptions = navigableOptions.concat(options);
      }

      if (actionsAfter) {
        navigableOptions = navigableOptions.concat(actionsAfter);
      }

      navigableOptions = assignOptionIds(navigableOptions, comboBoxId);
      this.setState({
        navigableOptions: navigableOptions
      });
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_, prevState) {
      var _this$props4 = this.props,
          contentBefore = _this$props4.contentBefore,
          contentAfter = _this$props4.contentAfter,
          emptyState = _this$props4.emptyState;
      var _this$state6 = this.state,
          navigableOptions = _this$state6.navigableOptions,
          popoverWasActive = _this$state6.popoverWasActive;
      this.subscriptions.forEach(function (subscriberCallback) {
        return subscriberCallback();
      });
      var optionsChanged = navigableOptions && prevState.navigableOptions && !optionsAreEqual(navigableOptions, prevState.navigableOptions);

      if (optionsChanged) {
        this.updateIndexOfSelectedOption(navigableOptions);
      }

      if (navigableOptions && navigableOptions.length === 0 && !contentBefore && !contentAfter && !emptyState) {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          popoverActive: false
        });
      } else if (popoverWasActive && navigableOptions && navigableOptions.length !== 0) {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          popoverActive: true
        });
      }
    }
  }, {
    key: "getComboBoxId",
    value: function getComboBoxId() {
      if (this.state && this.state.comboBoxId) {
        return this.state.comboBoxId;
      }

      return this.props.id || getUniqueId$1();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props5 = this.props,
          options = _this$props5.options,
          textField = _this$props5.textField,
          listTitle = _this$props5.listTitle,
          allowMultiple = _this$props5.allowMultiple,
          preferredPosition = _this$props5.preferredPosition,
          actionsBefore = _this$props5.actionsBefore,
          actionsAfter = _this$props5.actionsAfter,
          contentBefore = _this$props5.contentBefore,
          contentAfter = _this$props5.contentAfter,
          onEndReached = _this$props5.onEndReached,
          emptyState = _this$props5.emptyState;
      var actionsBeforeMarkup = actionsBefore && actionsBefore.length > 0 && React.createElement(ActionList, {
        actionRole: "option",
        items: actionsBefore
      });
      var actionsAfterMarkup = actionsAfter && actionsAfter.length > 0 && React.createElement(ActionList, {
        actionRole: "option",
        items: actionsAfter
      });
      var optionsMarkup = options.length > 0 && React.createElement(OptionList$1, {
        role: "presentation",
        optionRole: "option",
        options: filterForOptions(this.state.navigableOptions),
        onChange: this.selectOptions,
        selected: this.state.selectedOptions,
        title: listTitle,
        allowMultiple: allowMultiple
      });
      var emptyStateMarkup = !actionsAfter && !actionsBefore && !contentAfter && !contentBefore && options.length === 0 && emptyState && React.createElement("div", {
        className: styles$r.EmptyState
      }, emptyState);
      return React.createElement("div", {
        onClick: this.handleClick,
        role: "combobox",
        "aria-expanded": this.state.popoverActive,
        "aria-owns": this.state.comboBoxId,
        "aria-controls": this.state.comboBoxId,
        "aria-haspopup": true,
        onFocus: this.handleFocus,
        onBlur: this.handleBlur,
        tabIndex: 0
      }, React.createElement(KeypressListener, {
        keyCode: exports.Key.DownArrow,
        handler: this.handleDownArrow
      }), React.createElement(KeypressListener, {
        keyCode: exports.Key.UpArrow,
        handler: this.handleUpArrow
      }), React.createElement(KeypressListener, {
        keyCode: exports.Key.Enter,
        handler: this.handleEnter
      }), React.createElement(KeypressListener, {
        keyCode: exports.Key.Escape,
        handler: this.handlePopoverClose
      }), React.createElement(Popover, {
        activator: textField,
        active: this.state.popoverActive,
        onClose: this.handlePopoverClose,
        preferredPosition: preferredPosition,
        fullWidth: true,
        preventAutofocus: true
      }, React.createElement(Popover.Pane, {
        onScrolledToBottom: onEndReached
      }, React.createElement("div", {
        id: this.state.comboBoxId,
        role: "listbox",
        "aria-multiselectable": allowMultiple
      }, contentBefore, actionsBeforeMarkup, optionsMarkup, actionsAfterMarkup, contentAfter, emptyStateMarkup))));
    }
  }, {
    key: "selectedOptionId",
    get: function get() {
      var _this$state7 = this.state,
          selectedOption = _this$state7.selectedOption,
          selectedIndex = _this$state7.selectedIndex,
          comboBoxId = _this$state7.comboBoxId;
      return selectedOption ? "".concat(comboBoxId, "-").concat(selectedIndex) : undefined;
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, _ref2) {
      var nextOptions = _ref.options,
          nextSelected = _ref.selected,
          nextActionsBefore = _ref.actionsBefore,
          nextActionsAfter = _ref.actionsAfter;
      var navigableOptions = _ref2.navigableOptions,
          selectedOptions = _ref2.selectedOptions,
          comboBoxId = _ref2.comboBoxId;
      var optionsChanged = filterForOptions(navigableOptions) && nextOptions && !optionsAreEqual(navigableOptions, nextOptions);
      var newNavigableOptions = [];

      if (nextActionsBefore) {
        newNavigableOptions = newNavigableOptions.concat(nextActionsBefore);
      }

      if (optionsChanged || nextActionsBefore) {
        newNavigableOptions = newNavigableOptions.concat(nextOptions);
      }

      if (nextActionsAfter) {
        newNavigableOptions = newNavigableOptions.concat(nextActionsAfter);
      }

      newNavigableOptions = assignOptionIds(newNavigableOptions, comboBoxId);

      if (optionsChanged && selectedOptions !== nextSelected) {
        return {
          navigableOptions: newNavigableOptions,
          selectedOptions: nextSelected
        };
      } else if (optionsChanged) {
        return {
          navigableOptions: newNavigableOptions
        };
      } else if (selectedOptions !== nextSelected) {
        return {
          selectedOptions: nextSelected
        };
      }

      return null;
    }
  }]);

  return ComboBox;
}(React.PureComponent);
ComboBox.TextField = TextField$2;
ComboBox.OptionList = OptionList$1;
ComboBox.childContextTypes = contextTypes$1;

function assignOptionIds(options, comboBoxId) {
  options.map(function (option, optionIndex) {
    option.id = "".concat(comboBoxId, "-").concat(optionIndex);
  });
  return options;
}

function optionsAreEqual(firstOptions, secondOptions) {
  if (firstOptions.length !== secondOptions.length) {
    return false;
  }

  return firstOptions.every(function (firstItem, index) {
    var secondItem = secondOptions[index];

    if (isOption(firstItem)) {
      if (isOption(secondItem)) {
        return firstItem.value === secondItem.value;
      }

      return false;
    } else {
      if (!isOption(secondItem)) {
        return firstItem.content === secondItem.content;
      }

      return false;
    }
  });
}

function isOption(navigableOption) {
  return navigableOption.value !== undefined;
}

function filterForOptions(mixedArray) {
  return mixedArray.filter(function (item) {
    return isOption(item);
  });
}

var styles$s = {
  "Loading": "Polaris-Autocomplete__Loading",
};

function TextField$3(props) {
  return React.createElement(ComboBox.TextField, props);
}

var Autocomplete =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Autocomplete, _React$PureComponent);

  function Autocomplete() {
    _classCallCheck(this, Autocomplete);

    return _possibleConstructorReturn(this, _getPrototypeOf(Autocomplete).apply(this, arguments));
  }

  _createClass(Autocomplete, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          options = _this$props.options,
          selected = _this$props.selected,
          textField = _this$props.textField,
          preferredPosition = _this$props.preferredPosition,
          listTitle = _this$props.listTitle,
          allowMultiple = _this$props.allowMultiple,
          loading = _this$props.loading,
          actionBefore = _this$props.actionBefore,
          willLoadMoreResults = _this$props.willLoadMoreResults,
          emptyState = _this$props.emptyState,
          onSelect = _this$props.onSelect,
          onLoadMoreResults = _this$props.onLoadMoreResults,
          intl = _this$props.polaris.intl;
      var spinnerMarkup = loading ? React.createElement("div", {
        className: styles$s.Loading
      }, React.createElement(Spinner$1, {
        size: "small",
        accessibilityLabel: intl.translate('Polaris.Autocomplete.spinnerAccessibilityLabel')
      })) : null;
      var conditionalOptions = loading && !willLoadMoreResults ? [] : options;
      var conditionalAction = actionBefore && actionBefore !== [] ? [actionBefore] : undefined;
      return React.createElement(ComboBox, {
        id: id,
        options: conditionalOptions,
        selected: selected,
        textField: textField,
        preferredPosition: preferredPosition,
        listTitle: listTitle,
        allowMultiple: allowMultiple,
        contentAfter: spinnerMarkup,
        actionsBefore: conditionalAction,
        onSelect: onSelect,
        onEndReached: onLoadMoreResults,
        emptyState: emptyState
      });
    }
  }]);

  return Autocomplete;
}(React.PureComponent);
Autocomplete.TextField = TextField$3;
Autocomplete.ComboBox = ComboBox;
var Autocomplete$1 = withAppProvider()(Autocomplete);

var styles$t = {
  "Banner": "Polaris-Banner",
  "withinContentContainer": "Polaris-Banner--withinContentContainer",
  "statusSuccess": "Polaris-Banner--statusSuccess",
  "statusInfo": "Polaris-Banner--statusInfo",
  "statusWarning": "Polaris-Banner--statusWarning",
  "statusCritical": "Polaris-Banner--statusCritical",
  "Ribbon": "Polaris-Banner__Ribbon",
  "Actions": "Polaris-Banner__Actions",
  "Dismiss": "Polaris-Banner__Dismiss",
  "withinPage": "Polaris-Banner--withinPage",
  "hasDismiss": "Polaris-Banner--hasDismiss",
  "Heading": "Polaris-Banner__Heading",
  "Content": "Polaris-Banner__Content",
  "PrimaryAction": "Polaris-Banner__PrimaryAction",
  "SecondaryAction": "Polaris-Banner__SecondaryAction",
  "Text": "Polaris-Banner__Text",
};

var Banner =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Banner, _React$PureComponent);

  function Banner() {
    var _this;

    _classCallCheck(this, Banner);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Banner).apply(this, arguments));
    _this.wrapper = React.createRef();
    return _this;
  }

  _createClass(Banner, [{
    key: "focus",
    value: function focus$$1() {
      this.wrapper.current && this.wrapper.current.focus();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          icon = _this$props.icon,
          action = _this$props.action,
          secondaryAction = _this$props.secondaryAction,
          title = _this$props.title,
          children = _this$props.children,
          status = _this$props.status,
          onDismiss = _this$props.onDismiss;
      var withinContentContainer = this.context.withinContentContainer;
      var color;
      var defaultIcon;
      var ariaRoleType = 'status';

      switch (status) {
        case 'success':
          color = 'greenDark';
          defaultIcon = polarisIcons.CircleTickMajorTwotone;
          break;

        case 'info':
          color = 'tealDark';
          defaultIcon = polarisIcons.CircleInformationMajorTwotone;
          break;

        case 'warning':
          color = 'yellowDark';
          defaultIcon = polarisIcons.CircleAlertMajorTwotone;
          ariaRoleType = 'alert';
          break;

        case 'critical':
          color = 'redDark';
          defaultIcon = polarisIcons.CircleDisabledMajorTwotone;
          ariaRoleType = 'alert';
          break;

        default:
          color = 'inkLighter';
          defaultIcon = polarisIcons.FlagMajorTwotone;
      }

      var className = styles.classNames(styles$t.Banner, status && styles$t[styles.variationName('status', status)], onDismiss && styles$t.hasDismiss, withinContentContainer ? styles$t.withinContentContainer : styles$t.withinPage);
      var id = uniqueID();
      var iconName = icon || defaultIcon;
      var headingMarkup = null;
      var headingID;

      if (title) {
        headingID = "".concat(id, "Heading");
        headingMarkup = React.createElement("div", {
          className: styles$t.Heading,
          id: headingID
        }, React.createElement(Heading, {
          element: "p"
        }, title));
      }

      var buttonSizeValue = withinContentContainer ? 'slim' : undefined;
      var secondaryActionMarkup = secondaryAction ? secondaryActionFrom(secondaryAction) : null;
      var actionMarkup = action ? React.createElement("div", {
        className: styles$t.Actions
      }, React.createElement(ButtonGroup, null, React.createElement("div", {
        className: styles$t.PrimaryAction
      }, buttonFrom(action, {
        outline: true,
        size: buttonSizeValue
      })), secondaryActionMarkup)) : null;
      var contentMarkup = null;
      var contentID;

      if (children || actionMarkup) {
        contentID = "".concat(id, "Content");
        contentMarkup = React.createElement("div", {
          className: styles$t.Content,
          id: contentID
        }, children, actionMarkup);
      }

      var dismissButton = onDismiss ? React.createElement("div", {
        className: styles$t.Dismiss
      }, React.createElement(Button$1, {
        plain: true,
        icon: polarisIcons.CancelSmallMinor,
        onClick: onDismiss,
        accessibilityLabel: "Dismiss notification"
      })) : null;
      return React.createElement("div", {
        className: className // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
        ,
        tabIndex: 0,
        ref: this.wrapper,
        role: ariaRoleType,
        "aria-live": "polite",
        onMouseUp: handleMouseUp,
        "aria-labelledby": headingID,
        "aria-describedby": contentID
      }, dismissButton, React.createElement("div", {
        className: styles$t.Ribbon
      }, React.createElement(Icon$1, {
        source: iconName,
        color: color,
        backdrop: true
      })), React.createElement("div", null, headingMarkup, contentMarkup));
    }
  }]);

  return Banner;
}(React.PureComponent);
Banner.contextTypes = contentContextTypes;
var index = 1;

function uniqueID() {
  return "Banner".concat(index++);
}

function handleMouseUp(_ref) {
  var currentTarget = _ref.currentTarget;
  currentTarget.blur();
}

function secondaryActionFrom(action) {
  if (action.url) {
    return React.createElement(UnstyledLink$1, {
      className: styles$t.SecondaryAction,
      url: action.url,
      external: action.external
    }, React.createElement("span", {
      className: styles$t.Text
    }, action.content));
  }

  return React.createElement("button", {
    className: styles$t.SecondaryAction,
    onClick: action.onAction
  }, React.createElement("span", {
    className: styles$t.Text
  }, action.content));
}

var ScrollLock$1 =
/*#__PURE__*/
function (_React$Component) {
  _inherits(ScrollLock, _React$Component);

  function ScrollLock() {
    _classCallCheck(this, ScrollLock);

    return _possibleConstructorReturn(this, _getPrototypeOf(ScrollLock).apply(this, arguments));
  }

  _createClass(ScrollLock, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var scrollLockManager = this.context.polaris.scrollLockManager;
      scrollLockManager.registerScrollLock();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var scrollLockManager = this.context.polaris.scrollLockManager;
      scrollLockManager.unregisterScrollLock();
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);

  return ScrollLock;
}(React.Component);
ScrollLock$1.contextTypes = polarisAppProviderContextTypes;

var styles$u = {
  "Backdrop": "Polaris-Backdrop",
  "fade-in": "Polaris-Backdrop__fade--in",
  "belowNavigation": "Polaris-Backdrop--belowNavigation",
};

function Backdrop(props) {
  var onClick = props.onClick,
      onTouchStart = props.onTouchStart,
      belowNavigation = props.belowNavigation;
  var className = reactUtilities.classNames(styles$u.Backdrop, belowNavigation && styles$u.belowNavigation);
  return React.createElement(React.Fragment, null, React.createElement(ScrollLock$1, null), React.createElement("div", {
    className: className,
    onClick: onClick,
    onTouchStart: onTouchStart
  }));
}

var styles$v = {
  "Breadcrumb": "Polaris-Breadcrumbs__Breadcrumb",
  "Icon": "Polaris-Breadcrumbs__Icon",
  "Content": "Polaris-Breadcrumbs__Content",
};

var Breadcrumbs =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Breadcrumbs, _React$PureComponent);

  function Breadcrumbs() {
    _classCallCheck(this, Breadcrumbs);

    return _possibleConstructorReturn(this, _getPrototypeOf(Breadcrumbs).apply(this, arguments));
  }

  _createClass(Breadcrumbs, [{
    key: "render",
    value: function render() {
      var breadcrumbs = this.props.breadcrumbs;
      var breadcrumb = breadcrumbs[breadcrumbs.length - 1];

      if (breadcrumb == null) {
        return null;
      }

      var content = breadcrumb.content;
      var contentMarkup = React.createElement(React.Fragment, null, React.createElement("span", {
        className: styles$v.Icon
      }, React.createElement(Icon$1, {
        source: polarisIcons.ChevronLeftMinor
      })), React.createElement("span", {
        className: styles$v.Content
      }, content));
      var breadcrumbMarkup = 'url' in breadcrumb ? React.createElement(UnstyledLink$1, {
        key: content,
        url: breadcrumb.url,
        className: styles$v.Breadcrumb,
        onMouseUp: handleMouseUpByBlurring
      }, contentMarkup) : React.createElement("button", {
        key: content,
        className: styles$v.Breadcrumb,
        onClick: breadcrumb.onAction,
        onMouseUp: handleMouseUpByBlurring,
        type: "button"
      }, contentMarkup);
      return React.createElement("nav", {
        role: "navigation"
      }, breadcrumbMarkup);
    }
  }]);

  return Breadcrumbs;
}(React.PureComponent);

var styles$w = {
  "TextContainer": "Polaris-TextContainer",
  "spacingTight": "Polaris-TextContainer--spacingTight",
  "spacingLoose": "Polaris-TextContainer--spacingLoose",
};

function TextContainer(_ref) {
  var spacing = _ref.spacing,
      children = _ref.children;
  var className = styles.classNames(styles$w.TextContainer, spacing && styles$w[styles.variationName('spacing', spacing)]);
  return React.createElement("div", {
    className: className
  }, children);
}

var styles$x = {
  "CalloutCard": "Polaris-CalloutCard",
  "Image": "Polaris-CalloutCard__Image",
  "DismissImage": "Polaris-CalloutCard__DismissImage",
  "Content": "Polaris-CalloutCard__Content",
  "Title": "Polaris-CalloutCard__Title",
  "Buttons": "Polaris-CalloutCard__Buttons",
  "Container": "Polaris-CalloutCard__Container",
  "Dismiss": "Polaris-CalloutCard__Dismiss",
};

function CalloutCard(_ref) {
  var title = _ref.title,
      children = _ref.children,
      illustration = _ref.illustration,
      primaryAction = _ref.primaryAction,
      secondaryAction = _ref.secondaryAction,
      onDismiss = _ref.onDismiss;
  var primaryActionMarkup = buttonFrom(primaryAction);
  var secondaryActionMarkup = secondaryAction ? buttonFrom(secondaryAction, {
    plain: true
  }) : null;
  var buttonMarkup = secondaryActionMarkup ? React.createElement(ButtonGroup, null, primaryActionMarkup, secondaryActionMarkup) : primaryActionMarkup;
  var dismissButton = onDismiss ? React.createElement("div", {
    className: styles$x.Dismiss
  }, React.createElement(Button$1, {
    plain: true,
    icon: polarisIcons.CancelSmallMinor,
    onClick: onDismiss,
    accessibilityLabel: "Dismiss card"
  })) : null;
  var imageClassName = reactUtilities.classNames(styles$x.Image, onDismiss && styles$x.DismissImage);
  return React.createElement(Card, null, React.createElement("div", {
    className: styles$x.Container
  }, dismissButton, React.createElement(Card.Section, null, React.createElement("div", {
    className: styles$x.CalloutCard
  }, React.createElement("div", {
    className: styles$x.Content
  }, React.createElement("div", {
    className: styles$x.Title
  }, React.createElement(Heading, null, title)), React.createElement(TextContainer, null, children), React.createElement("div", {
    className: styles$x.Buttons
  }, buttonMarkup)), React.createElement(Image, {
    alt: "",
    className: imageClassName,
    source: illustration
  })))));
}

var styles$y = {
  "Caption": "Polaris-Caption",
};

function Caption(_ref) {
  var children = _ref.children;
  return React.createElement("p", {
    className: styles$y.Caption
  }, children);
}

var styles$z = {
  "Choice": "Polaris-Choice",
  "labelHidden": "Polaris-Choice--labelHidden",
  "Label": "Polaris-Choice__Label",
  "Control": "Polaris-Choice__Control",
  "disabled": "Polaris-Choice--disabled",
  "Descriptions": "Polaris-Choice__Descriptions",
  "HelpText": "Polaris-Choice__HelpText",
};

function Choice(_ref) {
  var id = _ref.id,
      label = _ref.label,
      disabled = _ref.disabled,
      error = _ref.error,
      children = _ref.children,
      labelHidden = _ref.labelHidden,
      helpText = _ref.helpText,
      onClick = _ref.onClick;
  var className = styles.classNames(styles$z.Choice, labelHidden && styles$z.labelHidden, disabled && styles$z.disabled);
  var labelMarkup = React.createElement("label", {
    className: className,
    htmlFor: id,
    onClick: onClick
  }, React.createElement("span", {
    className: styles$z.Control
  }, children), React.createElement("span", {
    className: styles$z.Label
  }, label));
  var helpTextMarkup = helpText ? React.createElement("div", {
    className: styles$z.HelpText,
    id: helpTextID$1(id)
  }, helpText) : null;
  var errorMarkup = error && typeof error !== 'boolean' && React.createElement("div", {
    className: styles$z.Error
  }, React.createElement(InlineError, {
    message: error,
    fieldID: id
  }));
  var descriptionMarkup = helpTextMarkup || errorMarkup ? React.createElement("div", {
    className: styles$z.Descriptions
  }, errorMarkup, helpTextMarkup) : null;
  return descriptionMarkup ? React.createElement("div", null, labelMarkup, descriptionMarkup) : labelMarkup;
}
function helpTextID$1(id) {
  return "".concat(id, "HelpText");
}

var styles$A = {
  "Checkbox": "Polaris-Checkbox",
  "error": "Polaris-Checkbox--error",
  "Input": "Polaris-Checkbox__Input",
  "Backdrop": "Polaris-Checkbox__Backdrop",
  "Input-indeterminate": "Polaris-Checkbox__Input--indeterminate",
  "Icon": "Polaris-Checkbox__Icon",
};

var getUniqueID$4 = other.createUniqueIDFactory('Checkbox');

var Checkbox$1 =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Checkbox, _React$PureComponent);

  function Checkbox() {
    var _this;

    _classCallCheck(this, Checkbox);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Checkbox).apply(this, arguments));
    _this.inputNode = React.createRef();

    _this.handleInput = function () {
      var _this$props = _this.props,
          onChange = _this$props.onChange,
          id = _this$props.id;

      if (onChange == null || _this.inputNode.current == null) {
        return;
      }

      onChange(!_this.inputNode.current.checked, id);

      _this.inputNode.current.focus();
    };

    _this.handleKeyUp = function (event) {
      var keyCode = event.keyCode;
      if (keyCode !== exports.Key.Space) return;

      _this.handleInput();
    };

    return _this;
  }

  _createClass(Checkbox, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          _this$props2$id = _this$props2.id,
          id = _this$props2$id === void 0 ? getUniqueID$4() : _this$props2$id,
          label = _this$props2.label,
          labelHidden = _this$props2.labelHidden,
          helpText = _this$props2.helpText,
          _this$props2$checked = _this$props2.checked,
          checked = _this$props2$checked === void 0 ? false : _this$props2$checked,
          error = _this$props2.error,
          disabled = _this$props2.disabled,
          onFocus = _this$props2.onFocus,
          onBlur = _this$props2.onBlur,
          name = _this$props2.name,
          value = _this$props2.value;
      var describedBy = [];

      if (error) {
        describedBy.push("".concat(id, "Error"));
      }

      if (helpText) {
        describedBy.push(helpTextID$1(id));
      }

      var ariaDescribedBy = describedBy.length ? describedBy.join(' ') : undefined;
      var wrapperClassName = styles.classNames(styles$A.Checkbox, error && styles$A.error);
      var isIndeterminate = checked === 'indeterminate';
      var isChecked = !isIndeterminate && Boolean(checked);
      var indeterminateAttributes = isIndeterminate ? {
        indeterminate: 'true',
        'aria-checked': 'mixed'
      } : {
        'aria-checked': isChecked
      };
      var iconSource = isIndeterminate ? polarisIcons.MinusMinor : polarisIcons.TickSmallMinor;
      var inputClassName = styles.classNames(styles$A.Input, isIndeterminate && styles$A['Input-indeterminate']);
      return (
        /* eslint-disable jsx-a11y/no-redundant-roles, jsx-a11y/role-has-required-aria-props */
        React.createElement(Choice, {
          id: id,
          label: label,
          labelHidden: labelHidden,
          helpText: helpText,
          error: error,
          disabled: disabled,
          onClick: this.handleInput
        }, React.createElement("span", {
          className: wrapperClassName
        }, React.createElement("input", Object.assign({
          onKeyUp: this.handleKeyUp,
          ref: this.inputNode,
          id: id,
          name: name,
          value: value,
          type: "checkbox",
          checked: isChecked,
          disabled: disabled,
          className: inputClassName,
          onFocus: onFocus,
          onBlur: onBlur,
          onClick: stopPropagation,
          onChange: other.noop,
          "aria-invalid": error != null,
          "aria-describedby": ariaDescribedBy,
          role: "checkbox"
        }, indeterminateAttributes)), React.createElement("span", {
          className: styles$A.Backdrop
        }), React.createElement("span", {
          className: styles$A.Icon
        }, React.createElement(Icon$1, {
          source: iconSource
        }))))
        /* eslint-enable jsx-a11y/no-redundant-roles, jsx-a11y/role-has-required-aria-props */

      );
    }
  }]);

  return Checkbox;
}(React.PureComponent);

function stopPropagation(event) {
  event.stopPropagation();
}

var Checkbox$2 = withAppProvider()(Checkbox$1);

var styles$B = {
  "RadioButton": "Polaris-RadioButton",
  "Input": "Polaris-RadioButton__Input",
  "Backdrop": "Polaris-RadioButton__Backdrop",
  "Icon": "Polaris-RadioButton__Icon",
};

var getUniqueID$5 = other.createUniqueIDFactory('RadioButton');
function RadioButton(_ref) {
  var label = _ref.label,
      labelHidden = _ref.labelHidden,
      helpText = _ref.helpText,
      checked = _ref.checked,
      disabled = _ref.disabled,
      onChange = _ref.onChange,
      onFocus = _ref.onFocus,
      onBlur = _ref.onBlur,
      _ref$id = _ref.id,
      id = _ref$id === void 0 ? getUniqueID$5() : _ref$id,
      _ref$name = _ref.name,
      name = _ref$name === void 0 ? id : _ref$name,
      value = _ref.value;

  function handleChange(_ref2) {
    var currentTarget = _ref2.currentTarget;

    if (onChange == null) {
      return;
    }

    onChange(currentTarget.checked, id);
  }

  var describedBy = helpText ? helpTextID$1(id) : undefined;
  return React.createElement(Choice, {
    label: label,
    labelHidden: labelHidden,
    disabled: disabled,
    id: id,
    helpText: helpText
  }, React.createElement("span", {
    className: styles$B.RadioButton
  }, React.createElement("input", {
    id: id,
    name: name,
    value: value,
    type: "radio",
    checked: checked,
    disabled: disabled,
    className: styles$B.Input,
    onChange: handleChange,
    onFocus: onFocus,
    onBlur: onBlur,
    "aria-describedby": describedBy
  }), React.createElement("span", {
    className: styles$B.Backdrop
  }), React.createElement("span", {
    className: styles$B.Icon
  })));
}

var styles$C = {
  "ChoiceList": "Polaris-ChoiceList",
  "titleHidden": "Polaris-ChoiceList--titleHidden",
  "Title": "Polaris-ChoiceList__Title",
  "Choices": "Polaris-ChoiceList__Choices",
  "ChoiceChildren": "Polaris-ChoiceList__ChoiceChildren",
  "ChoiceError": "Polaris-ChoiceList__ChoiceError",
};

var getUniqueID$6 = other.createUniqueIDFactory('ChoiceList');

function ChoiceList(_ref) {
  var title = _ref.title,
      titleHidden = _ref.titleHidden,
      allowMultiple = _ref.allowMultiple,
      choices = _ref.choices,
      selected = _ref.selected,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? other.noop : _ref$onChange,
      error = _ref.error,
      _ref$name = _ref.name,
      name = _ref$name === void 0 ? getUniqueID$6() : _ref$name;
  var ControlComponent = allowMultiple ? Checkbox$2 : RadioButton;
  var finalName = allowMultiple ? "".concat(name, "[]") : name;
  var className = styles.classNames(styles$C.ChoiceList, titleHidden && styles$C.titleHidden);
  var titleMarkup = title ? React.createElement("legend", {
    className: styles$C.Title
  }, title) : null;
  var choicesMarkup = choices.map(function (choice) {
    var value = choice.value,
        label = choice.label,
        helpText = choice.helpText,
        disabled = choice.disabled;

    function handleChange(checked) {
      onChange(updateSelectedChoices(choice, checked, selected, allowMultiple), name);
    }

    var isSelected = choiceIsSelected(choice, selected);
    var renderedChildren = choice.renderChildren ? choice.renderChildren(isSelected) : null;
    var children = renderedChildren ? React.createElement("div", {
      className: styles$C.ChoiceChildren
    }, renderedChildren) : null;
    return React.createElement("li", {
      key: value
    }, React.createElement(ControlComponent, {
      name: finalName,
      value: value,
      label: label,
      disabled: disabled,
      checked: choiceIsSelected(choice, selected),
      helpText: helpText,
      onChange: handleChange
    }), children);
  });
  var errorMarkup = error && React.createElement("div", {
    className: styles$C.ChoiceError
  }, React.createElement(InlineError, {
    message: error,
    fieldID: finalName
  }));
  return React.createElement("fieldset", {
    className: className,
    id: finalName,
    "aria-invalid": error != null,
    "aria-describedby": "".concat(finalName, "Error")
  }, titleMarkup, React.createElement("ul", {
    className: styles$C.Choices
  }, choicesMarkup), errorMarkup);
}

function choiceIsSelected(_ref2, selected) {
  var value = _ref2.value;
  return selected.indexOf(value) >= 0;
}

function updateSelectedChoices(_ref3, checked, selected) {
  var value = _ref3.value;
  var allowMultiple = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

  if (checked) {
    return allowMultiple ? [].concat(_toConsumableArray(selected), [value]) : [value];
  }

  return selected.filter(function (selectedChoice) {
    return selectedChoice !== value;
  });
}

var ChoiceList$1 = withAppProvider()(ChoiceList);

var styles$D = {
  "Collapsible": "Polaris-Collapsible",
  "animating": "Polaris-Collapsible--animating",
  "open": "Polaris-Collapsible--open",
  "fullyOpen": "Polaris-Collapsible--fullyOpen",
};

var CONTEXT_TYPES = {
  parentCollapsibleExpanding: PropTypes.bool
};
var Collapsible =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Collapsible, _React$Component);

  function Collapsible() {
    var _this;

    _classCallCheck(this, Collapsible);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Collapsible).apply(this, arguments));
    _this.state = {
      height: null,
      animationState: 'idle'
    };
    _this.node = null;
    _this.heightNode = null;

    _this.bindNode = function (node) {
      _this.node = node;
    };

    _this.bindHeightNode = function (node) {
      _this.heightNode = node;
    };

    _this.handleTransitionEnd = function (event) {
      var target$$1 = event.target;

      if (target$$1 === _this.node) {
        _this.setState({
          animationState: 'idle',
          height: null
        });
      }
    };

    return _this;
  }

  _createClass(Collapsible, [{
    key: "getChildContext",
    value: function getChildContext() {
      var open = this.props.open;
      var animationState = this.state.animationState;
      var parentCollapsibleExpanding = this.context.parentCollapsibleExpanding;
      return {
        parentCollapsibleExpanding: parentCollapsibleExpanding || open && animationState !== 'idle'
      };
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(_ref) {
      var willOpen = _ref.open;
      var open = this.props.open;

      if (open !== willOpen) {
        this.setState({
          animationState: 'measuring'
        });
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_ref2) {
      var _this2 = this;

      var wasOpen = _ref2.open;
      var animationState = this.state.animationState;
      var parentCollapsibleExpanding = this.context.parentCollapsibleExpanding;

      if (parentCollapsibleExpanding && animationState !== 'idle') {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          animationState: 'idle'
        });
        return;
      }

      fastdom.read(function () {
        switch (animationState) {
          case 'idle':
            break;

          case 'measuring':
            _this2.setState({
              animationState: wasOpen ? 'closingStart' : 'openingStart',
              height: wasOpen && _this2.heightNode ? _this2.heightNode.scrollHeight : 0
            });

            break;

          case 'closingStart':
            _this2.setState({
              animationState: 'closing',
              height: 0
            });

            break;

          case 'openingStart':
            _this2.setState({
              animationState: 'opening',
              height: _this2.heightNode ? _this2.heightNode.scrollHeight : 0
            });

        }
      });
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.node == null) {
        return;
      }

      events.addEventListener(this.node, 'transitionend', this.handleTransitionEnd);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.node == null) {
        return;
      }

      events.removeEventListener(this.node, 'transitionend', this.handleTransitionEnd);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          open = _this$props.open,
          children = _this$props.children;
      var _this$state = this.state,
          animationState = _this$state.animationState,
          height = _this$state.height;
      var animating = animationState !== 'idle';
      var wrapperClassName = styles.classNames(styles$D.Collapsible, open && styles$D.open, animating && styles$D.animating, !animating && open && styles$D.fullyOpen);
      var displayHeight = collapsibleHeight(open, animationState, height);
      var content = animating || open ? children : null;
      return React.createElement("div", {
        id: id,
        "aria-hidden": !open,
        style: {
          height: displayHeight
        },
        className: wrapperClassName,
        ref: this.bindNode
      }, React.createElement("div", {
        ref: this.bindHeightNode
      }, content));
    }
  }]);

  return Collapsible;
}(React.Component);
Collapsible.contextTypes = CONTEXT_TYPES;
Collapsible.childContextTypes = CONTEXT_TYPES;

function collapsibleHeight(open, animationState, height) {
  if (animationState === 'idle' && open) {
    return open ? 'auto' : undefined;
  }

  if (animationState === 'measuring') {
    return open ? undefined : 'auto';
  }

  return "".concat(height || 0, "px");
}

var Collapsible$1 = withAppProvider()(Collapsible);

var styles$E = {
  "ColorPicker": "Polaris-ColorPicker",
  "MainColor": "Polaris-ColorPicker__MainColor",
  "Dragger": "Polaris-ColorPicker__Dragger",
  "ColorLayer": "Polaris-ColorPicker__ColorLayer",
  "HuePicker": "Polaris-ColorPicker__HuePicker",
  "AlphaPicker": "Polaris-ColorPicker__AlphaPicker",
  "Slidable": "Polaris-ColorPicker__Slidable",
};

var Slidable =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Slidable, _React$PureComponent);

  function Slidable() {
    var _this;

    _classCallCheck(this, Slidable);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Slidable).apply(this, arguments));
    _this.state = {
      dragging: false
    };
    _this.node = null;
    _this.draggerNode = null;

    _this.setDraggerNode = function (node) {
      _this.draggerNode = node;
    };

    _this.setNode = function (node) {
      _this.node = node;
    };

    _this.startDrag = function (event) {
      if (event.type === 'mousedown') {
        var mouseEvent = event;

        _this.handleDraggerMove(mouseEvent.clientX, mouseEvent.clientY);
      }

      _this.setState({
        dragging: true
      });
    };

    _this.handleDragEnd = function () {
      _this.setState({
        dragging: false
      });
    };

    _this.handleMove = function (event) {
      event.stopImmediatePropagation();
      event.stopPropagation();
      event.preventDefault();

      if (event.type === 'mousemove') {
        var mouseEvent = event;

        _this.handleDraggerMove(mouseEvent.clientX, mouseEvent.clientY);

        return;
      }

      var touchEvent = event;

      _this.handleDraggerMove(touchEvent.touches[0].clientX, touchEvent.touches[0].clientY);
    };

    _this.handleDraggerMove = function (x, y) {
      if (_this.node == null) {
        return;
      }

      var onChange = _this.props.onChange;

      var rect = _this.node.getBoundingClientRect();

      var offsetX = x - rect.left;
      var offsetY = y - rect.top;
      onChange({
        x: offsetX,
        y: offsetY
      });
    };

    return _this;
  }

  _createClass(Slidable, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var onDraggerHeight = this.props.onDraggerHeight;

      if (onDraggerHeight == null) {
        return;
      }

      var draggerNode = this.draggerNode;

      if (draggerNode == null) {
        return;
      }

      onDraggerHeight(draggerNode.clientWidth);

      if (process.env.NODE_ENV === 'development') {
        setTimeout(function () {
          onDraggerHeight(draggerNode.clientWidth);
        }, 0);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var dragging = this.state.dragging;
      var _this$props = this.props,
          _this$props$draggerX = _this$props.draggerX,
          draggerX = _this$props$draggerX === void 0 ? 0 : _this$props$draggerX,
          _this$props$draggerY = _this$props.draggerY,
          draggerY = _this$props$draggerY === void 0 ? 0 : _this$props$draggerY;
      var draggerPositioning = {
        transform: "translate3d(".concat(draggerX, "px, ").concat(draggerY, "px, 0)")
      };
      var moveListener = dragging ? React.createElement(EventListener, {
        event: "mousemove",
        handler: this.handleMove
      }) : null;
      var touchMoveListener = dragging ? React.createElement(EventListener, {
        event: "touchmove",
        handler: this.handleMove
      }) : null;
      var endDragListener = dragging ? React.createElement(EventListener, {
        event: "mouseup",
        handler: this.handleDragEnd
      }) : null;
      var touchEndListener = dragging ? React.createElement(EventListener, {
        event: "touchend",
        handler: this.handleDragEnd
      }) : null;
      var touchCancelListener = dragging ? React.createElement(EventListener, {
        event: "touchcancel",
        handler: this.handleDragEnd
      }) : null;
      return React.createElement("div", {
        ref: this.setNode,
        className: styles$E.Slidable,
        onMouseDown: this.startDrag,
        onTouchStart: this.startDrag
      }, endDragListener, moveListener, touchMoveListener, touchEndListener, touchCancelListener, React.createElement("div", {
        style: draggerPositioning,
        className: styles$E.Dragger,
        ref: this.setDraggerNode
      }));
    }
  }]);

  return Slidable;
}(React.PureComponent);

var VERTICAL_PADDING = 13;
function calculateDraggerY(alpha, sliderHeight, draggerHeight) {
  var offset = offsetForAlpha(alpha, sliderHeight, draggerHeight);
  return math.clamp(offset, 0, sliderHeight);
}
function alphaForDraggerY(y, sliderHeight) {
  var offsetY = math.clamp(y, 0, sliderHeight);
  return alphaForOffset(offsetY, sliderHeight);
}
function alphaForOffset(offset, sliderHeight) {
  var selectionHeight = offset - VERTICAL_PADDING;
  var slidableArea = sliderHeight - VERTICAL_PADDING * 2;
  return math.clamp(1 - selectionHeight / slidableArea, 0, 1);
}

function offsetForAlpha(alpha, sliderHeight, draggerHeight) {
  var slidableArea = sliderHeight - (draggerHeight + VERTICAL_PADDING);
  return math.clamp((1 - alpha) * slidableArea + VERTICAL_PADDING, 0, sliderHeight - draggerHeight);
}

var AlphaPicker =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(AlphaPicker, _React$PureComponent);

  function AlphaPicker() {
    var _this;

    _classCallCheck(this, AlphaPicker);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AlphaPicker).apply(this, arguments));
    _this.state = {
      sliderHeight: 0,
      draggerHeight: 0
    };

    _this.setSliderHeight = function (node) {
      if (node == null) {
        return;
      }

      _this.setState({
        sliderHeight: node.clientHeight
      });

      if (process.env.NODE_ENV === 'development') {
        setTimeout(function () {
          _this.setState({
            sliderHeight: node.clientHeight
          });
        }, 0);
      }
    };

    _this.setDraggerHeight = function (height) {
      _this.setState({
        draggerHeight: height
      });
    };

    _this.handleChange = function (_ref) {
      var y = _ref.y;
      var onChange = _this.props.onChange;
      var sliderHeight = _this.state.sliderHeight;
      var alpha = alphaForDraggerY(y, sliderHeight);
      onChange(alpha);
    };

    return _this;
  }

  _createClass(AlphaPicker, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          color = _this$props.color,
          alpha = _this$props.alpha;
      var _this$state = this.state,
          sliderHeight = _this$state.sliderHeight,
          draggerHeight = _this$state.draggerHeight;
      var draggerY = calculateDraggerY(alpha, sliderHeight, draggerHeight);
      var background = alphaGradientForColor(color);
      return React.createElement("div", {
        className: styles$E.AlphaPicker,
        ref: this.setSliderHeight
      }, React.createElement("div", {
        className: styles$E.ColorLayer,
        style: {
          background: background
        }
      }), React.createElement(Slidable, {
        draggerY: draggerY,
        draggerX: 0,
        onChange: this.handleChange,
        onDraggerHeight: this.setDraggerHeight
      }));
    }
  }]);

  return AlphaPicker;
}(React.PureComponent);

function alphaGradientForColor(color) {
  var _hsbToRgb = hsbToRgb(color),
      red = _hsbToRgb.red,
      green = _hsbToRgb.green,
      blue = _hsbToRgb.blue;

  var rgb = "".concat(red, ", ").concat(green, ", ").concat(blue);
  return "linear-gradient(to top, rgba(".concat(rgb, ", 0) 18px, rgba(").concat(rgb, ", 1) calc(100% - 18px))");
}

var VERTICAL_PADDING$1 = 13;
function calculateDraggerY$1(hue, sliderHeight, draggerHeight) {
  var offset = offsetForHue(hue, sliderHeight, draggerHeight);
  return math.clamp(offset, 0, sliderHeight);
}
function hueForDraggerY(y, sliderHeight) {
  var offsetY = math.clamp(y, 0, sliderHeight);
  return hueForOffset(offsetY, sliderHeight);
}

function hueForOffset(offset, sliderHeight) {
  var selectionHeight = offset - VERTICAL_PADDING$1;
  var slidableArea = sliderHeight - VERTICAL_PADDING$1 * 2;
  return math.clamp(selectionHeight / slidableArea * 360, 0, 360);
}

function offsetForHue(hue, sliderHeight, draggerHeight) {
  var slidableArea = sliderHeight - (draggerHeight + VERTICAL_PADDING$1);
  return math.clamp(hue / 360 * slidableArea + VERTICAL_PADDING$1, 0, sliderHeight - draggerHeight);
}

var HuePicker =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(HuePicker, _React$PureComponent);

  function HuePicker() {
    var _this;

    _classCallCheck(this, HuePicker);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(HuePicker).apply(this, arguments));
    _this.state = {
      sliderHeight: 0,
      draggerHeight: 0
    };

    _this.setSliderHeight = function (node) {
      if (node == null) {
        return;
      }

      _this.setState({
        sliderHeight: node.clientHeight
      });

      if (process.env.NODE_ENV === 'development') {
        setTimeout(function () {
          _this.setState({
            sliderHeight: node.clientHeight
          });
        }, 0);
      }
    };

    _this.setDraggerHeight = function (height) {
      _this.setState({
        draggerHeight: height
      });
    };

    _this.handleChange = function (_ref) {
      var y = _ref.y;
      var onChange = _this.props.onChange;
      var sliderHeight = _this.state.sliderHeight;
      var hue = hueForDraggerY(y, sliderHeight);
      onChange(hue);
    };

    return _this;
  }

  _createClass(HuePicker, [{
    key: "render",
    value: function render() {
      var hue = this.props.hue;
      var _this$state = this.state,
          sliderHeight = _this$state.sliderHeight,
          draggerHeight = _this$state.draggerHeight;
      var draggerY = calculateDraggerY$1(hue, sliderHeight, draggerHeight);
      return React.createElement("div", {
        className: styles$E.HuePicker,
        ref: this.setSliderHeight
      }, React.createElement(Slidable, {
        draggerY: draggerY,
        draggerX: 0,
        onChange: this.handleChange,
        onDraggerHeight: this.setDraggerHeight
      }));
    }
  }]);

  return HuePicker;
}(React.PureComponent);

var ColorPicker =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(ColorPicker, _React$PureComponent);

  function ColorPicker() {
    var _this;

    _classCallCheck(this, ColorPicker);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ColorPicker).apply(this, arguments));
    _this.state = {
      pickerSize: 0
    };
    _this.colorNode = null;

    _this.setColorNode = function (node) {
      _this.colorNode = node;
    };

    _this.handleHueChange = function (hue) {
      var _this$props = _this.props,
          _this$props$color = _this$props.color,
          brightness = _this$props$color.brightness,
          saturation = _this$props$color.saturation,
          _this$props$color$alp = _this$props$color.alpha,
          alpha = _this$props$color$alp === void 0 ? 1 : _this$props$color$alp,
          onChange = _this$props.onChange;
      onChange({
        hue: hue,
        brightness: brightness,
        saturation: saturation,
        alpha: alpha
      });
    };

    _this.handleAlphaChange = function (alpha) {
      var _this$props2 = _this.props,
          _this$props2$color = _this$props2.color,
          hue = _this$props2$color.hue,
          brightness = _this$props2$color.brightness,
          saturation = _this$props2$color.saturation,
          onChange = _this$props2.onChange;
      onChange({
        hue: hue,
        brightness: brightness,
        saturation: saturation,
        alpha: alpha
      });
    };

    _this.handleDraggerMove = function (_ref) {
      var x = _ref.x,
          y = _ref.y;
      var pickerSize = _this.state.pickerSize;
      var _this$props3 = _this.props,
          _this$props3$color = _this$props3.color,
          hue = _this$props3$color.hue,
          _this$props3$color$al = _this$props3$color.alpha,
          alpha = _this$props3$color$al === void 0 ? 1 : _this$props3$color$al,
          onChange = _this$props3.onChange;
      var saturation = math.clamp(x / pickerSize, 0, 1);
      var brightness = math.clamp(1 - y / pickerSize, 0, 1);
      onChange({
        hue: hue,
        saturation: saturation,
        brightness: brightness,
        alpha: alpha
      });
    };

    return _this;
  }

  _createClass(ColorPicker, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      var colorNode = this.colorNode;

      if (colorNode == null) {
        return;
      }

      this.setState({
        pickerSize: colorNode.clientWidth
      });

      if (process.env.NODE_ENV === 'development') {
        setTimeout(function () {
          _this2.setState({
            pickerSize: colorNode.clientWidth
          });
        }, 0);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
          id = _this$props4.id,
          color = _this$props4.color,
          allowAlpha = _this$props4.allowAlpha;
      var hue = color.hue,
          saturation = color.saturation,
          brightness = color.brightness,
          providedAlpha = color.alpha;
      var pickerSize = this.state.pickerSize;
      var alpha = providedAlpha != null && allowAlpha ? providedAlpha : 1;

      var _hsbToRgb = hsbToRgb({
        hue: hue,
        saturation: 1,
        brightness: 1
      }),
          red = _hsbToRgb.red,
          green = _hsbToRgb.green,
          blue = _hsbToRgb.blue;

      var colorString = "rgba(".concat(red, ", ").concat(green, ", ").concat(blue, ", ").concat(alpha, ")");
      var draggerX = math.clamp(saturation * pickerSize, 0, pickerSize);
      var draggerY = math.clamp(pickerSize - brightness * pickerSize, 0, pickerSize);
      var alphaSliderMarkup = allowAlpha ? React.createElement(AlphaPicker, {
        alpha: alpha,
        color: color,
        onChange: this.handleAlphaChange
      }) : null;
      return React.createElement("div", {
        className: styles$E.ColorPicker,
        id: id
      }, React.createElement("div", {
        ref: this.setColorNode,
        className: styles$E.MainColor
      }, React.createElement("div", {
        className: styles$E.ColorLayer,
        style: {
          backgroundColor: colorString
        }
      }), React.createElement(Slidable, {
        onChange: this.handleDraggerMove,
        draggerX: draggerX,
        draggerY: draggerY
      })), React.createElement(HuePicker, {
        hue: hue,
        onChange: this.handleHueChange
      }), alphaSliderMarkup);
    }
  }]);

  return ColorPicker;
}(React.PureComponent);

var Focus =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Focus, _React$PureComponent);

  function Focus() {
    _classCallCheck(this, Focus);

    return _possibleConstructorReturn(this, _getPrototypeOf(Focus).apply(this, arguments));
  }

  _createClass(Focus, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.handleSelfFocus();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_a) {
      var prevChildren = _a.children,
          restPrevProps = tslib_1.__rest(_a, ["children"]);

      var _b = this.props,
          children = _b.children,
          restProps = tslib_1.__rest(_b, ["children"]);

      if (isEqual(restProps, restPrevProps)) {
        return;
      }

      this.handleSelfFocus();
    }
  }, {
    key: "handleSelfFocus",
    value: function handleSelfFocus() {
      if (this.props.disabled) {
        return;
      }

      var root = ReactDOM.findDOMNode(this);

      if (root) {
        if (!root.querySelector('[autofocus]')) {
          focus.focusFirstFocusableNode(root, false);
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var children = this.props.children;
      return React.createElement(React.Fragment, null, children);
    }
  }]);

  return Focus;
}(React.PureComponent);

var TrapFocus =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(TrapFocus, _React$PureComponent);

  function TrapFocus() {
    var _this;

    _classCallCheck(this, TrapFocus);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(TrapFocus).apply(this, arguments));
    _this.state = {
      shouldFocusSelf: undefined
    };

    _this.setFocusTrapWrapper = function (node) {
      _this.focusTrapWrapper = node;
    };

    _this.handleBlur = function (event) {
      var relatedTarget = event.relatedTarget;

      var _assertThisInitialize = _assertThisInitialized(_assertThisInitialized(_this)),
          focusTrapWrapper = _assertThisInitialize.focusTrapWrapper;

      var _this$props$trapping = _this.props.trapping,
          trapping = _this$props$trapping === void 0 ? true : _this$props$trapping;

      if (relatedTarget == null || trapping === false) {
        return;
      }

      if (focusTrapWrapper && !focusTrapWrapper.contains(relatedTarget) && !dom.closest(relatedTarget, '[data-polaris-overlay]')) {
        event.preventDefault();

        if (event.srcElement === focus.findFirstFocusableNode(focusTrapWrapper)) {
          return focus.focusLastFocusableNode(focusTrapWrapper);
        }

        focus.focusFirstFocusableNode(focusTrapWrapper);
      }
    };

    return _this;
  }

  _createClass(TrapFocus, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setState(this.handleTrappingChange());
    }
  }, {
    key: "handleTrappingChange",
    value: function handleTrappingChange() {
      var _this$props$trapping2 = this.props.trapping,
          trapping = _this$props$trapping2 === void 0 ? true : _this$props$trapping2;

      if (this.focusTrapWrapper.contains(document.activeElement)) {
        return {
          shouldFocusSelf: false
        };
      }

      return {
        shouldFocusSelf: trapping
      };
    }
  }, {
    key: "render",
    value: function render() {
      var children = this.props.children;
      return React.createElement(Focus, {
        disabled: this.shouldDisable
      }, React.createElement("div", {
        ref: this.setFocusTrapWrapper
      }, React.createElement(EventListener, {
        event: "focusout",
        handler: this.handleBlur
      }), children));
    }
  }, {
    key: "shouldDisable",
    get: function get() {
      var _this$props$trapping3 = this.props.trapping,
          trapping = _this$props$trapping3 === void 0 ? true : _this$props$trapping3;
      var shouldFocusSelf = this.state.shouldFocusSelf;

      if (shouldFocusSelf === undefined) {
        return true;
      }

      return shouldFocusSelf ? !trapping : !shouldFocusSelf;
    }
  }]);

  return TrapFocus;
}(React.PureComponent);

function isObject(value) {
  var type = _typeof(value);

  return value != null && (type === exports.TypeOf.Object || type === exports.TypeOf.Function);
}

function pluckDeep(obj, key) {
  if (!obj) {
    return null;
  }

  var keys = Object.keys(obj);

  for (var i = 0; i < keys.length; i++) {
    var currKey = keys[i];

    if (currKey === key) {
      return obj[key];
    }

    if (isObject(obj[currKey])) {
      var plucked = pluckDeep(obj[currKey], key);

      if (plucked) {
        return plucked;
      }
    }
  }

  return null;
}

function getWidth() {
  var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var defaultWidth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
  var key = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'width';
  var width = typeof value === 'number' ? value : pluckDeep(value, key);
  return width ? "".concat(width, "px") : "".concat(defaultWidth, "px");
}

var styles$F = {
  "Search": "Polaris-TopBar-Search",
  "visible": "Polaris-TopBar-Search--visible",
  "Overlay": "Polaris-TopBar-Search__Overlay",
};

var Search =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Search, _React$PureComponent);

  function Search() {
    var _this;

    _classCallCheck(this, Search);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Search).apply(this, arguments));
    _this.node = React.createRef();

    _this.handleDismiss = function (_ref) {
      var target$$1 = _ref.target;
      var onDismiss = _this.props.onDismiss;

      if (onDismiss != null && target$$1 === _this.node.current) {
        onDismiss();
      }
    };

    return _this;
  }

  _createClass(Search, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          visible = _this$props.visible,
          children = _this$props.children;
      var searchClassName = styles.classNames(styles$F.Search, visible && styles$F.visible);
      return React.createElement("div", {
        ref: this.node,
        className: searchClassName,
        onClick: this.handleDismiss
      }, React.createElement("div", {
        className: styles$F.Overlay
      }, children));
    }
  }]);

  return Search;
}(React.PureComponent);

function noop() {}

var styles$G = {
  "SearchField": "Polaris-TopBar-SearchField",
  "focused": "Polaris-TopBar-SearchField--focused",
  "Input": "Polaris-TopBar-SearchField__Input",
  "Backdrop": "Polaris-TopBar-SearchField__Backdrop",
  "Icon": "Polaris-TopBar-SearchField__Icon",
  "Clear": "Polaris-TopBar-SearchField__Clear",
  "toLightBackground": "Polaris-TopBar-SearchField--toLightBackground",
};

var SearchField =
/*#__PURE__*/
function (_React$Component) {
  _inherits(SearchField, _React$Component);

  function SearchField() {
    var _this;

    _classCallCheck(this, SearchField);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(SearchField).apply(this, arguments));
    _this.input = React.createRef();

    _this.handleFocus = function () {
      var onFocus = _this.props.onFocus;

      if (onFocus) {
        onFocus();
      }
    };

    _this.handleBlur = function () {
      var onBlur = _this.props.onBlur;

      if (onBlur) {
        onBlur();
      }
    };

    _this.handleClear = function () {
      var _this$props = _this.props,
          _this$props$onCancel = _this$props.onCancel,
          onCancel = _this$props$onCancel === void 0 ? noop : _this$props$onCancel,
          onChange = _this$props.onChange;

      var _assertThisInitialize = _assertThisInitialized(_assertThisInitialized(_this)),
          input = _assertThisInitialize.input.current;

      onCancel();

      if (input != null) {
        input.value = '';
        onChange('');
        input.focus();
      }
    };

    _this.handleChange = function (_ref) {
      var currentTarget = _ref.currentTarget;
      var onChange = _this.props.onChange;
      onChange(currentTarget.value);
    };

    return _this;
  }

  _createClass(SearchField, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var focused = this.props.focused;
      var input = this.input.current;

      if (input && focused) {
        input.focus();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_ref2) {
      var wasFocused = _ref2.focused;
      var input = this.input.current;

      if (input == null) {
        return;
      }

      var focused = this.props.focused;

      if (focused && !wasFocused) {
        input.focus();
      } else if (!focused && wasFocused) {
        input.blur();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          value = _this$props2.value,
          focused = _this$props2.focused,
          active = _this$props2.active,
          placeholder = _this$props2.placeholder;
      var clearMarkup = value !== '' && React.createElement("button", {
        type: "button",
        "aria-label": "Clear",
        className: styles$G.Clear,
        onClick: this.handleClear
      }, React.createElement(Icon$1, {
        source: polarisIcons.CircleCancelMinor
      }));
      var className = styles.classNames(styles$G.SearchField, (focused || active) && styles$G.focused);
      return React.createElement("div", {
        className: className,
        onFocus: this.handleFocus,
        onBlur: this.handleBlur
      }, React.createElement("input", {
        className: styles$G.Input,
        placeholder: placeholder,
        type: "search",
        autoCapitalize: "off",
        autoComplete: "off",
        autoCorrect: "off",
        ref: this.input,
        value: value,
        onChange: this.handleChange,
        onKeyDown: preventDefault
      }), React.createElement("span", {
        className: styles$G.Icon
      }, React.createElement(Icon$1, {
        source: polarisIcons.SearchMinor
      })), clearMarkup, React.createElement("div", {
        className: styles$G.Backdrop
      }));
    }
  }]);

  return SearchField;
}(React.Component);

function preventDefault(event) {
  if (event.key === 'Enter') {
    event.preventDefault();
  }
}

function withContext(Consumer) {
  return function addContext(WrappedComponent) {
    // eslint-disable-next-line react/prefer-stateless-function
    var WithContext =
    /*#__PURE__*/
    function (_React$Component) {
      _inherits(WithContext, _React$Component);

      function WithContext() {
        _classCallCheck(this, WithContext);

        return _possibleConstructorReturn(this, _getPrototypeOf(WithContext).apply(this, arguments));
      }

      _createClass(WithContext, [{
        key: "render",
        value: function render() {
          var _this = this;

          return React.createElement(Consumer, null, function (ctx) {
            var _a = _this.props,
                context = _a.context,
                rest = tslib_1.__rest(_a, ["context"]);

            return React.createElement(WrappedComponent, Object.assign({}, rest, {
              context: Object.assign({}, context, ctx)
            }));
          });
        }
      }]);

      return WithContext;
    }(React.Component);

    var FinalComponent = hoistStatics(WithContext, WrappedComponent);
    return FinalComponent;
  };
}

var UserMenuContext = React.createContext({});

var Provider$1 =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Provider, _React$Component);

  _createClass(Provider, null, [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, _ref2) {
      var nextMobileView = _ref.mobileView;
      var mobileView = _ref2.mobileView;

      if (nextMobileView !== mobileView) {
        return {
          mobileView: nextMobileView
        };
      }

      return null;
    }
  }]);

  function Provider(props) {
    var _this;

    _classCallCheck(this, Provider);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Provider).call(this, props));
    _this.setMobileUserMenuProps = _this.setMobileUserMenuProps.bind(_assertThisInitialized(_assertThisInitialized(_this)));
    _this.state = {
      // eslint-disable-next-line react/no-unused-state
      mobileView: props.mobileView,
      mobileUserMenuProps: undefined,
      // eslint-disable-next-line react/no-unused-state
      setMobileUserMenuProps: _this.setMobileUserMenuProps
    };
    return _this;
  }

  _createClass(Provider, [{
    key: "render",
    value: function render() {
      var state = this.state;
      var children = this.props.children;
      return React.createElement(UserMenuContext.Provider, {
        value: state
      }, children);
    }
  }, {
    key: "setMobileUserMenuProps",
    value: function setMobileUserMenuProps(mobileUserMenuProps) {
      var prevMobileUserMenuProps = this.state.mobileUserMenuProps;

      if (isEqual(mobileUserMenuProps, prevMobileUserMenuProps)) {
        return;
      }

      this.setState({
        mobileUserMenuProps: mobileUserMenuProps
      });
    }
  }]);

  return Provider;
}(React.Component);

var Consumer$1 = UserMenuContext.Consumer;

var Modifier =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Modifier, _React$Component);

  function Modifier() {
    var _this;

    _classCallCheck(this, Modifier);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Modifier).apply(this, arguments));
    _this.state = {};
    return _this;
  }

  _createClass(Modifier, [{
    key: "render",
    value: function render() {
      return null;
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref) {
      var setMobileUserMenuProps = _ref.context.setMobileUserMenuProps,
          userMenuProps = _ref.userMenuProps;

      if (setMobileUserMenuProps) {
        setMobileUserMenuProps(userMenuProps);
      }

      return null;
    }
  }]);

  return Modifier;
}(React.Component);

var UserMenuModifier = withContext(Consumer$1)(Modifier);

var styles$H = {
  "MessageIndicatorWrapper": "Polaris-MessageIndicator__MessageIndicatorWrapper",
  "MessageIndicator": "Polaris-MessageIndicator",
};

function MessageIndicator(_ref) {
  var children = _ref.children,
      active = _ref.active;
  var indicatorMarkup = active && React.createElement("div", {
    className: styles$H.MessageIndicator
  });
  return React.createElement("div", {
    className: styles$H.MessageIndicatorWrapper
  }, indicatorMarkup, children);
}

var styles$I = {
  "Link": "Polaris-Link",
  "IconLockup": "Polaris-Link__IconLockup",
  "IconLayout": "Polaris-Link__IconLayout",
  "monochrome": "Polaris-Link--monochrome",
};

function Link$1(_ref) {
  var url = _ref.url,
      children = _ref.children,
      onClick = _ref.onClick,
      external = _ref.external,
      id = _ref.id,
      monochrome = _ref.monochrome,
      polaris = _ref.polaris;
  var className = reactUtilities.classNames(styles$I.Link, monochrome && styles$I.monochrome);
  var childrenMarkup = children;

  if (external && typeof children === 'string') {
    var iconLabel = polaris.intl.translate('Polaris.Common.newWindowAccessibilityHint');
    childrenMarkup = React.createElement(React.Fragment, null, children, React.createElement("span", {
      className: styles$I.IconLockup
    }, React.createElement("span", {
      className: styles$I.IconLayout
    }, React.createElement(Icon$1, {
      accessibilityLabel: iconLabel,
      source: polarisIcons.ExternalSmallMinor
    }))));
  }

  return url ? React.createElement(UnstyledLink$1, {
    onClick: onClick,
    className: className,
    url: url,
    external: external,
    id: id,
    polaris: polaris
  }, childrenMarkup) : React.createElement("button", {
    type: "button",
    onClick: onClick,
    className: className,
    id: id
  }, childrenMarkup);
}

var Link$2 = withAppProvider()(Link$1);

var styles$J = {
  "Section": "Polaris-Menu-Message__Section",
};

function Message(_ref) {
  var title = _ref.title,
      description = _ref.description,
      action = _ref.action,
      link = _ref.link,
      badge = _ref.badge;
  var badgeMarkup = badge && React.createElement(Badge$1, {
    status: badge.status
  }, badge.content);
  var to = link.to,
      linkContent = link.content;
  var onClick = action.onClick,
      actionContent = action.content;
  return React.createElement("div", {
    className: styles$J.Section
  }, React.createElement(Popover.Section, null, React.createElement(Stack, {
    vertical: true,
    spacing: "tight"
  }, React.createElement(TextContainer, null, React.createElement(Heading, null, title, badgeMarkup), React.createElement("p", null, description)), React.createElement(Link$2, {
    url: to
  }, linkContent), React.createElement(Button$1, {
    plain: true,
    onClick: onClick
  }, actionContent))));
}

var styles$K = {
  "ActivatorWrapper": "Polaris-TopBar-Menu__ActivatorWrapper",
  "Activator": "Polaris-TopBar-Menu__Activator",
  "Section": "Polaris-TopBar-Menu__Section",
};

function Menu(props) {
  var actions$$1 = props.actions,
      onOpen = props.onOpen,
      onClose = props.onClose,
      open = props.open,
      activatorContent = props.activatorContent,
      message = props.message;
  var badgeProps = message && message.badge && {
    content: message.badge.content,
    status: message.badge.status
  };
  var messageMarkup = message && React.createElement(Message, {
    title: message.title,
    description: message.description,
    action: {
      onClick: message.action.onClick,
      content: message.action.content
    },
    link: {
      to: message.link.to,
      content: message.link.content
    },
    badge: badgeProps
  });
  var isFullHeight = Boolean(message);
  return React.createElement(Popover, {
    activator: React.createElement("div", {
      className: styles$K.ActivatorWrapper
    }, React.createElement("button", {
      type: "button",
      className: styles$K.Activator,
      onClick: onOpen
    }, activatorContent)),
    active: open,
    onClose: onClose,
    fixed: true,
    fullHeight: isFullHeight
  }, React.createElement(ActionList, {
    onActionAnyItem: onClose,
    sections: actions$$1
  }), messageMarkup);
}

var styles$L = {
  "Details": "Polaris-UserMenu-UserMenu__Details",
  "Name": "Polaris-UserMenu-UserMenu__Name",
  "Detail": "Polaris-UserMenu-UserMenu__Detail",
};

function UserMenu(_ref) {
  var name = _ref.name,
      detail = _ref.detail,
      avatar = _ref.avatar,
      initials = _ref.initials,
      actions$$1 = _ref.actions,
      message = _ref.message,
      onToggle = _ref.onToggle,
      open = _ref.open;
  var showIndicator = Boolean(message);
  var activatorContentMarkup = React.createElement(React.Fragment, null, React.createElement(MessageIndicator, {
    active: showIndicator
  }, React.createElement(Avatar$1, {
    size: "small",
    source: avatar,
    initials: initials && initials.replace(' ', '')
  })), React.createElement("span", {
    className: styles$L.Details
  }, React.createElement("p", {
    className: styles$L.Name
  }, name), React.createElement("p", {
    className: styles$L.Detail
  }, detail)));
  return React.createElement(Menu, {
    activatorContent: activatorContentMarkup,
    open: open,
    onOpen: onToggle,
    onClose: onToggle,
    actions: actions$$1,
    message: message
  });
}

function UserMenu$1(_a) {
  var _a$context = _a.context,
      mobileUserMenuProps = _a$context.mobileUserMenuProps,
      mobileView = _a$context.mobileView,
      userMenuProps = tslib_1.__rest(_a, ["context"]);

  if (mobileUserMenuProps && mobileView) {
    return React.createElement(UserMenu, mobileUserMenuProps);
  }

  return React.createElement(UserMenu, userMenuProps);
}

var UserMenu$2 = withContext(Consumer$1)(UserMenu$1);

var styles$M = {
  "TopBar": "Polaris-TopBar",
  "LogoContainer": "Polaris-TopBar__LogoContainer",
  "ContextControl": "Polaris-TopBar__ContextControl",
  "Logo": "Polaris-TopBar__Logo",
  "LogoLink": "Polaris-TopBar__LogoLink",
  "NavigationIcon": "Polaris-TopBar__NavigationIcon",
  "focused": "Polaris-TopBar--focused",
  "Contents": "Polaris-TopBar__Contents",
  "SearchField": "Polaris-TopBar__SearchField",
  "SecondaryMenu": "Polaris-TopBar__SecondaryMenu",
};

var TopBar =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(TopBar, _React$PureComponent);

  function TopBar() {
    var _this;

    _classCallCheck(this, TopBar);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(TopBar).apply(this, arguments));
    _this.state = {
      focused: false
    };

    _this.handleFocus = function () {
      _this.setState({
        focused: true
      });
    };

    _this.handleBlur = function () {
      _this.setState({
        focused: false
      });
    };

    return _this;
  }

  _createClass(TopBar, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          showNavigationToggle = _this$props.showNavigationToggle,
          userMenu = _this$props.userMenu,
          searchResults = _this$props.searchResults,
          searchField = _this$props.searchField,
          secondaryMenu = _this$props.secondaryMenu,
          searchResultsVisible = _this$props.searchResultsVisible,
          onNavigationToggle = _this$props.onNavigationToggle,
          onSearchResultsDismiss = _this$props.onSearchResultsDismiss,
          contextControl = _this$props.contextControl,
          logo = _this$props.polaris.theme.logo;
      var focused = this.state.focused;
      var className = styles.classNames(styles$M.NavigationIcon, focused && styles$M.focused);
      var navigationButtonMarkup = showNavigationToggle ? React.createElement("button", {
        type: "button",
        className: className,
        onClick: onNavigationToggle,
        onFocus: this.handleFocus,
        onBlur: this.handleBlur,
        "aria-label": "Toggle menu"
      }, React.createElement(Icon$1, {
        source: polarisIcons.MobileHamburgerMajorMonotone,
        color: "white"
      })) : null;
      var width = getWidth(logo, 104);
      var contextMarkup;

      if (contextControl) {
        contextMarkup = React.createElement("div", {
          className: styles$M.ContextControl
        }, contextControl);
      } else if (logo) {
        contextMarkup = React.createElement("div", {
          className: styles$M.LogoContainer
        }, React.createElement(UnstyledLink$1, {
          url: logo.url || '',
          className: styles$M.LogoLink,
          style: {
            width: width
          }
        }, React.createElement(Image, {
          source: logo.topBarSource || '',
          alt: logo.accessibilityLabel || '',
          className: styles$M.Logo,
          style: {
            width: width
          }
        })));
      }

      var searchResultsMarkup = searchResults && searchResultsVisible ? React.createElement(Search, {
        visible: searchResultsVisible,
        onDismiss: onSearchResultsDismiss
      }, searchResults) : null;
      var searchMarkup = searchField ? React.createElement(React.Fragment, null, searchField, searchResultsMarkup) : null;
      return React.createElement("div", {
        className: styles$M.TopBar
      }, navigationButtonMarkup, contextMarkup, React.createElement("div", {
        className: styles$M.Contents
      }, React.createElement("div", {
        className: styles$M.SearchField
      }, searchMarkup), React.createElement("div", {
        className: styles$M.SecondaryMenu
      }, secondaryMenu), userMenu));
    }
  }]);

  return TopBar;
}(React.PureComponent);
TopBar.UserMenu = UserMenu$2;
TopBar.SearchField = SearchField;
TopBar.Menu = Menu;
var TopBar$1 = withAppProvider()(TopBar);

function setRootProperty(name, value, node) {
  if (document == null) {
    return;
  }

  var styleNode = node && node instanceof HTMLElement ? node : document.documentElement;
  styleNode && styleNode.style.setProperty(name, value);
}

var frameContextTypes = {
  frame: PropTypes.object
};

var styles$N = {
  "Toast": "Polaris-Frame-Toast",
  "Action": "Polaris-Frame-Toast__Action",
  "error": "Polaris-Frame-Toast--error",
  "CloseButton": "Polaris-Frame-Toast__CloseButton",
};

var DEFAULT_TOAST_DURATION = 5000;
var DEFAULT_TOAST_DURATION_WITH_ACTION = 10000;

var Toast =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Toast, _React$Component);

  function Toast() {
    _classCallCheck(this, Toast);

    return _possibleConstructorReturn(this, _getPrototypeOf(Toast).apply(this, arguments));
  }

  _createClass(Toast, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.triggerDismissalTimeout();
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.triggerDismissalTimeout();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.clearDismissalTimeout();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          content = _this$props.content,
          onDismiss = _this$props.onDismiss,
          error = _this$props.error,
          action = _this$props.action;
      var dismissMarkup = React.createElement("button", {
        type: "button",
        className: styles$N.CloseButton,
        onClick: onDismiss
      }, React.createElement(Icon$1, {
        source: polarisIcons.MobileCancelMajorMonotone
      }));
      var actionMarkup = action ? React.createElement("div", {
        className: styles$N.Action
      }, React.createElement(Button$1, {
        plain: true,
        monochrome: true,
        onClick: action.onAction
      }, action.content)) : null;
      var className = reactUtilities.classNames(styles$N.Toast, error && styles$N.error);
      return React.createElement("div", {
        className: className
      }, React.createElement(KeypressListener, {
        keyCode: exports.Key.Escape,
        handler: onDismiss
      }), content, actionMarkup, dismissMarkup);
    }
  }, {
    key: "clearDismissalTimeout",
    value: function clearDismissalTimeout() {
      if (this.timer) {
        window.clearTimeout(this.timer);
      }
    }
  }, {
    key: "triggerDismissalTimeout",
    value: function triggerDismissalTimeout() {
      var _this$props2 = this.props,
          onDismiss = _this$props2.onDismiss,
          duration = _this$props2.duration,
          action = _this$props2.action;
      var timeoutDuration = duration || DEFAULT_TOAST_DURATION;

      if (action && !duration) {
        timeoutDuration = DEFAULT_TOAST_DURATION_WITH_ACTION;
      } else if (action && duration && duration < DEFAULT_TOAST_DURATION_WITH_ACTION) {
        // eslint-disable-next-line no-console
        console.log('Toast with action should persist for at least 10,000 milliseconds to give the merchant enough time to act on it.');
      }

      this.clearDismissalTimeout();

      if (onDismiss != null) {
        this.timer = window.setTimeout(onDismiss, timeoutDuration);
      }
    }
  }]);

  return Toast;
}(React.Component);

var styles$O = {
  "ToastManager": "Polaris-Frame-ToastManager",
  "ToastWrapper": "Polaris-Frame-ToastManager__ToastWrapper",
  "ToastWrapper-enter": "Polaris-Frame-ToastManager__ToastWrapper--enter",
  "ToastWrapper-exit": "Polaris-Frame-ToastManager__ToastWrapper--exit",
  "ToastWrapper-enter-done": "Polaris-Frame-ToastManager--toastWrapperEnterDone",
};

var ToastManager =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(ToastManager, _React$PureComponent);

  function ToastManager() {
    var _this;

    _classCallCheck(this, ToastManager);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ToastManager).apply(this, arguments));
    _this.toastNodes = [];

    _this.updateToasts = function () {
      var toastMessages = _this.props.toastMessages;
      var targetInPos = 0;
      toastMessages.forEach(function (_toast, i) {
        var currentToast = _this.toastNodes[i].current;

        if (currentToast) {
          targetInPos += currentToast.clientHeight;
          currentToast.style.setProperty('--toast-translate-y-in', "-".concat(targetInPos, "px"));
          currentToast.style.setProperty('--toast-translate-y-out', "".concat(-targetInPos + 150, "px"));
        }
      });
    };

    return _this;
  }

  _createClass(ToastManager, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.updateToasts();
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var toastMessages = this.props.toastMessages;
      var toastsMarkup = toastMessages.map(function (toast, index) {
        _this2.toastNodes[index] = React.createRef();
        return React.createElement(reactTransitionGroup.CSSTransition, {
          key: toast.id,
          timeout: {
            enter: 0,
            exit: 400
          },
          classNames: toastClasses
        }, React.createElement("div", {
          ref: _this2.toastNodes[index],
          "aria-live": "polite"
        }, React.createElement(Toast, toast)));
      });
      return React.createElement(Portal, {
        idPrefix: "toast-manager"
      }, React.createElement(EventListener, {
        event: "resize",
        handler: this.updateToasts
      }), React.createElement("div", {
        className: styles$O.ToastManager
      }, React.createElement(reactTransitionGroup.TransitionGroup, {
        component: null
      }, toastsMarkup)));
    }
  }]);

  return ToastManager;
}(React.PureComponent);
var toastClasses = {
  enter: styles.classNames(styles$O.ToastWrapper, styles$O['ToastWrapper-enter']),
  enterDone: styles.classNames(styles$O.ToastWrapper, styles$O['ToastWrapper-enter-done']),
  exit: styles.classNames(styles$O.ToastWrapper, styles$O['ToastWrapper-exit'])
};

var styles$P = {
  "Loading": "Polaris-Frame-Loading",
  "Level": "Polaris-Frame-Loading__Level",
};

var INITIAL_STEP = 10;
var STUCK_THRESHOLD = 99;

var Loading =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Loading, _React$Component);

  function Loading() {
    var _this;

    _classCallCheck(this, Loading);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Loading).apply(this, arguments));
    _this.state = {
      progress: 0,
      step: INITIAL_STEP,
      animation: null
    };
    _this.ariaValuenow = debounce(function () {
      var progress = _this.state.progress;
      return Math.floor(progress / 10) * 10;
    }, 15);
    return _this;
  }

  _createClass(Loading, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.increment();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var animation = this.state.animation;

      if (animation != null) {
        cancelAnimationFrame(animation);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var progress = this.state.progress;
      var customStyles = {
        transform: "scaleX(".concat(Math.floor(progress) / 100, ")")
      };
      var ariaValuenow = this.ariaValuenow();
      return React.createElement("div", {
        className: styles$P.Loading
      }, React.createElement("div", {
        className: styles$P.Level,
        style: customStyles,
        "aria-valuenow": ariaValuenow,
        "aria-valuemin": 0,
        "aria-valuemax": 100,
        role: "progressbar"
      }));
    }
  }, {
    key: "increment",
    value: function increment() {
      var _this2 = this;

      var _this$state = this.state,
          progress = _this$state.progress,
          step = _this$state.step;

      if (progress >= STUCK_THRESHOLD) {
        return;
      }

      var animation = requestAnimationFrame(function () {
        return _this2.increment();
      });
      this.setState({
        progress: Math.min(progress + step, 100),
        step: Math.pow(INITIAL_STEP, -(progress / 25)),
        animation: animation
      });
    }
  }]);

  return Loading;
}(React.Component);

// This path comment acts as a unique ID

function generateRedirect(appBridge, url) {
  var target$$1 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'APP';
  var external = arguments.length > 3 ? arguments[3] : undefined;

  if (url == null) {
    return undefined;
  }

  var redirect = actions.Redirect.create(appBridge);
  var payload = external === true ? {
    url: url,
    newContext: true
  } : url;
  return function () {
    redirect.dispatch(redirectAction(target$$1, external), payload);
  };
}

function redirectAction(target$$1, external) {
  if (external === true) {
    return actions.Redirect.Action.REMOTE;
  }

  return actions.Redirect.Action[target$$1];
}

function transformActions(appBridge, _ref) {
  var primaryAction = _ref.primaryAction,
      secondaryActions = _ref.secondaryActions,
      actionGroups = _ref.actionGroups;
  var primary = transformPrimaryAction(appBridge, primaryAction);
  var secondary = [].concat(_toConsumableArray(transformSecondaryActions(appBridge, secondaryActions)), _toConsumableArray(transformActionGroups(appBridge, actionGroups)));
  return {
    primary: primary,
    secondary: secondary
  };
}

function transformAction(appBridge, action) {
  var style = action.destructive === true ? actions.Button.Style.Danger : undefined;
  var button = actions.Button.create(appBridge, {
    label: action.content || '',
    disabled: action.disabled,
    style: style
  });

  if (action.onAction) {
    button.subscribe(actions.Button.Action.CLICK, action.onAction);
  }

  var redirect = generateRedirect(appBridge, action.url, action.target, action.external);

  if (redirect != null) {
    button.subscribe(actions.Button.Action.CLICK, redirect);
  }

  return button;
}

function transformPrimaryAction(appBridge, primaryAction) {
  if (primaryAction == null) {
    return undefined;
  }

  var primary = transformAction(appBridge, primaryAction);
  return primary;
}

function transformSecondaryActions(appBridge) {
  var secondaryActions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

  var secondary = _toConsumableArray(secondaryActions.map(function (secondaryAction) {
    return transformAction(appBridge, secondaryAction);
  }));

  return secondary;
}

function transformActionGroups(appBridge) {
  var actionGroups = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

  var buttonGroups = _toConsumableArray(actionGroups.map(function (group) {
    var buttons = group.actions.map(function (groupAction) {
      return transformAction(appBridge, groupAction);
    });
    return actions.ButtonGroup.create(appBridge, {
      label: group.title,
      buttons: buttons
    });
  }));

  return buttonGroups;
}

function pickValueAndLength(obj, key) {
  var keyPaths = key.split('.');
  var value = obj;
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = keyPaths[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var _key = _step.value;

      if (!value.hasOwnProperty(_key)) {
        return null;
      }

      value = value[_key];
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return != null) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return {
    keyPaths: keyPaths,
    value: value
  };
}

function pick(obj) {
  var _ref;

  for (var _len = arguments.length, keyPaths = new Array(_len > 1 ? _len - 1 : 0), _key2 = 1; _key2 < _len; _key2++) {
    keyPaths[_key2 - 1] = arguments[_key2];
  }

  var flattenedKeypaths = (_ref = []).concat.apply(_ref, keyPaths);

  if (obj == null || flattenedKeypaths.length === 0) return {};
  return flattenedKeypaths.reduce(function (acc, key) {
    if (_typeof(key) !== exports.TypeOf.String || obj.hasOwnProperty(key)) {
      return Object.assign({}, acc, _defineProperty({}, key, obj[key]));
    }

    var pickedValues = pickValueAndLength(obj, key);

    if (pickedValues === null) {
      return acc;
    }

    var keyPaths = pickedValues.keyPaths,
        value = pickedValues.value;
    var len = keyPaths.length;

    var innerObject = _defineProperty({}, keyPaths[--len], value);

    while (len--) {
      innerObject = _defineProperty({}, keyPaths[len], innerObject);
    }

    return Object.assign({}, acc, innerObject);
  }, {});
}

var styles$Q = {
  "Container": "Polaris-Modal-Dialog__Container",
  "Modal": "Polaris-Modal-Dialog__Modal",
  "limitHeight": "Polaris-Modal-Dialog--limitHeight",
  "sizeLarge": "Polaris-Modal-Dialog--sizeLarge",
  "animateFadeUp": "Polaris-Modal-Dialog--animateFadeUp",
  "entering": "Polaris-Modal-Dialog--entering",
  "exiting": "Polaris-Modal-Dialog--exiting",
  "exited": "Polaris-Modal-Dialog--exited",
  "entered": "Polaris-Modal-Dialog--entered",
};

function DialogContainer(props) {
  return React.createElement("div", {
    className: styles$Q.Container,
    "data-polaris-layer": true,
    "data-polaris-overlay": true
  }, props.children);
}

function Dialog(_a) {
  var instant = _a.instant,
      labelledBy = _a.labelledBy,
      children = _a.children,
      onClose = _a.onClose,
      onExited = _a.onExited,
      onEntered = _a.onEntered,
      large = _a.large,
      limitHeight = _a.limitHeight,
      props = tslib_1.__rest(_a, ["instant", "labelledBy", "children", "onClose", "onExited", "onEntered", "large", "limitHeight"]);

  var classes = styles.classNames(styles$Q.Modal, large && styles$Q.sizeLarge, limitHeight && styles$Q.limitHeight);
  var TransitionChild = instant ? reactTransitionGroup.Transition : FadeUp;
  return React.createElement(TransitionChild, Object.assign({}, props, {
    mountOnEnter: true,
    unmountOnExit: true,
    timeout: tokens.durationBase,
    onEntered: onEntered,
    onExited: onExited
  }), React.createElement(DialogContainer, null, React.createElement(TrapFocus, null, React.createElement("div", {
    className: classes,
    role: "dialog",
    "aria-labelledby": labelledBy,
    tabIndex: -1
  }, React.createElement(KeypressListener, {
    keyCode: exports.Key.Escape,
    handler: onClose
  }), children))));
}
var fadeUpClasses = {
  enter: styles.classNames(styles$Q.animateFadeUp, styles$Q.entering),
  enterActive: styles.classNames(styles$Q.animateFadeUp, styles$Q.entered),
  exit: styles.classNames(styles$Q.animateFadeUp, styles$Q.exiting),
  exitActive: styles.classNames(styles$Q.animateFadeUp, styles$Q.exited)
};

function FadeUp(_a) {
  var children = _a.children,
      props = tslib_1.__rest(_a, ["children"]);

  return React.createElement(reactTransitionGroup.CSSTransition, Object.assign({}, props, {
    classNames: fadeUpClasses
  }), children);
}

var styles$R = {
  "Footer": "Polaris-Modal-Footer",
  "FooterContent": "Polaris-Modal-Footer__FooterContent",
};

function Footer(_ref) {
  var primaryAction = _ref.primaryAction,
      secondaryActions = _ref.secondaryActions,
      children = _ref.children;
  var primaryActionButton = primaryAction && buttonsFrom(primaryAction, {
    primary: true
  }) || null;
  var secondaryActionButtons = secondaryActions && buttonsFrom(secondaryActions) || null;
  var actions$$1 = primaryActionButton || secondaryActionButtons ? React.createElement(ButtonGroup, null, secondaryActionButtons, primaryActionButton) : null;
  return React.createElement("div", {
    className: styles$R.Footer
  }, React.createElement("div", {
    className: styles$R.FooterContent
  }, React.createElement(Stack, {
    alignment: "center"
  }, React.createElement(Stack.Item, {
    fill: true
  }, children), actions$$1)));
}

var styles$S = {
  "DisplayText": "Polaris-DisplayText",
  "sizeSmall": "Polaris-DisplayText--sizeSmall",
  "sizeMedium": "Polaris-DisplayText--sizeMedium",
  "sizeLarge": "Polaris-DisplayText--sizeLarge",
  "sizeExtraLarge": "Polaris-DisplayText--sizeExtraLarge",
};

function DisplayText(_ref) {
  var _ref$element = _ref.element,
      Element = _ref$element === void 0 ? 'p' : _ref$element,
      children = _ref.children,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'medium' : _ref$size;
  var className = styles.classNames(styles$S.DisplayText, size && styles$S[styles.variationName('size', size)]);
  return React.createElement(Element, {
    className: className
  }, children);
}

var styles$T = {
  "CloseButton": "Polaris-Modal-CloseButton",
  "withoutTitle": "Polaris-Modal-CloseButton--withoutTitle",
};

function CloseButton(_ref) {
  var _ref$title = _ref.title,
      title = _ref$title === void 0 ? true : _ref$title,
      onClick = _ref.onClick;
  var className = reactUtilities.classNames(styles$T.CloseButton, !title && styles$T.withoutTitle);
  return React.createElement("button", {
    onClick: onClick,
    className: className
  }, React.createElement(Icon$1, {
    source: polarisIcons.MobileCancelMajorMonotone,
    color: "inkLighter"
  }));
}

var styles$U = {
  "Header": "Polaris-Modal-Header",
  "Title": "Polaris-Modal-Header__Title",
};

function Header$1(_ref) {
  var id = _ref.id,
      children = _ref.children,
      onClose = _ref.onClose;
  return React.createElement("div", {
    className: styles$U.Header
  }, React.createElement("div", {
    id: id,
    className: styles$U.Title
  }, React.createElement(DisplayText, {
    element: "h2",
    size: "small"
  }, children)), React.createElement(CloseButton, {
    onClick: onClose
  }));
}

var styles$V = {
  "Section": "Polaris-Modal-Section",
  "subdued": "Polaris-Modal-Section--subdued",
  "flush": "Polaris-Modal-Section--flush",
};

function Section$3(_ref) {
  var children = _ref.children,
      _ref$flush = _ref.flush,
      flush = _ref$flush === void 0 ? false : _ref$flush,
      _ref$subdued = _ref.subdued,
      subdued = _ref$subdued === void 0 ? false : _ref$subdued;
  var className = styles.classNames(styles$V.Section, flush && styles$V.flush, subdued && styles$V.subdued);
  return React.createElement("section", {
    className: className
  }, children);
}

var styles$W = {
  "BodyWrapper": "Polaris-Modal__BodyWrapper",
  "Body": "Polaris-Modal__Body",
  "IFrame": "Polaris-Modal__IFrame",
  "Spinner": "Polaris-Modal__Spinner",
};

var IFRAME_LOADING_HEIGHT = 200;
var getUniqueID$7 = other.createUniqueIDFactory('modal-header');
var APP_BRIDGE_PROPS = ['title', 'size', 'message', 'src', 'primaryAction', 'secondaryActions'];
var Modal =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Modal, _React$Component);

  function Modal() {
    var _this;

    _classCallCheck(this, Modal);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Modal).apply(this, arguments));
    _this.state = {
      iframeHeight: IFRAME_LOADING_HEIGHT
    };
    _this.headerId = getUniqueID$7();

    _this.handleEntered = function () {
      var onTransitionEnd = _this.props.onTransitionEnd;

      if (onTransitionEnd) {
        onTransitionEnd();
      }
    };

    _this.handleExited = function () {
      _this.setState({
        iframeHeight: IFRAME_LOADING_HEIGHT
      });

      if (_this.focusReturnPointNode) {
        fastdom.write(function () {
          return focus.focusFirstFocusableNode(_this.focusReturnPointNode, false);
        });
      }
    };

    _this.handleIFrameLoad = function (evt) {
      var iframe = evt.target;

      if (iframe && iframe.contentWindow) {
        _this.setState({
          iframeHeight: iframe.contentWindow.document.body.scrollHeight
        });
      }

      var onIFrameLoad = _this.props.onIFrameLoad;

      if (onIFrameLoad != null) {
        onIFrameLoad(evt);
      }
    };

    return _this;
  }

  _createClass(Modal, [{
    key: "getChildContext",
    value: function getChildContext() {
      return {
        withinContentContainer: true
      };
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.polaris.appBridge == null) {
        return;
      }

      this.appBridgeModal = actions.Modal.create(this.props.polaris.appBridge, this.transformProps());
      this.appBridgeModal.subscribe(actions.Modal.Action.CLOSE, this.props.onClose);
      var open = this.props.open;

      if (open) {
        this.focusReturnPointNode = document.activeElement;
        this.appBridgeModal.dispatch(actions.Modal.Action.OPEN);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.polaris.appBridge == null || this.appBridgeModal == null) {
        return;
      }

      var open = this.props.open;
      var wasOpen = prevProps.open;
      var transformedProps = this.transformProps();
      var prevAppBridgeProps = pick(prevProps, APP_BRIDGE_PROPS);
      var currentAppBridgeProps = pick(this.props, APP_BRIDGE_PROPS);

      if (!isEqual(prevAppBridgeProps, currentAppBridgeProps)) {
        if (isIframeModal(transformedProps)) {
          this.appBridgeModal.set(transformedProps);
        } else {
          this.appBridgeModal.set(transformedProps);
        }
      }

      if (wasOpen !== open) {
        if (open) {
          this.appBridgeModal.dispatch(actions.Modal.Action.OPEN);
        } else {
          this.appBridgeModal.dispatch(actions.Modal.Action.CLOSE);
        }
      }

      if (!wasOpen && open) {
        this.focusReturnPointNode = document.activeElement;
      } else if (wasOpen && !open && this.focusReturnPointNode != null && document.contains(this.focusReturnPointNode)) {
        this.focusReturnPointNode.focus();
        this.focusReturnPointNode = null;
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.props.polaris.appBridge == null || this.appBridgeModal == null) {
        return;
      }

      this.appBridgeModal.unsubscribe();
    }
  }, {
    key: "render",
    value: function render() {
      if (this.props.polaris.appBridge != null) {
        return null;
      }

      var _this$props = this.props,
          children = _this$props.children,
          title = _this$props.title,
          src = _this$props.src,
          iFrameName = _this$props.iFrameName,
          open = _this$props.open,
          instant = _this$props.instant,
          sectioned = _this$props.sectioned,
          loading = _this$props.loading,
          large = _this$props.large,
          limitHeight = _this$props.limitHeight,
          onClose = _this$props.onClose,
          footer = _this$props.footer,
          primaryAction = _this$props.primaryAction,
          secondaryActions = _this$props.secondaryActions,
          intl = _this$props.polaris.intl,
          onScrolledToBottom = _this$props.onScrolledToBottom;
      var iframeHeight = this.state.iframeHeight;
      var iframeTitle = intl.translate('Polaris.Modal.iFrameTitle');
      var dialog;
      var backdrop;

      if (open) {
        var footerMarkup = !footer && !primaryAction && !secondaryActions ? null : React.createElement(Footer, {
          primaryAction: primaryAction,
          secondaryActions: secondaryActions
        }, footer);
        var content = sectioned ? reactUtilities.wrapWithComponent(children, Section$3) : children;
        var body = loading ? React.createElement("div", {
          className: styles$W.Spinner
        }, React.createElement(Spinner$1, null)) : content;
        var bodyMarkup = src ? React.createElement("iframe", {
          name: iFrameName,
          title: iframeTitle,
          src: src,
          className: styles$W.IFrame,
          onLoad: this.handleIFrameLoad,
          style: {
            height: "".concat(iframeHeight, "px")
          }
        }) : React.createElement(Scrollable$1, {
          shadow: true,
          className: styles$W.Body,
          onScrolledToBottom: onScrolledToBottom
        }, body);
        var headerMarkup = title ? React.createElement(Header$1, {
          id: this.headerId,
          onClose: onClose
        }, title) : React.createElement(CloseButton, {
          onClick: onClose,
          title: false
        });
        dialog = React.createElement(Dialog, {
          instant: instant,
          labelledBy: this.headerId,
          onClose: onClose,
          onEntered: this.handleEntered,
          onExited: this.handleExited,
          large: large,
          limitHeight: limitHeight
        }, headerMarkup, React.createElement("div", {
          className: styles$W.BodyWrapper
        }, bodyMarkup), footerMarkup);
        backdrop = React.createElement(Backdrop, null);
      }

      var animated = !instant;
      return React.createElement(Portal, {
        idPrefix: "modal"
      }, React.createElement(reactTransitionGroup.TransitionGroup, {
        appear: animated,
        enter: animated,
        exit: animated
      }, dialog), backdrop);
    }
  }, {
    key: "transformProps",
    value: function transformProps() {
      var _this$props2 = this.props,
          title = _this$props2.title,
          size = _this$props2.size,
          message = _this$props2.message,
          src = _this$props2.src,
          primaryAction = _this$props2.primaryAction,
          secondaryActions = _this$props2.secondaryActions,
          polaris = _this$props2.polaris;
      var appBridge = polaris.appBridge;
      var safeTitle = typeof title === 'string' ? title : undefined;
      var safeSize = size != null ? actions.Modal.Size[size] : undefined;
      var srcPayload = {};

      if (src != null) {
        if (src.match('^https?://')) {
          srcPayload.url = src;
        } else {
          srcPayload.path = src;
        }
      }

      return Object.assign({
        title: safeTitle,
        message: message,
        size: safeSize
      }, srcPayload, {
        footer: {
          buttons: transformActions(appBridge, {
            primaryAction: primaryAction,
            secondaryActions: secondaryActions
          })
        }
      });
    }
  }]);

  return Modal;
}(React.Component);
Modal.childContextTypes = contentContextTypes;
Modal.Dialog = Dialog;
Modal.Section = Section$3;

function isIframeModal(options) {
  return typeof options.url === 'string' || typeof options.path === 'string';
}

var Modal$1 = withAppProvider()(Modal);

function DiscardConfirmationModal(_ref) {
  var open = _ref.open,
      onDiscard = _ref.onDiscard,
      onCancel = _ref.onCancel,
      intl = _ref.polaris.intl;
  return React.createElement(Modal$1, {
    title: intl.translate('Polaris.DiscardConfirmationModal.title'),
    open: open,
    onClose: onCancel,
    primaryAction: {
      content: intl.translate('Polaris.DiscardConfirmationModal.primaryAction'),
      destructive: true,
      onAction: onDiscard
    },
    secondaryActions: [{
      content: intl.translate('Polaris.DiscardConfirmationModal.secondaryAction'),
      onAction: onCancel
    }],
    sectioned: true
  }, intl.translate('Polaris.DiscardConfirmationModal.message'));
}

var DiscardConfirmationModal$1 = withAppProvider()(DiscardConfirmationModal);

var styles$X = {
  "ContextualSaveBar": "Polaris-Frame-ContextualSaveBar",
  "LogoContainer": "Polaris-Frame-ContextualSaveBar__LogoContainer",
  "Contents": "Polaris-Frame-ContextualSaveBar__Contents",
  "Message": "Polaris-Frame-ContextualSaveBar__Message",
  "Action": "Polaris-Frame-ContextualSaveBar__Action",
};

var ContextualSaveBar =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(ContextualSaveBar, _React$PureComponent);

  function ContextualSaveBar() {
    var _this;

    _classCallCheck(this, ContextualSaveBar);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ContextualSaveBar).apply(this, arguments));
    _this.state = {
      discardConfirmationModalVisible: false
    };

    _this.toggleDiscardConfirmationModal = function () {
      _this.setState(function (prevState) {
        return {
          discardConfirmationModalVisible: !prevState.discardConfirmationModalVisible
        };
      });
    };

    return _this;
  }

  _createClass(ContextualSaveBar, [{
    key: "render",
    value: function render() {
      var discardConfirmationModalVisible = this.state.discardConfirmationModalVisible;
      var _this$props = this.props,
          alignContentFlush = _this$props.alignContentFlush,
          message = _this$props.message,
          discardAction = _this$props.discardAction,
          saveAction = _this$props.saveAction,
          _this$props$polaris = _this$props.polaris,
          logo = _this$props$polaris.theme.logo,
          intl = _this$props$polaris.intl;
      var discardActionContent = discardAction && discardAction.content ? discardAction.content : intl.translate('Polaris.ContextualSaveBar.discard');
      var discardActionHandler;

      if (discardAction && discardAction.discardConfirmationModal) {
        discardActionHandler = this.toggleDiscardConfirmationModal;
      } else if (discardAction) {
        discardActionHandler = discardAction.onAction;
      }

      var discardConfirmationModalMarkup = discardAction && discardAction.onAction && discardAction.discardConfirmationModal && React.createElement(DiscardConfirmationModal$1, {
        open: discardConfirmationModalVisible,
        onCancel: this.toggleDiscardConfirmationModal,
        onDiscard: discardAction.onAction
      });
      var discardActionMarkup = discardAction && React.createElement(Button$1, {
        url: discardAction.url,
        onClick: discardActionHandler,
        loading: discardAction.loading,
        disabled: discardAction.disabled,
        accessibilityLabel: discardAction.content
      }, discardActionContent);
      var saveActionContent = saveAction && saveAction.content ? saveAction.content : intl.translate('Polaris.ContextualSaveBar.save');
      var saveActionMarkup = saveAction && React.createElement(Button$1, {
        primary: true,
        url: saveAction.url,
        onClick: saveAction.onAction,
        loading: saveAction.loading,
        disabled: saveAction.disabled,
        accessibilityLabel: saveAction.content
      }, saveActionContent);
      var width = getWidth(logo, 104);
      var imageMarkup = logo && React.createElement(Image, {
        style: {
          width: width
        },
        source: logo.contextualSaveBarSource || '',
        alt: ""
      });
      var logoMarkup = alignContentFlush ? null : React.createElement("div", {
        className: styles$X.LogoContainer,
        style: {
          width: width
        }
      }, imageMarkup);
      return React.createElement(React.Fragment, null, React.createElement("div", {
        className: styles$X.ContextualSaveBar
      }, logoMarkup, React.createElement("div", {
        className: styles$X.Contents
      }, React.createElement("h2", {
        className: styles$X.Message
      }, message), React.createElement(Stack, {
        spacing: "tight",
        wrap: false
      }, discardActionMarkup, saveActionMarkup))), discardConfirmationModalMarkup);
    }
  }]);

  return ContextualSaveBar;
}(React.PureComponent);

var ContextualSaveBar$1 = withAppProvider()(ContextualSaveBar);

var styles$Y = {
  "Frame": "Polaris-Frame",
  "Navigation": "Polaris-Frame__Navigation",
  "Navigation-enter": "Polaris-Frame__Navigation--enter",
  "Navigation-enterActive": "Polaris-Frame__Navigation--enterActive",
  "Navigation-exit": "Polaris-Frame__Navigation--exit",
  "Navigation-exitActive": "Polaris-Frame__Navigation--exitActive",
  "NavigationDismiss": "Polaris-Frame__NavigationDismiss",
  "Navigation-visible": "Polaris-Frame__Navigation--visible",
  "TopBar": "Polaris-Frame__TopBar",
  "ContextualSaveBar": "Polaris-Frame__ContextualSaveBar",
  "ContextualSaveBar-enter": "Polaris-Frame__ContextualSaveBar--enter",
  "ContextualSaveBar-enterActive": "Polaris-Frame__ContextualSaveBar--enterActive",
  "ContextualSaveBar-exit": "Polaris-Frame__ContextualSaveBar--exit",
  "ContextualSaveBar-exitActive": "Polaris-Frame__ContextualSaveBar--exitActive",
  "Main": "Polaris-Frame__Main",
  "hasNav": "Polaris-Frame--hasNav",
  "hasTopBar": "Polaris-Frame--hasTopBar",
  "Content": "Polaris-Frame__Content",
  "GlobalRibbonContainer": "Polaris-Frame__GlobalRibbonContainer",
  "LoadingBar": "Polaris-Frame__LoadingBar",
  "Skip": "Polaris-Frame__Skip",
  "focused": "Polaris-Frame--focused",
};

var GLOBAL_RIBBON_CUSTOM_PROPERTY = '--global-ribbon-height';
var APP_FRAME_MAIN = 'AppFrameMain';
var APP_FRAME_NAV = 'AppFrameNav';
var APP_FRAME_TOP_BAR = 'AppFrameTopBar';
var APP_FRAME_LOADING_BAR = 'AppFrameLoadingBar';
var Frame =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Frame, _React$PureComponent);

  function Frame() {
    var _this;

    _classCallCheck(this, Frame);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Frame).apply(this, arguments));
    _this.state = {
      skipFocused: false,
      globalRibbonHeight: 0,
      loadingStack: 0,
      toastMessages: [],
      mobileView: isMobileView(),
      showContextualSaveBar: false
    };
    _this.globalRibbonContainer = null;

    _this.setGlobalRibbonHeight = function () {
      var _assertThisInitialize = _assertThisInitialized(_assertThisInitialized(_this)),
          globalRibbonContainer = _assertThisInitialize.globalRibbonContainer;

      if (globalRibbonContainer) {
        _this.setState({
          globalRibbonHeight: globalRibbonContainer.offsetHeight
        }, _this.setGlobalRibbonRootProperty);
      }
    };

    _this.setGlobalRibbonRootProperty = function () {
      var globalRibbonHeight = _this.state.globalRibbonHeight;
      setRootProperty(GLOBAL_RIBBON_CUSTOM_PROPERTY, "".concat(globalRibbonHeight, "px"), null);
    };

    _this.showToast = function (toast) {
      _this.setState(function (_ref) {
        var toastMessages = _ref.toastMessages;
        var hasToastById = toastMessages.find(function (_ref2) {
          var id = _ref2.id;
          return id === toast.id;
        }) != null;
        return {
          toastMessages: hasToastById ? toastMessages : [].concat(_toConsumableArray(toastMessages), [toast])
        };
      });
    };

    _this.hideToast = function (_ref3) {
      var id = _ref3.id;

      _this.setState(function (_ref4) {
        var toastMessages = _ref4.toastMessages;
        return {
          toastMessages: toastMessages.filter(function (_ref5) {
            var toastId = _ref5.id;
            return id !== toastId;
          })
        };
      });
    };

    _this.setContextualSaveBar = function (props) {
      var showContextualSaveBar = _this.state.showContextualSaveBar;
      _this.contextualSaveBar = Object.assign({}, props);

      if (showContextualSaveBar === true) {
        _this.forceUpdate();
      } else {
        _this.setState({
          showContextualSaveBar: true
        });
      }
    };

    _this.removeContextualSaveBar = function () {
      _this.contextualSaveBar = null;

      _this.setState({
        showContextualSaveBar: false
      });
    };

    _this.startLoading = function () {
      _this.setState(function (_ref6) {
        var loadingStack = _ref6.loadingStack;
        return {
          loadingStack: loadingStack + 1
        };
      });
    };

    _this.stopLoading = function () {
      _this.setState(function (_ref7) {
        var loadingStack = _ref7.loadingStack;
        return {
          loadingStack: Math.max(0, loadingStack - 1)
        };
      });
    };

    _this.handleResize = function () {
      var mobileView = _this.state.mobileView;

      if (isMobileView() && !mobileView) {
        _this.setState({
          mobileView: true
        });
      } else if (!isMobileView() && mobileView) {
        _this.setState({
          mobileView: false
        });
      }

      if (_this.props.globalRibbon) {
        _this.setGlobalRibbonHeight();
      }
    };

    _this.handleClick = function () {
      focusAppFrameMain();
    };

    _this.handleFocus = function () {
      _this.setState({
        skipFocused: true
      });
    };

    _this.handleBlur = function () {
      _this.setState({
        skipFocused: false
      });
    };

    _this.handleNavigationDismiss = function () {
      var onNavigationDismiss = _this.props.onNavigationDismiss;

      if (onNavigationDismiss != null) {
        onNavigationDismiss();
      }
    };

    _this.setGlobalRibbonContainer = function (node) {
      _this.globalRibbonContainer = node;
    };

    _this.handleNavKeydown = function (event) {
      var key = event.key;

      if (key === 'Escape') {
        _this.handleNavigationDismiss();
      }
    };

    return _this;
  }

  _createClass(Frame, [{
    key: "getChildContext",
    value: function getChildContext() {
      return {
        frame: {
          showToast: this.showToast,
          hideToast: this.hideToast,
          startLoading: this.startLoading,
          stopLoading: this.stopLoading,
          setContextualSaveBar: this.setContextualSaveBar,
          removeContextualSaveBar: this.removeContextualSaveBar
        }
      };
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.handleResize();

      if (this.props.globalRibbon) {
        return;
      }

      this.setGlobalRibbonRootProperty();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.globalRibbon !== prevProps.globalRibbon) {
        this.setGlobalRibbonHeight();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state = this.state,
          skipFocused = _this$state.skipFocused,
          loadingStack = _this$state.loadingStack,
          toastMessages = _this$state.toastMessages,
          showContextualSaveBar = _this$state.showContextualSaveBar,
          mobileView = _this$state.mobileView;
      var _this$props = this.props,
          children = _this$props.children,
          navigation = _this$props.navigation,
          topBar = _this$props.topBar,
          globalRibbon = _this$props.globalRibbon,
          _this$props$showMobil = _this$props.showMobileNavigation,
          showMobileNavigation = _this$props$showMobil === void 0 ? false : _this$props$showMobil,
          intl = _this$props.polaris.intl;
      var navClassName = styles.classNames(styles$Y.Navigation, showMobileNavigation && styles$Y['Navigation-visible']);
      var mobileNavHidden = mobileView && !showMobileNavigation;
      var mobileNavShowing = mobileView && showMobileNavigation;
      var tabIndex = mobileNavShowing ? 0 : -1;
      var navigationMarkup = navigation ? React.createElement(TrapFocus, {
        trapping: mobileNavShowing
      }, React.createElement(reactTransitionGroup.CSSTransition, {
        appear: mobileView,
        exit: mobileView,
        in: showMobileNavigation,
        timeout: tokens.durationSlow,
        classNames: navTransitionClasses
      }, React.createElement("div", {
        className: navClassName,
        onKeyDown: this.handleNavKeydown,
        id: APP_FRAME_NAV,
        key: "NavContent",
        hidden: mobileNavHidden
      }, navigation, React.createElement("button", {
        type: "button",
        className: styles$Y.NavigationDismiss,
        onClick: this.handleNavigationDismiss,
        "aria-hidden": mobileNavHidden || !mobileView && !showMobileNavigation,
        "aria-label": intl.translate('Polaris.Frame.Navigation.closeMobileNavigationLabel'),
        tabIndex: tabIndex
      }, React.createElement(Icon$1, {
        source: polarisIcons.MobileCancelMajorMonotone,
        color: "white"
      }))))) : null;
      var loadingMarkup = loadingStack > 0 ? React.createElement("div", {
        className: styles$Y.LoadingBar,
        id: APP_FRAME_LOADING_BAR
      }, React.createElement(Loading, null)) : null;
      var contextualSaveBarMarkup = React.createElement(reactTransitionGroup.CSSTransition, {
        appear: true,
        exit: true,
        in: showContextualSaveBar,
        timeout: 300,
        classNames: contextualSaveBarTransitionClasses,
        mountOnEnter: true,
        unmountOnExit: true
      }, React.createElement("div", {
        className: styles$Y.ContextualSaveBar
      }, React.createElement(ContextualSaveBar$1, this.contextualSaveBar)));
      var topBarMarkup = topBar ? React.createElement("div", Object.assign({
        className: styles$Y.TopBar
      }, layer.props, dataPolarisTopBar.props, {
        id: APP_FRAME_TOP_BAR
      }), topBar) : null;
      var globalRibbonMarkup = globalRibbon ? React.createElement("div", {
        className: styles$Y.GlobalRibbonContainer,
        ref: this.setGlobalRibbonContainer
      }, globalRibbon) : null;
      var skipClassName = styles.classNames(styles$Y.Skip, skipFocused && styles$Y.focused);
      var skipMarkup = React.createElement("div", {
        className: skipClassName
      }, React.createElement(Button$1, {
        onClick: this.handleClick,
        onFocus: this.handleFocus,
        onBlur: this.handleBlur
      }, intl.translate('Polaris.Frame.skipToContent')));
      var navigationAttributes = navigation ? {
        'data-has-navigation': true
      } : {};
      var frameClassName = styles.classNames(styles$Y.Frame, navigation && styles$Y.hasNav, topBar && styles$Y.hasTopBar);
      var navigationOverlayMarkup = showMobileNavigation && mobileView ? React.createElement(Backdrop, {
        belowNavigation: true,
        onClick: this.handleNavigationDismiss,
        onTouchStart: this.handleNavigationDismiss
      }) : null;
      return React.createElement("div", Object.assign({
        className: frameClassName
      }, layer.props, navigationAttributes), skipMarkup, React.createElement(Provider$1, {
        mobileView: mobileView || false
      }, topBarMarkup, navigationMarkup), contextualSaveBarMarkup, loadingMarkup, navigationOverlayMarkup, React.createElement("main", {
        className: styles$Y.Main,
        id: APP_FRAME_MAIN,
        "data-has-global-ribbon": Boolean(globalRibbon)
      }, React.createElement("div", {
        className: styles$Y.Content
      }, children)), React.createElement(ToastManager, {
        toastMessages: toastMessages
      }), globalRibbonMarkup, React.createElement(EventListener, {
        event: "resize",
        handler: this.handleResize
      }));
    }
  }]);

  return Frame;
}(React.PureComponent);
Frame.childContextTypes = frameContextTypes;
var navTransitionClasses = {
  enter: styles.classNames(styles$Y['Navigation-enter']),
  enterActive: styles.classNames(styles$Y['Navigation-enterActive']),
  enterDone: styles.classNames(styles$Y['Navigation-enterActive']),
  exit: styles.classNames(styles$Y['Navigation-exit']),
  exitActive: styles.classNames(styles$Y['Navigation-exitActive'])
};
var contextualSaveBarTransitionClasses = {
  enter: styles.classNames(styles$Y['ContextualSaveBar-enter']),
  enterActive: styles.classNames(styles$Y['ContextualSaveBar-enterActive']),
  enterDone: styles.classNames(styles$Y['ContextualSaveBar-enterActive']),
  exit: styles.classNames(styles$Y['ContextualSaveBar-exit']),
  exitActive: styles.classNames(styles$Y['ContextualSaveBar-exitActive'])
};

function focusAppFrameMain() {
  window.location.assign("".concat(window.location.pathname, "#").concat(APP_FRAME_MAIN));
}

function isMobileView() {
  return navigationBarCollapsed().matches;
}

var Frame$1 = withAppProvider()(Frame);

var ContextualSaveBar$2 =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(ContextualSaveBar, _React$PureComponent);

  function ContextualSaveBar() {
    _classCallCheck(this, ContextualSaveBar);

    return _possibleConstructorReturn(this, _getPrototypeOf(ContextualSaveBar).apply(this, arguments));
  }

  _createClass(ContextualSaveBar, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.context.frame.setContextualSaveBar(this.props);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.context.frame.removeContextualSaveBar();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(oldProps) {
      if (contextualSaveBarHasChanged(this.props, oldProps)) {
        this.context.frame.setContextualSaveBar(this.props);
      }
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);

  return ContextualSaveBar;
}(React.PureComponent);

ContextualSaveBar$2.contextTypes = frameContextTypes;

function contextualSaveBarHasChanged(_ref, _ref2) {
  var message = _ref.message,
      saveAction = _ref.saveAction,
      discardAction = _ref.discardAction;
  var oldMessage = _ref2.message,
      oldsaveAction = _ref2.saveAction,
      oldDiscardAction = _ref2.discardAction;
  return Boolean(message !== oldMessage || !isEqual(saveAction, oldsaveAction) || !isEqual(discardAction, oldDiscardAction));
}

var styles$Z = {
  "DataTable": "Polaris-DataTable",
  "collapsed": "Polaris-DataTable--collapsed",
  "Table": "Polaris-DataTable__Table",
  "Navigation": "Polaris-DataTable__Navigation",
  "ScrollContainer": "Polaris-DataTable__ScrollContainer",
  "hasFooter": "Polaris-DataTable--hasFooter",
  "Pip": "Polaris-DataTable__Pip",
  "Pip-visible": "Polaris-DataTable__Pip--visible",
  "TableRow": "Polaris-DataTable__TableRow",
  "Cell": "Polaris-DataTable__Cell",
  "TableFoot": "Polaris-DataTable__TableFoot",
  "Cell-numeric": "Polaris-DataTable__Cell--numeric",
  "Cell-fixed": "Polaris-DataTable__Cell--fixed",
  "Cell-truncated": "Polaris-DataTable__Cell--truncated",
  "Cell-header": "Polaris-DataTable__Cell--header",
  "Cell-sortable": "Polaris-DataTable__Cell--sortable",
  "Icon": "Polaris-DataTable__Icon",
  "Heading": "Polaris-DataTable__Heading",
  "Heading-left": "Polaris-DataTable__Heading--left",
  "Cell-sorted": "Polaris-DataTable__Cell--sorted",
  "Cell-total": "Polaris-DataTable__Cell--total",
  "Cell-footer": "Polaris-DataTable__Cell--footer",
};

function Cell(_ref) {
  var height = _ref.height,
      content = _ref.content,
      contentType = _ref.contentType,
      fixed = _ref.fixed,
      truncate = _ref.truncate,
      header = _ref.header,
      total = _ref.total,
      footer = _ref.footer,
      sorted = _ref.sorted,
      sortable = _ref.sortable,
      sortDirection = _ref.sortDirection,
      defaultSortDirection = _ref.defaultSortDirection,
      translate$$1 = _ref.polaris.intl.translate,
      onSort = _ref.onSort;
  var numeric = contentType === 'numeric';
  var className = styles.classNames(styles$Z.Cell, fixed && styles$Z['Cell-fixed'], fixed && truncate && styles$Z['Cell-truncated'], header && styles$Z['Cell-header'], total && styles$Z['Cell-total'], footer && styles$Z['Cell-footer'], numeric && styles$Z['Cell-numeric'], sortable && styles$Z['Cell-sortable'], sorted && styles$Z['Cell-sorted']);
  var headerClassName = styles.classNames(header && styles$Z.Heading, header && contentType === 'text' && styles$Z['Heading-left']);
  var iconClassName = styles.classNames(sortable && styles$Z.Icon);
  var style = {
    height: height ? "".concat(height, "px") : undefined
  };
  var direction = sorted ? sortDirection : defaultSortDirection;
  var source = direction === 'ascending' ? polarisIcons.CaretUpMinor : polarisIcons.CaretDownMinor;
  var oppositeDirection = sortDirection === 'ascending' ? 'descending' : 'ascending';
  var sortAccessibilityLabel = translate$$1('Polaris.DataTable.sortAccessibilityLabel', {
    direction: sorted ? oppositeDirection : direction
  });
  var iconMarkup = React.createElement("span", {
    className: iconClassName
  }, React.createElement(Icon$1, {
    source: source,
    accessibilityLabel: sortAccessibilityLabel
  }));
  var sortableHeadingContent = React.createElement("button", {
    className: headerClassName,
    onClick: onSort
  }, iconMarkup, content);
  var columnHeadingContent = sortable ? sortableHeadingContent : content;
  var headingMarkup = header ? React.createElement("th", Object.assign({}, headerCell.props, {
    className: className,
    scope: "col",
    "aria-sort": sortDirection,
    style: style
  }), columnHeadingContent) : React.createElement("th", {
    className: className,
    scope: "row",
    style: style
  }, content);
  var cellMarkup = header || fixed ? headingMarkup : React.createElement("td", {
    className: className,
    style: style
  }, content);
  return cellMarkup;
}

var Cell$1 = withAppProvider()(Cell);

function Navigation(_ref) {
  var columnVisibilityData = _ref.columnVisibilityData,
      isScrolledFarthestLeft = _ref.isScrolledFarthestLeft,
      isScrolledFarthestRight = _ref.isScrolledFarthestRight,
      navigateTableLeft = _ref.navigateTableLeft,
      navigateTableRight = _ref.navigateTableRight,
      translate$$1 = _ref.polaris.intl.translate;
  var pipMarkup = columnVisibilityData.map(function (column, index) {
    var className = styles.classNames(styles$Z.Pip, column.isVisible && styles$Z['Pip-visible']);
    return React.createElement("div", {
      className: className,
      key: "pip-".concat(index)
    });
  });
  var leftA11yLabel = translate$$1('Polaris.DataTable.navAccessibilityLabel', {
    direction: 'left'
  });
  var rightA11yLabel = translate$$1('Polaris.DataTable.navAccessibilityLabel', {
    direction: 'right'
  });
  return React.createElement("div", {
    className: styles$Z.Navigation
  }, React.createElement(Button$1, {
    plain: true,
    icon: polarisIcons.ChevronLeftMinor,
    disabled: isScrolledFarthestLeft,
    accessibilityLabel: leftA11yLabel,
    onClick: navigateTableLeft
  }), pipMarkup, React.createElement(Button$1, {
    plain: true,
    icon: polarisIcons.ChevronRightMinor,
    disabled: isScrolledFarthestRight,
    accessibilityLabel: rightA11yLabel,
    onClick: navigateTableRight
  }));
}

var Navigation$1 = withAppProvider()(Navigation);

function measureColumn(tableData) {
  return function (column, index) {
    var firstVisibleColumnIndex = tableData.firstVisibleColumnIndex,
        tableStart = tableData.tableLeftVisibleEdge,
        tableEnd = tableData.tableRightVisibleEdge,
        fixedColumnWidth = tableData.fixedColumnWidth;
    var leftEdge = column.offsetLeft + fixedColumnWidth;
    var rightEdge = leftEdge + column.offsetWidth;
    var isVisibleLeft = isEdgeVisible(leftEdge, tableStart, tableEnd);
    var isVisibleRight = isEdgeVisible(rightEdge, tableStart, tableEnd);
    var isVisible = isVisibleLeft || isVisibleRight;

    if (isVisible) {
      tableData.firstVisibleColumnIndex = Math.min(firstVisibleColumnIndex, index);
    }

    return {
      leftEdge: leftEdge,
      rightEdge: rightEdge,
      isVisible: isVisible
    };
  };
}
function isEdgeVisible(position, start, end) {
  var minVisiblePixels = 30;
  return position >= start + minVisiblePixels && position <= end - minVisiblePixels;
}
function getPrevAndCurrentColumns(tableData, columnData) {
  var firstVisibleColumnIndex = tableData.firstVisibleColumnIndex;
  var previousColumnIndex = Math.max(firstVisibleColumnIndex - 1, 0);
  var previousColumn = columnData[previousColumnIndex];
  var currentColumn = columnData[firstVisibleColumnIndex];
  return {
    previousColumn: previousColumn,
    currentColumn: currentColumn
  };
}

var DataTable =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(DataTable, _React$PureComponent);

  function DataTable(props) {
    var _this;

    _classCallCheck(this, DataTable);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DataTable).call(this, props));
    _this.state = {
      collapsed: false,
      columnVisibilityData: [],
      heights: [],
      preservedScrollPosition: {},
      isScrolledFarthestLeft: true,
      isScrolledFarthestRight: false
    };
    _this.dataTable = React.createRef();
    _this.scrollContainer = React.createRef();
    _this.table = React.createRef();
    _this.handleResize = debounce(function () {
      var _this$props = _this.props,
          footerContent = _this$props.footerContent,
          truncate = _this$props.truncate;

      var _assertThisInitialize = _assertThisInitialized(_assertThisInitialized(_this)),
          table = _assertThisInitialize.table.current,
          scrollContainer = _assertThisInitialize.scrollContainer.current;

      var collapsed = false;

      if (table && scrollContainer) {
        collapsed = table.scrollWidth > scrollContainer.clientWidth;
        scrollContainer.scrollLeft = 0;
      }

      _this.setState(Object.assign({
        collapsed: collapsed,
        heights: []
      }, _this.calculateColumnVisibilityData(collapsed)), function () {
        if (footerContent || !truncate) {
          _this.setHeightsAndScrollPosition();
        }
      });
    });

    _this.tallestCellHeights = function () {
      var _this$props2 = _this.props,
          footerContent = _this$props2.footerContent,
          truncate = _this$props2.truncate;

      var _assertThisInitialize2 = _assertThisInitialized(_assertThisInitialized(_this)),
          table = _assertThisInitialize2.table.current;

      var heights = _this.state.heights;

      if (table) {
        var rows = Array.from(table.getElementsByTagName('tr'));

        if (!truncate) {
          return heights = rows.map(function (row) {
            var fixedCell = row.childNodes[0];
            return Math.max(row.clientHeight, fixedCell.clientHeight);
          });
        }

        if (footerContent) {
          var footerCellHeight = rows[rows.length - 1].childNodes[0].clientHeight;
          heights = [footerCellHeight];
        }
      }

      return heights;
    };

    _this.resetScrollPosition = function () {
      var _assertThisInitialize3 = _assertThisInitialized(_assertThisInitialized(_this)),
          scrollContainer = _assertThisInitialize3.scrollContainer.current;

      if (scrollContainer) {
        var _this$state$preserved = _this.state.preservedScrollPosition,
            left = _this$state$preserved.left,
            top = _this$state$preserved.top;

        if (left) {
          scrollContainer.scrollLeft = left;
        }

        if (top) {
          window.scrollTo(0, top);
        }
      }
    };

    _this.setHeightsAndScrollPosition = function () {
      _this.setState({
        heights: _this.tallestCellHeights()
      }, _this.resetScrollPosition);
    };

    _this.calculateColumnVisibilityData = function (collapsed) {
      var _assertThisInitialize4 = _assertThisInitialized(_assertThisInitialized(_this)),
          table = _assertThisInitialize4.table.current,
          scrollContainer = _assertThisInitialize4.scrollContainer.current,
          dataTable = _assertThisInitialize4.dataTable.current;

      if (collapsed && table && scrollContainer && dataTable) {
        var headerCells = table.querySelectorAll(headerCell.selector);
        var collapsedHeaderCells = Array.from(headerCells).slice(1);
        var fixedColumnWidth = headerCells[0].offsetWidth;
        var firstVisibleColumnIndex = collapsedHeaderCells.length - 1;
        var tableLeftVisibleEdge = scrollContainer.scrollLeft + fixedColumnWidth;
        var tableRightVisibleEdge = scrollContainer.scrollLeft + dataTable.offsetWidth;
        var tableData = {
          fixedColumnWidth: fixedColumnWidth,
          firstVisibleColumnIndex: firstVisibleColumnIndex,
          tableLeftVisibleEdge: tableLeftVisibleEdge,
          tableRightVisibleEdge: tableRightVisibleEdge
        };
        var columnVisibilityData = collapsedHeaderCells.map(measureColumn(tableData));
        var lastColumn = columnVisibilityData[columnVisibilityData.length - 1];
        return Object.assign({
          fixedColumnWidth: fixedColumnWidth,
          columnVisibilityData: columnVisibilityData
        }, getPrevAndCurrentColumns(tableData, columnVisibilityData), {
          isScrolledFarthestLeft: tableLeftVisibleEdge === fixedColumnWidth,
          isScrolledFarthestRight: lastColumn.rightEdge <= tableRightVisibleEdge
        });
      }

      return {
        columnVisibilityData: [],
        previousColumn: undefined,
        currentColumn: undefined
      };
    };

    _this.scrollListener = function () {
      _this.setState(function (prevState) {
        return Object.assign({}, _this.calculateColumnVisibilityData(prevState.collapsed));
      });
    };

    _this.navigateTable = function (direction) {
      var _this$state = _this.state,
          currentColumn = _this$state.currentColumn,
          previousColumn = _this$state.previousColumn,
          fixedColumnWidth = _this$state.fixedColumnWidth;

      var _assertThisInitialize5 = _assertThisInitialized(_assertThisInitialized(_this)),
          scrollContainer = _assertThisInitialize5.scrollContainer.current;

      var handleScroll = function handleScroll() {
        if (!currentColumn || !previousColumn || !fixedColumnWidth) {
          return;
        }

        if (scrollContainer) {
          scrollContainer.scrollLeft = direction === 'right' ? currentColumn.rightEdge - fixedColumnWidth : previousColumn.leftEdge - fixedColumnWidth;
          requestAnimationFrame(function () {
            _this.setState(function (prevState) {
              return Object.assign({}, _this.calculateColumnVisibilityData(prevState.collapsed));
            });
          });
        }
      };

      return handleScroll;
    };

    _this.renderTotals = function (total, index) {
      var id = "totals-cell-".concat(index);
      var heights = _this.state.heights;
      var _this$props$truncate = _this.props.truncate,
          truncate = _this$props$truncate === void 0 ? false : _this$props$truncate;
      var content;
      var contentType;

      if (index === 0) {
        content = _this.totalsRowHeading;
      }

      if (total !== '' && index > 0) {
        contentType = 'numeric';
        content = total;
      }

      return React.createElement(Cell$1, {
        total: true,
        fixed: index === 0,
        key: id,
        height: heights[1],
        content: content,
        contentType: contentType,
        truncate: truncate
      });
    };

    _this.defaultRenderRow = function (row, index) {
      var className = styles.classNames(styles$Z.TableRow);
      var _this$props3 = _this.props,
          columnContentTypes = _this$props3.columnContentTypes,
          totals = _this$props3.totals,
          footerContent = _this$props3.footerContent,
          _this$props3$truncate = _this$props3.truncate,
          truncate = _this$props3$truncate === void 0 ? false : _this$props3$truncate;
      var heights = _this.state.heights;
      var bodyCellHeights = totals ? heights.slice(2) : heights.slice(1);

      if (footerContent) {
        bodyCellHeights.pop();
      }

      return React.createElement("tr", {
        key: "row-".concat(index),
        className: className
      }, row.map(function (content, cellIndex) {
        var id = "cell-".concat(cellIndex, "-row-").concat(index);
        return React.createElement(Cell$1, {
          key: id,
          height: bodyCellHeights[index],
          content: content,
          contentType: columnContentTypes[cellIndex],
          fixed: cellIndex === 0,
          truncate: truncate
        });
      }));
    };

    _this.renderFooter = function () {
      var heights = _this.state.heights;
      var footerCellHeight = heights[heights.length - 1];
      return React.createElement(Cell$1, {
        footer: true,
        height: footerCellHeight,
        content: _this.props.footerContent,
        truncate: _this.props.truncate
      });
    };

    _this.defaultOnSort = function (headingIndex) {
      var _this$props4 = _this.props,
          onSort = _this$props4.onSort,
          truncate = _this$props4.truncate,
          _this$props4$defaultS = _this$props4.defaultSortDirection,
          defaultSortDirection = _this$props4$defaultS === void 0 ? 'ascending' : _this$props4$defaultS,
          initialSortColumnIndex = _this$props4.initialSortColumnIndex;
      var _this$state2 = _this.state,
          _this$state2$sortDire = _this$state2.sortDirection,
          sortDirection = _this$state2$sortDire === void 0 ? defaultSortDirection : _this$state2$sortDire,
          _this$state2$sortedCo = _this$state2.sortedColumnIndex,
          sortedColumnIndex = _this$state2$sortedCo === void 0 ? initialSortColumnIndex : _this$state2$sortedCo;
      var newSortDirection = defaultSortDirection;

      if (sortedColumnIndex === headingIndex) {
        newSortDirection = sortDirection === 'ascending' ? 'descending' : 'ascending';
      }

      var handleSort = function handleSort() {
        _this.setState({
          sortDirection: newSortDirection,
          sortedColumnIndex: headingIndex
        }, function () {
          if (onSort) {
            onSort(headingIndex, newSortDirection);

            if (!truncate && _this.scrollContainer.current) {
              var preservedScrollPosition = {
                left: _this.scrollContainer.current.scrollLeft,
                top: window.scrollY
              };

              _this.setState({
                preservedScrollPosition: preservedScrollPosition
              });

              _this.handleResize();
            }
          }
        });
      };

      return handleSort;
    };

    var translate$$1 = props.polaris.intl.translate;
    _this.totalsRowHeading = translate$$1('Polaris.DataTable.totalsRowHeading');
    return _this;
  }

  _createClass(DataTable, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      // We need to defer the calculation in development so the styles have time to be injected.
      if (process.env.NODE_ENV === 'development') {
        setTimeout(function () {
          _this2.handleResize();
        }, 10);
      } else {
        this.handleResize();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (isEqual(prevProps, this.props)) {
        return;
      }

      this.handleResize();
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _this$props5 = this.props,
          columnContentTypes = _this$props5.columnContentTypes,
          headings = _this$props5.headings,
          totals = _this$props5.totals,
          rows = _this$props5.rows,
          truncate = _this$props5.truncate,
          footerContent = _this$props5.footerContent,
          sortable = _this$props5.sortable,
          _this$props5$defaultS = _this$props5.defaultSortDirection,
          defaultSortDirection = _this$props5$defaultS === void 0 ? 'ascending' : _this$props5$defaultS,
          _this$props5$initialS = _this$props5.initialSortColumnIndex,
          initialSortColumnIndex = _this$props5$initialS === void 0 ? 0 : _this$props5$initialS;
      var _this$state3 = this.state,
          collapsed = _this$state3.collapsed,
          columnVisibilityData = _this$state3.columnVisibilityData,
          heights = _this$state3.heights,
          _this$state3$sortedCo = _this$state3.sortedColumnIndex,
          sortedColumnIndex = _this$state3$sortedCo === void 0 ? initialSortColumnIndex : _this$state3$sortedCo,
          _this$state3$sortDire = _this$state3.sortDirection,
          sortDirection = _this$state3$sortDire === void 0 ? defaultSortDirection : _this$state3$sortDire,
          isScrolledFarthestLeft = _this$state3.isScrolledFarthestLeft,
          isScrolledFarthestRight = _this$state3.isScrolledFarthestRight;
      var className = styles.classNames(styles$Z.DataTable, collapsed && styles$Z.collapsed, footerContent && styles$Z.hasFooter);
      var wrapperClassName = styles.classNames(styles$Z.TableWrapper, collapsed && styles$Z.collapsed);
      var footerClassName = styles.classNames(footerContent && styles$Z.TableFoot);
      var footerMarkup = footerContent ? React.createElement("tfoot", {
        className: footerClassName
      }, React.createElement("tr", null, this.renderFooter())) : null;
      var totalsMarkup = totals ? React.createElement("tr", null, totals.map(this.renderTotals)) : null;
      var headingMarkup = React.createElement("tr", null, headings.map(function (heading, headingIndex) {
        var sortableHeadingProps;
        var id = "heading-cell-".concat(headingIndex);

        if (sortable) {
          var isSortable = sortable[headingIndex];
          var isSorted = sortedColumnIndex === headingIndex;
          var direction = isSorted ? sortDirection : 'none';
          sortableHeadingProps = {
            defaultSortDirection: defaultSortDirection,
            sorted: isSorted,
            sortable: isSortable,
            sortDirection: direction,
            onSort: _this3.defaultOnSort(headingIndex)
          };
        }

        var height = !truncate ? heights[0] : undefined;
        return React.createElement(Cell$1, Object.assign({
          header: true,
          key: id,
          height: height,
          content: heading,
          contentType: columnContentTypes[headingIndex],
          fixed: headingIndex === 0,
          truncate: truncate
        }, sortableHeadingProps));
      }));
      var bodyMarkup = rows.map(this.defaultRenderRow);
      var style = footerContent ? {
        marginBottom: "".concat(heights[heights.length - 1], "px")
      } : undefined;
      return React.createElement("div", {
        className: wrapperClassName
      }, React.createElement(Navigation$1, {
        columnVisibilityData: columnVisibilityData,
        isScrolledFarthestLeft: isScrolledFarthestLeft,
        isScrolledFarthestRight: isScrolledFarthestRight,
        navigateTableLeft: this.navigateTable('left'),
        navigateTableRight: this.navigateTable('right')
      }), React.createElement("div", {
        className: className,
        ref: this.dataTable
      }, React.createElement("div", {
        className: styles$Z.ScrollContainer,
        ref: this.scrollContainer,
        style: style
      }, React.createElement(EventListener, {
        event: "resize",
        handler: this.handleResize
      }), React.createElement(EventListener, {
        capture: true,
        event: "scroll",
        handler: this.scrollListener
      }), React.createElement("table", {
        className: styles$Z.Table,
        ref: this.table
      }, React.createElement("thead", null, headingMarkup, totalsMarkup), React.createElement("tbody", null, bodyMarkup), footerMarkup))));
    }
  }]);

  return DataTable;
}(React.PureComponent);
var DataTable$1 = withAppProvider()(DataTable);

function monthName(month) {
  switch (month) {
    case 0:
      return 'january';

    case 1:
      return 'february';

    case 2:
      return 'march';

    case 3:
      return 'april';

    case 4:
      return 'may';

    case 5:
      return 'june';

    case 6:
      return 'july';

    case 7:
      return 'august';

    case 8:
      return 'september';

    case 9:
      return 'october';

    case 10:
      return 'november';

    case 11:
      return 'december';
  }
}
function weekdayName(weekday) {
  switch (weekday) {
    case 0:
      return 'sunday';

    case 1:
      return 'monday';

    case 2:
      return 'tuesday';

    case 3:
      return 'wednesday';

    case 4:
      return 'thursday';

    case 5:
      return 'friday';

    case 6:
      return 'saturday';
  }
}

var styles$_ = {
  "DatePicker": "Polaris-DatePicker",
  "MonthContainer": "Polaris-DatePicker__MonthContainer",
  "Month": "Polaris-DatePicker__Month",
  "Month-current": "Polaris-DatePicker__Month--current",
  "Week": "Polaris-DatePicker__Week",
  "WeekHeadings": "Polaris-DatePicker__WeekHeadings",
  "Day": "Polaris-DatePicker__Day",
  "EmptyDay": "Polaris-DatePicker__EmptyDay",
  "Day-today": "Polaris-DatePicker__Day--today",
  "Day-inRange": "Polaris-DatePicker__Day--inRange",
  "Day-selected": "Polaris-DatePicker__Day--selected",
  "Day-disabled": "Polaris-DatePicker__Day--disabled",
  "Weekday": "Polaris-DatePicker__Weekday",
  "Weekday-current": "Polaris-DatePicker__Weekday--current",
  "Header": "Polaris-DatePicker__Header",
  "Title": "Polaris-DatePicker__Title",
};

var Day =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Day, _React$PureComponent);

  function Day() {
    var _this;

    _classCallCheck(this, Day);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Day).apply(this, arguments));
    _this.dayNode = null;

    _this.setNode = function (node) {
      _this.dayNode = node;
    };

    return _this;
  }

  _createClass(Day, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (!prevProps.focused && this.props.focused && this.dayNode) {
        this.dayNode.focus();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          day = _this$props.day,
          focused = _this$props.focused,
          onClick = _this$props.onClick,
          _this$props$onHover = _this$props.onHover,
          onHover = _this$props$onHover === void 0 ? other.noop : _this$props$onHover,
          _this$props$onFocus = _this$props.onFocus,
          onFocus = _this$props$onFocus === void 0 ? other.noop : _this$props$onFocus,
          selected = _this$props.selected,
          inRange = _this$props.inRange,
          inHoveringRange = _this$props.inHoveringRange,
          disabled = _this$props.disabled,
          intl = _this$props.polaris.intl;
      var handleHover = onHover.bind(null, day);

      if (!day) {
        return React.createElement("div", {
          className: styles$_.EmptyDay,
          onMouseOver: handleHover
        });
      }

      var handleClick = onClick && !disabled ? onClick.bind(null, day) : other.noop;
      var today = dates.isSameDay(new Date(), day);
      var className = styles.classNames(styles$_.Day, selected && styles$_['Day-selected'], disabled && styles$_['Day-disabled'], today && styles$_['Day-today'], (inRange || inHoveringRange) && !disabled && styles$_['Day-inRange']);
      var date = day.getDate();
      var tabIndex = (focused || selected || today || date === 1) && !disabled ? 0 : -1;
      var ariaLabel = ["".concat(today ? intl.translate('Polaris.DatePicker.today') : ''), "".concat(dates.Months[day.getMonth()], " "), "".concat(date, " "), "".concat(day.getFullYear())].join('');
      return React.createElement("button", {
        // eslint-disable-next-line react/jsx-no-bind
        onFocus: onFocus.bind(null, day),
        type: "button",
        ref: this.setNode,
        tabIndex: tabIndex,
        className: className,
        onMouseOver: handleHover // eslint-disable-next-line react/jsx-no-bind
        ,
        onClick: handleClick,
        "aria-label": ariaLabel,
        "aria-selected": selected,
        "aria-disabled": disabled,
        role: "gridcell"
      }, date);
    }
  }]);

  return Day;
}(React.PureComponent);
var Day$1 = withAppProvider()(Day);

function Weekday(_ref) {
  var label = _ref.label,
      title = _ref.title,
      current = _ref.current;
  var className = styles.classNames(styles$_.Weekday, current && styles$_['Weekday-current']);
  return React.createElement("div", {
    "aria-label": dates.Weekdays[label],
    className: className
  }, title);
}

var WEEKDAYS = [dates.Weekdays.Sunday, dates.Weekdays.Monday, dates.Weekdays.Tuesday, dates.Weekdays.Wednesday, dates.Weekdays.Thursday, dates.Weekdays.Friday, dates.Weekdays.Saturday];

function Month(_ref) {
  var focusedDate = _ref.focusedDate,
      selected = _ref.selected,
      hoverDate = _ref.hoverDate,
      disableDatesBefore = _ref.disableDatesBefore,
      disableDatesAfter = _ref.disableDatesAfter,
      allowRange = _ref.allowRange,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? other.noop : _ref$onChange,
      _ref$onHover = _ref.onHover,
      onHover = _ref$onHover === void 0 ? other.noop : _ref$onHover,
      _ref$onFocus = _ref.onFocus,
      onFocus = _ref$onFocus === void 0 ? other.noop : _ref$onFocus,
      month = _ref.month,
      year = _ref.year,
      weekStartsOn = _ref.weekStartsOn,
      intl = _ref.polaris.intl;
  var isInHoveringRange = allowRange ? hoveringDateIsInRange : function () {
    return false;
  };
  var now = new Date();
  var current = now.getMonth() === month && now.getFullYear() === year;
  var className = styles.classNames(styles$_.Title, current && styles$_['Month-current']);
  var weeks = dates.getWeeksForMonth(month, year, weekStartsOn);
  var weekdays = getWeekdaysOrdered(weekStartsOn).map(function (weekday) {
    return React.createElement(Weekday, {
      key: weekday,
      title: intl.translate("Polaris.DatePicker.daysAbbreviated.".concat(weekdayName(weekday))),
      current: current && new Date().getDay() === weekday,
      label: weekday
    });
  });

  function handleDateClick(selectedDate) {
    onChange(dates.getNewRange(allowRange && selected, selectedDate));
  }

  function renderWeek(day, dayIndex) {
    if (day == null) {
      var lastDayOfMonth = new Date(year, month + 1, 0);
      return (// eslint-disable-next-line react/jsx-no-bind
        React.createElement(Day$1, {
          key: dayIndex,
          onHover: onHover.bind(null, lastDayOfMonth)
        })
      );
    }

    var disabled = disableDatesBefore && dates.isDateBefore(day, disableDatesBefore) || disableDatesAfter && dates.isDateAfter(day, disableDatesAfter);
    return React.createElement(Day$1, {
      focused: focusedDate != null && dates.isSameDay(day, focusedDate),
      day: day,
      key: dayIndex,
      onFocus: onFocus,
      onClick: handleDateClick,
      onHover: onHover,
      selected: selected != null && dates.dateIsSelected(day, selected),
      inRange: selected != null && dates.dateIsInRange(day, selected),
      disabled: disabled,
      inHoveringRange: selected != null && hoverDate != null && isInHoveringRange(day, selected, hoverDate)
    });
  }

  var weeksMarkup = weeks.map(function (week, index) {
    return React.createElement("div", {
      role: "row",
      className: styles$_.Week,
      key: index
    }, week.map(renderWeek));
  });
  return React.createElement("div", {
    role: "grid",
    className: styles$_.Month
  }, React.createElement("div", {
    className: className
  }, intl.translate("Polaris.DatePicker.months.".concat(monthName(month))), " ", year), React.createElement("div", {
    role: "rowheader",
    className: styles$_.WeekHeadings
  }, weekdays), weeksMarkup);
}

var Month$1 = withAppProvider()(Month);

function hoveringDateIsInRange(day, range, hoverEndDate) {
  if (day == null) {
    return false;
  }

  var start = range.start,
      end = range.end;
  return Boolean(dates.isSameDay(start, end) && day > start && day <= hoverEndDate);
}

function getWeekdaysOrdered(weekStartsOn) {
  var weekDays = [].concat(WEEKDAYS);
  var restOfDays = weekDays.splice(weekStartsOn);
  return [].concat(_toConsumableArray(restOfDays), _toConsumableArray(weekDays));
}

var DatePicker =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(DatePicker, _React$PureComponent);

  function DatePicker() {
    var _this;

    _classCallCheck(this, DatePicker);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DatePicker).apply(this, arguments));
    _this.state = {
      hoverDate: undefined,
      focusDate: undefined
    };

    _this.handleFocus = function (date) {
      _this.setState({
        focusDate: date
      });
    };

    _this.resetFocus = function () {
      _this.setState({
        focusDate: undefined
      });
    };

    _this.handleKeyUp = function (event) {
      var key = event.key;
      var _this$props = _this.props,
          selected = _this$props.selected,
          disableDatesBefore = _this$props.disableDatesBefore,
          disableDatesAfter = _this$props.disableDatesAfter;
      var focusDate = _this.state.focusDate;
      var range = deriveRange(selected);
      var focusedDate = focusDate || range && range.start;

      if (focusedDate == null) {
        return;
      }

      if (key === 'ArrowUp') {
        var previousWeek = new Date(focusedDate);
        previousWeek.setDate(focusedDate.getDate() - 7);

        if (!(disableDatesBefore && dates.isDateBefore(previousWeek, disableDatesBefore))) {
          _this.setFocusDateAndHandleMonthChange(previousWeek);
        }
      }

      if (key === 'ArrowDown') {
        var nextWeek = new Date(focusedDate);
        nextWeek.setDate(focusedDate.getDate() + 7);

        if (!(disableDatesAfter && dates.isDateAfter(nextWeek, disableDatesAfter))) {
          _this.setFocusDateAndHandleMonthChange(nextWeek);
        }
      }

      if (key === 'ArrowRight') {
        var tomorrow = new Date(focusedDate);
        tomorrow.setDate(focusedDate.getDate() + 1);

        if (!(disableDatesAfter && dates.isDateAfter(tomorrow, disableDatesAfter))) {
          _this.setFocusDateAndHandleMonthChange(tomorrow);
        }
      }

      if (key === 'ArrowLeft') {
        var yesterday = new Date(focusedDate);
        yesterday.setDate(focusedDate.getDate() - 1);

        if (!(disableDatesBefore && dates.isDateBefore(yesterday, disableDatesBefore))) {
          _this.setFocusDateAndHandleMonthChange(yesterday);
        }
      }
    };

    _this.setFocusDateAndHandleMonthChange = function (date) {
      var onMonthChange = _this.props.onMonthChange;

      if (onMonthChange) {
        onMonthChange(date.getMonth(), date.getFullYear());
      }

      _this.setState({
        hoverDate: date,
        focusDate: date
      });
    };

    _this.handleDateSelection = function (range) {
      var end = range.end;
      var _this$props$onChange = _this.props.onChange,
          onChange = _this$props$onChange === void 0 ? other.noop : _this$props$onChange;

      _this.setState({
        hoverDate: end,
        focusDate: new Date(end)
      }, function () {
        return onChange(range);
      });
    };

    _this.handleMonthChangeClick = function (month, year) {
      var onMonthChange = _this.props.onMonthChange;

      if (!onMonthChange) {
        return;
      }

      _this.setState({
        focusDate: undefined
      });

      onMonthChange(month, year);
    };

    _this.handleHover = function (date) {
      _this.setState({
        hoverDate: date
      });
    };

    return _this;
  }

  _createClass(DatePicker, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var selectedPropDidChange = !isSameSelectedDate(prevProps.selected, this.props.selected);

      if (selectedPropDidChange) {
        this.resetFocus();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          id = _this$props2.id,
          selected = _this$props2.selected,
          month = _this$props2.month,
          year = _this$props2.year,
          allowRange = _this$props2.allowRange,
          multiMonth = _this$props2.multiMonth,
          disableDatesBefore = _this$props2.disableDatesBefore,
          disableDatesAfter = _this$props2.disableDatesAfter,
          _this$props2$weekStar = _this$props2.weekStartsOn,
          weekStartsOn = _this$props2$weekStar === void 0 ? dates.Weekdays.Sunday : _this$props2$weekStar,
          intl = _this$props2.polaris.intl;
      var _this$state = this.state,
          hoverDate = _this$state.hoverDate,
          focusDate = _this$state.focusDate;
      var showNextYear = dates.getNextDisplayYear(month, year);
      var showNextMonth = dates.getNextDisplayMonth(month);
      var showNextToNextYear = dates.getNextDisplayYear(showNextMonth, showNextYear);
      var showNextToNextMonth = dates.getNextDisplayMonth(showNextMonth);
      var showPreviousYear = dates.getPreviousDisplayYear(month, year);
      var showPreviousMonth = dates.getPreviousDisplayMonth(month);
      var previousMonthName = intl.translate("Polaris.DatePicker.months.".concat(monthName(showPreviousMonth)));
      var nextMonth = multiMonth ? intl.translate("Polaris.DatePicker.months.".concat(monthName(showNextToNextMonth))) : intl.translate("Polaris.DatePicker.months.".concat(monthName(showNextMonth)));
      var nextYear = multiMonth ? showNextToNextYear : showNextYear;
      var secondDatePicker = multiMonth ? React.createElement(Month$1, {
        onFocus: this.handleFocus,
        focusedDate: focusDate,
        month: showNextMonth,
        year: showNextYear,
        selected: deriveRange(selected),
        hoverDate: hoverDate,
        onChange: this.handleDateSelection,
        onHover: this.handleHover,
        disableDatesBefore: disableDatesBefore,
        disableDatesAfter: disableDatesAfter,
        allowRange: allowRange,
        weekStartsOn: weekStartsOn
      }) : null;
      return React.createElement("div", {
        id: id,
        className: styles$_.DatePicker,
        onKeyDown: handleKeyDown,
        onKeyUp: this.handleKeyUp
      }, React.createElement("div", {
        className: styles$_.Header
      }, React.createElement(Button$1, {
        plain: true,
        icon: polarisIcons.ArrowLeftMinor,
        accessibilityLabel: intl.translate('Polaris.DatePicker.previousMonth', {
          previousMonthName: previousMonthName,
          showPreviousYear: showPreviousYear
        }) // eslint-disable-next-line react/jsx-no-bind
        ,
        onClick: this.handleMonthChangeClick.bind(null, showPreviousMonth, showPreviousYear)
      }), React.createElement(Button$1, {
        plain: true,
        icon: polarisIcons.ArrowRightMinor,
        accessibilityLabel: intl.translate('Polaris.DatePicker.nextMonth', {
          nextMonth: nextMonth,
          nextYear: nextYear
        }) // eslint-disable-next-line react/jsx-no-bind
        ,
        onClick: this.handleMonthChangeClick.bind(null, showNextMonth, showNextYear)
      })), React.createElement("div", {
        className: styles$_.MonthContainer
      }, React.createElement(Month$1, {
        onFocus: this.handleFocus,
        focusedDate: focusDate,
        month: month,
        year: year,
        selected: deriveRange(selected),
        hoverDate: hoverDate,
        onChange: this.handleDateSelection,
        onHover: this.handleHover,
        disableDatesBefore: disableDatesBefore,
        disableDatesAfter: disableDatesAfter,
        allowRange: allowRange,
        weekStartsOn: weekStartsOn
      }), secondDatePicker));
    }
  }]);

  return DatePicker;
}(React.PureComponent);

function handleKeyDown(event) {
  var key = event.key;

  if (key === 'ArrowUp' || key === 'ArrowDown' || key === 'ArrowLeft' || key === 'ArrowRight') {
    event.preventDefault();
    event.stopPropagation();
  }
}

function isSameSelectedDate(previousDate, currentDate) {
  if (previousDate == null || currentDate == null) {
    return previousDate == null && currentDate == null;
  }

  if (previousDate instanceof Date || currentDate instanceof Date) {
    return previousDate instanceof Date && currentDate instanceof Date && dates.isSameDay(previousDate, currentDate);
  }

  return dates.isSameDay(previousDate.start, currentDate.start) && dates.isSameDay(previousDate.end, currentDate.end);
}

function deriveRange(selected) {
  return selected instanceof Date ? {
    start: selected,
    end: selected
  } : selected;
}

var DatePicker$1 = withAppProvider()(DatePicker);

var styles$10 = {
  "DescriptionList": "Polaris-DescriptionList",
  "Term": "Polaris-DescriptionList__Term",
  "Description": "Polaris-DescriptionList__Description",
};

var getUniqueTermKey = other.createUniqueIDFactory("Term");
var getUniqueDescriptionKey = other.createUniqueIDFactory("Description");
function DescriptionList(_ref) {
  var items = _ref.items;
  var terms = items.reduce(function (allTerms, _ref2) {
    var term = _ref2.term,
        description = _ref2.description;
    return [].concat(_toConsumableArray(allTerms), [React.createElement("dt", {
      key: getUniqueTermKey(),
      className: styles$10.Term
    }, term), React.createElement("dd", {
      key: getUniqueDescriptionKey(),
      className: styles$10.Description
    }, description)]);
  }, []);
  return React.createElement("dl", {
    className: styles$10.DescriptionList
  }, terms);
}

function capitalize() {
  var word = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var wordLower = word.toLowerCase();
  return wordLower.charAt(0).toUpperCase() + wordLower.slice(1);
}

var fileUpload = 'data:image/svg+xml;base64,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';

var imageUpload = 'data:image/svg+xml;base64,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';

var _React$createContext$1 = React.createContext({
  size: 'extraLarge',
  type: 'file'
}),
    Provider$2 = _React$createContext$1.Provider,
    Consumer$2 = _React$createContext$1.Consumer;

var styles$11 = {
  "FileUpload": "Polaris-DropZone-FileUpload",
  "Image": "Polaris-DropZone-FileUpload__Image",
  "sizeExtraLarge": "Polaris-DropZone-FileUpload--sizeExtraLarge",
  "sizeLarge": "Polaris-DropZone-FileUpload--sizeLarge",
};

var FileUpload =
/*#__PURE__*/
function (_React$Component) {
  _inherits(FileUpload, _React$Component);

  function FileUpload(props) {
    var _this;

    _classCallCheck(this, FileUpload);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(FileUpload).call(this, props));
    var translate$$1 = props.polaris.intl.translate,
        type = props.context.type;
    var suffix = capitalize(type);
    _this.state = {
      actionTitle: translate$$1("Polaris.DropZone.FileUpload.actionTitle".concat(suffix)),
      actionHint: translate$$1("Polaris.DropZone.FileUpload.actionHint".concat(suffix))
    };
    return _this;
  }

  _createClass(FileUpload, [{
    key: "updateStateFromProps",
    value: function updateStateFromProps(props) {
      var _this$state = this.state,
          actionTitle = _this$state.actionTitle,
          actionHint = _this$state.actionHint;

      if (props.actionTitle && props.actionTitle !== actionTitle) {
        this.setState({
          actionTitle: props.actionTitle
        });
      }

      if (props.actionHint && props.actionHint !== actionHint) {
        this.setState({
          actionHint: props.actionHint
        });
      }
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(props) {
      this.updateStateFromProps(props);
    }
  }, {
    key: "componentWillMount",
    value: function componentWillMount() {
      this.updateStateFromProps(this.props);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props$context = this.props.context,
          size = _this$props$context.size,
          type = _this$props$context.type;
      var _this$state2 = this.state,
          actionTitle = _this$state2.actionTitle,
          actionHint = _this$state2.actionHint;
      var imageClasses = styles.classNames(styles$11.Image, size && size === 'extraLarge' && styles$11.sizeExtraLarge, size && size === 'large' && styles$11.sizeLarge);
      var extraLargeView = size === 'extraLarge' ? React.createElement(Stack, {
        vertical: true
      }, type === 'file' && React.createElement("img", {
        className: imageClasses,
        src: fileUpload,
        alt: ""
      }), type === 'image' && React.createElement("img", {
        className: imageClasses,
        src: imageUpload,
        alt: ""
      }), React.createElement(Button$1, null, actionTitle), React.createElement(TextStyle, {
        variation: "subdued"
      }, actionHint)) : null;
      var largeView = size === 'large' ? React.createElement(Stack, {
        vertical: true,
        spacing: "tight"
      }, type === 'file' && React.createElement("img", {
        className: imageClasses,
        src: fileUpload,
        alt: ""
      }), type === 'image' && React.createElement("img", {
        className: imageClasses,
        src: imageUpload,
        alt: ""
      }), React.createElement(Button$1, {
        size: "slim"
      }, actionTitle), React.createElement(Caption, null, React.createElement(TextStyle, {
        variation: "subdued"
      }, actionHint))) : null;
      var mediumView = size === 'medium' ? React.createElement(Stack, {
        vertical: true,
        spacing: "tight"
      }, React.createElement(Link$2, null, actionTitle), React.createElement(Caption, null, React.createElement(TextStyle, {
        variation: "subdued"
      }, actionHint))) : null;
      var smallView = size === 'small' ? React.createElement(Stack, {
        vertical: true,
        spacing: "tight"
      }, React.createElement(Icon$1, {
        source: polarisIcons.DragDropMajorMonotone,
        color: "inkLightest"
      })) : null;
      return React.createElement("div", {
        className: styles$11.FileUpload
      }, smallView, mediumView, largeView, extraLargeView);
    }
  }]);

  return FileUpload;
}(React.Component);
var FileUpload$1 = compose$2(withContext(Consumer$2), withAppProvider(), withRef())(FileUpload);

var dragEvents = ['dragover', 'dragenter', 'drop'];
function fileAccepted(file, accept) {
  return file.type === 'application/x-moz-file' || accepts(file, accept);
}
function getDataTransferFiles(event) {
  if (isDragEvent(event) && event.dataTransfer) {
    var dt = event.dataTransfer;

    if (dt.files && dt.files.length) {
      return Array.from(dt.files);
    } else if (dt.items && dt.items.length) {
      // Chrome is the only browser that allows to read the file list on drag
      // events and uses `items` instead of `files` in this case.
      return Array.from(dt.items);
    }
  } else if (isChangeEvent(event) && event.target.files) {
    // Return files from even when a file was selected from an upload dialog
    return Array.from(event.target.files);
  }

  return [];
}

function accepts(file, acceptedFiles) {
  if (file && acceptedFiles) {
    var fileName = file.name || '';
    var mimeType = file.type || '';
    var baseMimeType = mimeType.replace(/\/.*$/, '');
    var acceptedFilesArray = Array.isArray(acceptedFiles) ? acceptedFiles : acceptedFiles.split(',');
    return acceptedFilesArray.some(function (type) {
      var validType = type.trim();

      if (validType.charAt(0) === '.') {
        return fileName.toLowerCase().endsWith(validType.toLowerCase());
      } else if (/\/\*$/.test(validType)) {
        // This is something like a image/* mime type
        return baseMimeType === validType.replace(/\/.*$/, '');
      }

      return mimeType === validType;
    });
  }

  return true;
}

function isDragEvent(event) {
  return dragEvents.indexOf(event.type) > 0;
}

function isChangeEvent(event) {
  return event.hasOwnProperty('target');
}

var styles$12 = {
  "DropZone": "Polaris-DropZone",
  "hasOutline": "Polaris-DropZone--hasOutline",
  "isDragging": "Polaris-DropZone--isDragging",
  "isDisabled": "Polaris-DropZone--isDisabled",
  "sizeExtraLarge": "Polaris-DropZone--sizeExtraLarge",
  "sizeLarge": "Polaris-DropZone--sizeLarge",
  "sizeMedium": "Polaris-DropZone--sizeMedium",
  "sizeSmall": "Polaris-DropZone--sizeSmall",
  "Container": "Polaris-DropZone__Container",
  "Overlay": "Polaris-DropZone__Overlay",
  "hasError": "Polaris-DropZone--hasError",
};

var getUniqueID$8 = other.createUniqueIDFactory('DropZone');
var DropZone =
/*#__PURE__*/
function (_React$Component) {
  _inherits(DropZone, _React$Component);

  function DropZone(props) {
    var _this;

    _classCallCheck(this, DropZone);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DropZone).call(this, props));
    _this.node = React.createRef();
    _this.dragTargets = [];
    _this.fileInputNode = React.createRef();
    _this.adjustSize = debounce(function () {
      if (!_this.node.current) {
        return;
      }

      var size = 'extraLarge';

      var width = _this.node.current.getBoundingClientRect().width;

      if (width < 100) {
        size = 'small';
      } else if (width < 160) {
        size = 'medium';
      } else if (width < 300) {
        size = 'large';
      }

      _this.setState({
        size: size
      });
    }, 50, {
      trailing: true
    });

    _this.triggerFileDialog = function () {
      _this.open();

      if (_this.props.onFileDialogClose) {
        _this.props.onFileDialogClose();
      }
    };

    _this.open = function () {
      if (!_this.fileInputNode.current) {
        return;
      }

      _this.fileInputNode.current.click();
    };

    _this.getValidatedFiles = function (files) {
      var _this$props = _this.props,
          accept = _this$props.accept,
          allowMultiple = _this$props.allowMultiple,
          customValidator = _this$props.customValidator;
      var acceptedFiles = [];
      var rejectedFiles = [];
      Array.from(files).forEach(function (file) {
        if (!fileAccepted(file, accept) || customValidator && !customValidator(file)) {
          rejectedFiles.push(file);
        } else {
          acceptedFiles.push(file);
        }
      });

      if (!allowMultiple) {
        acceptedFiles.splice(1, acceptedFiles.length);
        rejectedFiles.push.apply(rejectedFiles, _toConsumableArray(acceptedFiles.slice(1)));
      }

      return {
        files: files,
        acceptedFiles: acceptedFiles,
        rejectedFiles: rejectedFiles
      };
    };

    _this.handleClick = function (event) {
      var numFiles = _this.state.numFiles;
      var _this$props2 = _this.props,
          onClick = _this$props2.onClick,
          disabled = _this$props2.disabled,
          allowMultiple = _this$props2.allowMultiple;

      if (disabled || !allowMultiple && numFiles > 0) {
        return;
      }

      return onClick ? onClick(event) : _this.open();
    };

    _this.handleDrop = function (event) {
      event.preventDefault();
      event.stopPropagation();
      var _this$props3 = _this.props,
          disabled = _this$props3.disabled,
          onDrop = _this$props3.onDrop,
          onDropAccepted = _this$props3.onDropAccepted,
          onDropRejected = _this$props3.onDropRejected,
          allowMultiple = _this$props3.allowMultiple;
      var numFiles = _this.state.numFiles;

      if (disabled || !allowMultiple && numFiles > 0) {
        return;
      }

      var fileList = getDataTransferFiles(event);

      var _this$getValidatedFil = _this.getValidatedFiles(fileList),
          files = _this$getValidatedFil.files,
          acceptedFiles = _this$getValidatedFil.acceptedFiles,
          rejectedFiles = _this$getValidatedFil.rejectedFiles;

      _this.dragTargets = [];

      _this.setState(function (prev) {
        return {
          dragging: false,
          error: rejectedFiles.length > 0,
          numFiles: prev.numFiles + acceptedFiles.length
        };
      });

      if (onDrop) {
        onDrop(files, acceptedFiles, rejectedFiles);
      }

      if (onDropAccepted && acceptedFiles.length) {
        onDropAccepted(acceptedFiles);
      }

      if (onDropRejected && rejectedFiles.length) {
        onDropRejected(rejectedFiles);
      }

      event.target.value = '';
    };

    _this.handleDragEnter = function (event) {
      event.preventDefault();
      event.stopPropagation();
      var _this$state = _this.state,
          dragging = _this$state.dragging,
          numFiles = _this$state.numFiles;
      var _this$props4 = _this.props,
          disabled = _this$props4.disabled,
          onDragEnter = _this$props4.onDragEnter,
          allowMultiple = _this$props4.allowMultiple;

      if (disabled || !allowMultiple && numFiles > 0) {
        return;
      }

      var fileList = getDataTransferFiles(event);

      if (event.target && _this.dragTargets.indexOf(event.target) === -1) {
        _this.dragTargets.push(event.target);
      }

      if (dragging) {
        return false;
      }

      var _this$getValidatedFil2 = _this.getValidatedFiles(fileList),
          rejectedFiles = _this$getValidatedFil2.rejectedFiles;

      _this.setState({
        dragging: true,
        error: rejectedFiles.length > 0
      });

      if (onDragEnter) {
        onDragEnter();
      }
    };

    _this.handleDragOver = function (event) {
      event.preventDefault();
      event.stopPropagation();
      var numFiles = _this.state.numFiles;
      var _this$props5 = _this.props,
          disabled = _this$props5.disabled,
          onDragOver = _this$props5.onDragOver,
          allowMultiple = _this$props5.allowMultiple;

      if (disabled || !allowMultiple && numFiles > 0) {
        return;
      }

      if (onDragOver) {
        onDragOver();
      }

      return false;
    };

    _this.handleDragLeave = function (event) {
      event.preventDefault();
      var numFiles = _this.state.numFiles;
      var _this$props6 = _this.props,
          disabled = _this$props6.disabled,
          onDragLeave = _this$props6.onDragLeave,
          allowMultiple = _this$props6.allowMultiple;

      if (disabled || !allowMultiple && numFiles > 0) {
        return;
      }

      _this.dragTargets = _this.dragTargets.filter(function (el) {
        return el !== event.target && _this.dropNode && _this.dropNode.contains(el);
      });

      if (_this.dragTargets.length > 0) {
        return;
      }

      _this.setState({
        dragging: false,
        error: false
      });

      if (onDragLeave) {
        onDragLeave();
      }
    };

    var translate$$1 = props.polaris.intl.translate,
        type = props.type;
    var suffix = capitalize(type);
    _this.state = {
      type: type,
      id: props.id || getUniqueID$8(),
      size: 'extraLarge',
      dragging: false,
      error: false,
      overlayText: translate$$1("Polaris.DropZone.overlayText".concat(suffix)),
      errorOverlayText: translate$$1("Polaris.DropZone.errorOverlayText".concat(suffix)),
      numFiles: 0
    };
    return _this;
  }

  _createClass(DropZone, [{
    key: "render",
    value: function render() {
      var _this$state2 = this.state,
          id = _this$state2.id,
          dragging = _this$state2.dragging,
          error = _this$state2.error,
          size = _this$state2.size,
          overlayText = _this$state2.overlayText,
          errorOverlayText = _this$state2.errorOverlayText;
      var _this$props7 = this.props,
          label = _this$props7.label,
          labelAction = _this$props7.labelAction,
          labelHidden = _this$props7.labelHidden,
          children = _this$props7.children,
          disabled = _this$props7.disabled,
          outline = _this$props7.outline,
          accept = _this$props7.accept,
          active = _this$props7.active,
          overlay = _this$props7.overlay,
          allowMultiple = _this$props7.allowMultiple;
      var inputAttributes = {
        id: id,
        accept: accept,
        disabled: disabled,
        type: 'file',
        multiple: allowMultiple,
        ref: this.fileInputNode,
        onChange: this.handleDrop,
        autoComplete: 'off'
      };
      var classes = styles.classNames(styles$12.DropZone, outline && styles$12.hasOutline, (active || dragging) && styles$12.isDragging, error && styles$12.hasError, size && size === 'extraLarge' && styles$12.sizeExtraLarge, size && size === 'large' && styles$12.sizeLarge, size && size === 'medium' && styles$12.sizeMedium, size && size === 'small' && styles$12.sizeSmall);
      var dragOverlay = (active || dragging) && !error && overlay ? React.createElement("div", {
        className: styles$12.Overlay
      }, React.createElement(Stack, {
        vertical: true,
        spacing: "tight"
      }, React.createElement(Icon$1, {
        source: polarisIcons.DragDropMajorMonotone,
        color: "indigo"
      }), size === 'extraLarge' && React.createElement(DisplayText, {
        size: "small",
        element: "p"
      }, overlayText), (size === 'medium' || size === 'large') && React.createElement(Caption, null, overlayText))) : null;
      var dragErrorOverlay = dragging && error ? React.createElement("div", {
        className: styles$12.Overlay
      }, React.createElement(Stack, {
        vertical: true,
        spacing: "tight"
      }, React.createElement(Icon$1, {
        source: polarisIcons.CircleAlertMajorMonotone,
        color: "red"
      }), size === 'extraLarge' && React.createElement(DisplayText, {
        size: "small",
        element: "p"
      }, errorOverlayText), (size === 'medium' || size === 'large') && React.createElement(Caption, null, errorOverlayText))) : null;
      var dropZoneMarkup = React.createElement("div", {
        ref: this.node,
        className: classes,
        "aria-disabled": disabled,
        onClick: this.handleClick,
        onDragStart: handleDragStart
      }, dragOverlay, dragErrorOverlay, React.createElement("div", {
        className: styles$12.Container
      }, children), React.createElement(VisuallyHidden, null, React.createElement("input", inputAttributes)));
      var labelledDropzoneMarkup = label ? React.createElement(Labelled, {
        id: id,
        label: label,
        action: labelAction,
        labelHidden: labelHidden
      }, dropZoneMarkup) : dropZoneMarkup;
      return React.createElement(Provider$2, {
        value: this.getContext
      }, labelledDropzoneMarkup);
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.dragTargets = [];
      this.setState({
        error: this.props.error
      });

      if (!this.dropNode) {
        return;
      }

      events.addEventListener(this.dropNode, 'drop', this.handleDrop);
      events.addEventListener(this.dropNode, 'dragover', this.handleDragOver);
      events.addEventListener(this.dropNode, 'dragenter', this.handleDragEnter);
      events.addEventListener(this.dropNode, 'dragleave', this.handleDragLeave);
      events.addEventListener(window, 'resize', this.adjustSize);
      this.adjustSize();

      if (this.props.openFileDialog) {
        this.triggerFileDialog();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (!this.dropNode) {
        return;
      }

      events.removeEventListener(this.dropNode, 'drop', this.handleDrop);
      events.removeEventListener(this.dropNode, 'dragover', this.handleDragOver);
      events.removeEventListener(this.dropNode, 'dragenter', this.handleDragEnter);
      events.removeEventListener(this.dropNode, 'dragleave', this.handleDragLeave);
      events.removeEventListener(window, 'resize', this.adjustSize);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      if (this.props.openFileDialog) {
        this.triggerFileDialog();
      }
    }
  }, {
    key: "getContext",
    get: function get() {
      return {
        size: this.state.size,
        type: this.state.type || 'file'
      };
    }
  }, {
    key: "dropNode",
    get: function get() {
      return this.props.dropOnPage ? document : this.node.current;
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var id = prevState.id,
          error = prevState.error,
          type = prevState.type,
          overlayText = prevState.overlayText,
          errorOverlayText = prevState.errorOverlayText;
      var newState = {};

      if (nextProps.id != null && id !== nextProps.id) {
        newState.id = nextProps.id || id;
      }

      if (nextProps.error != null && error !== nextProps.error) {
        newState.error = nextProps.error;
      }

      if (nextProps.type != null && type !== nextProps.type) {
        newState.type = nextProps.type;
      }

      if (nextProps.overlayText != null && overlayText !== nextProps.overlayText) {
        newState.overlayText = nextProps.overlayText;
      }

      if (nextProps.errorOverlayText != null && errorOverlayText !== nextProps.errorOverlayText) {
        newState.errorOverlayText = nextProps.errorOverlayText;
      }

      return Object.keys(newState).length ? newState : null;
    }
  }]);

  return DropZone;
}(React.Component);
DropZone.FileUpload = FileUpload$1;
DropZone.defaultProps = {
  type: 'file',
  outline: true,
  overlay: true,
  allowMultiple: true
};

function handleDragStart(event) {
  event.preventDefault();
  event.stopPropagation();
}

var DropZone$1 = withAppProvider()(DropZone);

var emptySearch = 'data:image/svg+xml;base64,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';

var styles$13 = {
  "Image": "Polaris-EmptySearchResult__Image",
};

var EmptySearchResult =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(EmptySearchResult, _React$PureComponent);

  function EmptySearchResult() {
    _classCallCheck(this, EmptySearchResult);

    return _possibleConstructorReturn(this, _getPrototypeOf(EmptySearchResult).apply(this, arguments));
  }

  _createClass(EmptySearchResult, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          title = _this$props.title,
          description = _this$props.description,
          withIllustration = _this$props.withIllustration,
          intl = _this$props.polaris.intl;
      var altText = intl.translate('Polaris.EmptySearchResult.altText');
      var descriptionMarkup = description ? React.createElement("p", null, description) : null;
      var illustrationMarkup = withIllustration ? React.createElement(Image, {
        alt: altText,
        source: emptySearch,
        className: styles$13.Image,
        draggable: false
      }) : null;
      return React.createElement(Stack, {
        alignment: "center",
        vertical: true
      }, illustrationMarkup, React.createElement(DisplayText, {
        size: "small"
      }, title), React.createElement(TextStyle, {
        variation: "subdued"
      }, descriptionMarkup));
    }
  }]);

  return EmptySearchResult;
}(React.PureComponent);
var EmptySearchResult$1 = withAppProvider()(EmptySearchResult);

var styles$14 = {
  "EmptyState": "Polaris-EmptyState",
  "imageContained": "Polaris-EmptyState--imageContained",
  "Image": "Polaris-EmptyState__Image",
  "Section": "Polaris-EmptyState__Section",
  "ImageContainer": "Polaris-EmptyState__ImageContainer",
  "DetailsContainer": "Polaris-EmptyState__DetailsContainer",
  "Details": "Polaris-EmptyState__Details",
  "Content": "Polaris-EmptyState__Content",
  "Actions": "Polaris-EmptyState__Actions",
  "FooterContent": "Polaris-EmptyState__FooterContent",
};

var EmptyState =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(EmptyState, _React$PureComponent);

  function EmptyState() {
    _classCallCheck(this, EmptyState);

    return _possibleConstructorReturn(this, _getPrototypeOf(EmptyState).apply(this, arguments));
  }

  _createClass(EmptyState, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          heading = _this$props.heading,
          image = _this$props.image,
          largeImage = _this$props.largeImage,
          imageContained = _this$props.imageContained,
          action = _this$props.action,
          secondaryAction = _this$props.secondaryAction,
          footerContent = _this$props.footerContent;
      var className = styles.classNames(styles$14.EmptyState, imageContained && styles$14.imageContained);
      var imageMarkup = largeImage ? React.createElement(Image, {
        alt: "",
        role: "presentation",
        className: styles$14.Image,
        source: largeImage,
        sourceSet: [{
          source: image,
          descriptor: '568w'
        }, {
          source: largeImage,
          descriptor: '1136w'
        }],
        sizes: "(max-width: 568px) 60vw"
      }) : React.createElement(Image, {
        role: "presentation",
        alt: "",
        className: styles$14.Image,
        source: image
      });
      var secondaryActionMarkup = secondaryAction ? buttonFrom(secondaryAction, {
        plain: true
      }) : null;
      var footerContentMarkup = footerContent ? React.createElement("div", {
        className: styles$14.FooterContent
      }, React.createElement(TextContainer, null, footerContent)) : null;
      return React.createElement("div", {
        className: className
      }, React.createElement("div", {
        className: styles$14.Section
      }, React.createElement("div", {
        className: styles$14.DetailsContainer
      }, React.createElement("div", {
        className: styles$14.Details
      }, React.createElement(TextContainer, null, React.createElement(DisplayText, {
        size: "medium"
      }, heading), React.createElement("div", {
        className: styles$14.Content
      }, children)), React.createElement("div", {
        className: styles$14.Actions
      }, React.createElement(Stack, {
        alignment: "center"
      }, buttonFrom(action, {
        primary: true,
        size: 'large'
      }), secondaryActionMarkup)), footerContentMarkup)), React.createElement("div", {
        className: styles$14.ImageContainer
      }, imageMarkup)));
    }
  }]);

  return EmptyState;
}(React.PureComponent);

var styles$15 = {
  "Truncate": "Polaris-Truncate",
};

function Truncate(_ref) {
  var children = _ref.children;
  return React.createElement("span", {
    className: styles$15.Truncate
  }, children);
}

var styles$16 = {
  "ExceptionList": "Polaris-ExceptionList",
  "Item": "Polaris-ExceptionList__Item",
  "Icon": "Polaris-ExceptionList__Icon",
  "statusWarning": "Polaris-ExceptionList--statusWarning",
  "statusCritical": "Polaris-ExceptionList--statusCritical",
  "Bullet": "Polaris-ExceptionList__Bullet",
  "Title": "Polaris-ExceptionList__Title",
  "Description": "Polaris-ExceptionList__Description",
};

function ExceptionList(_ref) {
  var itemsList = _ref.items;
  var items = itemsList.map(function (item, index) {
    var status = item.status,
        icon = item.icon,
        title = item.title,
        description = item.description,
        _item$truncate = item.truncate,
        truncate = _item$truncate === void 0 ? false : _item$truncate;
    var itemClasses = styles.classNames(styles$16.Item, status && styles$16[styles.variationName('status', status)]);
    var iconMarkup = icon ? React.createElement(Icon$1, {
      source: icon
    }) : React.createElement("span", {
      className: styles$16.Bullet
    });
    var titleMarkup = title && React.createElement("span", {
      className: styles$16.Title
    }, title);
    var descriptionMarkup = description && React.createElement("span", {
      className: styles$16.Description
    }, description);
    var Element = truncate ? Truncate : React.Fragment;
    return React.createElement("li", {
      className: itemClasses,
      key: index
    }, React.createElement("span", {
      className: styles$16.Icon
    }, iconMarkup), React.createElement(Element, null, titleMarkup, descriptionMarkup));
  });
  return React.createElement("ul", {
    className: styles$16.ExceptionList
  }, items);
}

var styles$17 = {
  "FooterHelp": "Polaris-FooterHelp",
  "Content": "Polaris-FooterHelp__Content",
  "Icon": "Polaris-FooterHelp__Icon",
  "Text": "Polaris-FooterHelp__Text",
};

function FooterHelp(_ref) {
  var children = _ref.children;
  return React.createElement("div", {
    className: styles$17.FooterHelp
  }, React.createElement("div", {
    className: styles$17.Content
  }, React.createElement("div", {
    className: styles$17.Icon
  }, React.createElement(Icon$1, {
    source: polarisIcons.QuestionMarkMajorTwotone,
    color: "teal",
    backdrop: true
  })), React.createElement("div", {
    className: styles$17.Text
  }, children)));
}

var Form =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Form, _React$PureComponent);

  function Form() {
    var _this;

    _classCallCheck(this, Form);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Form).apply(this, arguments));

    _this.handleSubmit = function (event) {
      var _this$props = _this.props,
          _this$props$preventDe = _this$props.preventDefault,
          preventDefault = _this$props$preventDe === void 0 ? true : _this$props$preventDe,
          onSubmit = _this$props.onSubmit;

      if (!preventDefault) {
        return;
      }

      event.preventDefault();
      onSubmit(event);
    };

    return _this;
  }

  _createClass(Form, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          acceptCharset = _this$props2.acceptCharset,
          action = _this$props2.action,
          autoComplete = _this$props2.autoComplete,
          children = _this$props2.children,
          encType = _this$props2.encType,
          _this$props2$implicit = _this$props2.implicitSubmit,
          implicitSubmit = _this$props2$implicit === void 0 ? true : _this$props2$implicit,
          _this$props2$method = _this$props2.method,
          method = _this$props2$method === void 0 ? 'post' : _this$props2$method,
          name = _this$props2.name,
          noValidate = _this$props2.noValidate,
          target$$1 = _this$props2.target;
      var autoCompleteInputs = normalizeAutoComplete$1(autoComplete);
      var submitMarkup = implicitSubmit ? React.createElement(VisuallyHidden, null, React.createElement("button", {
        type: "submit",
        "aria-hidden": "true"
      })) : null;
      return React.createElement("form", {
        acceptCharset: acceptCharset,
        action: action,
        autoComplete: autoCompleteInputs,
        encType: encType,
        method: method,
        name: name,
        noValidate: noValidate,
        target: target$$1,
        onSubmit: this.handleSubmit
      }, children, submitMarkup);
    }
  }]);

  return Form;
}(React.PureComponent);

function normalizeAutoComplete$1(autoComplete) {
  if (autoComplete == null) {
    return autoComplete;
  }

  return autoComplete ? 'on' : 'off';
}

var styles$18 = {
  "FormLayout": "Polaris-FormLayout",
  "Title": "Polaris-FormLayout__Title",
  "Items": "Polaris-FormLayout__Items",
  "HelpText": "Polaris-FormLayout__HelpText",
  "Item": "Polaris-FormLayout__Item",
  "grouped": "Polaris-FormLayout--grouped",
  "condensed": "Polaris-FormLayout--condensed",
};

function Item$4(props) {
  return React.createElement("div", {
    className: styles$18.Item
  }, props.children);
}

var getUniqueID$9 = other.createUniqueIDFactory('FormLayoutGroup');
function Group(_ref) {
  var children = _ref.children,
      condensed = _ref.condensed,
      title = _ref.title,
      helpText = _ref.helpText;
  var className = styles.classNames(condensed ? styles$18.condensed : styles$18.grouped);
  var id = getUniqueID$9();
  var helpTextElement = null;
  var helpTextID;
  var titleElement = null;
  var titleID;

  if (helpText) {
    helpTextID = "".concat(id, "HelpText");
    helpTextElement = React.createElement("div", {
      id: helpTextID,
      className: styles$18.HelpText
    }, helpText);
  }

  if (title) {
    titleID = "".concat(id, "Title");
    titleElement = React.createElement("div", {
      id: titleID,
      className: styles$18.Title
    }, title);
  }

  var itemsMarkup = React.Children.map(children, function (child) {
    return reactUtilities.wrapWithComponent(child, Item$4);
  });
  return React.createElement("div", {
    role: "group",
    className: className,
    "aria-labelledby": titleID,
    "aria-describedby": helpTextID
  }, titleElement, React.createElement("div", {
    className: styles$18.Items
  }, itemsMarkup), helpTextElement);
}

var FormLayout =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(FormLayout, _React$PureComponent);

  function FormLayout() {
    _classCallCheck(this, FormLayout);

    return _possibleConstructorReturn(this, _getPrototypeOf(FormLayout).apply(this, arguments));
  }

  _createClass(FormLayout, [{
    key: "render",
    value: function render() {
      var children = this.props.children;
      return React.createElement("div", {
        className: styles$18.FormLayout
      }, React.Children.map(children, wrapChildren));
    }
  }]);

  return FormLayout;
}(React.PureComponent);
FormLayout.Group = Group;

function wrapChildren(child, index) {
  if (reactUtilities.isElementOfType(child, Group)) {
    return child;
  }

  var props = {
    key: index
  };
  return reactUtilities.wrapWithComponent(child, Item$4, props);
}

var styles$19 = {
  "KeyboardKey": "Polaris-KeyboardKey",
};

function KeyboardKey(_ref) {
  var children = _ref.children;
  var key = children || '';
  key = key.length > 1 ? key.toLowerCase() : key.toUpperCase();
  return React.createElement("kbd", {
    className: styles$19.KeyboardKey
  }, key);
}

var styles$1a = {
  "Layout": "Polaris-Layout",
  "Section": "Polaris-Layout__Section",
  "Section-secondary": "Polaris-Layout__Section--secondary",
  "Section-fullWidth": "Polaris-Layout__Section--fullWidth",
  "Section-oneHalf": "Polaris-Layout__Section--oneHalf",
  "Section-oneThird": "Polaris-Layout__Section--oneThird",
  "AnnotatedSection": "Polaris-Layout__AnnotatedSection",
  "AnnotationWrapper": "Polaris-Layout__AnnotationWrapper",
  "AnnotationContent": "Polaris-Layout__AnnotationContent",
  "Annotation": "Polaris-Layout__Annotation",
  "AnnotationDescription": "Polaris-Layout__AnnotationDescription",
};

function AnnotatedSection(props) {
  var children = props.children,
      title = props.title,
      description = props.description;
  var descriptionMarkup = typeof description === 'string' ? React.createElement("p", null, description) : description;
  return React.createElement("div", {
    className: styles$1a.AnnotatedSection
  }, React.createElement("div", {
    className: styles$1a.AnnotationWrapper
  }, React.createElement("div", {
    className: styles$1a.Annotation
  }, React.createElement(TextContainer, null, React.createElement(Heading, null, title), descriptionMarkup && React.createElement("div", {
    className: styles$1a.AnnotationDescription
  }, descriptionMarkup))), React.createElement("div", {
    className: styles$1a.AnnotationContent
  }, children)));
}

function Section$4(_ref) {
  var children = _ref.children,
      secondary = _ref.secondary,
      fullWidth = _ref.fullWidth,
      oneHalf = _ref.oneHalf,
      oneThird = _ref.oneThird;
  var className = styles.classNames(styles$1a.Section, secondary && styles$1a['Section-secondary'], fullWidth && styles$1a['Section-fullWidth'], oneHalf && styles$1a['Section-oneHalf'], oneThird && styles$1a['Section-oneThird']);
  return React.createElement("div", {
    className: className
  }, children);
}

var Layout =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Layout, _React$Component);

  function Layout() {
    _classCallCheck(this, Layout);

    return _possibleConstructorReturn(this, _getPrototypeOf(Layout).apply(this, arguments));
  }

  _createClass(Layout, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          sectioned = _this$props.sectioned;
      var content = sectioned ? React.createElement(Section$4, null, children) : children;
      return React.createElement("div", {
        className: styles$1a.Layout
      }, content);
    }
  }]);

  return Layout;
}(React.Component);
Layout.AnnotatedSection = AnnotatedSection;
Layout.Section = Section$4;

var styles$1b = {
  "List": "Polaris-List",
  "typeNumber": "Polaris-List--typeNumber",
  "Item": "Polaris-List__Item",
};

function Item$5(_ref) {
  var children = _ref.children;
  return React.createElement("li", {
    className: styles$1b.Item
  }, children);
}

var ContentList =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(ContentList, _React$PureComponent);

  function ContentList() {
    _classCallCheck(this, ContentList);

    return _possibleConstructorReturn(this, _getPrototypeOf(ContentList).apply(this, arguments));
  }

  _createClass(ContentList, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          _this$props$type = _this$props.type,
          type = _this$props$type === void 0 ? 'bullet' : _this$props$type;
      var className = styles.classNames(styles$1b.List, type && styles$1b[styles.variationName('type', type)]);
      var ListElement = type === 'bullet' ? 'ul' : 'ol';
      return React.createElement(ListElement, {
        className: className
      }, children);
    }
  }]);

  return ContentList;
}(React.PureComponent);
ContentList.Item = Item$5;

var Loading$1 =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Loading, _React$PureComponent);

  function Loading() {
    _classCallCheck(this, Loading);

    return _possibleConstructorReturn(this, _getPrototypeOf(Loading).apply(this, arguments));
  }

  _createClass(Loading, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var appBridge = this.props.polaris.appBridge;

      if (appBridge == null) {
        this.context.frame.startLoading();
      } else {
        this.appBridgeLoading = actions.Loading.create(appBridge);
        this.appBridgeLoading.dispatch(actions.Loading.Action.START);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var appBridge = this.props.polaris.appBridge;

      if (appBridge == null) {
        this.context.frame.stopLoading();
      } else if (this.appBridgeLoading != null) {
        this.appBridgeLoading.dispatch(actions.Loading.Action.STOP);
      }
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);

  return Loading;
}(React.PureComponent);
Loading$1.contextTypes = frameContextTypes;
var Loading$2 = withAppProvider()(Loading$1);

// This path comment acts as a unique ID

var contextTypes$2 = {
  location: PropTypes.string,
  onNavigationDismiss: PropTypes.func
};

var styles$1c = {
  "Indicator": "Polaris-Indicator",
  "pulseIndicator": "Polaris-Indicator--pulseIndicator",
  "bounce": "Polaris-Indicator--bounce",
  "pulse": "Polaris-Indicator--pulse",
};

function Indicator(_ref) {
  var _ref$pulse = _ref.pulse,
      pulse = _ref$pulse === void 0 ? true : _ref$pulse;
  var className = styles.classNames(styles$1c.Indicator, pulse && styles$1c.pulseIndicator);
  return React.createElement("span", {
    className: className
  });
}

var styles$1d = {
  "Navigation": "Polaris-Navigation",
  "UserMenu": "Polaris-Navigation__UserMenu",
  "ContextControl": "Polaris-Navigation__ContextControl",
  "PrimaryNavigation": "Polaris-Navigation__PrimaryNavigation",
  "Item": "Polaris-Navigation__Item",
  "Icon": "Polaris-Navigation__Icon",
  "Item-selected": "Polaris-Navigation__Item--selected",
  "Item-disabled": "Polaris-Navigation__Item--disabled",
  "Badge": "Polaris-Navigation__Badge",
  "subNavigationActive": "Polaris-Navigation--subNavigationActive",
  "ListItem": "Polaris-Navigation__ListItem",
  "RollupSection": "Polaris-Navigation__RollupSection",
  "SecondaryNavigation": "Polaris-Navigation__SecondaryNavigation",
  "fade-in": "Polaris-Navigation__fade--in",
  "ListItem-hasAction": "Polaris-Navigation__ListItem--hasAction",
  "Text": "Polaris-Navigation__Text",
  "SecondaryAction": "Polaris-Navigation__SecondaryAction",
  "List": "Polaris-Navigation__List",
  "Section": "Polaris-Navigation__Section",
  "Section-fill": "Polaris-Navigation__Section--fill",
  "Section-withSeparator": "Polaris-Navigation__Section--withSeparator",
  "SectionHeading": "Polaris-Navigation__SectionHeading",
  "Action": "Polaris-Navigation__Action",
  "RollupToggle": "Polaris-Navigation__RollupToggle",
  "Indicator": "Polaris-Navigation__Indicator",
};

var createSecondaryNavigationId = other.createUniqueIDFactory('SecondaryNavigation');
function Secondary(_ref) {
  var children = _ref.children,
      expanded = _ref.expanded;
  var secondaryNavigationId = createSecondaryNavigationId();
  return React.createElement(Collapsible$1, {
    id: secondaryNavigationId,
    open: expanded
  }, React.createElement("ul", {
    className: styles$1d.List
  }, children));
}

var MatchState;

(function (MatchState) {
  MatchState[MatchState["MatchForced"] = 0] = "MatchForced";
  MatchState[MatchState["MatchUrl"] = 1] = "MatchUrl";
  MatchState[MatchState["MatchPaths"] = 2] = "MatchPaths";
  MatchState[MatchState["Excluded"] = 3] = "Excluded";
  MatchState[MatchState["NoMatch"] = 4] = "NoMatch";
})(MatchState || (MatchState = {}));

var BaseItem =
/*#__PURE__*/
function (_React$Component) {
  _inherits(BaseItem, _React$Component);

  function BaseItem() {
    var _this;

    _classCallCheck(this, BaseItem);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(BaseItem).apply(this, arguments));
    _this.state = {
      expanded: false
    };

    _this.handleResize = function () {
      if (!navigationBarCollapsed().matches && _this.state.expanded) {
        _this.setState({
          expanded: false
        });
      }
    };

    _this.getClickHandler = function (onClick) {
      return function (event) {
        var currentTarget = event.currentTarget;
        var subNavigationItems = _this.props.subNavigationItems;
        var _this$context = _this.context,
            location = _this$context.location,
            onNavigationDismiss = _this$context.onNavigationDismiss;

        if (currentTarget.getAttribute('href') === location) {
          event.preventDefault();
        }

        if (subNavigationItems && subNavigationItems.length > 0 && navigationBarCollapsed().matches) {
          event.preventDefault();

          _this.setState(function (_ref) {
            var expanded = _ref.expanded;
            return {
              expanded: !expanded
            };
          });
        } else if (onNavigationDismiss) {
          onNavigationDismiss();

          if (onClick && onClick !== onNavigationDismiss) {
            onClick();
          }

          return;
        }

        if (onClick) {
          onClick();
        }
      };
    };

    return _this;
  }

  _createClass(BaseItem, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      navigationBarCollapsed().addListener(this.handleResize);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      navigationBarCollapsed().removeListener(this.handleResize);
    }
  }, {
    key: "render",
    value: function render() {
      var expanded = this.state.expanded;
      var _this$props = this.props,
          url = _this$props.url,
          icon = _this$props.icon,
          label = _this$props.label,
          _this$props$subNaviga = _this$props.subNavigationItems,
          subNavigationItems = _this$props$subNaviga === void 0 ? [] : _this$props$subNaviga,
          secondaryAction = _this$props.secondaryAction,
          disabled = _this$props.disabled,
          onClick = _this$props.onClick,
          accessibilityLabel = _this$props.accessibilityLabel,
          iconBody = _this$props.iconBody,
          selectedOverride = _this$props.selected,
          badge = _this$props.badge,
          isNew = _this$props.new,
          intl = _this$props.polaris.intl;
      var _this$context2 = this.context,
          location = _this$context2.location,
          onNavigationDismiss = _this$context2.onNavigationDismiss;
      var tabIndex = disabled ? -1 : 0;
      var hasNewChild = subNavigationItems.filter(function (subNavigationItem) {
        return subNavigationItem.new;
      }).length > 0;
      var indicatorMarkup = hasNewChild ? React.createElement("span", {
        className: styles$1d.Indicator
      }, React.createElement(Indicator, {
        pulse: true
      })) : null;

      if (iconBody) {
        // eslint-disable-next-line no-console
        console.warn('Deprecation: The iconBody prop is deprecated. Pass a string into the icon prop instead');
      }

      var iconBodyOrIcon = iconBody || icon;
      var iconMarkup = iconBodyOrIcon ? React.createElement("div", {
        className: styles$1d.Icon
      }, React.createElement(Icon$1, {
        source: iconBodyOrIcon
      })) : null;
      var badgeMarkup = null;

      if (isNew) {
        badgeMarkup = React.createElement(Badge$1, {
          status: "new",
          size: "small"
        }, intl.translate('Polaris.Badge.STATUS_LABELS.new'));
      } else if (typeof badge === 'string') {
        badgeMarkup = React.createElement(Badge$1, {
          status: "new",
          size: "small"
        }, badge);
      } else {
        badgeMarkup = badge;
      }

      var wrappedBadgeMarkup = badgeMarkup == null ? null : React.createElement("div", {
        className: styles$1d.Badge
      }, badgeMarkup);
      var itemContentMarkup = React.createElement(React.Fragment, null, iconMarkup, React.createElement("span", {
        className: styles$1d.Text
      }, label, indicatorMarkup), wrappedBadgeMarkup);

      if (url == null) {
        var _className = styles.classNames(styles$1d.Item, disabled && styles$1d['Item-disabled']);

        return React.createElement("li", {
          className: styles$1d.ListItem
        }, React.createElement("button", {
          type: "button",
          className: _className,
          disabled: disabled,
          "aria-disabled": disabled,
          "aria-label": accessibilityLabel,
          onClick: this.getClickHandler(onClick)
        }, itemContentMarkup));
      }

      var secondaryActionMarkup = secondaryAction && React.createElement(UnstyledLink$1, {
        external: true,
        url: secondaryAction.url,
        className: styles$1d.SecondaryAction,
        tabIndex: tabIndex,
        "aria-disabled": disabled,
        "aria-label": secondaryAction.accessibilityLabel
      }, React.createElement(Icon$1, {
        source: secondaryAction.icon
      }));
      var matchState = matchStateForItem(this.props, location);
      var matchingSubNavigationItems = subNavigationItems.filter(function (item) {
        var subMatchState = matchStateForItem(item, location);
        return subMatchState === MatchState.MatchForced || subMatchState === MatchState.MatchUrl || subMatchState === MatchState.MatchPaths;
      });
      var childIsActive = matchingSubNavigationItems.length > 0;
      var selected = selectedOverride == null ? matchState === MatchState.MatchForced || matchState === MatchState.MatchUrl || matchState === MatchState.MatchPaths : selectedOverride;
      var showExpanded = selected || expanded || childIsActive;
      var itemClassName = styles.classNames(styles$1d.Item, disabled && styles$1d['Item-disabled'], selected && subNavigationItems.length === 0 && styles$1d['Item-selected'], showExpanded && styles$1d.subNavigationActive);
      var secondaryNavigationMarkup = null;

      if (subNavigationItems.length > 0 && showExpanded) {
        var longestMatch = matchingSubNavigationItems.sort(function (_ref2, _ref3) {
          var firstUrl = _ref2.url;
          var secondUrl = _ref3.url;
          return secondUrl.length - firstUrl.length;
        })[0];
        secondaryNavigationMarkup = React.createElement("div", {
          className: styles$1d.SecondaryNavigation
        }, React.createElement(Secondary, {
          expanded: showExpanded
        }, subNavigationItems.map(function (item) {
          var label = item.label,
              rest = tslib_1.__rest(item, ["label"]);

          return React.createElement(Item$6, Object.assign({}, rest, {
            key: label,
            label: label,
            matches: item === longestMatch,
            onClick: onNavigationDismiss
          }));
        })));
      }

      var className = styles.classNames(styles$1d.ListItem, secondaryAction && styles$1d['ListItem-hasAction']);
      return React.createElement("li", {
        className: className
      }, React.createElement(UnstyledLink$1, {
        url: url,
        className: itemClassName,
        tabIndex: tabIndex,
        "aria-disabled": disabled,
        "aria-label": accessibilityLabel,
        onClick: this.getClickHandler(onClick)
      }, itemContentMarkup), secondaryActionMarkup, secondaryNavigationMarkup);
    }
  }]);

  return BaseItem;
}(React.Component);
BaseItem.contextTypes = contextTypes$2;
function isNavigationItemActive(navigationItem, currentPath) {
  var matchState = matchStateForItem(navigationItem, currentPath);
  var matchingSubNavigationItems = navigationItem.subNavigationItems && navigationItem.subNavigationItems.filter(function (item) {
    var subMatchState = matchStateForItem(item, currentPath);
    return subMatchState === MatchState.MatchForced || subMatchState === MatchState.MatchUrl || subMatchState === MatchState.MatchPaths;
  });
  var childIsActive = matchingSubNavigationItems && matchingSubNavigationItems.length > 0;
  var selected = matchState === MatchState.MatchForced || matchState === MatchState.MatchUrl || matchState === MatchState.MatchPaths;
  return selected || childIsActive;
}

function normalizePathname(pathname) {
  var barePathname = pathname.split('?')[0].split('#')[0];
  return barePathname.endsWith('/') ? barePathname : "".concat(barePathname, "/");
}

function safeEqual(location, path) {
  return normalizePathname(location) === normalizePathname(path);
}

function safeStartsWith(location, path) {
  return normalizePathname(location).startsWith(normalizePathname(path));
}

function matchStateForItem(_ref4, location) {
  var url = _ref4.url,
      matches = _ref4.matches,
      exactMatch = _ref4.exactMatch,
      matchPaths = _ref4.matchPaths,
      excludePaths = _ref4.excludePaths;

  if (url == null) {
    return MatchState.NoMatch;
  }

  if (matches) {
    return MatchState.MatchForced;
  }

  if (matches === false || excludePaths && excludePaths.some(function (path) {
    return safeStartsWith(location, path);
  })) {
    return MatchState.Excluded;
  }

  if (matchPaths && matchPaths.some(function (path) {
    return safeStartsWith(location, path);
  })) {
    return MatchState.MatchPaths;
  }

  var matchesUrl = exactMatch ? safeEqual(location, url) : safeStartsWith(location, url);
  return matchesUrl ? MatchState.MatchUrl : MatchState.NoMatch;
}

var Item$6 = withAppProvider()(BaseItem);

var createAdditionalItemsId = other.createUniqueIDFactory('AdditionalItems');

var Section$5 =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Section, _React$Component);

  function Section() {
    var _this;

    _classCallCheck(this, Section);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Section).apply(this, arguments));
    _this.state = {
      expanded: false
    };
    _this.animationFrame = null;

    _this.toggleViewAll = function () {
      _this.setState(function (_ref) {
        var expanded = _ref.expanded;
        return {
          expanded: !expanded
        };
      });
    };

    return _this;
  }

  _createClass(Section, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.animationFrame) {
        cancelAnimationFrame(this.animationFrame);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          title = _this$props.title,
          fill = _this$props.fill,
          action = _this$props.action,
          items = _this$props.items,
          rollup = _this$props.rollup,
          separator = _this$props.separator;
      var expanded = this.state.expanded;
      var className = styles.classNames(styles$1d.Section, separator && styles$1d['Section-withSeparator'], fill && styles$1d['Section-fill']);
      var actionMarkup = action && React.createElement("button", {
        type: "button",
        className: styles$1d.Action,
        "aria-label": action.accessibilityLabel,
        onClick: action.onClick
      }, React.createElement(Icon$1, {
        source: action.icon
      }));
      var sectionHeadingMarkup = title && React.createElement("li", {
        className: styles$1d.SectionHeading
      }, React.createElement("span", {
        className: styles$1d.Text
      }, title), actionMarkup);
      var itemsMarkup = items.map(function (item) {
        var onClick = item.onClick,
            label = item.label,
            rest = tslib_1.__rest(item, ["onClick", "label"]);

        return React.createElement(Item$6, Object.assign({}, rest, {
          key: label,
          label: label,
          onClick: _this2.handleClick(onClick)
        }));
      });
      var toggleClassName = styles.classNames(styles$1d.Item, styles$1d.RollupToggle);
      var ariaLabel = rollup && (expanded ? rollup.hide : rollup.view);
      var toggleRollup = rollup && items.length > rollup.after && React.createElement("div", {
        className: styles$1d.ListItem,
        key: "List Item"
      }, React.createElement("button", {
        type: "button",
        className: toggleClassName,
        onClick: this.toggleViewAll,
        "aria-label": ariaLabel
      }, React.createElement("span", {
        className: styles$1d.Icon
      }, React.createElement(Icon$1, {
        source: polarisIcons.HorizontalDotsMinor
      })), ariaLabel));
      var activeItemIndex = items.findIndex(function (item) {
        if (!rollup) {
          return false;
        }

        return rollup.activePath === item.url || item.url && rollup.activePath.startsWith(item.url) || (item.subNavigationItems ? item.subNavigationItems.some(function (_ref2) {
          var itemUrl = _ref2.url;
          return rollup.activePath.startsWith(itemUrl);
        }) : false);
      });
      var sectionItems = rollup ? itemsMarkup.slice(0, rollup.after) : itemsMarkup;
      var additionalItems = rollup ? itemsMarkup.slice(rollup.after) : [];

      if (rollup && activeItemIndex !== -1 && activeItemIndex > rollup.after - 1) {
        sectionItems.push.apply(sectionItems, _toConsumableArray(additionalItems.splice(activeItemIndex - rollup.after, 1)));
      }

      var additionalItemsId = createAdditionalItemsId();
      var activeItemsMarkup = rollup && additionalItems.length > 0 && React.createElement("li", {
        className: styles$1d.RollupSection
      }, React.createElement(Collapsible$1, {
        id: additionalItemsId,
        open: expanded
      }, React.createElement("ul", {
        className: styles$1d.List
      }, additionalItems)), toggleRollup);
      return React.createElement("ul", {
        className: className
      }, sectionHeadingMarkup, sectionItems, activeItemsMarkup);
    }
  }, {
    key: "handleClick",
    value: function handleClick(onClick) {
      var _this3 = this;

      return function () {
        if (onClick) {
          onClick();
        }

        if (_this3.animationFrame) {
          cancelAnimationFrame(_this3.animationFrame);
        }

        _this3.animationFrame = requestAnimationFrame(function () {
          return _this3.setState({
            expanded: false
          });
        });
      };
    }
  }]);

  return Section;
}(React.Component);
Section$5.contextTypes = contextTypes$2;

/** @deprecated Use <TopBar.UserMenu /> instead. */

var UserMenu$3 =
/*#__PURE__*/
function (_React$Component) {
  _inherits(UserMenu, _React$Component);

  function UserMenu(props) {
    var _this;

    _classCallCheck(this, UserMenu);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(UserMenu).call(this, props));
    _this.state = {
      open: false
    };

    _this.handleToggle = function () {
      var open = _this.state.open;

      _this.setState({
        open: !open
      });
    }; // eslint-disable-next-line no-console


    console.warn('Deprecation: <Navigation.UserMenu /> is deprecated and will be removed in the next major version. Use <TopBar.UserMenu /> instead.');
    return _this;
  }

  _createClass(UserMenu, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          name = _this$props.name,
          detail = _this$props.detail,
          actions$$1 = _this$props.actions,
          message = _this$props.message,
          avatarInitials = _this$props.avatarInitials,
          avatarSource = _this$props.avatarSource;
      var open = this.state.open;
      var userMenuProps = {
        actions: actions$$1 || [],
        message: message,
        name: name || '',
        detail: detail,
        initials: avatarInitials,
        avatar: avatarSource,
        onToggle: this.handleToggle,
        open: open
      };
      return React.createElement(UserMenuModifier, {
        userMenuProps: userMenuProps
      });
    }
  }]);

  return UserMenu;
}(React.Component);

var Navigation$2 =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Navigation, _React$Component);

  function Navigation(props) {
    var _this;

    _classCallCheck(this, Navigation);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Navigation).call(this, props));

    if (props.userMenu) {
      // eslint-disable-next-line no-console
      console.warn('Deprecation: the `userMenu` prop is deprecated and will be removed in the next major version. Pass a user menu into <TopBar /> instead.');
    }

    return _this;
  }

  _createClass(Navigation, [{
    key: "getChildContext",
    value: function getChildContext() {
      return {
        location: this.props.location,
        onNavigationDismiss: this.props.onDismiss
      };
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          userMenu = _this$props.userMenu,
          contextControl = _this$props.contextControl;
      var contextControlMarkup = contextControl && React.createElement("div", {
        className: styles$1d.ContextControl
      }, contextControl);
      return React.createElement("nav", {
        className: styles$1d.Navigation
      }, contextControlMarkup, React.createElement("div", {
        className: styles$1d.UserMenu
      }, userMenu), React.createElement(Scrollable$1, {
        className: styles$1d.PrimaryNavigation
      }, children));
    }
  }]);

  return Navigation;
}(React.Component);
Navigation$2.Item = Item$6;
Navigation$2.UserMenu = UserMenu$3;
Navigation$2.Section = Section$5;
Navigation$2.childContextTypes = contextTypes$2;

var EditableTarget;

(function (EditableTarget) {
  EditableTarget["Input"] = "INPUT";
  EditableTarget["Textarea"] = "TEXTAREA";
  EditableTarget["Select"] = "SELECT";
  EditableTarget["ContentEditable"] = "contenteditable";
})(EditableTarget || (EditableTarget = {}));

function isInputFocused() {
  if (document == null || document.activeElement == null) {
    return false;
  }

  var tagName = document.activeElement.tagName;
  return tagName === EditableTarget.Input || tagName === EditableTarget.Textarea || tagName === EditableTarget.Select || document.activeElement.hasAttribute(EditableTarget.ContentEditable);
}

var styles$1f = {
  "Tooltip": "Polaris-Tooltip",
  "measuring": "Polaris-Tooltip--measuring",
  "positionedAbove": "Polaris-Tooltip--positionedAbove",
  "light": "Polaris-Tooltip--light",
  "Wrapper": "Polaris-Tooltip__Wrapper",
  "Content": "Polaris-Tooltip__Content",
  "Label": "Polaris-Tooltip__Label",
};

var TooltipOverlay =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(TooltipOverlay, _React$PureComponent);

  function TooltipOverlay() {
    var _this;

    _classCallCheck(this, TooltipOverlay);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(TooltipOverlay).apply(this, arguments));

    _this.renderOverlay = function () {
      var _this$props = _this.props,
          active = _this$props.active,
          activator = _this$props.activator,
          _this$props$preferred = _this$props.preferredPosition,
          preferredPosition = _this$props$preferred === void 0 ? 'below' : _this$props$preferred;
      return React.createElement(PositionedOverlay, {
        active: active,
        activator: activator,
        preferredPosition: preferredPosition,
        render: _this.renderTooltip
      });
    };

    _this.renderTooltip = function (overlayDetails) {
      var measuring = overlayDetails.measuring,
          desiredHeight = overlayDetails.desiredHeight,
          positioning = overlayDetails.positioning;
      var _this$props2 = _this.props,
          id = _this$props2.id,
          children = _this$props2.children,
          light = _this$props2.light;
      var containerClassName = styles.classNames(styles$1f.Tooltip, light && styles$1f.light, measuring && styles$1f.measuring, positioning === 'above' && styles$1f.positionedAbove);
      var contentStyles = measuring ? undefined : {
        maxHeight: desiredHeight
      };
      return React.createElement("div", Object.assign({
        className: containerClassName
      }, layer.props), React.createElement("div", {
        className: styles$1f.Wrapper
      }, React.createElement("div", {
        id: id,
        role: "tooltip",
        className: styles$1f.Content,
        style: contentStyles
      }, children)));
    };

    return _this;
  }

  _createClass(TooltipOverlay, [{
    key: "render",
    value: function render() {
      var markup = this.props.active ? this.renderOverlay() : null;
      return markup;
    }
  }]);

  return TooltipOverlay;
}(React.PureComponent);

var getUniqueID$a = other.createUniqueIDFactory('TooltipContent');

var Tooltip =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Tooltip, _React$PureComponent);

  function Tooltip() {
    var _this;

    _classCallCheck(this, Tooltip);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Tooltip).apply(this, arguments));
    _this.state = {
      active: Boolean(_this.props.active),
      activatorNode: null
    };
    _this.id = getUniqueID$a();

    _this.setActivator = function (node) {
      if (node == null) {
        _this.activatorContainer = null;

        _this.setState({
          activatorNode: null
        });

        return;
      }

      _this.setState({
        activatorNode: node.firstElementChild
      });

      _this.activatorContainer = node;
    };

    _this.handleFocus = function () {
      _this.setState({
        active: true
      });
    };

    _this.handleBlur = function () {
      _this.setState({
        active: false
      });
    };

    _this.handleMouseEnter = function () {
      _this.setState({
        active: true
      });
    };

    _this.handleMouseLeave = function () {
      _this.setState({
        active: false
      });
    };

    return _this;
  }

  _createClass(Tooltip, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setAccessibilityAttributes();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.setAccessibilityAttributes();
    }
  }, {
    key: "render",
    value: function render() {
      var id = this.id;
      var _this$props = this.props,
          children = _this$props.children,
          content = _this$props.content,
          light = _this$props.light,
          _this$props$preferred = _this$props.preferredPosition,
          preferredPosition = _this$props$preferred === void 0 ? 'below' : _this$props$preferred,
          _this$props$activator = _this$props.activatorWrapper,
          WrapperComponent = _this$props$activator === void 0 ? 'span' : _this$props$activator;
      var _this$state = this.state,
          active = _this$state.active,
          activatorNode = _this$state.activatorNode;
      var portal = activatorNode ? React.createElement(Portal, {
        idPrefix: "tooltip"
      }, React.createElement(TooltipOverlay, {
        id: id,
        preferredPosition: preferredPosition,
        activator: activatorNode,
        active: active,
        onClose: other.noop,
        light: light
      }, React.createElement("div", {
        className: styles$1f.Label
      }, content))) : null;
      return React.createElement(WrapperComponent, {
        onFocus: this.handleFocus,
        onBlur: this.handleBlur,
        onMouseEnter: this.handleMouseEnter,
        onMouseLeave: this.handleMouseLeave,
        ref: this.setActivator
      }, children, portal);
    }
  }, {
    key: "setAccessibilityAttributes",
    value: function setAccessibilityAttributes() {
      var activatorContainer = this.activatorContainer,
          id = this.id;

      if (activatorContainer == null) {
        return;
      }

      var firstFocusable = focus.findFirstFocusableNode(activatorContainer);
      var accessibilityNode = firstFocusable || activatorContainer;
      accessibilityNode.tabIndex = 0;
      accessibilityNode.setAttribute('aria-describedby', id);
    }
  }]);

  return Tooltip;
}(React.PureComponent);

var styles$1g = {
  "Pagination": "Polaris-Pagination",
  "plain": "Polaris-Pagination--plain",
  "Button": "Polaris-Pagination__Button",
};

function Pagination(_ref) {
  var hasNext = _ref.hasNext,
      hasPrevious = _ref.hasPrevious,
      nextURL = _ref.nextURL,
      previousURL = _ref.previousURL,
      onNext = _ref.onNext,
      onPrevious = _ref.onPrevious,
      nextTooltip = _ref.nextTooltip,
      previousTooltip = _ref.previousTooltip,
      nextKeys = _ref.nextKeys,
      previousKeys = _ref.previousKeys,
      plain = _ref.plain,
      accessibilityLabel = _ref.accessibilityLabel,
      intl = _ref.polaris.intl;
  var node = React.createRef();
  var label;

  if (accessibilityLabel) {
    label = accessibilityLabel;
  } else {
    label = intl.translate('Polaris.Pagination.pagination');
  }

  var className = reactUtilities.classNames(styles$1g.Pagination, plain && styles$1g.plain);
  var previousButton = previousURL ? React.createElement(UnstyledLink$1, {
    className: styles$1g.Button,
    url: previousURL,
    onMouseUp: handleMouseUpByBlurring,
    "aria-label": intl.translate('Polaris.Pagination.previous'),
    id: "previousURL"
  }, React.createElement(Icon$1, {
    source: polarisIcons.ArrowLeftMinor
  })) : React.createElement("button", {
    onClick: onPrevious,
    type: "button",
    onMouseUp: handleMouseUpByBlurring,
    className: styles$1g.Button,
    "aria-label": intl.translate('Polaris.Pagination.previous'),
    disabled: !hasPrevious
  }, React.createElement(Icon$1, {
    source: polarisIcons.ArrowLeftMinor
  }));
  var nextButton = nextURL ? React.createElement(UnstyledLink$1, {
    className: styles$1g.Button,
    url: nextURL,
    onMouseUp: handleMouseUpByBlurring,
    "aria-label": intl.translate('Polaris.Pagination.next'),
    id: "nextURL"
  }, React.createElement(Icon$1, {
    source: polarisIcons.ArrowRightMinor
  })) : React.createElement("button", {
    onClick: onNext,
    type: "button",
    onMouseUp: handleMouseUpByBlurring,
    className: styles$1g.Button,
    "aria-label": intl.translate('Polaris.Pagination.next'),
    disabled: !hasNext
  }, React.createElement(Icon$1, {
    source: polarisIcons.ArrowRightMinor
  }));
  var constructedPrevious = previousTooltip ? React.createElement(Tooltip, {
    content: previousTooltip
  }, previousButton) : previousButton;
  var constructedNext = nextTooltip ? React.createElement(Tooltip, {
    content: nextTooltip
  }, nextButton) : nextButton;
  var previousButtonEvents = previousKeys && (previousURL || onPrevious) && hasPrevious && previousKeys.map(function (key) {
    return React.createElement(KeypressListener, {
      key: key,
      keyCode: key,
      handler: previousURL ? handleCallback(clickPaginationLink('previousURL', node)) : handleCallback(onPrevious)
    });
  });
  var nextButtonEvents = nextKeys && (nextURL || onNext) && hasNext && nextKeys.map(function (key) {
    return React.createElement(KeypressListener, {
      key: key,
      keyCode: key,
      handler: nextURL ? handleCallback(clickPaginationLink('nextURL', node)) : handleCallback(onNext)
    });
  });
  return React.createElement("nav", {
    className: className,
    "aria-label": label,
    ref: node
  }, previousButtonEvents, constructedPrevious, nextButtonEvents, constructedNext);
}

function clickPaginationLink(id, node) {
  return function () {
    if (node.current == null) {
      return;
    }

    var link = node.current.querySelector("#".concat(id));

    if (link) {
      link.click();
    }
  };
}

function handleCallback(fn) {
  return function () {
    if (isInputFocused()) {
      return;
    }

    fn();
  };
}

var Pagination$1 = withAppProvider()(Pagination);

var styles$1h = {
  "Action": "Polaris-Header-Action",
  "ActionIcon": "Polaris-Header-Action__ActionIcon",
  "disabled": "Polaris-Header-Action--disabled",
  "ActionContent": "Polaris-Header-Action__ActionContent",
  "Action-outline": "Polaris-Header-Action__Action--outline",
};

function Action(_ref) {
  var icon = _ref.icon,
      url = _ref.url,
      external = _ref.external,
      onAction = _ref.onAction,
      children = _ref.children,
      disclosure = _ref.disclosure,
      accessibilityLabel = _ref.accessibilityLabel,
      disabled = _ref.disabled;
  var iconMarkup = icon && React.createElement("span", {
    className: styles$1h.ActionIcon
  }, React.createElement(Icon$1, {
    source: icon
  }));
  var disclosureIconMarkup = disclosure && React.createElement("span", {
    className: styles$1h.ActionIcon
  }, React.createElement(Icon$1, {
    source: polarisIcons.CaretDownMinor
  }));
  var contentMarkup = iconMarkup || disclosureIconMarkup ? React.createElement("span", {
    className: styles$1h.ActionContent
  }, iconMarkup, React.createElement("span", null, children), disclosureIconMarkup) : children;

  if (url) {
    return React.createElement(UnstyledLink$1, {
      key: children,
      external: external,
      url: url,
      onMouseUp: handleMouseUpByBlurring,
      className: styles$1h.Action,
      "aria-label": accessibilityLabel
    }, contentMarkup);
  }

  var className = reactUtilities.classNames(styles$1h.Action, disabled && styles$1h.disabled, icon && children == null && styles$1h.iconOnly);
  return React.createElement("button", {
    key: children,
    className: className,
    onClick: onAction,
    onMouseUp: handleMouseUpByBlurring,
    "aria-label": accessibilityLabel,
    type: "button",
    disabled: disabled
  }, contentMarkup);
}

var styles$1i = {
  "Details": "Polaris-Header-ActionGroup__Details",
  "withActions": "Polaris-Header-ActionGroup--withActions",
};

var ActionGroup =
/*#__PURE__*/
function (_React$Component) {
  _inherits(ActionGroup, _React$Component);

  function ActionGroup() {
    var _this;

    _classCallCheck(this, ActionGroup);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ActionGroup).apply(this, arguments));

    _this.handleClose = function () {
      var _this$props = _this.props,
          title = _this$props.title,
          onClose = _this$props.onClose;
      onClose(title);
    };

    _this.handleOpen = function () {
      var _this$props2 = _this.props,
          title = _this$props2.title,
          onOpen = _this$props2.onOpen;
      onOpen(title);
    };

    return _this;
  }

  _createClass(ActionGroup, [{
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          actions$$1 = _this$props3.actions,
          details = _this$props3.details,
          title = _this$props3.title,
          icon = _this$props3.icon,
          active = _this$props3.active;
      var detailsMarkup = details && React.createElement("div", {
        className: styles$1i.Details
      }, details);
      return React.createElement("div", {
        className: styles$1i.ActionGroup,
        key: "ActionGroup-".concat(title)
      }, React.createElement(Popover, {
        key: title,
        active: active,
        onClose: this.handleClose,
        activator: React.createElement(Action, {
          disclosure: true,
          icon: icon,
          onAction: this.handleOpen
        }, title)
      }, React.createElement(ActionList, {
        items: actions$$1,
        onActionAnyItem: this.handleClose
      }), detailsMarkup));
    }
  }]);

  return ActionGroup;
}(React.Component);

var styles$1j = {
  "Header": "Polaris-Page-Header",
  "Header-hasPagination": "Polaris-Page-Header__Header--hasPagination",
  "Header-hasBreadcrumbs": "Polaris-Page-Header__Header--hasBreadcrumbs",
  "Header-hasRollup": "Polaris-Page-Header__Header--hasRollup",
  "Header-hasSecondaryActions": "Polaris-Page-Header__Header--hasSecondaryActions",
  "Header-hasSeparator": "Polaris-Page-Header__Header--hasSeparator",
  "Content": "Polaris-Page-Header__Content",
  "SecondaryActions": "Polaris-Page-Header__SecondaryActions",
  "IndividualActions": "Polaris-Page-Header__IndividualActions",
  "Pagination": "Polaris-Page-Header__Pagination",
  "Rollup": "Polaris-Page-Header__Rollup",
  "Title-hidden": "Polaris-Page-Header__Title--hidden",
  "PrimaryAction": "Polaris-Page-Header__PrimaryAction",
  "MainContent": "Polaris-Page-Header__MainContent",
  "Actions": "Polaris-Page-Header__Actions",
  "Navigation": "Polaris-Page-Header__Navigation",
  "TitleAndRollup": "Polaris-Page-Header__TitleAndRollup",
  "TitleAndActions": "Polaris-Page-Header__TitleAndActions",
  "Title": "Polaris-Page-Header__Title",
  "IndividualAction": "Polaris-Page-Header__IndividualAction",
};

var Header$2 =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Header, _React$PureComponent);

  function Header() {
    var _this;

    _classCallCheck(this, Header);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Header).apply(this, arguments));
    _this.state = {
      rollupOpen: false
    };

    _this.renderRollupAction = function () {
      var rollupOpen = _this.state.rollupOpen;
      var _this$props = _this.props,
          _this$props$secondary = _this$props.secondaryActions,
          secondaryActions = _this$props$secondary === void 0 ? [] : _this$props$secondary,
          _this$props$actionGro = _this$props.actionGroups,
          actionGroups = _this$props$actionGro === void 0 ? [] : _this$props$actionGro;
      var rollupMarkup = _this.hasRollup ? React.createElement("div", {
        className: styles$1j.Rollup
      }, React.createElement(Popover, {
        active: rollupOpen,
        onClose: _this.handleRollupToggle,
        activator: React.createElement(Button$1, {
          plain: true,
          icon: polarisIcons.HorizontalDotsMinor,
          onClick: _this.handleRollupToggle
        })
      }, React.createElement(ActionList, {
        items: secondaryActions,
        sections: actionGroups.map(convertActionGroupToActionListSection),
        onActionAnyItem: _this.handleRollupToggle
      }))) : null;
      return rollupMarkup;
    };

    _this.renderSecondaryActions = function () {
      var openActionGroup = _this.state.openActionGroup;
      var _this$props2 = _this.props,
          _this$props2$secondar = _this$props2.secondaryActions,
          secondaryActions = _this$props2$secondar === void 0 ? [] : _this$props2$secondar,
          _this$props2$actionGr = _this$props2.actionGroups,
          actionGroups = _this$props2$actionGr === void 0 ? [] : _this$props2$actionGr;

      if (secondaryActions.length === 0 && actionGroups.length === 0) {
        return null;
      }

      var secondaryActionMarkup = secondaryActions.length > 0 ? secondaryActionsFrom(secondaryActions) : null;
      var actionGroupsMarkup = actionGroups.length > 0 ? actionGroups.map(function (_ref, index) {
        var title = _ref.title,
            icon = _ref.icon,
            actions$$1 = _ref.actions,
            details = _ref.details;
        return React.createElement("div", {
          className: styles$1j.IndividualAction,
          key: "ActionGroup-".concat(title, "-").concat(index)
        }, React.createElement(ActionGroup, {
          title: title,
          icon: icon,
          actions: actions$$1,
          details: details,
          onOpen: _this.handleActionGroupOpen,
          onClose: _this.handleActionGroupClose,
          active: title === openActionGroup
        }));
      }) : null;
      return React.createElement("div", {
        className: styles$1j.SecondaryActions
      }, React.createElement("div", {
        className: styles$1j.IndividualActions
      }, secondaryActionMarkup, actionGroupsMarkup));
    };

    _this.handleRollupToggle = function () {
      _this.setState(function (_ref2) {
        var rollupOpen = _ref2.rollupOpen;
        return {
          rollupOpen: !rollupOpen
        };
      });
    };

    _this.handleActionGroupClose = function (group) {
      _this.setState(function (_ref3) {
        var openActionGroup = _ref3.openActionGroup;
        return openActionGroup === group ? {
          openActionGroup: undefined
        } : {};
      });
    };

    _this.handleActionGroupOpen = function (group) {
      _this.setState({
        openActionGroup: group
      });
    };

    return _this;
  }

  _createClass(Header, [{
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          title = _this$props3.title,
          titleMetadata = _this$props3.titleMetadata,
          _this$props3$breadcru = _this$props3.breadcrumbs,
          breadcrumbs = _this$props3$breadcru === void 0 ? [] : _this$props3$breadcru,
          _this$props3$titleHid = _this$props3.titleHidden,
          titleHidden = _this$props3$titleHid === void 0 ? false : _this$props3$titleHid,
          primaryAction = _this$props3.primaryAction,
          pagination = _this$props3.pagination,
          separator = _this$props3.separator,
          secondaryActions = _this$props3.secondaryActions,
          icon = _this$props3.icon,
          actionGroups = _this$props3.actionGroups,
          intl = _this$props3.polaris.intl;

      if (icon) {
        // eslint-disable-next-line no-console
        console.warn(intl.translate('Polaris.Page.Header.iconWarningMessage'));
      }

      var className = styles.classNames(styles$1j.Header, titleHidden && styles$1j['Title-hidden'], pagination && styles$1j['Header-hasPagination'], separator && styles$1j['Header-hasSeparator'], breadcrumbs && breadcrumbs.length && styles$1j['Header-hasBreadcrumbs'], this.hasRollup && styles$1j['Header-hasRollup'], secondaryActions && secondaryActions.length && styles$1j['Header-hasSecondaryActions']);
      var breadcrumbMarkup = breadcrumbs.length > 0 ? React.createElement(Breadcrumbs, {
        breadcrumbs: breadcrumbs
      }) : null;
      var primary = primaryAction && (primaryAction.primary === undefined ? true : primaryAction.primary);
      var primaryActionMarkup = primaryAction ? React.createElement("div", {
        className: styles$1j.PrimaryAction
      }, buttonsFrom(primaryAction, {
        primary: primary
      })) : null;
      var paginationMarkup = pagination ? React.createElement("div", {
        className: styles$1j.Pagination
      }, React.createElement(Pagination$1, Object.assign({}, pagination, {
        plain: true
      }))) : null;
      var rollupMarkup = this.renderRollupAction();
      var nonPrimaryActionsMarkup = this.renderSecondaryActions();
      var actionsMarkup = primaryAction || secondaryActions || actionGroups ? React.createElement("div", {
        className: styles$1j.Actions
      }, nonPrimaryActionsMarkup, primaryActionMarkup) : null;
      var navigationMarkup = breadcrumbMarkup || paginationMarkup ? React.createElement("div", {
        className: styles$1j.Navigation
      }, breadcrumbMarkup, paginationMarkup, breadcrumbMarkup && rollupMarkup) : null;
      var titleMarkup = React.createElement("div", {
        className: styles$1j.TitleAndRollup
      }, React.createElement("div", {
        className: styles$1j.Title
      }, React.createElement("div", null, React.createElement(DisplayText, {
        size: "large",
        element: "h1"
      }, title)), React.createElement("div", null, titleMetadata)), !breadcrumbMarkup && rollupMarkup);
      return primaryActionMarkup ? React.createElement("div", {
        className: className
      }, navigationMarkup, React.createElement("div", {
        className: styles$1j.MainContent
      }, React.createElement("div", {
        className: styles$1j.TitleAndActions
      }, titleMarkup, actionsMarkup), primaryActionMarkup)) : React.createElement("div", {
        className: className
      }, navigationMarkup, titleMarkup, actionsMarkup);
    }
  }, {
    key: "hasRollup",
    get: function get() {
      var _this$props4 = this.props,
          _this$props4$secondar = _this$props4.secondaryActions,
          secondaryActions = _this$props4$secondar === void 0 ? [] : _this$props4$secondar,
          _this$props4$actionGr = _this$props4.actionGroups,
          actionGroups = _this$props4$actionGr === void 0 ? [] : _this$props4$actionGr;
      return secondaryActions.length + actionGroups.length >= 1;
    }
  }]);

  return Header;
}(React.PureComponent);

function convertActionGroupToActionListSection(_ref4) {
  var title = _ref4.title,
      actions$$1 = _ref4.actions;
  return {
    title: title,
    items: actions$$1
  };
}

function secondaryActionsFrom(actions$$1) {
  return actions$$1.map(function (_a, index) {
    var content = _a.content,
        action = tslib_1.__rest(_a, ["content"]);

    return React.createElement("div", {
      className: styles$1j.IndividualAction,
      key: "Action-".concat(content || index)
    }, React.createElement(Action, action, content));
  });
}

var Header$3 = withAppProvider()(Header$2);

var styles$1k = {
  "Page": "Polaris-Page",
  "fullWidth": "Polaris-Page--fullWidth",
  "singleColumn": "Polaris-Page--singleColumn",
  "Content": "Polaris-Page__Content",
};

var APP_BRIDGE_PROPS$1 = ['title', 'breadcrumbs', 'secondaryActions', 'actionGroups', 'primaryAction'];
var Page =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Page, _React$PureComponent);

  function Page() {
    _classCallCheck(this, Page);

    return _possibleConstructorReturn(this, _getPrototypeOf(Page).apply(this, arguments));
  }

  _createClass(Page, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.delegateToAppbridge === false) {
        return;
      }

      this.titlebar = actions.TitleBar.create(this.props.polaris.appBridge, this.transformProps());
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.titlebar == null || this.delegateToAppbridge === false) {
        return;
      }

      var prevAppBridgeProps = pick(prevProps, APP_BRIDGE_PROPS$1);
      var currentAppBridgeProps = pick(this.props, APP_BRIDGE_PROPS$1);

      if (!isEqual(prevAppBridgeProps, currentAppBridgeProps)) {
        this.titlebar.unsubscribe();
        this.titlebar.set(this.transformProps());
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.titlebar == null || this.delegateToAppbridge === false) {
        return;
      }

      this.titlebar.unsubscribe();
    }
  }, {
    key: "render",
    value: function render() {
      var _a = this.props,
          children = _a.children,
          fullWidth = _a.fullWidth,
          singleColumn = _a.singleColumn,
          rest = tslib_1.__rest(_a, ["children", "fullWidth", "singleColumn"]);

      var className = styles.classNames(styles$1k.Page, fullWidth && styles$1k.fullWidth, singleColumn && styles$1k.singleColumn);
      var headerMarkup = this.delegateToAppbridge || this.hasHeaderContent() === false ? null : React.createElement(Header$3, rest);
      return React.createElement("div", {
        className: className
      }, headerMarkup, React.createElement("div", {
        className: styles$1k.Content
      }, children));
    }
  }, {
    key: "hasHeaderContent",
    value: function hasHeaderContent() {
      var _this$props = this.props,
          title = _this$props.title,
          primaryAction = _this$props.primaryAction,
          secondaryActions = _this$props.secondaryActions,
          actionGroups = _this$props.actionGroups,
          breadcrumbs = _this$props.breadcrumbs;
      return title != null && title !== '' || primaryAction != null || secondaryActions != null && secondaryActions.length > 0 || actionGroups != null && actionGroups.length > 0 || breadcrumbs != null && breadcrumbs.length > 0;
    }
  }, {
    key: "transformProps",
    value: function transformProps() {
      var appBridge = this.props.polaris.appBridge;
      var _this$props2 = this.props,
          title = _this$props2.title,
          primaryAction = _this$props2.primaryAction,
          secondaryActions = _this$props2.secondaryActions,
          actionGroups = _this$props2.actionGroups;
      return {
        title: title,
        buttons: transformActions(appBridge, {
          primaryAction: primaryAction,
          secondaryActions: secondaryActions,
          actionGroups: actionGroups
        }),
        breadcrumbs: this.transformBreadcrumbs()
      };
    }
  }, {
    key: "transformBreadcrumbs",
    value: function transformBreadcrumbs() {
      var appBridge = this.props.polaris.appBridge;
      var breadcrumbs = this.props.breadcrumbs;

      if (breadcrumbs != null && breadcrumbs.length > 0) {
        var breadcrumb = breadcrumbs[breadcrumbs.length - 1];
        var button = actions.Button.create(appBridge, {
          label: breadcrumb.content || ''
        });
        var callback = !('url' in breadcrumb) ? breadcrumb.onAction : generateRedirect(appBridge, breadcrumb.url, breadcrumb.target);

        if (callback != null) {
          button.subscribe(actions.Button.Action.CLICK, callback);
        }

        return button;
      } else {
        return undefined;
      }
    }
  }, {
    key: "delegateToAppbridge",
    get: function get() {
      var _this$props3 = this.props,
          appBridge = _this$props3.polaris.appBridge,
          _this$props3$forceRen = _this$props3.forceRender,
          forceRender = _this$props3$forceRen === void 0 ? false : _this$props3$forceRen;
      return appBridge != null && forceRender === false;
    }
  }]);

  return Page;
}(React.PureComponent);
var Page$1 = withAppProvider()(Page);

var styles$1l = {
  "PageActions": "Polaris-PageActions",
};

function PageActions(_ref) {
  var primaryAction = _ref.primaryAction,
      secondaryActions = _ref.secondaryActions;
  var primaryActionMarkup = primaryAction ? buttonsFrom(primaryAction, {
    primary: true
  }) : null;
  var secondaryActionsMarkup = secondaryActions ? React.createElement(ButtonGroup, null, buttonsFrom(secondaryActions)) : null;
  var distribution = secondaryActionsMarkup ? 'equalSpacing' : 'trailing';
  return React.createElement("div", {
    className: styles$1l.PageActions
  }, React.createElement(Stack, {
    distribution: distribution,
    spacing: "tight"
  }, secondaryActionsMarkup, primaryActionMarkup));
}

var styles$1m = {
  "RangeSlider": "Polaris-RangeSlider",
  "disabled": "Polaris-RangeSlider--disabled",
  "InputWrapper": "Polaris-RangeSlider__InputWrapper",
  "Prefix": "Polaris-RangeSlider__Prefix",
  "Suffix": "Polaris-RangeSlider__Suffix",
  "Input": "Polaris-RangeSlider__Input",
  "error": "Polaris-RangeSlider--error",
  "Output": "Polaris-RangeSlider__Output",
  "OutputBubble": "Polaris-RangeSlider__OutputBubble",
  "OutputText": "Polaris-RangeSlider__OutputText",
};

var getUniqueID$b = other.createUniqueIDFactory('RangeSlider');
var cssVarPrefix = '--Polaris-RangeSlider-';
var RangeSlider =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(RangeSlider, _React$PureComponent);

  function RangeSlider(props) {
    var _this;

    _classCallCheck(this, RangeSlider);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(RangeSlider).call(this, props));

    _this.handleChange = function (event) {
      var onChange = _this.props.onChange;

      if (onChange == null) {
        return;
      }

      onChange(parseFloat(event.currentTarget.value), _this.state.id);
    };

    _this.state = {
      id: props.id || getUniqueID$b()
    };
    return _this;
  }

  _createClass(RangeSlider, [{
    key: "render",
    value: function render() {
      var _cssVars;

      var id = this.state.id;
      var _this$props = this.props,
          _this$props$min = _this$props.min,
          min = _this$props$min === void 0 ? 0 : _this$props$min,
          _this$props$max = _this$props.max,
          max = _this$props$max === void 0 ? 100 : _this$props$max;
      var _this$props2 = this.props,
          label = _this$props2.label,
          labelAction = _this$props2.labelAction,
          labelHidden = _this$props2.labelHidden,
          step = _this$props2.step,
          value = _this$props2.value,
          output = _this$props2.output,
          helpText = _this$props2.helpText,
          error = _this$props2.error,
          disabled = _this$props2.disabled,
          prefix = _this$props2.prefix,
          suffix = _this$props2.suffix,
          onFocus = _this$props2.onFocus,
          onBlur = _this$props2.onBlur;
      var describedBy = [];

      if (error) {
        describedBy.push("".concat(id, "Error"));
      }

      if (helpText) {
        describedBy.push(helpTextID(id));
      }

      var ariaDescribedBy = describedBy.length ? describedBy.join(' ') : undefined;
      var sliderProgress = (value - min) * 100 / (max - min);
      var cssVars = (_cssVars = {}, _defineProperty(_cssVars, "".concat(cssVarPrefix, "min"), min), _defineProperty(_cssVars, "".concat(cssVarPrefix, "max"), max), _defineProperty(_cssVars, "".concat(cssVarPrefix, "current"), value), _defineProperty(_cssVars, "".concat(cssVarPrefix, "progress"), "".concat(sliderProgress, "%")), _defineProperty(_cssVars, "".concat(cssVarPrefix, "output-factor"), invertNumber((sliderProgress - 50) / 100)), _cssVars);
      var outputMarkup = !disabled && output && React.createElement("output", {
        htmlFor: id,
        className: styles$1m.Output
      }, React.createElement("div", {
        className: styles$1m.OutputBubble
      }, React.createElement("span", {
        className: styles$1m.OutputText
      }, value)));
      var prefixMarkup = prefix && React.createElement("div", {
        className: styles$1m.Prefix
      }, prefix);
      var suffixMarkup = suffix && React.createElement("div", {
        className: styles$1m.Suffix
      }, suffix);
      var className = styles.classNames(styles$1m.RangeSlider, error && styles$1m.error, disabled && styles$1m.disabled);
      return React.createElement(Labelled, {
        id: id,
        label: label,
        error: error,
        action: labelAction,
        labelHidden: labelHidden,
        helpText: helpText
      }, React.createElement("div", {
        className: className,
        style: cssVars
      }, prefixMarkup, React.createElement("div", {
        className: styles$1m.InputWrapper
      }, React.createElement("input", {
        type: "range",
        className: styles$1m.Input,
        id: id,
        name: id,
        min: min,
        max: max,
        step: step,
        value: value,
        disabled: disabled,
        onChange: this.handleChange,
        onFocus: onFocus,
        onBlur: onBlur,
        "aria-valuemin": min,
        "aria-valuemax": max,
        "aria-valuenow": value,
        "aria-invalid": Boolean(error),
        "aria-describedby": ariaDescribedBy
      }), outputMarkup), suffixMarkup));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      return nextProps.id != null && nextProps.id !== prevState.id ? {
        id: nextProps.id || prevState.id
      } : null;
    }
  }]);

  return RangeSlider;
}(React.PureComponent);
function invertNumber(number) {
  if (Math.sign(number) === 1) {
    return -Math.abs(number);
  } else if (Math.sign(number) === -1) {
    return Math.abs(number);
  } else {
    return 0;
  }
}
var RangeSlider$1 = withAppProvider()(RangeSlider);

var Sticky =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Sticky, _React$Component);

  function Sticky() {
    var _this;

    _classCallCheck(this, Sticky);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Sticky).apply(this, arguments));
    _this.state = {
      isSticky: false,
      style: {}
    };
    _this.placeHolderNode = null;
    _this.stickyNode = null;

    _this.setPlaceHolderNode = function (node) {
      _this.placeHolderNode = node;
    };

    _this.setStickyNode = function (node) {
      _this.stickyNode = node;
    };

    _this.handlePositioning = function (stick) {
      var top = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var left = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var width = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      var isSticky = _this.state.isSticky;

      if (stick && !isSticky || !stick && isSticky) {
        _this.adjustPlaceHolderNode(stick);

        _this.setState({
          isSticky: !isSticky
        });
      }

      var style = stick ? {
        position: 'fixed',
        top: top,
        left: left,
        width: width
      } : {};

      _this.setState({
        style: style
      });
    };

    _this.adjustPlaceHolderNode = function (add) {
      if (_this.placeHolderNode && _this.stickyNode) {
        _this.placeHolderNode.style.paddingBottom = add ? "".concat(geometry.getRectForNode(_this.stickyNode).height, "px") : '0px';
      }
    };

    return _this;
  }

  _createClass(Sticky, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var stickyManager = this.context.polaris.stickyManager;
      var _this$props = this.props,
          boundingElement = _this$props.boundingElement,
          offset = _this$props.offset,
          disableWhenStacked = _this$props.disableWhenStacked;
      stickyManager.registerStickyItem({
        stickyNode: this.stickyNode,
        placeHolderNode: this.placeHolderNode,
        handlePositioning: this.handlePositioning,
        offset: offset,
        boundingElement: boundingElement,
        disableWhenStacked: disableWhenStacked
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var stickyManager = this.context.polaris.stickyManager;
      stickyManager.unregisterStickyItem(this.stickyNode);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state = this.state,
          style = _this$state.style,
          isSticky = _this$state.isSticky;
      var children = this.props.children;
      var childrenContent = isFunction(children) ? children(isSticky) : children;
      return React.createElement("div", null, React.createElement("div", {
        ref: this.setPlaceHolderNode
      }), React.createElement("div", {
        ref: this.setStickyNode,
        style: style
      }, childrenContent));
    }
  }]);

  return Sticky;
}(React.Component);
Sticky.contextTypes = polarisAppProviderContextTypes;

function isFunction(arg) {
  return typeof arg === 'function';
}

var styles$1n = {
  "Select": "Polaris-Select",
  "disabled": "Polaris-Select--disabled",
  "Content": "Polaris-Select__Content",
  "InlineLabel": "Polaris-Select__InlineLabel",
  "Icon": "Polaris-Select__Icon",
  "Backdrop": "Polaris-Select__Backdrop",
  "error": "Polaris-Select--error",
  "Input": "Polaris-Select__Input",
  "placeholder": "Polaris-Select--placeholder",
  "SelectedOption": "Polaris-Select__SelectedOption",
};

var PLACEHOLDER_VALUE = '';
var getUniqueID$c = other.createUniqueIDFactory('Select');
function Select(_ref) {
  var optionsProp = _ref.options,
      groupsProp = _ref.groups,
      label = _ref.label,
      labelAction = _ref.labelAction,
      labelHiddenProp = _ref.labelHidden,
      labelInline = _ref.labelInline,
      disabled = _ref.disabled,
      helpText = _ref.helpText,
      placeholder = _ref.placeholder,
      _ref$id = _ref.id,
      id = _ref$id === void 0 ? getUniqueID$c() : _ref$id,
      name = _ref.name,
      _ref$value = _ref.value,
      value = _ref$value === void 0 ? PLACEHOLDER_VALUE : _ref$value,
      error = _ref.error,
      onChange = _ref.onChange,
      onFocus = _ref.onFocus,
      onBlur = _ref.onBlur;
  var labelHidden = labelInline ? true : labelHiddenProp;
  var className = styles.classNames(styles$1n.Select, error && styles$1n.error, disabled && styles$1n.disabled);
  var handleChange = onChange ? function (event) {
    return onChange(event.currentTarget.value, id);
  } : undefined;
  var describedBy = [];

  if (helpText) {
    describedBy.push(helpTextID(id));
  }

  if (error) {
    describedBy.push("".concat(id, "Error"));
  }

  if (groupsProp != null) {
    // eslint-disable-next-line no-console
    console.warn('Deprecation: the `groups` prop is deprecated and will be removed in the next major version. Pass groups to the `options` prop instead.');
  }

  var options = optionsProp || groupsProp || [];
  var normalizedOptions = options.map(normalizeOption);

  if (placeholder) {
    normalizedOptions = [{
      label: placeholder,
      value: PLACEHOLDER_VALUE,
      disabled: true
    }].concat(_toConsumableArray(normalizedOptions));
  }

  var inlineLabelMarkup = labelInline && React.createElement("span", {
    className: styles$1n.InlineLabel
  }, label);
  var selectedOption = getSelectedOption(normalizedOptions, value);
  var contentMarkup = React.createElement("div", {
    className: styles$1n.Content,
    "aria-hidden": true
  }, inlineLabelMarkup, React.createElement("span", {
    className: styles$1n.SelectedOption
  }, selectedOption), React.createElement("span", {
    className: styles$1n.Icon
  }, React.createElement(Icon$1, {
    source: polarisIcons.ArrowUpDownMinor
  })));
  var optionsMarkup = normalizedOptions.map(renderOption);
  return React.createElement(Labelled, {
    id: id,
    label: label,
    error: error,
    action: labelAction,
    labelHidden: labelHidden,
    helpText: helpText
  }, React.createElement("div", {
    className: className
  }, React.createElement("select", {
    id: id,
    name: name,
    value: value,
    className: styles$1n.Input,
    disabled: disabled,
    onFocus: onFocus,
    onBlur: onBlur,
    onChange: handleChange,
    "aria-invalid": Boolean(error),
    "aria-describedby": describedBy.length ? describedBy.join(' ') : undefined
  }, optionsMarkup), contentMarkup, React.createElement("div", {
    className: styles$1n.Backdrop
  })));
}

function isString(option) {
  return typeof option === 'string';
}

function isGroup(option) {
  return option.options != null;
}

function normalizeStringOption(option) {
  return {
    label: option,
    value: option
  };
}
/**
 * Converts a string option (and each string option in a Group) into
 * an Option object.
 */


function normalizeOption(option) {
  if (isString(option)) {
    return normalizeStringOption(option);
  } else if (isGroup(option)) {
    var title = option.title,
        options = option.options;
    return {
      title: title,
      options: options.map(function (option) {
        return isString(option) ? normalizeStringOption(option) : option;
      })
    };
  }

  return option;
}
/**
 * Gets the text to display in the UI, for the currently selected option
 */


function getSelectedOption(options, value) {
  var flatOptions = flattenOptions(options);
  var selectedOption = flatOptions.find(function (option) {
    return value === option.value;
  });

  if (selectedOption === undefined) {
    // Get the first visible option (not the hidden placeholder)
    selectedOption = flatOptions.find(function (option) {
      return !option.hidden;
    });
  }

  return selectedOption ? selectedOption.label : '';
}
/**
 * Ungroups an options array
 */


function flattenOptions(options) {
  var flatOptions = [];
  options.forEach(function (optionOrGroup) {
    if (isGroup(optionOrGroup)) {
      flatOptions = flatOptions.concat(optionOrGroup.options);
    } else {
      flatOptions.push(optionOrGroup);
    }
  });
  return flatOptions;
}

function renderSingleOption(option) {
  var value = option.value,
      label = option.label,
      rest = tslib_1.__rest(option, ["value", "label"]);

  return React.createElement("option", Object.assign({
    key: value,
    value: value
  }, rest), label);
}

function renderOption(optionOrGroup) {
  if (isGroup(optionOrGroup)) {
    var title = optionOrGroup.title,
        options = optionOrGroup.options;
    return React.createElement("optgroup", {
      label: title,
      key: title
    }, options.map(renderSingleOption));
  }

  return renderSingleOption(optionOrGroup);
}

var styles$1o = {
  "CheckableButton": "Polaris-ResourceList-CheckableButton",
  "CheckableButton-measuring": "Polaris-ResourceList-CheckableButton__CheckableButton--measuring",
  "CheckableButton-plain": "Polaris-ResourceList-CheckableButton__CheckableButton--plain",
  "CheckableButton-selectMode": "Polaris-ResourceList-CheckableButton__CheckableButton--selectMode",
  "CheckableButton-selected": "Polaris-ResourceList-CheckableButton__CheckableButton--selected",
  "Checkbox": "Polaris-ResourceList-CheckableButton__Checkbox",
  "Label": "Polaris-ResourceList-CheckableButton__Label",
};

function CheckableButton(_ref) {
  var accessibilityLabel = _ref.accessibilityLabel,
      _ref$label = _ref.label,
      label = _ref$label === void 0 ? '' : _ref$label,
      onToggleAll = _ref.onToggleAll,
      selected = _ref.selected,
      selectMode = _ref.selectMode,
      plain = _ref.plain,
      measuring = _ref.measuring,
      disabled = _ref.disabled;
  var className = plain ? styles.classNames(styles$1o.CheckableButton, styles$1o['CheckableButton-plain']) : styles.classNames(styles$1o.CheckableButton, selectMode && styles$1o['CheckableButton-selectMode'], selected && styles$1o['CheckableButton-selected'], measuring && styles$1o['CheckableButton-measuring']);
  return React.createElement("div", {
    className: className,
    onClick: onToggleAll
  }, React.createElement("div", {
    className: styles$1o.Checkbox
  }, React.createElement(Checkbox$2, {
    label: accessibilityLabel,
    labelHidden: true,
    checked: selected,
    disabled: disabled,
    onChange: onToggleAll
  })), React.createElement("span", {
    className: styles$1o.Label
  }, label));
}

var CheckableButton$1 = withAppProvider()(CheckableButton);

var styles$1p = {
  "Button": "Polaris-ResourceList-BulkActions__Button",
  "Group-measuring": "Polaris-ResourceList-BulkActions__Group--measuring",
  "disabled": "Polaris-ResourceList-BulkActions--disabled",
  "Group": "Polaris-ResourceList-BulkActions__Group",
  "Group-entering": "Polaris-ResourceList-BulkActions__Group--entering",
  "Group-exiting": "Polaris-ResourceList-BulkActions__Group--exiting",
  "Group-entered": "Polaris-ResourceList-BulkActions__Group--entered",
  "Group-exited": "Polaris-ResourceList-BulkActions__Group--exited",
  "Group-smallScreen": "Polaris-ResourceList-BulkActions__Group--smallScreen",
  "Group-largeScreen": "Polaris-ResourceList-BulkActions__Group--largeScreen",
  "ButtonGroup": "Polaris-ResourceList-BulkActions__ButtonGroup",
  "Button-cancel": "Polaris-ResourceList-BulkActions__Button--cancel",
  "Popover": "Polaris-ResourceList-BulkActions__Popover",
  "ActionContent": "Polaris-ResourceList-BulkActions__ActionContent",
  "ActionIcon": "Polaris-ResourceList-BulkActions__ActionIcon",
  "PaginatedSelectAll": "Polaris-ResourceList-BulkActions__PaginatedSelectAll",
  "Slide": "Polaris-ResourceList-BulkActions__Slide",
  "Slide-appear": "Polaris-ResourceList-BulkActions__Slide--appear",
  "Slide-enter": "Polaris-ResourceList-BulkActions__Slide--enter",
  "Slide-exit": "Polaris-ResourceList-BulkActions__Slide--exit",
  "Slide-appearing": "Polaris-ResourceList-BulkActions__Slide--appearing",
  "Slide-entering": "Polaris-ResourceList-BulkActions__Slide--entering",
};

var BulkActionButton =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(BulkActionButton, _React$PureComponent);

  function BulkActionButton() {
    _classCallCheck(this, BulkActionButton);

    return _possibleConstructorReturn(this, _getPrototypeOf(BulkActionButton).apply(this, arguments));
  }

  _createClass(BulkActionButton, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var handleMeasurement = this.props.handleMeasurement;

      if (handleMeasurement) {
        var bulkActionButtonNode = ReactDOM.findDOMNode(this);
        var width = bulkActionButtonNode instanceof Element && bulkActionButtonNode.getBoundingClientRect().width || 0;
        handleMeasurement(width);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          url = _this$props.url,
          external = _this$props.external,
          onAction = _this$props.onAction,
          content = _this$props.content,
          disclosure = _this$props.disclosure,
          accessibilityLabel = _this$props.accessibilityLabel,
          disabled = _this$props.disabled;
      var disclosureIconMarkup = disclosure ? React.createElement("span", {
        className: styles$1p.ActionIcon
      }, React.createElement(Icon$1, {
        source: polarisIcons.CaretDownMinor
      })) : null;
      var contentMarkup = disclosureIconMarkup ? React.createElement("span", {
        className: styles$1p.ActionContent
      }, React.createElement("span", null, content), disclosureIconMarkup) : content;

      if (url) {
        return React.createElement(UnstyledLink$1, {
          external: external,
          url: url,
          onMouseUp: handleMouseUpByBlurring,
          className: styles$1p.Button,
          "aria-label": accessibilityLabel
        }, contentMarkup);
      }

      var className = reactUtilities.classNames(styles$1p.Button, disabled && styles$1p.disabled);
      return React.createElement("button", {
        className: className,
        onClick: onAction,
        onMouseUp: handleMouseUpByBlurring,
        "aria-label": accessibilityLabel,
        type: "button",
        disabled: disabled
      }, contentMarkup);
    }
  }]);

  return BulkActionButton;
}(React.PureComponent);

var MAX_PROMOTED_ACTIONS = 2;
var slideClasses = {
  appear: styles.classNames(styles$1p.Slide, styles$1p['Slide-appear']),
  appearActive: styles.classNames(styles$1p.Slide, styles$1p['Slide-appearing']),
  enter: styles.classNames(styles$1p.Slide, styles$1p['Slide-enter']),
  enterActive: styles.classNames(styles$1p.Slide, styles$1p['Slide-entering']),
  exit: styles.classNames(styles$1p.Slide, styles$1p['Slide-exit'])
};
var BulkActions =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(BulkActions, _React$PureComponent);

  function BulkActions() {
    var _this;

    _classCallCheck(this, BulkActions);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(BulkActions).apply(this, arguments));
    _this.state = {
      smallScreenPopoverVisible: false,
      largeScreenPopoverVisible: false,
      containerWidth: 0,
      measuring: true
    };
    _this.promotedActionsWidths = [];
    _this.bulkActionsWidth = 0;
    _this.addedMoreActionsWidthForMeasuring = 0;
    _this.handleResize = debounce(function () {
      var _this$state = _this.state,
          smallScreenPopoverVisible = _this$state.smallScreenPopoverVisible,
          largeScreenPopoverVisible = _this$state.largeScreenPopoverVisible;

      if (_this.containerNode) {
        var containerWidth = _this.containerNode.getBoundingClientRect().width;

        if (containerWidth > 0) {
          _this.setState({
            containerWidth: containerWidth
          });
        }
      }

      if (smallScreenPopoverVisible || largeScreenPopoverVisible) {
        _this.setState({
          smallScreenPopoverVisible: false,
          largeScreenPopoverVisible: false
        });
      }
    }, 50, {
      trailing: true
    });

    _this.setLargeScreenButtonsNode = function (node) {
      _this.largeScreenButtonsNode = node;
    };

    _this.setContainerNode = function (node) {
      _this.containerNode = node;
    };

    _this.setMoreActionsNode = function (node) {
      _this.moreActionsNode = node;
    };

    _this.setSelectMode = function (val) {
      var onSelectModeToggle = _this.props.onSelectModeToggle;

      if (onSelectModeToggle) {
        onSelectModeToggle(val);
      }
    };

    _this.toggleSmallScreenPopover = function () {
      _this.setState(function (_ref) {
        var smallScreenPopoverVisible = _ref.smallScreenPopoverVisible;
        return {
          smallScreenPopoverVisible: !smallScreenPopoverVisible
        };
      });
    };

    _this.toggleLargeScreenPopover = function () {
      _this.setState(function (_ref2) {
        var largeScreenPopoverVisible = _ref2.largeScreenPopoverVisible;
        return {
          largeScreenPopoverVisible: !largeScreenPopoverVisible
        };
      });
    };

    _this.handleMeasurement = function (width) {
      var measuring = _this.state.measuring;

      if (measuring) {
        _this.promotedActionsWidths.push(width);
      }
    };

    return _this;
  }

  _createClass(BulkActions, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props = this.props,
          actions$$1 = _this$props.actions,
          promotedActions = _this$props.promotedActions;

      if (promotedActions && !actions$$1 && this.moreActionsNode) {
        this.addedMoreActionsWidthForMeasuring = this.moreActionsNode.getBoundingClientRect().width;
      }

      this.bulkActionsWidth = this.largeScreenButtonsNode ? this.largeScreenButtonsNode.getBoundingClientRect().width - this.addedMoreActionsWidthForMeasuring : 0;

      if (this.containerNode) {
        this.setState({
          containerWidth: this.containerNode.getBoundingClientRect().width,
          measuring: false
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          selectMode = _this$props2.selectMode,
          accessibilityLabel = _this$props2.accessibilityLabel,
          _this$props2$label = _this$props2.label,
          label = _this$props2$label === void 0 ? '' : _this$props2$label,
          onToggleAll = _this$props2.onToggleAll,
          selected = _this$props2.selected,
          disabled = _this$props2.disabled,
          promotedActions = _this$props2.promotedActions,
          _this$props2$paginate = _this$props2.paginatedSelectAllText,
          paginatedSelectAllText = _this$props2$paginate === void 0 ? null : _this$props2$paginate,
          paginatedSelectAllAction = _this$props2.paginatedSelectAllAction,
          intl = _this$props2.polaris.intl;

      if (promotedActions && promotedActions.length > MAX_PROMOTED_ACTIONS) {
        // eslint-disable-next-line no-console
        console.warn(intl.translate('Polaris.ResourceList.BulkActions.warningMessage', {
          maxPromotedActions: MAX_PROMOTED_ACTIONS
        }));
      }

      var _this$state2 = this.state,
          smallScreenPopoverVisible = _this$state2.smallScreenPopoverVisible,
          largeScreenPopoverVisible = _this$state2.largeScreenPopoverVisible,
          measuring = _this$state2.measuring;
      var paginatedSelectAllActionMarkup = paginatedSelectAllAction ? React.createElement(Button$1, {
        onClick: paginatedSelectAllAction.onAction,
        plain: true,
        disabled: disabled
      }, paginatedSelectAllAction.content) : null;
      var paginatedSelectAllTextMarkup = paginatedSelectAllText && paginatedSelectAllAction ? React.createElement("span", {
        "aria-live": "polite"
      }, paginatedSelectAllText) : paginatedSelectAllText;
      var paginatedSelectAllMarkup = paginatedSelectAllActionMarkup || paginatedSelectAllTextMarkup ? React.createElement("div", {
        className: styles$1p.PaginatedSelectAll
      }, paginatedSelectAllTextMarkup, " ", paginatedSelectAllActionMarkup) : null;
      var cancelButtonClassName = styles.classNames(styles$1p.Button, styles$1p['Button-cancel'], disabled && styles$1p.disabled);
      var cancelButton = React.createElement("button", {
        className: cancelButtonClassName // eslint-disable-next-line react/jsx-no-bind
        ,
        onClick: this.setSelectMode.bind(this, false),
        disabled: disabled
      }, intl.translate('Polaris.Common.cancel'));
      var numberOfPromotedActionsToRender = this.numberOfPromotedActionsToRender;
      var allActionsPopover = this.hasActions ? React.createElement("div", {
        className: styles$1p.Popover,
        ref: this.setMoreActionsNode
      }, React.createElement(Popover, {
        active: smallScreenPopoverVisible,
        activator: React.createElement(BulkActionButton, {
          disclosure: true,
          onAction: this.toggleSmallScreenPopover,
          content: intl.translate('Polaris.ResourceList.BulkActions.actionsActivatorLabel'),
          disabled: disabled
        }),
        onClose: this.toggleSmallScreenPopover
      }, React.createElement(ActionList, {
        items: promotedActions,
        sections: this.actionSections,
        onActionAnyItem: this.toggleSmallScreenPopover
      }))) : null;
      var promotedActionsMarkup = promotedActions && numberOfPromotedActionsToRender > 0 ? _toConsumableArray(promotedActions).slice(0, numberOfPromotedActionsToRender).map(function (action, index) {
        return React.createElement(BulkActionButton, Object.assign({
          disabled: disabled
        }, action, {
          key: index,
          handleMeasurement: _this2.handleMeasurement
        }));
      }) : null;
      var rolledInPromotedActions = promotedActions && numberOfPromotedActionsToRender < promotedActions.length ? _toConsumableArray(promotedActions).slice(numberOfPromotedActionsToRender) : [];
      var activatorLabel = !promotedActions || promotedActions && numberOfPromotedActionsToRender === 0 && !measuring ? intl.translate('Polaris.ResourceList.BulkActions.actionsActivatorLabel') : intl.translate('Polaris.ResourceList.BulkActions.moreActionsActivatorLabel');
      var combinedActions = [];

      if (this.actionSections && rolledInPromotedActions.length > 0) {
        combinedActions = [{
          items: rolledInPromotedActions
        }].concat(_toConsumableArray(this.actionSections));
      } else if (this.actionSections) {
        combinedActions = this.actionSections;
      } else if (rolledInPromotedActions.length > 0) {
        combinedActions = [{
          items: rolledInPromotedActions
        }];
      }

      var actionsPopover = this.actionSections || rolledInPromotedActions.length > 0 || measuring ? React.createElement("div", {
        className: styles$1p.Popover,
        ref: this.setMoreActionsNode
      }, React.createElement(Popover, {
        active: largeScreenPopoverVisible,
        activator: React.createElement(BulkActionButton, {
          disclosure: true,
          onAction: this.toggleLargeScreenPopover,
          content: activatorLabel,
          disabled: disabled
        }),
        onClose: this.toggleLargeScreenPopover
      }, React.createElement(ActionList, {
        sections: combinedActions,
        onActionAnyItem: this.toggleLargeScreenPopover
      }))) : null;
      var checkableButtonProps = {
        accessibilityLabel: accessibilityLabel,
        label: label,
        selected: selected,
        selectMode: selectMode,
        onToggleAll: onToggleAll,
        measuring: measuring,
        disabled: disabled
      };
      var smallScreenGroup = React.createElement(reactTransitionGroup.Transition, {
        timeout: 0,
        in: selectMode,
        key: "smallGroup"
      }, function (status) {
        var smallScreenGroupClassName = styles.classNames(styles$1p.Group, styles$1p['Group-smallScreen'], styles$1p["Group-".concat(status)]);
        return React.createElement("div", {
          className: smallScreenGroupClassName
        }, React.createElement("div", {
          className: styles$1p.ButtonGroup
        }, React.createElement(reactTransitionGroup.CSSTransition, {
          in: selectMode,
          timeout: tokens.durationBase,
          classNames: slideClasses,
          appear: true
        }, React.createElement(CheckableButton$1, checkableButtonProps)), allActionsPopover, cancelButton), paginatedSelectAllMarkup);
      });
      var largeScreenGroup = React.createElement(reactTransitionGroup.Transition, {
        timeout: 0,
        in: selectMode,
        key: "largeGroup"
      }, function (status) {
        var largeScreenGroupClassName = styles.classNames(styles$1p.Group, styles$1p['Group-largeScreen'], !measuring && styles$1p["Group-".concat(status)], measuring && styles$1p['Group-measuring']);
        return React.createElement("div", {
          className: largeScreenGroupClassName
        }, React.createElement(EventListener, {
          event: "resize",
          handler: _this2.handleResize
        }), React.createElement("div", {
          className: styles$1p.ButtonGroup,
          ref: _this2.setLargeScreenButtonsNode
        }, React.createElement(CheckableButton$1, checkableButtonProps), promotedActionsMarkup, actionsPopover), paginatedSelectAllMarkup);
      });
      return React.createElement("div", {
        ref: this.setContainerNode
      }, smallScreenGroup, largeScreenGroup);
    }
  }, {
    key: "numberOfPromotedActionsToRender",
    get: function get() {
      var promotedActions = this.props.promotedActions;
      var _this$state3 = this.state,
          containerWidth = _this$state3.containerWidth,
          measuring = _this$state3.measuring;

      if (!promotedActions) {
        return 0;
      }

      if (containerWidth >= this.bulkActionsWidth || measuring) {
        return promotedActions.length;
      }

      var sufficientSpace = false;
      var counter = promotedActions.length - 1;
      var totalWidth = 0;

      while (!sufficientSpace && counter >= 0) {
        totalWidth += this.promotedActionsWidths[counter];
        var widthWithRemovedAction = this.bulkActionsWidth - totalWidth + this.addedMoreActionsWidthForMeasuring;

        if (containerWidth >= widthWithRemovedAction) {
          sufficientSpace = true;
        } else {
          counter--;
        }
      }

      return counter;
    }
  }, {
    key: "hasActions",
    get: function get() {
      var _this$props3 = this.props,
          promotedActions = _this$props3.promotedActions,
          actions$$1 = _this$props3.actions;
      return Boolean(promotedActions && promotedActions.length > 0 || actions$$1 && actions$$1.length > 0);
    }
  }, {
    key: "actionSections",
    get: function get() {
      var actions$$1 = this.props.actions;

      if (!actions$$1 || actions$$1.length === 0) {
        return;
      }

      if (instanceOfBulkActionListSectionArray(actions$$1)) {
        return actions$$1;
      }

      if (instanceOfBulkActionArray(actions$$1)) {
        return [{
          items: actions$$1
        }];
      }
    }
  }]);

  return BulkActions;
}(React.PureComponent);

function instanceOfBulkActionListSectionArray(actions$$1) {
  var validList = actions$$1.filter(function (action) {
    return action.items;
  });
  return actions$$1.length === validList.length;
}

function instanceOfBulkActionArray(actions$$1) {
  var validList = actions$$1.filter(function (action) {
    return !action.items;
  });
  return actions$$1.length === validList.length;
}

var BulkActions$1 = withAppProvider()(BulkActions);

var styles$1q = {
  "Tag": "Polaris-Tag",
  "disabled": "Polaris-Tag--disabled",
  "TagText": "Polaris-Tag__TagText",
  "Button": "Polaris-Tag__Button",
};

function Tag(_ref) {
  var children = _ref.children,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      onRemove = _ref.onRemove,
      intl = _ref.polaris.intl;
  var className = reactUtilities.classNames(disabled && styles$1q.disabled, styles$1q.Tag);
  var ariaLabel = intl.translate('Polaris.Tag.ariaLabel', {
    children: children
  });
  return React.createElement("span", {
    className: className
  }, React.createElement("span", {
    title: children,
    className: styles$1q.TagText
  }, children), React.createElement("button", {
    type: "button",
    "aria-label": ariaLabel,
    className: styles$1q.Button,
    onClick: onRemove,
    onMouseUp: handleMouseUpByBlurring,
    disabled: disabled
  }, React.createElement(Icon$1, {
    source: polarisIcons.CancelSmallMinor
  })));
}

var Tag$1 = withAppProvider()(Tag);

var intl = new Intl(undefined);

var _React$createContext$2 = React.createContext({
  selectMode: false,
  resourceName: {
    singular: intl.translate('Polaris.ResourceList.defaultItemSingular'),
    plural: intl.translate('Polaris.ResourceList.defaultItemPlural')
  }
}),
    Provider$3 = _React$createContext$2.Provider,
    Consumer$3 = _React$createContext$2.Consumer;

var styles$1r = {
  "DateTextField": "Polaris-FilterControl-DateSelector__DateTextField",
  "DatePicker": "Polaris-FilterControl-DateSelector__DatePicker",
};

var VALID_DATE_REGEX = /^\d{4}-\d{1,2}-\d{1,2}$/;
var DateFilterOption;

(function (DateFilterOption) {
  DateFilterOption["PastWeek"] = "past_week";
  DateFilterOption["PastMonth"] = "past_month";
  DateFilterOption["PastQuarter"] = "past_quarter";
  DateFilterOption["PastYear"] = "past_year";
  DateFilterOption["ComingWeek"] = "coming_week";
  DateFilterOption["ComingMonth"] = "coming_month";
  DateFilterOption["ComingQuarter"] = "coming_quarter";
  DateFilterOption["ComingYear"] = "coming_year";
  DateFilterOption["OnOrBefore"] = "on_or_before";
  DateFilterOption["OnOrAfter"] = "on_or_after";
})(DateFilterOption || (DateFilterOption = {}));

var DateSelector =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(DateSelector, _React$PureComponent);

  function DateSelector() {
    var _this;

    _classCallCheck(this, DateSelector);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DateSelector).apply(this, arguments));
    _this.state = {
      datePickerMonth: _this.now.getMonth(),
      datePickerYear: _this.now.getFullYear(),
      initialConsumerFilterKey: _this.props.filterKey
    };

    _this.handleDateFilterOptionsChange = function (newOption) {
      var _this$props = _this.props,
          onFilterValueChange = _this$props.onFilterValueChange,
          onFilterKeyChange = _this$props.onFilterKeyChange,
          filterMinKey = _this$props.filterMinKey,
          filterMaxKey = _this$props.filterMaxKey;
      var _this$state = _this.state,
          initialConsumerFilterKey = _this$state.initialConsumerFilterKey,
          selectedDate = _this$state.selectedDate;

      if (!initialConsumerFilterKey) {
        return;
      }

      if (newOption === DateFilterOption.OnOrBefore) {
        onFilterKeyChange(filterMaxKey);
        onFilterValueChange(selectedDate ? stripTimeFromISOString(formatDateForLocalTimezone(selectedDate)) : undefined);
        return;
      }

      if (newOption === DateFilterOption.OnOrAfter) {
        onFilterKeyChange(filterMinKey);
        onFilterValueChange(selectedDate ? stripTimeFromISOString(formatDateForLocalTimezone(selectedDate)) : undefined);
        return;
      }

      onFilterKeyChange(initialConsumerFilterKey);
      onFilterValueChange(newOption);
    };

    _this.handleDateFieldChange = function (value) {
      var onFilterValueChange = _this.props.onFilterValueChange;
      var userInputDateError = _this.state.userInputDateError;

      if (value.length === 0) {
        _this.setState({
          selectedDate: undefined
        }, function () {
          onFilterValueChange(undefined);
        });
      }

      if (userInputDateError && isValidDate(value)) {
        _this.setState({
          userInputDateError: undefined
        });
      }

      _this.setState({
        userInputDate: value
      });
    };

    _this.handleDateBlur = function () {
      var _this$props2 = _this.props,
          intl = _this$props2.polaris.intl,
          onFilterValueChange = _this$props2.onFilterValueChange;

      if (!_this.dateTextFieldValue || !isValidDate(_this.dateTextFieldValue)) {
        _this.setState({
          selectedDate: undefined,
          userInputDateError: intl.translate('Polaris.ResourceList.DateSelector.dateValueError')
        });

        onFilterValueChange(undefined);
        return;
      }

      var userInputDate = _this.state.userInputDate;

      if (!userInputDate) {
        return;
      }

      var formattedDateForTimezone = new Date(formatDateForLocalTimezone(new Date(userInputDate)));

      _this.setState({
        selectedDate: formattedDateForTimezone,
        datePickerMonth: formattedDateForTimezone.getMonth(),
        datePickerYear: formattedDateForTimezone.getFullYear(),
        userInputDate: undefined,
        userInputDateError: undefined
      }, _this.handleDateChanged);
    };

    _this.handleDatePickerChange = function (_ref) {
      var nextDate = _ref.end;

      _this.setState({
        selectedDate: new Date(nextDate),
        userInputDate: undefined,
        userInputDateError: undefined
      }, _this.handleDateChanged);
    };

    _this.handleDatePickerMonthChange = function (month, year) {
      _this.setState({
        datePickerMonth: month,
        datePickerYear: year
      });
    };

    return _this;
  }

  _createClass(DateSelector, [{
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          filterValue = _this$props3.filterValue,
          filterKey = _this$props3.filterKey,
          filterMinKey = _this$props3.filterMinKey,
          filterMaxKey = _this$props3.filterMaxKey,
          dateOptionType = _this$props3.dateOptionType,
          intl = _this$props3.polaris.intl;
      var _this$state2 = this.state,
          selectedDate = _this$state2.selectedDate,
          datePickerMonth = _this$state2.datePickerMonth,
          datePickerYear = _this$state2.datePickerYear,
          userInputDateError = _this$state2.userInputDateError;
      var dateFilterOption = getDateFilterOption(filterValue, filterKey, filterMinKey, filterMaxKey);
      var showDatePredicate = dateFilterOption === DateFilterOption.OnOrBefore || dateFilterOption === DateFilterOption.OnOrAfter;
      var datePredicateMarkup = showDatePredicate && React.createElement(React.Fragment, null, React.createElement("div", {
        className: styles$1r.DateTextField
      }, React.createElement(TextField$1, {
        label: intl.translate('Polaris.ResourceList.DateSelector.dateValueLabel'),
        placeholder: intl.translate('Polaris.ResourceList.DateSelector.dateValuePlaceholder'),
        value: this.dateTextFieldValue,
        error: userInputDateError,
        prefix: React.createElement(Icon$1, {
          source: polarisIcons.CalendarMinor,
          color: "skyDark"
        }),
        autoComplete: false,
        onChange: this.handleDateFieldChange,
        onBlur: this.handleDateBlur
      })), React.createElement("div", {
        className: styles$1r.DatePicker
      }, React.createElement(DatePicker$1, {
        selected: selectedDate,
        month: datePickerMonth,
        year: datePickerYear,
        onChange: this.handleDatePickerChange,
        onMonthChange: this.handleDatePickerMonthChange
      })));
      return React.createElement(React.Fragment, null, React.createElement(Select, {
        label: intl.translate('Polaris.ResourceList.DateSelector.SelectOptions.dateFilterLabel'),
        labelHidden: true,
        options: dateOptionType ? this.dateOptionTypes[dateOptionType] : this.dateOptionTypes.full,
        placeholder: intl.translate('Polaris.ResourceList.FilterValueSelector.selectFilterValuePlaceholder'),
        value: dateFilterOption,
        onChange: this.handleDateFilterOptionsChange
      }), datePredicateMarkup);
    }
  }, {
    key: "handleDateChanged",
    value: function handleDateChanged() {
      var onFilterValueChange = this.props.onFilterValueChange;
      var selectedDate = this.state.selectedDate;

      if (!selectedDate) {
        return;
      }

      onFilterValueChange(stripTimeFromISOString(formatDateForLocalTimezone(selectedDate)));
    }
  }, {
    key: "dateComparatorOptions",
    get: function get() {
      var intl = this.props.polaris.intl;
      return [{
        value: DateFilterOption.OnOrBefore,
        label: intl.translate('Polaris.ResourceList.DateSelector.SelectOptions.OnOrBefore')
      }, {
        value: DateFilterOption.OnOrAfter,
        label: intl.translate('Polaris.ResourceList.DateSelector.SelectOptions.OnOrAfter')
      }];
    }
  }, {
    key: "datePastOptions",
    get: function get() {
      var intl = this.props.polaris.intl;
      return [{
        value: DateFilterOption.PastWeek,
        label: intl.translate('Polaris.ResourceList.DateSelector.SelectOptions.PastWeek')
      }, {
        value: DateFilterOption.PastMonth,
        label: intl.translate('Polaris.ResourceList.DateSelector.SelectOptions.PastMonth')
      }, {
        value: DateFilterOption.PastQuarter,
        label: intl.translate('Polaris.ResourceList.DateSelector.SelectOptions.PastQuarter')
      }, {
        value: DateFilterOption.PastYear,
        label: intl.translate('Polaris.ResourceList.DateSelector.SelectOptions.PastYear')
      }];
    }
  }, {
    key: "dateFutureOptions",
    get: function get() {
      var intl = this.props.polaris.intl;
      return [{
        value: DateFilterOption.ComingWeek,
        label: intl.translate('Polaris.ResourceList.DateSelector.SelectOptions.ComingWeek')
      }, {
        value: DateFilterOption.ComingMonth,
        label: intl.translate('Polaris.ResourceList.DateSelector.SelectOptions.ComingMonth')
      }, {
        value: DateFilterOption.ComingQuarter,
        label: intl.translate('Polaris.ResourceList.DateSelector.SelectOptions.ComingQuarter')
      }, {
        value: DateFilterOption.ComingYear,
        label: intl.translate('Polaris.ResourceList.DateSelector.SelectOptions.ComingYear')
      }];
    }
  }, {
    key: "dateOptionTypes",
    get: function get() {
      return {
        past: [].concat(_toConsumableArray(this.datePastOptions), _toConsumableArray(this.dateComparatorOptions)),
        future: [].concat(_toConsumableArray(this.dateFutureOptions), _toConsumableArray(this.dateComparatorOptions)),
        full: [].concat(_toConsumableArray(this.datePastOptions), _toConsumableArray(this.dateFutureOptions), _toConsumableArray(this.dateComparatorOptions))
      };
    }
  }, {
    key: "now",
    get: function get() {
      return new Date();
    }
  }, {
    key: "dateTextFieldValue",
    get: function get() {
      var _this$state3 = this.state,
          userInputDate = _this$state3.userInputDate,
          selectedDate = _this$state3.selectedDate;

      if (!userInputDate && !selectedDate) {
        return undefined;
      }

      if (userInputDate !== undefined) {
        return userInputDate;
      }

      if (selectedDate) {
        return stripTimeFromISOString(formatDateForLocalTimezone(selectedDate));
      }
    }
  }]);

  return DateSelector;
}(React.PureComponent);

function isValidDate(date) {
  if (!date) {
    return false;
  }

  return VALID_DATE_REGEX.test(date) && !isNaN(new Date(date).getTime());
}

function getDateFilterOption(filterValue, filterKey, filterMinKey, filterMaxKey) {
  if (filterKey === filterMaxKey) {
    return DateFilterOption.OnOrBefore;
  }

  if (filterKey === filterMinKey) {
    return DateFilterOption.OnOrAfter;
  }

  return filterValue;
}

function stripTimeFromISOString(ISOString) {
  return ISOString.slice(0, 10);
}

function formatDateForLocalTimezone(date) {
  var timezoneOffset = date.getTimezoneOffset();
  var timezoneOffsetMs = timezoneOffset * 60 * 1000;
  var isFringeTimezone = timezoneOffset === -720 || timezoneOffset === 720;
  var formattedDate = new Date();

  if (isFringeTimezone && date.getHours() !== 0) {
    return date.toISOString();
  }

  var newTime = timezoneOffset > -1 ? date.getTime() + timezoneOffsetMs : date.getTime() - timezoneOffsetMs;
  formattedDate.setTime(newTime);
  return formattedDate.toISOString();
}

var DateSelector$1 = withAppProvider()(DateSelector);

(function (FilterType) {
  FilterType[FilterType["Select"] = 0] = "Select";
  FilterType[FilterType["TextField"] = 1] = "TextField";
  FilterType[FilterType["DateSelector"] = 2] = "DateSelector";
})(exports.FilterType || (exports.FilterType = {}));

var FilterValueSelector =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(FilterValueSelector, _React$PureComponent);

  function FilterValueSelector() {
    var _this;

    _classCallCheck(this, FilterValueSelector);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(FilterValueSelector).apply(this, arguments));

    _this.handleOperatorOptionChange = function (operatorKey) {
      var _this$props = _this.props,
          value = _this$props.value,
          onChange = _this$props.onChange,
          onFilterKeyChange = _this$props.onFilterKeyChange;
      onFilterKeyChange(operatorKey);

      if (!value) {
        return;
      }

      onChange(value);
    };

    return _this;
  }

  _createClass(FilterValueSelector, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props$filter = this.props.filter,
          operatorText = _this$props$filter.operatorText,
          type = _this$props$filter.type;

      if (type === exports.FilterType.DateSelector || !operatorText || typeof operatorText === 'string' || operatorText.length === 0) {
        return;
      }

      this.handleOperatorOptionChange(operatorText[0].key);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          filter = _this$props2.filter,
          filterKey = _this$props2.filterKey,
          value = _this$props2.value,
          onChange = _this$props2.onChange,
          onFilterKeyChange = _this$props2.onFilterKeyChange,
          intl = _this$props2.polaris.intl;
      var operatorText = filter.operatorText;
      var showOperatorOptions = filter.type !== exports.FilterType.DateSelector && operatorText && typeof operatorText !== 'string';
      var operatorOptionsMarkup = showOperatorOptions ? React.createElement(Select, {
        label: filter.label,
        labelHidden: true,
        options: buildOperatorOptions(operatorText),
        value: filterKey,
        onChange: this.handleOperatorOptionChange
      }) : null;
      var selectedFilterLabel = typeof operatorText === 'string' ? operatorText : '';

      switch (filter.type) {
        case exports.FilterType.Select:
          return React.createElement(Stack, {
            vertical: true
          }, operatorOptionsMarkup, React.createElement(Select, {
            label: selectedFilterLabel,
            options: filter.options,
            placeholder: intl.translate('Polaris.ResourceList.FilterValueSelector.selectFilterValuePlaceholder'),
            value: value,
            onChange: onChange
          }));

        case exports.FilterType.TextField:
          return React.createElement(Stack, {
            vertical: true
          }, operatorOptionsMarkup, React.createElement(TextField$1, {
            label: selectedFilterLabel,
            value: value,
            type: filter.textFieldType,
            onChange: onChange
          }));

        case exports.FilterType.DateSelector:
          return React.createElement(DateSelector$1, {
            dateOptionType: filter.dateOptionType,
            filterValue: value,
            filterKey: filterKey,
            filterMinKey: filter.minKey,
            filterMaxKey: filter.maxKey,
            onFilterValueChange: onChange,
            onFilterKeyChange: onFilterKeyChange
          });

        default:
          return null;
      }
    }
  }]);

  return FilterValueSelector;
}(React.PureComponent);

function buildOperatorOptions(operatorText) {
  if (!operatorText || typeof operatorText === 'string') {
    return [];
  }

  return operatorText.map(function (_ref) {
    var key = _ref.key,
        optionLabel = _ref.optionLabel;
    return {
      value: key,
      label: optionLabel
    };
  });
}

var FilterValueSelector$1 = withAppProvider()(FilterValueSelector);

var FilterCreator =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(FilterCreator, _React$PureComponent);

  function FilterCreator() {
    var _this;

    _classCallCheck(this, FilterCreator);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(FilterCreator).apply(this, arguments));
    _this.state = {
      popoverActive: false
    };
    _this.node = null;

    _this.handleButtonFocus = function () {
      var event = arguments.length <= 0 ? undefined : arguments[0];

      if (!_this.node && event) {
        _this.node = event.target;
      }
    };

    _this.togglePopover = function () {
      _this.setState(function (_ref) {
        var popoverActive = _ref.popoverActive;
        return {
          popoverActive: !popoverActive
        };
      });
    };

    _this.handleFilterKeyChange = function (filterKey) {
      var filters = _this.props.filters;
      var foundFilter = filters.find(function (filter) {
        var minKey = filter.minKey,
            maxKey = filter.maxKey,
            operatorText = filter.operatorText;

        if (minKey || maxKey) {
          return filter.key === filterKey || minKey === filterKey || maxKey === filterKey;
        }

        if (operatorText && typeof operatorText !== 'string') {
          return filter.key === filterKey || operatorText.filter(function (_ref2) {
            var key = _ref2.key;
            return key === filterKey;
          }).length === 1;
        }

        return filter.key === filterKey;
      });

      if (!foundFilter) {
        return;
      }

      _this.setState({
        selectedFilter: foundFilter,
        selectedFilterKey: filterKey,
        selectedFilterValue: undefined
      });
    };

    _this.handleFilterValueChange = function (filterValue) {
      _this.setState({
        selectedFilterValue: filterValue
      });
    };

    _this.handleAddFilter = function () {
      var onAddFilter = _this.props.onAddFilter;
      var selectedFilterKey = _this.state.selectedFilterKey;

      if (!onAddFilter || !_this.canAddFilter || !selectedFilterKey) {
        return;
      }

      onAddFilter({
        key: selectedFilterKey,
        value: _this.state.selectedFilterValue || ''
      });

      _this.setState({
        popoverActive: false,
        selectedFilter: undefined,
        selectedFilterValue: undefined
      });

      if (_this.node != null) {
        _this.node.focus();
      }
    };

    return _this;
  }

  _createClass(FilterCreator, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          filters = _this$props.filters,
          resourceName = _this$props.resourceName,
          disabled = _this$props.disabled,
          intl = _this$props.polaris.intl;
      var _this$state = this.state,
          popoverActive = _this$state.popoverActive,
          selectedFilter = _this$state.selectedFilter,
          selectedFilterKey = _this$state.selectedFilterKey,
          selectedFilterValue = _this$state.selectedFilterValue;
      var activator = React.createElement(Button$1, {
        onClick: this.togglePopover,
        disclosure: true,
        disabled: disabled,
        onFocus: this.handleButtonFocus
      }, intl.translate('Polaris.ResourceList.FilterCreator.filterButtonLabel'));
      var filterOptions = filters.map(function (_ref3) {
        var key = _ref3.key,
            label = _ref3.label;
        return {
          value: key,
          label: label
        };
      });
      var filterValueSelectionMarkup = selectedFilter ? React.createElement(FilterValueSelector$1, {
        filter: selectedFilter,
        filterKey: selectedFilterKey,
        value: selectedFilterValue,
        onFilterKeyChange: this.handleFilterKeyChange,
        onChange: this.handleFilterValueChange
      }) : null;
      var addFilterButtonMarkup = selectedFilter ? React.createElement(Button$1, {
        onClick: this.handleAddFilter,
        disabled: !this.canAddFilter
      }, intl.translate('Polaris.ResourceList.FilterCreator.addFilterButtonLabel')) : null;
      return React.createElement(Popover, {
        active: popoverActive,
        activator: activator,
        onClose: this.togglePopover,
        sectioned: true,
        fullHeight: true
      }, React.createElement(Form, {
        onSubmit: this.handleAddFilter
      }, React.createElement(FormLayout, null, React.createElement(Select, {
        label: intl.translate('Polaris.ResourceList.FilterCreator.showAllWhere', {
          resourceNamePlural: resourceName.plural.toLocaleLowerCase()
        }),
        placeholder: intl.translate('Polaris.ResourceList.FilterCreator.selectFilterKeyPlaceholder'),
        options: filterOptions,
        onChange: this.handleFilterKeyChange,
        value: selectedFilter && selectedFilter.key
      }), filterValueSelectionMarkup, addFilterButtonMarkup)));
    }
  }, {
    key: "canAddFilter",
    get: function get() {
      return Boolean(this.state.selectedFilter && this.state.selectedFilterKey && this.state.selectedFilterValue);
    }
  }]);

  return FilterCreator;
}(React.PureComponent);
var FilterCreator$1 = withAppProvider()(FilterCreator);

var styles$1s = {
  "AppliedFilters": "Polaris-ResourceList-FilterControl__AppliedFilters",
  "AppliedFilter": "Polaris-ResourceList-FilterControl__AppliedFilter",
};

var FilterControl =
/*#__PURE__*/
function (_React$Component) {
  _inherits(FilterControl, _React$Component);

  function FilterControl() {
    var _this;

    _classCallCheck(this, FilterControl);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(FilterControl).apply(this, arguments));

    _this.handleAddFilter = function (newFilter) {
      var _this$props = _this.props,
          onFiltersChange = _this$props.onFiltersChange,
          _this$props$appliedFi = _this$props.appliedFilters,
          appliedFilters = _this$props$appliedFi === void 0 ? [] : _this$props$appliedFi;

      if (!onFiltersChange) {
        return;
      }

      var foundFilter = appliedFilters.find(function (appliedFilter) {
        return idFromFilter(appliedFilter) === idFromFilter(newFilter);
      });

      if (foundFilter) {
        return;
      }

      var newAppliedFilters = [].concat(_toConsumableArray(appliedFilters), [newFilter]);
      onFiltersChange(newAppliedFilters);
    };

    return _this;
  }

  _createClass(FilterControl, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          searchValue = _this$props2.searchValue,
          _this$props2$appliedF = _this$props2.appliedFilters,
          appliedFilters = _this$props2$appliedF === void 0 ? [] : _this$props2$appliedF,
          additionalAction = _this$props2.additionalAction,
          _this$props2$focused = _this$props2.focused,
          focused = _this$props2$focused === void 0 ? false : _this$props2$focused,
          _this$props2$filters = _this$props2.filters,
          filters = _this$props2$filters === void 0 ? [] : _this$props2$filters,
          placeholder = _this$props2.placeholder,
          onSearchBlur = _this$props2.onSearchBlur,
          onSearchChange = _this$props2.onSearchChange,
          intl = _this$props2.polaris.intl,
          _this$props2$context = _this$props2.context,
          selectMode = _this$props2$context.selectMode,
          resourceName = _this$props2$context.resourceName;
      var textFieldLabel = placeholder ? placeholder : intl.translate('Polaris.ResourceList.FilterControl.textFieldLabel', {
        resourceNamePlural: resourceName.plural.toLocaleLowerCase()
      });

      if (additionalAction) {
        additionalAction.disabled = selectMode;
      }

      var additionalActionButton = additionalAction && buttonsFrom(additionalAction) || null;
      var filterCreatorMarkup = filters.length > 0 ? React.createElement(FilterCreator$1, {
        resourceName: resourceName,
        filters: filters,
        onAddFilter: this.handleAddFilter,
        disabled: selectMode
      }) : null;
      var appliedFiltersMarkup = appliedFilters.map(function (appliedFilter) {
        var activeFilterLabel = _this2.getFilterLabel(appliedFilter);

        var filterId = idFromFilter(appliedFilter);
        return React.createElement("li", {
          className: styles$1s.AppliedFilter,
          key: filterId
        }, React.createElement(Tag$1, {
          onRemove: _this2.getRemoveFilterCallback(filterId),
          disabled: selectMode
        }, activeFilterLabel));
      });
      var appliedFiltersWrapper = appliedFilters.length > 0 ? React.createElement("ul", {
        className: styles$1s.AppliedFilters
      }, appliedFiltersMarkup) : null;
      return React.createElement(FormLayout, null, React.createElement(TextField$1, {
        connectedLeft: filterCreatorMarkup,
        connectedRight: additionalActionButton,
        label: textFieldLabel,
        labelHidden: true,
        placeholder: textFieldLabel,
        prefix: React.createElement(Icon$1, {
          source: polarisIcons.SearchMinor,
          color: "skyDark"
        }),
        value: searchValue,
        onChange: onSearchChange,
        onBlur: onSearchBlur,
        focused: focused,
        disabled: selectMode
      }), appliedFiltersWrapper);
    }
  }, {
    key: "getRemoveFilterCallback",
    value: function getRemoveFilterCallback(filterId) {
      var _this3 = this;

      return function () {
        _this3.handleRemoveFilter(filterId);
      };
    }
  }, {
    key: "handleRemoveFilter",
    value: function handleRemoveFilter(filterId) {
      var _this$props3 = this.props,
          onFiltersChange = _this$props3.onFiltersChange,
          _this$props3$appliedF = _this$props3.appliedFilters,
          appliedFilters = _this$props3$appliedF === void 0 ? [] : _this$props3$appliedF;

      if (!onFiltersChange) {
        return;
      }

      var foundIndex = appliedFilters.findIndex(function (appliedFilter) {
        return idFromFilter(appliedFilter) === filterId;
      });
      var newAppliedFilters = foundIndex >= 0 ? [].concat(_toConsumableArray(appliedFilters.slice(0, foundIndex)), _toConsumableArray(appliedFilters.slice(foundIndex + 1, appliedFilters.length))) : _toConsumableArray(appliedFilters);
      onFiltersChange(newAppliedFilters);
    }
  }, {
    key: "getFilterLabel",
    value: function getFilterLabel(appliedFilter) {
      var key = appliedFilter.key,
          value = appliedFilter.value,
          label = appliedFilter.label;

      if (label) {
        return label;
      }

      var _this$props$filters = this.props.filters,
          filters = _this$props$filters === void 0 ? [] : _this$props$filters;
      var filter = filters.find(function (filter) {
        var minKey = filter.minKey,
            maxKey = filter.maxKey,
            operatorText = filter.operatorText;

        if (minKey || maxKey) {
          return filter.key === key || minKey === key || maxKey === key;
        }

        if (operatorText && typeof operatorText !== 'string') {
          return filter.key === key || operatorText.filter(function (_ref) {
            var operatorKey = _ref.key;
            return operatorKey === key;
          }).length === 1;
        }

        return filter.key === key;
      });

      if (!filter) {
        return value;
      }

      var filterOperatorLabel = findOperatorLabel(filter, appliedFilter);
      var filterLabelByType = this.findFilterLabelByType(filter, appliedFilter);

      if (!filterOperatorLabel) {
        return "".concat(filter.label, " ").concat(filterLabelByType);
      }

      return "".concat(filter.label, " ").concat(filterOperatorLabel, " ").concat(filterLabelByType);
    }
  }, {
    key: "findFilterLabelByType",
    value: function findFilterLabelByType(filter, appliedFilter) {
      var intl = this.props.polaris.intl;
      var appliedFilterValue = appliedFilter.value;

      if (filter.type === exports.FilterType.Select) {
        var foundFilterOption = filter.options.find(function (option) {
          return typeof option === 'string' ? option === appliedFilterValue : option.value === appliedFilterValue;
        });

        if (foundFilterOption) {
          return typeof foundFilterOption === 'string' ? foundFilterOption : foundFilterOption.label;
        }
      }

      if (filter.type === exports.FilterType.DateSelector) {
        if (filter.key === appliedFilter.key) {
          var filterLabelKey = "Polaris.ResourceList.DateSelector.FilterLabelForValue.".concat(appliedFilter.value);
          return intl.translationKeyExists(filterLabelKey) ? intl.translate(filterLabelKey) : appliedFilter.value;
        }

        if (appliedFilter.key === filter.maxKey) {
          return intl.translate('Polaris.ResourceList.DateSelector.FilterLabelForValue.on_or_before', {
            date: formatDateForLabelDisplay(appliedFilter.value)
          });
        }

        if (appliedFilter.key === filter.minKey) {
          return intl.translate('Polaris.ResourceList.DateSelector.FilterLabelForValue.on_or_after', {
            date: formatDateForLabelDisplay(appliedFilter.value)
          });
        }
      }

      return appliedFilterValue;
    }
  }]);

  return FilterControl;
}(React.Component);

function idFromFilter(appliedFilter) {
  return "".concat(appliedFilter.key, "-").concat(appliedFilter.value);
}

function formatDateForLabelDisplay(date) {
  if (isNaN(new Date(date).getTime())) {
    return date;
  }

  return new Date(date.replace(/-/g, '/')).toLocaleDateString();
}

function findOperatorLabel(filter, appliedFilter) {
  var operatorText = filter.operatorText;

  if (filter.type === exports.FilterType.DateSelector && (appliedFilter.key === filter.minKey || appliedFilter.key === filter.maxKey)) {
    return '';
  }

  if (!operatorText || typeof operatorText === 'string') {
    return operatorText;
  }

  var appliedOperator = operatorText.find(function (operator) {
    return operator.key === appliedFilter.key;
  });

  if (appliedOperator) {
    return appliedOperator.filterLabel || appliedOperator.optionLabel;
  }
}

var FilterControl$1 = compose(withAppProvider(), withContext(Consumer$3))(FilterControl);

var SELECT_ALL_ITEMS = 'All';

var styles$1t = {
  "CheckboxWrapper": "Polaris-ResourceList-Item__CheckboxWrapper",
  "Item": "Polaris-ResourceList-Item",
  "persistActions": "Polaris-ResourceList-Item--persistActions",
  "Actions": "Polaris-ResourceList-Item__Actions",
  "selected": "Polaris-ResourceList-Item--selected",
  "focused": "Polaris-ResourceList-Item--focused",
  "focusedInner": "Polaris-ResourceList-Item--focusedInner",
  "Link": "Polaris-ResourceList-Item__Link",
  "Button": "Polaris-ResourceList-Item__Button",
  "Container": "Polaris-ResourceList-Item__Container",
  "Owned": "Polaris-ResourceList-Item__Owned",
  "Handle": "Polaris-ResourceList-Item__Handle",
  "selectMode": "Polaris-ResourceList-Item--selectMode",
  "selectable": "Polaris-ResourceList-Item--selectable",
  "Media": "Polaris-ResourceList-Item__Media",
  "Content": "Polaris-ResourceList-Item__Content",
  "Disclosure": "Polaris-ResourceList-Item__Disclosure",
};

var getUniqueCheckboxID = other.createUniqueIDFactory('ResourceListItemCheckbox');
var Item$7 =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Item, _React$PureComponent);

  function Item() {
    var _this;

    _classCallCheck(this, Item);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Item).apply(this, arguments));
    _this.state = {
      actionsMenuVisible: false,
      focused: false,
      focusedInner: false
    };
    _this.node = null;
    _this.checkboxId = getUniqueCheckboxID();

    _this.setNode = function (node) {
      _this.node = node;
    };

    _this.handleAnchorFocus = function () {
      _this.setState({
        focused: true,
        focusedInner: false
      });
    };

    _this.handleFocusedBlur = function () {
      _this.setState({
        focused: true,
        focusedInner: true
      });
    };

    _this.handleFocus = function () {
      _this.setState({
        focused: true
      });
    };

    _this.handleBlur = function (event) {
      var isInside = _this.compareEventNode(event);

      if (_this.node == null || !_this.node.contains(event.relatedTarget)) {
        _this.setState({
          focused: false
        });
      } else if (isInside) {
        _this.setState({
          focusedInner: true
        });
      }
    };

    _this.handleMouseDown = function () {
      _this.setState({
        focusedInner: true
      });
    };

    _this.handleLargerSelectionArea = function (event) {
      stopPropagation$1(event);

      _this.handleSelection(!_this.isSelected());
    };

    _this.handleSelection = function (value) {
      var _this$props = _this.props,
          id = _this$props.id,
          onSelectionChange = _this$props.context.onSelectionChange;

      if (id == null || onSelectionChange == null) {
        return;
      }

      _this.setState({
        focused: true,
        focusedInner: true
      });

      onSelectionChange(value, id);
    };

    _this.handleClick = function (event) {
      var _this$props2 = _this.props,
          id = _this$props2.id,
          onClick = _this$props2.onClick,
          url = _this$props2.url,
          selectMode = _this$props2.context.selectMode;
      var _event$nativeEvent = event.nativeEvent,
          ctrlKey = _event$nativeEvent.ctrlKey,
          metaKey = _event$nativeEvent.metaKey;

      var anchor = _this.node && _this.node.querySelector('a');

      if (selectMode) {
        _this.handleLargerSelectionArea(event);

        return;
      }

      if (anchor === event.target) {
        return;
      }

      if (onClick) {
        onClick(id);
      }

      if (url && (ctrlKey || metaKey)) {
        window.open(url, '_blank');
        return;
      }

      if (url && anchor) {
        anchor.click();
      }
    };

    _this.handleKeypress = function (event) {
      var _this$props3 = _this.props,
          _this$props3$onClick = _this$props3.onClick,
          onClick = _this$props3$onClick === void 0 ? other.noop : _this$props3$onClick,
          selectMode = _this$props3.context.selectMode;
      var key = event.key;

      if (key === 'Enter' && !selectMode) {
        onClick();
      }
    };

    _this.handleActionsClick = function () {
      _this.setState(function (_ref) {
        var actionsMenuVisible = _ref.actionsMenuVisible;
        return {
          actionsMenuVisible: !actionsMenuVisible
        };
      });
    };

    _this.handleCloseRequest = function () {
      _this.setState({
        actionsMenuVisible: false
      });
    };

    return _this;
  }

  _createClass(Item, [{
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
          children = _this$props4.children,
          url = _this$props4.url,
          media = _this$props4.media,
          shortcutActions = _this$props4.shortcutActions,
          ariaControls = _this$props4.ariaControls,
          ariaExpanded = _this$props4.ariaExpanded,
          _this$props4$persistA = _this$props4.persistActions,
          persistActions = _this$props4$persistA === void 0 ? false : _this$props4$persistA,
          intl = _this$props4.polaris.intl,
          accessibilityLabel = _this$props4.accessibilityLabel,
          _this$props4$context = _this$props4.context,
          selectable = _this$props4$context.selectable,
          selectMode = _this$props4$context.selectMode,
          loading = _this$props4$context.loading;
      var _this$state = this.state,
          actionsMenuVisible = _this$state.actionsMenuVisible,
          focused = _this$state.focused,
          focusedInner = _this$state.focusedInner;
      var selected = this.isSelected();
      var ownedMarkup = null;
      var handleMarkup = null;
      var mediaMarkup = media ? React.createElement("div", {
        className: styles$1t.Media
      }, media) : null;
      var checkboxAccessibilityLabel = accessibilityLabel || intl.translate('Polaris.Common.checkbox');

      if (selectable) {
        var label = selected ? intl.translate('Polaris.ResourceList.Item.deselectItem', {
          accessibilityLabel: checkboxAccessibilityLabel
        }) : intl.translate('Polaris.ResourceList.Item.selectItem', {
          accessibilityLabel: checkboxAccessibilityLabel
        });
        handleMarkup = React.createElement("div", {
          className: styles$1t.Handle,
          onClick: this.handleLargerSelectionArea
        }, React.createElement("div", {
          onClick: stopPropagation$1,
          className: styles$1t.CheckboxWrapper
        }, React.createElement(Checkbox$2, {
          id: this.checkboxId,
          label: label,
          labelHidden: true,
          onChange: this.handleSelection,
          checked: selected,
          disabled: loading
        })));
      }

      if (media || selectable) {
        ownedMarkup = React.createElement("div", {
          className: styles$1t.Owned
        }, handleMarkup, mediaMarkup);
      }

      var className = styles.classNames(styles$1t.Item, focused && styles$1t.focused, selectable && styles$1t.selectable, selected && styles$1t.selected, selectMode && styles$1t.selectMode, persistActions && styles$1t.persistActions, focusedInner && styles$1t.focusedInner);
      var actionsMarkup = null;
      var disclosureMarkup = null;

      if (shortcutActions && !loading) {
        if (persistActions) {
          actionsMarkup = React.createElement("div", {
            className: styles$1t.Actions,
            onClick: stopPropagation$1
          }, React.createElement(ButtonGroup, null, buttonsFrom(shortcutActions, {
            size: 'slim',
            plain: true
          })));
          disclosureMarkup = React.createElement("div", {
            className: styles$1t.Disclosure,
            onClick: stopPropagation$1
          }, React.createElement(Popover, {
            activator: React.createElement(Button$1, {
              "aria-label": intl.translate('Polaris.ResourceList.Item.actionsDropdown'),
              onClick: this.handleActionsClick,
              plain: true,
              icon: polarisIcons.HorizontalDotsMinor
            }),
            onClose: this.handleCloseRequest,
            active: actionsMenuVisible
          }, React.createElement(ActionList, {
            items: shortcutActions
          })));
        } else {
          actionsMarkup = React.createElement("div", {
            className: styles$1t.Actions,
            onClick: stopPropagation$1
          }, React.createElement(ButtonGroup, {
            segmented: true
          }, buttonsFrom(shortcutActions, {
            size: 'slim'
          })));
        }
      }

      var content = children ? React.createElement("div", {
        className: styles$1t.Content
      }, children) : null;
      var containerMarkup = React.createElement("div", {
        className: styles$1t.Container,
        id: this.props.id
      }, ownedMarkup, content, actionsMarkup, disclosureMarkup);
      var tabIndex = loading ? -1 : 0;
      var accessibleMarkup = url ? React.createElement(UnstyledLink$1, {
        "aria-describedby": this.props.id,
        "aria-label": accessibilityLabel,
        className: styles$1t.Link,
        url: url,
        onFocus: this.handleAnchorFocus,
        onBlur: this.handleFocusedBlur,
        tabIndex: tabIndex
      }) : React.createElement("button", {
        className: styles$1t.Button,
        "aria-label": accessibilityLabel,
        "aria-controls": ariaControls,
        "aria-expanded": ariaExpanded,
        onClick: this.handleClick,
        onFocus: this.handleAnchorFocus,
        onBlur: this.handleFocusedBlur,
        tabIndex: tabIndex
      });
      return React.createElement("div", {
        ref: this.setNode,
        className: className,
        onClick: this.handleClick,
        onFocus: this.handleFocus,
        onBlur: this.handleBlur,
        onMouseDown: this.handleMouseDown,
        onKeyUp: this.handleKeypress,
        "data-href": url
      }, accessibleMarkup, containerMarkup);
    }
  }, {
    key: "isSelected",
    value: function isSelected() {
      var _this$props5 = this.props,
          id = _this$props5.id,
          selectedItems = _this$props5.context.selectedItems;
      return selectedItems && (Array.isArray(selectedItems) && selectedItems.includes(id) || selectedItems === SELECT_ALL_ITEMS);
    }
  }, {
    key: "compareEventNode",
    value: function compareEventNode(event) {
      return this.props.onClick ? event.target === this.node : event.target.tagName.toLowerCase() === 'a';
    }
  }]);

  return Item;
}(React.PureComponent);

function stopPropagation$1(event) {
  event.stopPropagation();
}

var Item$8 = compose(withContext(Consumer$3), withAppProvider())(Item$7);

var styles$1u = {
  "FiltersWrapper": "Polaris-ResourceList__FiltersWrapper",
  "ResourceList": "Polaris-ResourceList",
  "HeaderOuterWrapper": "Polaris-ResourceList__HeaderOuterWrapper",
  "HeaderWrapper-disabled": "Polaris-ResourceList__HeaderWrapper--disabled",
  "HeaderWrapper-overlay": "Polaris-ResourceList__HeaderWrapper--overlay",
  "HeaderWrapper": "Polaris-ResourceList__HeaderWrapper",
  "HeaderWrapper-isSticky": "Polaris-ResourceList__HeaderWrapper--isSticky",
  "HeaderContentWrapper": "Polaris-ResourceList__HeaderContentWrapper",
  "HeaderWrapper-inSelectMode": "Polaris-ResourceList__HeaderWrapper--inSelectMode",
  "SortWrapper": "Polaris-ResourceList__SortWrapper",
  "AlternateToolWrapper": "Polaris-ResourceList__AlternateToolWrapper",
  "HeaderWrapper-hasSelect": "Polaris-ResourceList__HeaderWrapper--hasSelect",
  "HeaderWrapper-hasAlternateTool": "Polaris-ResourceList__HeaderWrapper--hasAlternateTool",
  "HeaderWrapper-hasSort": "Polaris-ResourceList__HeaderWrapper--hasSort",
  "SortLabel": "Polaris-ResourceList__SortLabel",
  "HeaderTitleWrapper": "Polaris-ResourceList__HeaderTitleWrapper",
  "BulkActionsWrapper": "Polaris-ResourceList__BulkActionsWrapper",
  "CheckableButtonWrapper": "Polaris-ResourceList__CheckableButtonWrapper",
  "SelectButtonWrapper": "Polaris-ResourceList__SelectButtonWrapper",
  "EmptySearchResultWrapper": "Polaris-ResourceList__EmptySearchResultWrapper",
  "ResourceListWrapper": "Polaris-ResourceList__ResourceListWrapper",
  "ItemWrapper": "Polaris-ResourceList__ItemWrapper",
  "ItemWrapper-isLoading": "Polaris-ResourceList__ItemWrapper--isLoading",
  "SpinnerContainer": "Polaris-ResourceList__SpinnerContainer",
  "LoadingOverlay": "Polaris-ResourceList__LoadingOverlay",
  "DisabledPointerEvents": "Polaris-ResourceList__DisabledPointerEvents",
};

var SMALL_SCREEN_WIDTH = 458;
var SMALL_SPINNER_HEIGHT = 28;
var LARGE_SPINNER_HEIGHT = 45;
var getUniqueID$d = other.createUniqueIDFactory('Select');
var ResourceList =
/*#__PURE__*/
function (_React$Component) {
  _inherits(ResourceList, _React$Component);

  function ResourceList(props) {
    var _this;

    _classCallCheck(this, ResourceList);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ResourceList).call(this, props));
    _this.listRef = React.createRef();
    _this.handleResize = debounce(function () {
      var selectedItems = _this.props.selectedItems;
      var selectMode = _this.state.selectMode;

      if (selectedItems && selectedItems.length === 0 && selectMode && !isSmallScreen()) {
        _this.handleSelectMode(false);
      }
    }, 50);

    _this.setLoadingPosition = function () {
      if (_this.listRef.current != null) {
        if (typeof window === 'undefined') {
          return;
        }

        var overlay = _this.listRef.current.getBoundingClientRect();

        var viewportHeight = Math.max(document.documentElement ? document.documentElement.clientHeight : 0, window.innerHeight || 0);
        var overflow = viewportHeight - overlay.height;
        var spinnerHeight = _this.props.items.length === 1 ? SMALL_SPINNER_HEIGHT : LARGE_SPINNER_HEIGHT;
        var spinnerPosition = overflow > 0 ? (overlay.height - spinnerHeight) / 2 : (viewportHeight - overlay.top - spinnerHeight) / 2;

        _this.setState({
          loadingPosition: spinnerPosition
        });
      }
    };

    _this.handleSelectAllItemsInStore = function () {
      var _this$props = _this.props,
          onSelectionChange = _this$props.onSelectionChange,
          selectedItems = _this$props.selectedItems,
          items = _this$props.items,
          _this$props$idForItem = _this$props.idForItem,
          idForItem = _this$props$idForItem === void 0 ? defaultIdForItem : _this$props$idForItem;
      var newlySelectedItems = selectedItems === SELECT_ALL_ITEMS ? getAllItemsOnPage(items, idForItem) : SELECT_ALL_ITEMS;

      if (onSelectionChange) {
        onSelectionChange(newlySelectedItems);
      }
    };

    _this.renderItem = function (item, index) {
      var _this$props2 = _this.props,
          renderItem = _this$props2.renderItem,
          _this$props2$idForIte = _this$props2.idForItem,
          idForItem = _this$props2$idForIte === void 0 ? defaultIdForItem : _this$props2$idForIte;
      var id = idForItem(item, index);
      return React.createElement("li", {
        key: id,
        className: styles$1u.ItemWrapper
      }, renderItem(item, id));
    };

    _this.handleSelectionChange = function (selected, id) {
      var _this$props3 = _this.props,
          onSelectionChange = _this$props3.onSelectionChange,
          selectedItems = _this$props3.selectedItems,
          items = _this$props3.items,
          _this$props3$idForIte = _this$props3.idForItem,
          idForItem = _this$props3$idForIte === void 0 ? defaultIdForItem : _this$props3$idForIte;

      if (selectedItems == null || onSelectionChange == null) {
        return;
      }

      var newlySelectedItems = selectedItems === SELECT_ALL_ITEMS ? getAllItemsOnPage(items, idForItem) : _toConsumableArray(selectedItems);

      if (selected) {
        newlySelectedItems.push(id);
      } else {
        newlySelectedItems.splice(newlySelectedItems.indexOf(id), 1);
      }

      if (newlySelectedItems.length === 0 && !isSmallScreen()) {
        _this.handleSelectMode(false);
      } else if (newlySelectedItems.length > 0) {
        _this.handleSelectMode(true);
      }

      if (onSelectionChange) {
        onSelectionChange(newlySelectedItems);
      }
    };

    _this.handleSelectMode = function (selectMode) {
      var onSelectionChange = _this.props.onSelectionChange;

      _this.setState({
        selectMode: selectMode
      });

      if (!selectMode && onSelectionChange) {
        onSelectionChange([]);
      }
    };

    _this.handleToggleAll = function () {
      var _this$props4 = _this.props,
          onSelectionChange = _this$props4.onSelectionChange,
          selectedItems = _this$props4.selectedItems,
          items = _this$props4.items,
          _this$props4$idForIte = _this$props4.idForItem,
          idForItem = _this$props4$idForIte === void 0 ? defaultIdForItem : _this$props4$idForIte;
      var newlySelectedItems = [];

      if (Array.isArray(selectedItems) && selectedItems.length === items.length || selectedItems === SELECT_ALL_ITEMS) {
        newlySelectedItems = [];
      } else {
        newlySelectedItems = items.map(function (item, index) {
          var id = idForItem(item, index);
          return id;
        });
      }

      if (newlySelectedItems.length === 0 && !isSmallScreen()) {
        _this.handleSelectMode(false);
      } else if (newlySelectedItems.length > 0) {
        _this.handleSelectMode(true);
      }

      if (onSelectionChange) {
        onSelectionChange(newlySelectedItems);
      }
    };

    var selectedItems = props.selectedItems,
        intl = props.polaris.intl;
    _this.defaultResourceName = {
      singular: intl.translate('Polaris.ResourceList.defaultItemSingular'),
      plural: intl.translate('Polaris.ResourceList.defaultItemPlural')
    };
    _this.state = {
      selectMode: Boolean(selectedItems && selectedItems.length > 0),
      loadingPosition: 0
    };
    return _this;
  }

  _createClass(ResourceList, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.forceUpdate();

      if (this.props.loading) {
        this.setLoadingPosition();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_ref) {
      var prevLoading = _ref.loading,
          prevItems = _ref.items,
          prevSelectedItems = _ref.selectedItems;
      var _this$props5 = this.props,
          selectedItems = _this$props5.selectedItems,
          loading = _this$props5.loading;

      if (this.listRef.current && this.itemsExist() && !this.itemsExist(prevItems)) {
        this.forceUpdate();
      }

      if (loading && !prevLoading) {
        this.setLoadingPosition();
      }

      if (selectedItems && selectedItems.length > 0 && !this.state.selectMode) {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          selectMode: true
        });
        return;
      }

      if (prevSelectedItems && prevSelectedItems.length > 0 && (!selectedItems || selectedItems.length === 0) && !isSmallScreen()) {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          selectMode: false
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props6 = this.props,
          items = _this$props6.items,
          promotedBulkActions = _this$props6.promotedBulkActions,
          bulkActions = _this$props6.bulkActions,
          filterControl = _this$props6.filterControl,
          loading = _this$props6.loading,
          _this$props6$showHead = _this$props6.showHeader,
          showHeader = _this$props6$showHead === void 0 ? false : _this$props6$showHead,
          sortOptions = _this$props6.sortOptions,
          sortValue = _this$props6.sortValue,
          alternateTool = _this$props6.alternateTool,
          onSortChange = _this$props6.onSortChange,
          intl = _this$props6.polaris.intl;
      var _this$state = this.state,
          selectMode = _this$state.selectMode,
          loadingPosition = _this$state.loadingPosition;
      var filterControlMarkup = filterControl ? React.createElement("div", {
        className: styles$1u.FiltersWrapper
      }, filterControl) : null;
      var bulkActionsMarkup = this.selectable ? React.createElement("div", {
        className: styles$1u.BulkActionsWrapper
      }, React.createElement(BulkActions$1, {
        label: this.bulkActionsLabel,
        accessibilityLabel: this.bulkActionsAccessibilityLabel,
        selected: this.bulkSelectState,
        onToggleAll: this.handleToggleAll,
        selectMode: selectMode,
        onSelectModeToggle: this.handleSelectMode,
        promotedActions: promotedBulkActions,
        paginatedSelectAllAction: this.paginatedSelectAllAction,
        paginatedSelectAllText: this.paginatedSelectAllText,
        actions: bulkActions,
        disabled: loading
      }), React.createElement(EventListener, {
        event: "resize",
        handler: this.handleResize
      })) : null;
      var selectId = getUniqueID$d();
      var sortingLabelMarkup = React.createElement("label", {
        className: styles$1u.SortLabel,
        htmlFor: selectId
      }, intl.translate('Polaris.ResourceList.sortingLabel'));
      var sortingSelectMarkup = sortOptions && sortOptions.length > 0 && !alternateTool ? React.createElement("div", {
        className: styles$1u.SortWrapper
      }, sortingLabelMarkup, React.createElement(Select, {
        label: intl.translate('Polaris.ResourceList.sortingLabel'),
        labelHidden: true,
        options: sortOptions,
        onChange: onSortChange,
        value: sortValue,
        disabled: selectMode
      })) : null;
      var alternateToolMarkup = alternateTool && !sortingSelectMarkup ? React.createElement("div", {
        className: styles$1u.AlternateToolWrapper
      }, alternateTool) : null;
      var headerTitleMarkup = React.createElement("div", {
        className: styles$1u.HeaderTitleWrapper
      }, this.headerTitle);
      var selectButtonMarkup = this.selectable ? React.createElement("div", {
        className: styles$1u.SelectButtonWrapper
      }, React.createElement(Button$1, {
        disabled: selectMode,
        icon: polarisIcons.EnableSelectionMinor // eslint-disable-next-line react/jsx-no-bind
        ,
        onClick: this.handleSelectMode.bind(this, true)
      }, intl.translate('Polaris.ResourceList.selectButtonText'))) : null;
      var checkableButtonMarkup = this.selectable ? React.createElement("div", {
        className: styles$1u.CheckableButtonWrapper
      }, React.createElement(CheckableButton$1, {
        accessibilityLabel: this.bulkActionsAccessibilityLabel,
        label: this.headerTitle,
        onToggleAll: this.handleToggleAll,
        plain: true,
        disabled: loading
      })) : null;
      var needsHeader = this.selectable || sortOptions && sortOptions.length > 0 || alternateTool;
      var headerWrapperOverlay = loading ? React.createElement("div", {
        className: styles$1u['HeaderWrapper-overlay']
      }) : null;
      var showEmptyState = filterControl && !this.itemsExist() && !loading;
      var headerMarkup = !showEmptyState && (showHeader || needsHeader) && this.listRef.current && React.createElement("div", {
        className: styles$1u.HeaderOuterWrapper
      }, React.createElement(Sticky, {
        boundingElement: this.listRef.current
      }, function (isSticky) {
        var headerClassName = styles.classNames(styles$1u.HeaderWrapper, sortOptions && sortOptions.length > 0 && !alternateTool && styles$1u['HeaderWrapper-hasSort'], alternateTool && styles$1u['HeaderWrapper-hasAlternateTool'], _this2.selectable && styles$1u['HeaderWrapper-hasSelect'], loading && styles$1u['HeaderWrapper-disabled'], _this2.selectable && selectMode && styles$1u['HeaderWrapper-inSelectMode'], isSticky && styles$1u['HeaderWrapper-isSticky']);
        return React.createElement("div", {
          className: headerClassName
        }, headerWrapperOverlay, React.createElement("div", {
          className: styles$1u.HeaderContentWrapper
        }, headerTitleMarkup, checkableButtonMarkup, alternateToolMarkup, sortingSelectMarkup, selectButtonMarkup), bulkActionsMarkup);
      }));
      var emptyStateMarkup = showEmptyState ? React.createElement("div", {
        className: styles$1u.EmptySearchResultWrapper
      }, React.createElement(EmptySearchResult$1, Object.assign({}, this.emptySearchResultText, {
        withIllustration: true
      }))) : null;
      var defaultTopPadding = 8;
      var topPadding = loadingPosition > 0 ? loadingPosition : defaultTopPadding;
      var spinnerStyle = {
        paddingTop: "".concat(topPadding, "px")
      };
      var spinnerSize = items.length < 2 ? 'small' : 'large';
      var loadingOverlay = loading ? React.createElement(React.Fragment, null, React.createElement("div", {
        className: styles$1u.SpinnerContainer,
        style: spinnerStyle
      }, React.createElement(Spinner$1, {
        size: spinnerSize,
        accessibilityLabel: "Items are loading"
      })), React.createElement("div", {
        className: styles$1u.LoadingOverlay
      })) : null;
      var className = styles.classNames(styles$1u.ItemWrapper, loading && styles$1u['ItemWrapper-isLoading']);
      var loadingWithoutItemsMarkup = loading && !this.itemsExist() ? React.createElement("div", {
        className: className,
        tabIndex: -1
      }, loadingOverlay) : null;
      var resourceListClassName = styles.classNames(styles$1u.ResourceList, loading && styles$1u.disabledPointerEvents);
      var listMarkup = this.itemsExist() ? React.createElement("ul", {
        className: resourceListClassName,
        ref: this.listRef,
        "aria-live": "polite",
        "aria-busy": loading
      }, loadingOverlay, items.map(this.renderItem)) : emptyStateMarkup;
      return React.createElement(Provider$3, {
        value: this.getContext
      }, React.createElement("div", {
        className: styles$1u.ResourceListWrapper
      }, filterControlMarkup, headerMarkup, listMarkup, loadingWithoutItemsMarkup));
    }
  }, {
    key: "itemsExist",
    value: function itemsExist(items) {
      return (items || this.props.items).length > 0;
    }
  }, {
    key: "selectable",
    get: function get() {
      var _this$props7 = this.props,
          promotedBulkActions = _this$props7.promotedBulkActions,
          bulkActions = _this$props7.bulkActions;
      return Boolean(promotedBulkActions && promotedBulkActions.length > 0 || bulkActions && bulkActions.length > 0);
    }
  }, {
    key: "bulkSelectState",
    get: function get() {
      var _this$props8 = this.props,
          selectedItems = _this$props8.selectedItems,
          items = _this$props8.items;
      var selectState = 'indeterminate';

      if (!selectedItems || Array.isArray(selectedItems) && selectedItems.length === 0) {
        selectState = false;
      } else if (selectedItems === SELECT_ALL_ITEMS || Array.isArray(selectedItems) && selectedItems.length === items.length) {
        selectState = true;
      }

      return selectState;
    }
  }, {
    key: "headerTitle",
    get: function get() {
      var _this$props9 = this.props,
          _this$props9$resource = _this$props9.resourceName,
          resourceName = _this$props9$resource === void 0 ? this.defaultResourceName : _this$props9$resource,
          items = _this$props9.items,
          intl = _this$props9.polaris.intl,
          loading = _this$props9.loading;
      var itemsCount = items.length;
      var resource = itemsCount === 1 && !loading ? resourceName.singular : resourceName.plural;
      var headerTitleMarkup = loading ? intl.translate('Polaris.ResourceList.loading', {
        resource: resource
      }) : intl.translate('Polaris.ResourceList.showing', {
        itemsCount: itemsCount,
        resource: resource
      });
      return headerTitleMarkup;
    }
  }, {
    key: "bulkActionsLabel",
    get: function get() {
      var _this$props10 = this.props,
          _this$props10$selecte = _this$props10.selectedItems,
          selectedItems = _this$props10$selecte === void 0 ? [] : _this$props10$selecte,
          items = _this$props10.items,
          intl = _this$props10.polaris.intl;
      var selectedItemsCount = selectedItems === SELECT_ALL_ITEMS ? "".concat(items.length, "+") : selectedItems.length;
      return intl.translate('Polaris.ResourceList.selected', {
        selectedItemsCount: selectedItemsCount
      });
    }
  }, {
    key: "bulkActionsAccessibilityLabel",
    get: function get() {
      var _this$props11 = this.props,
          _this$props11$resourc = _this$props11.resourceName,
          resourceName = _this$props11$resourc === void 0 ? this.defaultResourceName : _this$props11$resourc,
          _this$props11$selecte = _this$props11.selectedItems,
          selectedItems = _this$props11$selecte === void 0 ? [] : _this$props11$selecte,
          items = _this$props11.items,
          intl = _this$props11.polaris.intl;
      var selectedItemsCount = selectedItems.length;
      var totalItemsCount = items.length;
      var allSelected = selectedItemsCount === totalItemsCount;

      if (totalItemsCount === 1 && allSelected) {
        return intl.translate('Polaris.ResourceList.a11yCheckboxDeselectAllSingle', {
          resourceNameSingular: resourceName.singular
        });
      } else if (totalItemsCount === 1) {
        return intl.translate('Polaris.ResourceList.a11yCheckboxSelectAllSingle', {
          resourceNameSingular: resourceName.singular
        });
      } else if (allSelected) {
        return intl.translate('Polaris.ResourceList.a11yCheckboxDeselectAllMultiple', {
          itemsLength: items.length,
          resourceNamePlural: resourceName.plural
        });
      } else {
        return intl.translate('Polaris.ResourceList.a11yCheckboxSelectAllMultiple', {
          itemsLength: items.length,
          resourceNamePlural: resourceName.plural
        });
      }
    }
  }, {
    key: "paginatedSelectAllText",
    get: function get() {
      var _this$props12 = this.props,
          hasMoreItems = _this$props12.hasMoreItems,
          selectedItems = _this$props12.selectedItems,
          items = _this$props12.items,
          _this$props12$resourc = _this$props12.resourceName,
          resourceName = _this$props12$resourc === void 0 ? this.defaultResourceName : _this$props12$resourc,
          intl = _this$props12.polaris.intl;

      if (!this.selectable || !hasMoreItems) {
        return;
      }

      if (selectedItems === SELECT_ALL_ITEMS) {
        return intl.translate('Polaris.ResourceList.allItemsSelected', {
          itemsLength: items.length,
          resourceNamePlural: resourceName.plural
        });
      }
    }
  }, {
    key: "paginatedSelectAllAction",
    get: function get() {
      var _this$props13 = this.props,
          hasMoreItems = _this$props13.hasMoreItems,
          selectedItems = _this$props13.selectedItems,
          items = _this$props13.items,
          _this$props13$resourc = _this$props13.resourceName,
          resourceName = _this$props13$resourc === void 0 ? this.defaultResourceName : _this$props13$resourc,
          intl = _this$props13.polaris.intl;

      if (!this.selectable || !hasMoreItems) {
        return;
      }

      var actionText = selectedItems === SELECT_ALL_ITEMS ? intl.translate('Polaris.Common.undo') : intl.translate('Polaris.ResourceList.selectAllItems', {
        itemsLength: items.length,
        resourceNamePlural: resourceName.plural
      });
      return {
        content: actionText,
        onAction: this.handleSelectAllItemsInStore
      };
    }
  }, {
    key: "emptySearchResultText",
    get: function get() {
      var _this$props14 = this.props,
          intl = _this$props14.polaris.intl,
          _this$props14$resourc = _this$props14.resourceName,
          resourceName = _this$props14$resourc === void 0 ? this.defaultResourceName : _this$props14$resourc;
      return {
        title: intl.translate('Polaris.ResourceList.emptySearchResultTitle', {
          resourceNamePlural: resourceName.plural
        }),
        description: intl.translate('Polaris.ResourceList.emptySearchResultDescription')
      };
    }
  }, {
    key: "getContext",
    get: function get() {
      var _this$props15 = this.props,
          selectedItems = _this$props15.selectedItems,
          _this$props15$resourc = _this$props15.resourceName,
          resourceName = _this$props15$resourc === void 0 ? this.defaultResourceName : _this$props15$resourc,
          loading = _this$props15.loading;
      var selectMode = this.state.selectMode;
      return {
        selectable: this.selectable,
        selectedItems: selectedItems,
        selectMode: selectMode,
        resourceName: resourceName,
        loading: loading,
        onSelectionChange: this.handleSelectionChange
      };
    }
  }]);

  return ResourceList;
}(React.Component);
ResourceList.Item = Item$8;
ResourceList.FilterControl = FilterControl$1;

function getAllItemsOnPage(items, idForItem) {
  return items.map(function (item, index) {
    return idForItem(item, index);
  });
}

function defaultIdForItem(item, index) {
  return item.hasOwnProperty('id') ? item.id : index.toString();
}

function isSmallScreen() {
  return typeof window === 'undefined' ? false : window.innerWidth <= SMALL_SCREEN_WIDTH;
}

var ResourceList$1 = withAppProvider()(ResourceList);

var ResourcePicker =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(ResourcePicker, _React$PureComponent);

  function ResourcePicker() {
    var _this;

    _classCallCheck(this, ResourcePicker);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ResourcePicker).apply(this, arguments));
    _this.focusReturnPoint = null;
    return _this;
  }

  _createClass(ResourcePicker, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.polaris.appBridge == null) {
        return;
      }

      var _this$props = this.props,
          open = _this$props.open,
          resourceType = _this$props.resourceType,
          initialQuery = _this$props.initialQuery,
          _this$props$showHidde = _this$props.showHidden,
          showHidden = _this$props$showHidde === void 0 ? true : _this$props$showHidde,
          _this$props$allowMult = _this$props.allowMultiple,
          allowMultiple = _this$props$allowMult === void 0 ? true : _this$props$allowMult,
          _this$props$showVaria = _this$props.showVariants,
          showVariants = _this$props$showVaria === void 0 ? true : _this$props$showVaria,
          onSelection = _this$props.onSelection,
          onCancel = _this$props.onCancel;
      var appBridge = this.props.polaris.appBridge;
      this.appBridgeResourcePicker = actions.ResourcePicker.create(appBridge, {
        resourceType: actions.ResourcePicker.ResourceType[resourceType],
        options: {
          initialQuery: initialQuery,
          showHidden: showHidden,
          selectMultiple: allowMultiple,
          showVariants: showVariants
        }
      });

      if (onSelection != null) {
        this.appBridgeResourcePicker.subscribe(actions.ResourcePicker.Action.SELECT, function (_ref) {
          var selection = _ref.selection;
          onSelection({
            selection: selection
          });
        });
      }

      if (onCancel != null) {
        this.appBridgeResourcePicker.subscribe(actions.ResourcePicker.Action.CANCEL, onCancel);
      }

      if (open) {
        this.focusReturnPoint = document.activeElement;
        this.appBridgeResourcePicker.dispatch(actions.ResourcePicker.Action.OPEN);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.appBridgeResourcePicker == null) {
        return;
      }

      var _this$props2 = this.props,
          open = _this$props2.open,
          initialQuery = _this$props2.initialQuery,
          _this$props2$showHidd = _this$props2.showHidden,
          showHidden = _this$props2$showHidd === void 0 ? false : _this$props2$showHidd,
          _this$props2$allowMul = _this$props2.allowMultiple,
          allowMultiple = _this$props2$allowMul === void 0 ? true : _this$props2$allowMul,
          _this$props2$showVari = _this$props2.showVariants,
          showVariants = _this$props2$showVari === void 0 ? true : _this$props2$showVari;
      var wasOpen = prevProps.open;

      if (!isEqual(prevProps, this.props)) {
        this.appBridgeResourcePicker.set({
          initialQuery: initialQuery,
          showHidden: showHidden,
          selectMultiple: allowMultiple,
          showVariants: showVariants
        });
      }

      if (wasOpen !== open) {
        if (open) {
          this.appBridgeResourcePicker.dispatch(actions.ResourcePicker.Action.OPEN);
        } else {
          this.appBridgeResourcePicker.dispatch(actions.ResourcePicker.Action.CLOSE);
        }
      }

      if (!wasOpen && open) {
        this.focusReturnPoint = document.activeElement;
      } else if (wasOpen && !open && this.focusReturnPoint != null && document.contains(this.focusReturnPoint)) {
        this.focusReturnPoint.focus();
        this.focusReturnPoint = null;
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.appBridgeResourcePicker == null) {
        return;
      }

      this.appBridgeResourcePicker.unsubscribe();
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);

  return ResourcePicker;
}(React.PureComponent);
var ResourcePicker$1 = withAppProvider()(ResourcePicker);

function SettingToggle(_ref) {
  var enabled = _ref.enabled,
      action = _ref.action,
      children = _ref.children;
  var actionMarkup = action ? buttonFrom(action, {
    primary: !enabled
  }) : null;
  return React.createElement(Card, {
    sectioned: true
  }, React.createElement(SettingAction, {
    action: actionMarkup
  }, children));
}

function getVisibleAndHiddenTabIndices(tabs, selected, disclosureWidth, tabWidths, containerWidth) {
  var sumTabWidths = tabWidths.reduce(function (sum, width) {
    return sum + width;
  }, 0);
  var arrayOfTabIndices = tabs.map(function (_, index) {
    return index;
  });
  var visibleTabs = [];
  var hiddenTabs = [];

  if (containerWidth > sumTabWidths) {
    visibleTabs.push.apply(visibleTabs, _toConsumableArray(arrayOfTabIndices));
  } else {
    visibleTabs.push(selected);
    var newTabWidth = tabWidths[selected];
    arrayOfTabIndices.forEach(function (index) {
      if (index !== selected) {
        if (newTabWidth + tabWidths[index] > containerWidth - disclosureWidth) {
          hiddenTabs.push(index);
          return;
        }

        visibleTabs.push(index);
        newTabWidth += tabWidths[index];
      }
    });
  }

  return {
    visibleTabs: visibleTabs,
    hiddenTabs: hiddenTabs
  };
}

var styles$1v = {
  "Tabs": "Polaris-Tabs",
  "fitted": "Polaris-Tabs--fitted",
  "TabContainer": "Polaris-Tabs__TabContainer",
  "Tab": "Polaris-Tabs__Tab",
  "Title": "Polaris-Tabs__Title",
  "fillSpace": "Polaris-Tabs--fillSpace",
  "Tab-selected": "Polaris-Tabs__Tab--selected",
  "Panel": "Polaris-Tabs__Panel",
  "List": "Polaris-Tabs__List",
  "Item": "Polaris-Tabs__Item",
  "DisclosureTab": "Polaris-Tabs__DisclosureTab",
  "DisclosureTab-visible": "Polaris-Tabs__DisclosureTab--visible",
  "DisclosureActivator": "Polaris-Tabs__DisclosureActivator",
  "TabMeasurer": "Polaris-Tabs__TabMeasurer",
};

var Item$9 =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Item, _React$PureComponent);

  function Item() {
    var _this;

    _classCallCheck(this, Item);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Item).apply(this, arguments));
    _this.focusedNode = null;

    _this.setFocusedNode = function (node) {
      _this.focusedNode = node;
    };

    return _this;
  }

  _createClass(Item, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var focusedNode = this.focusedNode;
      var focused = this.props.focused;

      if (focusedNode && focusedNode instanceof HTMLElement && focused) {
        focusedNode.focus();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var focusedNode = this.focusedNode;
      var focused = this.props.focused;

      if (focusedNode && focusedNode instanceof HTMLElement && focused) {
        focusedNode.focus();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          panelID = _this$props.panelID,
          children = _this$props.children,
          url = _this$props.url,
          accessibilityLabel = _this$props.accessibilityLabel,
          _this$props$onClick = _this$props.onClick,
          onClick = _this$props$onClick === void 0 ? other.noop : _this$props$onClick;
      var sharedProps = {
        id: id,
        ref: this.setFocusedNode,
        onClick: onClick,
        className: styles$1v.Item,
        'aria-controls': panelID,
        'aria-selected': false,
        'aria-label': accessibilityLabel
      };
      var markup = url ? React.createElement(UnstyledLink$1, Object.assign({
        url: url
      }, sharedProps), children) : React.createElement("button", Object.assign({}, sharedProps, {
        type: "button"
      }), children);
      return React.createElement("li", {
        role: "presentation"
      }, markup);
    }
  }]);

  return Item;
}(React.PureComponent);

var List =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(List, _React$PureComponent);

  function List() {
    var _this;

    _classCallCheck(this, List);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(List).apply(this, arguments));

    _this.handleKeypress = function (event) {
      var _this$props$onKeyPres = _this.props.onKeyPress,
          onKeyPress = _this$props$onKeyPres === void 0 ? other.noop : _this$props$onKeyPres;
      onKeyPress(event);
    };

    return _this;
  }

  _createClass(List, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          focusIndex = _this$props.focusIndex,
          disclosureTabs = _this$props.disclosureTabs,
          _this$props$onClick = _this$props.onClick,
          onClick = _this$props$onClick === void 0 ? other.noop : _this$props$onClick;
      var tabs = disclosureTabs.map(function (_a, index) {
        var id = _a.id,
            content = _a.content,
            tabProps = tslib_1.__rest(_a, ["id", "content"]);

        return React.createElement(Item$9, Object.assign({}, tabProps, {
          key: id,
          id: id,
          focused: index === focusIndex // eslint-disable-next-line react/jsx-no-bind
          ,
          onClick: onClick.bind(null, id)
        }), content);
      });
      return React.createElement("ul", {
        className: styles$1v.List,
        onKeyDown: handleKeyDown$1,
        onKeyUp: this.handleKeypress
      }, tabs);
    }
  }]);

  return List;
}(React.PureComponent);

function handleKeyDown$1(event) {
  var key = event.key;

  if (key === 'ArrowUp' || key === 'ArrowDown' || key === 'ArrowLeft' || key === 'ArrowRight') {
    event.preventDefault();
    event.stopPropagation();
  }
}

function Panel(_ref) {
  var id = _ref.id,
      tabID = _ref.tabID,
      children = _ref.children;
  return React.createElement("div", {
    className: styles$1v.Panel,
    id: id,
    role: "tabpanel",
    "aria-labelledby": tabID,
    tabIndex: -1
  }, children);
}

var Tab =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Tab, _React$PureComponent);

  function Tab() {
    var _this;

    _classCallCheck(this, Tab);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Tab).apply(this, arguments));
    _this.node = null;

    _this.setNode = function (node) {
      _this.node = node;
    };

    return _this;
  } // A tab can start selected when it is moved from the disclosure dropdown
  // into the main list, so we need to send focus from the tab to the panel
  // on mount and update


  _createClass(Tab, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props = this.props,
          id = _this$props.id,
          measuring = _this$props.measuring,
          selected = _this$props.selected,
          panelID = _this$props.panelID,
          focused = _this$props.focused;

      if (measuring) {
        return;
      } // Because of timing issues with the render, we may still have the old,
      // in-disclosure version of the tab that has focus. Check for this
      // as a second indicator of focus


      var itemHadFocus = focused || document.activeElement && document.activeElement.id === id; // If we just check for selected, the panel for the active tab will
      // be focused on page load, which we don’t want

      if (itemHadFocus && selected && panelID != null) {
        focusPanelID(panelID);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(previousProps) {
      var wasSelected = previousProps.selected;
      var _this$props2 = this.props,
          focused = _this$props2.focused,
          measuring = _this$props2.measuring,
          selected = _this$props2.selected,
          panelID = _this$props2.panelID;

      if (measuring) {
        return;
      }

      if (selected && !wasSelected && panelID != null) {
        focusPanelID(panelID);
      } else if (focused && this.node != null) {
        focus.focusFirstFocusableNode(this.node);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          id = _this$props3.id,
          focused = _this$props3.focused,
          siblingTabHasFocus = _this$props3.siblingTabHasFocus,
          children = _this$props3.children,
          onClick = _this$props3.onClick,
          selected = _this$props3.selected,
          url = _this$props3.url,
          panelID = _this$props3.panelID,
          measuring = _this$props3.measuring,
          accessibilityLabel = _this$props3.accessibilityLabel;
      var handleClick = onClick && onClick.bind(null, id);
      var className = styles.classNames(styles$1v.Tab, selected && styles$1v['Tab-selected']);
      var tabIndex;

      if (selected && !siblingTabHasFocus && !measuring) {
        tabIndex = 0;
      } else if (focused && !measuring) {
        tabIndex = 0;
      } else {
        tabIndex = -1;
      }

      var markup = url ? React.createElement(UnstyledLink$1, {
        id: id,
        url: url,
        role: "tab",
        tabIndex: tabIndex,
        onClick: handleClick,
        className: className,
        "aria-selected": selected,
        "aria-controls": panelID,
        "aria-label": accessibilityLabel,
        onMouseUp: handleMouseUpByBlurring
      }, React.createElement("span", {
        className: styles$1v.Title
      }, children)) : React.createElement("button", {
        id: id,
        role: "tab",
        type: "button",
        tabIndex: tabIndex,
        className: className,
        onClick: handleClick,
        "aria-selected": selected,
        "aria-controls": panelID,
        "aria-label": accessibilityLabel,
        onMouseUp: handleMouseUpByBlurring
      }, React.createElement("span", {
        className: styles$1v.Title
      }, children));
      return React.createElement("li", {
        role: "presentation",
        className: styles$1v.TabContainer,
        ref: this.setNode
      }, markup);
    }
  }]);

  return Tab;
}(React.PureComponent);

function focusPanelID(panelID) {
  var panel = document.getElementById(panelID);

  if (panel) {
    panel.focus();
  }
}

var Tab$1 = withAppProvider()(Tab);

var TabMeasurer =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(TabMeasurer, _React$PureComponent);

  function TabMeasurer() {
    var _this;

    _classCallCheck(this, TabMeasurer);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(TabMeasurer).apply(this, arguments));
    _this.containerNode = null;

    _this.setContainerNode = function (node) {
      _this.containerNode = node;
    };

    _this.handleMeasurement = function () {
      if (_this.containerNode == null) {
        return;
      }

      var handleMeasurement = _this.props.handleMeasurement;
      var containerWidth = _this.containerNode.offsetWidth;
      var tabMeasurerNode = ReactDOM.findDOMNode(_assertThisInitialized(_assertThisInitialized(_this)));
      var hiddenTabNodes = tabMeasurerNode instanceof Element && tabMeasurerNode.children;
      var hiddenTabNodesArray = [].slice.call(hiddenTabNodes);
      var hiddenTabWidths = hiddenTabNodesArray.map(function (node) {
        return node.getBoundingClientRect().width;
      });
      var disclosureWidth = hiddenTabWidths.pop();
      handleMeasurement({
        containerWidth: containerWidth,
        disclosureWidth: disclosureWidth,
        hiddenTabWidths: hiddenTabWidths
      });
    };

    return _this;
  }

  _createClass(TabMeasurer, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.handleMeasurement();

      if (process.env.NODE_ENV === 'development') {
        // We need to defer the calculation in development so the
        // styles have time to be injected.
        setTimeout(this.handleMeasurement, 0);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.tabs !== this.props.tabs) {
        this.handleMeasurement();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          selected = _this$props.selected,
          tabs = _this$props.tabs,
          activator = _this$props.activator,
          tabToFocus = _this$props.tabToFocus,
          siblingTabHasFocus = _this$props.siblingTabHasFocus;
      var tabsMarkup = tabs.map(function (tab, index) {
        return React.createElement(Tab$1, {
          measuring: true,
          key: "".concat(index).concat(tab.id, "Hidden"),
          id: "".concat(tab.id, "Measurer"),
          siblingTabHasFocus: siblingTabHasFocus,
          focused: index === tabToFocus,
          selected: index === selected,
          onClick: other.noop,
          url: tab.url
        }, tab.content);
      });
      var classname = styles.classNames(styles$1v.Tabs, styles$1v.TabMeasurer);
      return React.createElement("div", {
        className: classname,
        ref: this.setContainerNode
      }, React.createElement(EventListener, {
        event: "resize",
        handler: this.handleMeasurement
      }), tabsMarkup, activator);
    }
  }]);

  return TabMeasurer;
}(React.PureComponent);

var Tabs =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Tabs, _React$PureComponent);

  function Tabs() {
    var _this;

    _classCallCheck(this, Tabs);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Tabs).apply(this, arguments));
    _this.state = {
      disclosureWidth: 0,
      containerWidth: Infinity,
      tabWidths: [],
      visibleTabs: [],
      hiddenTabs: [],
      showDisclosure: false,
      tabToFocus: -1
    };

    _this.handleKeyPress = function (event) {
      var _this$state = _this.state,
          tabToFocus = _this$state.tabToFocus,
          visibleTabs = _this$state.visibleTabs,
          hiddenTabs = _this$state.hiddenTabs;
      var tabsArrayInOrder = visibleTabs.concat(hiddenTabs);
      var key = event.key;
      var newFocus = tabsArrayInOrder.indexOf(tabToFocus);

      if (key === 'ArrowRight' || key === 'ArrowDown') {
        newFocus += 1;

        if (newFocus === tabsArrayInOrder.length) {
          newFocus = 0;
        }
      }

      if (key === 'ArrowLeft' || key === 'ArrowUp') {
        if (newFocus === -1 || newFocus === 0) {
          newFocus = tabsArrayInOrder.length - 1;
        } else {
          newFocus -= 1;
        }
      }

      _this.setState({
        showDisclosure: hiddenTabs.indexOf(tabsArrayInOrder[newFocus]) > -1,
        tabToFocus: tabsArrayInOrder[newFocus]
      });
    };

    _this.renderTabMarkup = function (tab, index) {
      var selected = _this.props.selected;
      var tabToFocus = _this.state.tabToFocus;
      return React.createElement(Tab$1, {
        key: "".concat(index, "-").concat(tab.id),
        id: tab.id,
        siblingTabHasFocus: tabToFocus > -1,
        focused: index === tabToFocus,
        selected: index === selected,
        onClick: _this.handleTabClick,
        panelID: tab.panelID || "".concat(tab.id, "-panel"),
        accessibilityLabel: tab.accessibilityLabel,
        url: tab.url
      }, tab.content);
    };

    _this.handleFocus = function (event) {
      var _this$props = _this.props,
          selected = _this$props.selected,
          tabs = _this$props.tabs; // If we are explicitly focusing one of the non-selected tabs, use it
      // move the focus to it

      var target$$1 = event.target;

      if (target$$1.classList.contains(styles$1v.Tab) || target$$1.classList.contains(styles$1v.Item)) {
        var tabToFocus = -1;
        tabs.every(function (tab, index) {
          if (tab.id === target$$1.id) {
            tabToFocus = index;
            return false;
          }

          return true;
        });

        _this.setState({
          tabToFocus: tabToFocus
        });

        return;
      }

      if (target$$1.classList.contains(styles$1v.DisclosureActivator)) {
        return;
      } // If we are coming in from somewhere other than another tab, focus the
      // selected tab, and the focus (click) is not on the disclosure activator,
      // focus the selected tab


      if (!event.relatedTarget) {
        _this.setState({
          tabToFocus: selected
        });

        return;
      }

      var relatedTarget = event.relatedTarget;

      if (!relatedTarget.classList.contains(styles$1v.Tab) && !relatedTarget.classList.contains(styles$1v.Item) && !relatedTarget.classList.contains(styles$1v.DisclosureActivator)) {
        _this.setState({
          tabToFocus: selected
        });
      }
    };

    _this.handleBlur = function (event) {
      // If we blur and the target is not another tab, forget the focus position
      if (event.relatedTarget == null) {
        _this.setState({
          tabToFocus: -1
        });

        return;
      }

      var target$$1 = event.relatedTarget; // If we are going to anywhere other than another tab, lose the last focused tab

      if (!target$$1.classList.contains(styles$1v.Tab) && !target$$1.classList.contains(styles$1v.Item)) {
        _this.setState({
          tabToFocus: -1
        });
      }
    };

    _this.handleDisclosureActivatorClick = function () {
      _this.setState(function (_ref) {
        var showDisclosure = _ref.showDisclosure;
        return {
          showDisclosure: !showDisclosure
        };
      });
    };

    _this.handleClose = function () {
      _this.setState({
        showDisclosure: false
      });
    };

    _this.handleMeasurement = function (measurements) {
      var _this$props2 = _this.props,
          tabs = _this$props2.tabs,
          selected = _this$props2.selected;
      var tabToFocus = _this.state.tabToFocus;
      var tabWidths = measurements.hiddenTabWidths,
          containerWidth = measurements.containerWidth,
          disclosureWidth = measurements.disclosureWidth;

      var _getVisibleAndHiddenT = getVisibleAndHiddenTabIndices(tabs, selected, disclosureWidth, tabWidths, containerWidth),
          visibleTabs = _getVisibleAndHiddenT.visibleTabs,
          hiddenTabs = _getVisibleAndHiddenT.hiddenTabs;

      _this.setState({
        tabToFocus: tabToFocus === -1 ? -1 : selected,
        visibleTabs: visibleTabs,
        hiddenTabs: hiddenTabs,
        disclosureWidth: disclosureWidth,
        containerWidth: containerWidth,
        tabWidths: tabWidths
      });
    };

    _this.handleTabClick = function (id) {
      var _this$props3 = _this.props,
          tabs = _this$props3.tabs,
          _this$props3$onSelect = _this$props3.onSelect,
          onSelect = _this$props3$onSelect === void 0 ? other.noop : _this$props3$onSelect;
      var tab = tabs.find(function (aTab) {
        return aTab.id === id;
      });

      if (tab == null) {
        return;
      }

      var selectedIndex = tabs.indexOf(tab);
      onSelect(selectedIndex);
    };

    return _this;
  }

  _createClass(Tabs, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props4 = this.props,
          tabs = _this$props4.tabs,
          selected = _this$props4.selected,
          fitted = _this$props4.fitted,
          children = _this$props4.children;
      var _this$state2 = this.state,
          tabToFocus = _this$state2.tabToFocus,
          visibleTabs = _this$state2.visibleTabs,
          hiddenTabs = _this$state2.hiddenTabs,
          showDisclosure = _this$state2.showDisclosure;
      var disclosureTabs = hiddenTabs.map(function (tabIndex) {
        return tabs[tabIndex];
      });
      var panelMarkup = children ? React.createElement(Panel, {
        id: tabs[selected].panelID || "".concat(tabs[selected].id, "-panel"),
        tabID: tabs[selected].id
      }, children) : null;
      var tabsMarkup = visibleTabs.sort(function (tabA, tabB) {
        return tabA - tabB;
      }).map(function (tabIndex) {
        return _this2.renderTabMarkup(tabs[tabIndex], tabIndex);
      });
      var disclosureActivatorVisible = visibleTabs.length < tabs.length;
      var classname = styles.classNames(styles$1v.Tabs, fitted && styles$1v.fitted, disclosureActivatorVisible && styles$1v.fillSpace);
      var disclosureTabClassName = styles.classNames(styles$1v.DisclosureTab, disclosureActivatorVisible && styles$1v['DisclosureTab-visible']);
      var activator = React.createElement("button", {
        tabIndex: -1,
        className: styles$1v.DisclosureActivator,
        onClick: this.handleDisclosureActivatorClick
      }, React.createElement(Icon$1, {
        source: polarisIcons.HorizontalDotsMinor
      }));
      return React.createElement("div", null, React.createElement("ul", {
        role: "tablist",
        className: classname,
        onFocus: this.handleFocus,
        onBlur: this.handleBlur,
        onKeyDown: handleKeyDown$2,
        onKeyUp: this.handleKeyPress
      }, tabsMarkup, React.createElement("li", {
        role: "presentation",
        className: disclosureTabClassName
      }, React.createElement(Popover, {
        preferredPosition: "below",
        activator: activator,
        active: disclosureActivatorVisible && showDisclosure,
        onClose: this.handleClose
      }, React.createElement(List, {
        focusIndex: hiddenTabs.indexOf(tabToFocus),
        disclosureTabs: disclosureTabs,
        onClick: this.handleTabClick,
        onKeyPress: this.handleKeyPress
      })))), React.createElement(TabMeasurer, {
        tabToFocus: tabToFocus,
        activator: activator,
        selected: selected,
        tabs: tabs,
        siblingTabHasFocus: tabToFocus > -1,
        handleMeasurement: this.handleMeasurement
      }), panelMarkup);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var disclosureWidth = prevState.disclosureWidth,
          tabWidths = prevState.tabWidths,
          containerWidth = prevState.containerWidth;

      var _getVisibleAndHiddenT2 = getVisibleAndHiddenTabIndices(nextProps.tabs, nextProps.selected, disclosureWidth, tabWidths, containerWidth),
          visibleTabs = _getVisibleAndHiddenT2.visibleTabs,
          hiddenTabs = _getVisibleAndHiddenT2.hiddenTabs;

      return {
        visibleTabs: visibleTabs,
        hiddenTabs: hiddenTabs,
        selected: nextProps.selected
      };
    }
  }]);

  return Tabs;
}(React.PureComponent);
Tabs.Panel = Panel;

function handleKeyDown$2(event) {
  var key = event.key;

  if (key === 'ArrowUp' || key === 'ArrowDown' || key === 'ArrowLeft' || key === 'ArrowRight') {
    event.preventDefault();
    event.stopPropagation();
  }
}

var styles$1w = {
  "Thumbnail": "Polaris-Thumbnail",
  "sizeSmall": "Polaris-Thumbnail--sizeSmall",
  "sizeMedium": "Polaris-Thumbnail--sizeMedium",
  "sizeLarge": "Polaris-Thumbnail--sizeLarge",
  "Image": "Polaris-Thumbnail__Image",
};

function Thumbnail(_ref) {
  var source = _ref.source,
      alt = _ref.alt,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'medium' : _ref$size;
  var className = styles.classNames(styles$1w.Thumbnail, size && styles$1w[styles.variationName('size', size)]);
  return React.createElement("span", {
    className: className
  }, React.createElement(Image, {
    alt: alt,
    source: source,
    className: styles$1w.Image
  }));
}

var createId = other.createUniqueIDFactory('Toast');
var Toast$1 =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Toast, _React$PureComponent);

  function Toast() {
    var _this;

    _classCallCheck(this, Toast);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Toast).apply(this, arguments));
    _this.id = createId();
    return _this;
  }

  _createClass(Toast, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var context = this.context,
          id = this.id,
          props = this.props;
      var error = props.error,
          content = props.content,
          _props$duration = props.duration,
          duration = _props$duration === void 0 ? DEFAULT_TOAST_DURATION : _props$duration,
          onDismiss = props.onDismiss;
      var appBridge = props.polaris.appBridge;

      if (appBridge == null) {
        context.frame.showToast(Object.assign({
          id: id
        }, props));
      } else {
        this.appBridgeToast = actions.Toast.create(appBridge, {
          message: content,
          duration: duration,
          isError: error
        });
        this.appBridgeToast.subscribe(actions.Toast.Action.CLEAR, onDismiss);
        this.appBridgeToast.dispatch(actions.Toast.Action.SHOW);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var appBridge = this.props.polaris.appBridge;

      if (appBridge == null) {
        this.context.frame.hideToast({
          id: this.id
        });
      } else if (this.appBridgeToast != null) {
        this.appBridgeToast.unsubscribe();
      }
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);

  return Toast;
}(React.PureComponent);
Toast$1.contextTypes = frameContextTypes;
var Toast$2 = withAppProvider()(Toast$1);

var styles$1x = {
  "DisplayText": "Polaris-SkeletonDisplayText__DisplayText",
  "sizeSmall": "Polaris-SkeletonDisplayText--sizeSmall",
  "sizeMedium": "Polaris-SkeletonDisplayText--sizeMedium",
  "sizeLarge": "Polaris-SkeletonDisplayText--sizeLarge",
  "sizeExtraLarge": "Polaris-SkeletonDisplayText--sizeExtraLarge",
};

function SkeletonDisplayText(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'medium' : _ref$size;
  var className = styles.classNames(styles$1x.DisplayText, size && styles$1x[styles.variationName('size', size)]);
  return React.createElement("div", {
    className: className
  });
}

var styles$1y = {
  "SkeletonBodyTextContainer": "Polaris-SkeletonBodyText__SkeletonBodyTextContainer",
  "SkeletonBodyText": "Polaris-SkeletonBodyText",
};

function SkeletonBodyText(_ref) {
  var _ref$lines = _ref.lines,
      lines = _ref$lines === void 0 ? 3 : _ref$lines;
  var bodyTextLines = [];

  for (var i = 0; i < lines; i++) {
    bodyTextLines.push(React.createElement("div", {
      className: styles$1y.SkeletonBodyText,
      key: i
    }));
  }

  return React.createElement("div", {
    className: styles$1y.SkeletonBodyTextContainer
  }, bodyTextLines);
}

var styles$1z = {
  "Page": "Polaris-SkeletonPage__Page",
  "fullWidth": "Polaris-SkeletonPage--fullWidth",
  "singleColumn": "Polaris-SkeletonPage--singleColumn",
  "Content": "Polaris-SkeletonPage__Content",
  "Header": "Polaris-SkeletonPage__Header",
  "Header-hasSecondaryActions": "Polaris-SkeletonPage__Header--hasSecondaryActions",
  "BreadcrumbAction": "Polaris-SkeletonPage__BreadcrumbAction",
  "TitleAndPrimaryAction": "Polaris-SkeletonPage__TitleAndPrimaryAction",
  "Title": "Polaris-SkeletonPage__Title",
  "PrimaryAction": "Polaris-SkeletonPage__PrimaryAction",
  "Actions": "Polaris-SkeletonPage__Actions",
  "Action": "Polaris-SkeletonPage__Action",
};

var SkeletonPage =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(SkeletonPage, _React$PureComponent);

  function SkeletonPage() {
    _classCallCheck(this, SkeletonPage);

    return _possibleConstructorReturn(this, _getPrototypeOf(SkeletonPage).apply(this, arguments));
  }

  _createClass(SkeletonPage, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          fullWidth = _this$props.fullWidth,
          singleColumn = _this$props.singleColumn,
          primaryAction = _this$props.primaryAction,
          secondaryActions = _this$props.secondaryActions,
          _this$props$title = _this$props.title,
          title = _this$props$title === void 0 ? '' : _this$props$title,
          breadcrumbs = _this$props.breadcrumbs;
      var className = styles.classNames(styles$1z.Page, fullWidth && styles$1z.fullWidth, singleColumn && styles$1z.singleColumn);
      var headerClassName = styles.classNames(styles$1z.Header, breadcrumbs && styles$1z['Header-hasBreadcrumbs'], secondaryActions && styles$1z['Header-hasSecondaryActions']);
      var titleMarkup = title !== null ? renderTitle(title) : null;
      var primaryActionMarkup = primaryAction ? React.createElement("div", {
        className: styles$1z.PrimaryAction
      }, React.createElement(SkeletonDisplayText, {
        size: "large"
      })) : null;
      var secondaryActionsMarkup = secondaryActions ? renderSecondaryActions(secondaryActions) : null;
      var breadcrumbMarkup = breadcrumbs ? React.createElement("div", {
        className: styles$1z.BreadcrumbAction,
        style: {
          width: 60
        }
      }, React.createElement(SkeletonBodyText, {
        lines: 1
      })) : null;
      var headerMarkup = !this.props.polaris.appBridge ? React.createElement("div", {
        className: headerClassName
      }, breadcrumbMarkup, React.createElement("div", {
        className: styles$1z.TitleAndPrimaryAction
      }, titleMarkup, primaryActionMarkup), secondaryActionsMarkup) : null;
      return React.createElement("div", {
        className: className,
        role: "status",
        "aria-label": "Page loading"
      }, headerMarkup, React.createElement("div", {
        className: styles$1z.Content
      }, children));
    }
  }]);

  return SkeletonPage;
}(React.PureComponent);

function renderSecondaryActions(actionCount) {
  var actions$$1 = [];

  for (var i = 0; i < actionCount; i++) {
    var width = Math.round(Math.random() * 40 + 60);
    actions$$1.push(React.createElement("div", {
      className: styles$1z.Action,
      style: {
        width: width
      },
      key: i
    }, React.createElement(SkeletonBodyText, {
      lines: 1
    })));
  }

  return React.createElement("div", {
    className: styles$1z.Actions
  }, actions$$1);
}

function renderTitle(title) {
  var titleContent = title === '' ? React.createElement(SkeletonDisplayText, {
    size: "large"
  }) : React.createElement(DisplayText, {
    size: "large",
    element: "h1"
  }, title);
  return React.createElement("div", {
    className: styles$1z.Title
  }, titleContent);
}

var SkeletongBodyText = withAppProvider()(SkeletonPage);

var styles$1A = {
  "SkeletonThumbnail": "Polaris-SkeletonThumbnail",
  "sizeSmall": "Polaris-SkeletonThumbnail--sizeSmall",
  "sizeMedium": "Polaris-SkeletonThumbnail--sizeMedium",
  "sizeLarge": "Polaris-SkeletonThumbnail--sizeLarge",
};

function SkeletonThumbnail(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'medium' : _ref$size;
  var className = styles.classNames(styles$1A.SkeletonThumbnail, size && styles$1A[styles.variationName('size', size)]);
  return React.createElement("div", {
    className: className
  });
}

var styles$1B = {
  "ProgressBar": "Polaris-ProgressBar",
  "sizeSmall": "Polaris-ProgressBar--sizeSmall",
  "sizeMedium": "Polaris-ProgressBar--sizeMedium",
  "sizeLarge": "Polaris-ProgressBar--sizeLarge",
  "Indicator": "Polaris-ProgressBar__Indicator",
  "fillup": "Polaris-ProgressBar--fillup",
  "Progress": "Polaris-ProgressBar__Progress",
  "Label": "Polaris-ProgressBar__Label",
};

function ProgressBar(_ref) {
  var _ref$progress = _ref.progress,
      progress = _ref$progress === void 0 ? 0 : _ref$progress,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'medium' : _ref$size,
      intl = _ref.polaris.intl;
  var className = styles.classNames(styles$1B.ProgressBar, size && styles$1B[styles.variationName('size', size)]);
  var warningMessage = intl.translate(progress < 0 ? 'Polaris.ProgressBar.negativeWarningMessage' : 'Polaris.ProgressBar.exceedWarningMessage', {
    progress: progress
  });
  var parsedProgress = parseProgress(progress, warningMessage);
  return React.createElement("div", {
    className: className
  }, React.createElement("progress", {
    className: styles$1B.Progress,
    value: parsedProgress,
    max: "100"
  }), React.createElement("div", {
    className: styles$1B.Indicator,
    style: {
      width: "".concat(parsedProgress, "%")
    }
  }, React.createElement("span", {
    className: styles$1B.Label
  }, parsedProgress, "%")));
}

function parseProgress(progress, warningMessage) {
  var progressWidth;

  if (progress < 0) {
    if (process.env.NODE_ENV === 'development') {
      // eslint-disable-next-line no-console
      console.warn(warningMessage);
    }

    progressWidth = 0;
  } else if (progress > 100) {
    if (process.env.NODE_ENV === 'development') {
      // eslint-disable-next-line no-console
      console.warn(warningMessage);
    }

    progressWidth = 100;
  } else {
    progressWidth = progress;
  }

  return progressWidth;
}

var ProgressBar$1 = withAppProvider()(ProgressBar);

exports.Months = dates.Months;
exports.contentContextTypes = contentContextTypes;
exports.AccountConnection = AccountConnection;
exports.ActionList = ActionList;
exports.AppProvider = AppProvider;
exports.polarisContextTypes = polarisAppProviderContextTypes;
exports.createAppProviderContext = createAppProviderContext;
exports.createPolarisContext = createPolarisContext;
exports.withAppProvider = withAppProvider;
exports.Autocomplete = Autocomplete$1;
exports.Avatar = Avatar$1;
exports.Badge = Badge$1;
exports.Banner = Banner;
exports.Backdrop = Backdrop;
exports.Breadcrumbs = Breadcrumbs;
exports.Button = Button$1;
exports.buttonFrom = buttonFrom;
exports.buttonsFrom = buttonsFrom;
exports.ButtonGroup = ButtonGroup;
exports.CalloutCard = CalloutCard;
exports.Caption = Caption;
exports.Card = Card;
exports.Checkbox = Checkbox$2;
exports.ChoiceList = ChoiceList$1;
exports.Collapsible = Collapsible$1;
exports.ColorPicker = ColorPicker;
exports.rgbToHex = rgbToHex;
exports.rgbToHsb = rgbToHsb;
exports.rgbToHsl = rgbToHsl;
exports.hsbToRgb = hsbToRgb;
exports.hsbToHex = hsbToHex;
exports.rgbString = rgbString;
exports.rgbaString = rgbaString;
exports.Connected = Connected;
exports.ContextualSaveBar = ContextualSaveBar$2;
exports.DataTable = DataTable$1;
exports.DatePicker = DatePicker$1;
exports.DescriptionList = DescriptionList;
exports.DisplayText = DisplayText;
exports.DropZone = DropZone$1;
exports.EmptySearchResult = EmptySearchResult$1;
exports.EmptyState = EmptyState;
exports.EventListener = EventListener;
exports.ExceptionList = ExceptionList;
exports.Focus = Focus;
exports.TrapFocus = TrapFocus;
exports.FooterHelp = FooterHelp;
exports.Form = Form;
exports.FormLayout = FormLayout;
exports.Frame = Frame$1;
exports.DEFAULT_TOAST_DURATION = DEFAULT_TOAST_DURATION;
exports.DEFAULT_TOAST_DURATION_WITH_ACTION = DEFAULT_TOAST_DURATION_WITH_ACTION;
exports.Heading = Heading;
exports.Icon = Icon$1;
exports.Image = Image;
exports.InlineError = InlineError;
exports.KeyboardKey = KeyboardKey;
exports.KeypressListener = KeypressListener;
exports.Label = Label;
exports.Labelled = Labelled;
exports.Layout = Layout;
exports.Link = Link$2;
exports.List = ContentList;
exports.Loading = Loading$2;
exports.Modal = Modal$1;
exports.OptionList = OptionList$1;
exports.Navigation = Navigation$2;
exports.isNavigationItemActive = isNavigationItemActive;
exports.Page = Page$1;
exports.PageActions = PageActions;
exports.Pagination = Pagination$1;
exports.Popover = Popover;
exports.Portal = Portal;
exports.RadioButton = RadioButton;
exports.RangeSlider = RangeSlider$1;
exports.ResourceList = ResourceList$1;
exports.ResourcePicker = ResourcePicker$1;
exports.Scrollable = Scrollable$1;
exports.ScrollLock = ScrollLock$1;
exports.Select = Select;
exports.SettingToggle = SettingToggle;
exports.Spinner = Spinner$1;
exports.Stack = Stack;
exports.Sticky = Sticky;
exports.Subheading = Subheading;
exports.Tabs = Tabs;
exports.Tag = Tag$1;
exports.TextContainer = TextContainer;
exports.TextField = TextField$1;
exports.TextStyle = TextStyle;
exports.Thumbnail = Thumbnail;
exports.ThemeProvider = ThemeProvider;
exports.Toast = Toast$2;
exports.Tooltip = Tooltip;
exports.TopBar = TopBar$1;
exports.Truncate = Truncate;
exports.UnstyledLink = UnstyledLink$1;
exports.VisuallyHidden = VisuallyHidden;
exports.SkeletonPage = SkeletongBodyText;
exports.SkeletonBodyText = SkeletonBodyText;
exports.SkeletonDisplayText = SkeletonDisplayText;
exports.SkeletonThumbnail = SkeletonThumbnail;
exports.ProgressBar = ProgressBar$1;
exports.Indicator = Indicator;
exports.withContext = withContext;
exports.withRef = withRef;
exports.DATA_ATTRIBUTE = DATA_ATTRIBUTE;
