import * as React from 'react';
import { ClientApplication } from '@shopify/app-bridge';
import Intl from '../Intl';
import Link from '../Link';
import { StickyManager } from '../withSticky';
import ScrollLockManager from '../ScrollLockManager';
import { ThemeContext } from '../../../ThemeProvider';
export interface WithAppProviderProps {
    polaris: {
        intl: Intl;
        link: Link;
        stickyManager: StickyManager;
        scrollLockManager: ScrollLockManager;
        theme: ThemeContext;
        appBridge: ClientApplication<{}>;
        subscribe(callback: () => void): void;
        unsubscribe(callback: () => void): void;
    };
}
export default function withAppProvider<OwnProps>(): <C>(WrappedComponent: (React.ComponentClass<OwnProps & WithAppProviderProps, React.ComponentState> & C) | (React.StatelessComponent<OwnProps & WithAppProviderProps> & C)) => React.ComponentClass<OwnProps, React.ComponentState> & C;
