import * as React from 'react';
import { ActionListItemDescriptor } from '../../types';
import { WithAppProviderProps } from '../AppProvider';
import { PreferredPosition } from '../PositionedOverlay';
import { OptionDescriptor } from '../OptionList';
import { Props as TextFieldProps } from '../TextField';
import { ComboBox } from './components';
export interface Props {
    /** A unique identifier for the Autocomplete */
    id?: string;
    /** Collection of options to be listed */
    options: OptionDescriptor[];
    /** The selected options */
    selected: string[];
    /** The text field component attached to the list of options */
    textField: React.ReactElement<any>;
    /** The preferred direction to open the popover */
    preferredPosition?: PreferredPosition;
    /** Title of the list of options */
    listTitle?: string;
    /** Allow more than one option to be selected */
    allowMultiple?: boolean;
    /** An action to render above the list of options */
    actionBefore?: ActionListItemDescriptor;
    /** Display loading state */
    loading?: boolean;
    /** Indicates if more results will load dynamically */
    willLoadMoreResults?: boolean;
    /** Is rendered when there are no options */
    emptyState?: React.ReactNode;
    /** Callback when the selection of options is changed */
    onSelect(selected: string[]): void;
    /** Callback when the end of the list is reached */
    onLoadMoreResults?(): void;
}
export declare type CombinedProps = Props & WithAppProviderProps;
declare function TextField(props: TextFieldProps): JSX.Element;
export declare class Autocomplete extends React.PureComponent<CombinedProps, never> {
    static TextField: typeof TextField;
    static ComboBox: typeof ComboBox;
    render(): JSX.Element;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Autocomplete;
export default _default;
