import * as React from 'react';
import { OptionDescriptor } from '../../../OptionList';
import { PreferredPosition } from '../../../PositionedOverlay';
import { ActionListItemDescriptor } from '../../../../types';
import { TextField } from './components';
export interface State {
    comboBoxId: string;
    selectedOption?: OptionDescriptor | ActionListItemDescriptor | undefined;
    selectedIndex: number;
    selectedOptions: string[];
    navigableOptions: (OptionDescriptor | ActionListItemDescriptor)[];
    popoverActive: boolean;
    popoverWasActive: boolean;
}
export interface Props {
    /** A unique identifier for the ComboBox */
    id?: string;
    /** Collection of options to be listed */
    options: OptionDescriptor[];
    /** The selected options */
    selected: string[];
    /** The text field component attached to the list of options */
    textField: React.ReactElement<any>;
    /** The preferred direction to open the popover */
    preferredPosition?: PreferredPosition;
    /** Title of the list of options */
    listTitle?: string;
    /** Allow more than one option to be selected */
    allowMultiple?: boolean;
    /** Actions to be displayed before the list of options */
    actionsBefore?: ActionListItemDescriptor[];
    /** Actions to be displayed after the list of options */
    actionsAfter?: ActionListItemDescriptor[];
    /** Content to be displayed before the list of options */
    contentBefore?: React.ReactNode;
    /** Content to be displayed after the list of options */
    contentAfter?: React.ReactNode;
    /** Is rendered when there are no options */
    emptyState?: React.ReactNode;
    /** Callback when the selection of options is changed */
    onSelect(selected: string[]): void;
    /** Callback when the end of the list is reached */
    onEndReached?(): void;
}
export interface Context {
    comboBoxId: string;
    selectedOptionId?: string;
    subscribe(callback: () => void): void;
    unsubscribe(callback: () => void): void;
}
export default class ComboBox extends React.PureComponent<Props, State> {
    static TextField: typeof TextField;
    static OptionList: React.ComponentClass<import("../../../OptionList/OptionList").Props, React.ComponentState> & typeof import("../../../OptionList/OptionList").OptionList;
    static childContextTypes: React.ValidationMap<any>;
    static getDerivedStateFromProps({ options: nextOptions, selected: nextSelected, actionsBefore: nextActionsBefore, actionsAfter: nextActionsAfter, }: Props, { navigableOptions, selectedOptions, comboBoxId }: State): {
        navigableOptions: (ActionListItemDescriptor | OptionDescriptor)[];
        selectedOptions: string[];
    } | {
        navigableOptions: (ActionListItemDescriptor | OptionDescriptor)[];
        selectedOptions?: undefined;
    } | {
        selectedOptions: string[];
        navigableOptions?: undefined;
    } | null;
    state: State;
    private subscriptions;
    getChildContext(): Context;
    componentDidMount(): void;
    componentDidUpdate(_: Props, prevState: State): void;
    getComboBoxId(): string;
    render(): JSX.Element;
    subscribe: (callback: () => void) => void;
    unsubscribe: (callback: () => void) => void;
    private handleDownArrow;
    private handleUpArrow;
    private handleEnter;
    private handleFocus;
    private handleBlur;
    private handleClick;
    private handleSelection;
    private selectOptions;
    private updateIndexOfSelectedOption;
    private resetVisuallySelectedOptions;
    private handlePopoverClose;
    private handlePopoverOpen;
    private selectNextOption;
    private selectPreviousOption;
    private selectOptionAtIndex;
    private visuallyUpdateSelectedOption;
    private readonly selectedOptionId;
}
