import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
export declare type Size = 'small' | 'medium' | 'large';
export interface Props {
    /**
     * Size of avatar
     * @default 'medium'
     */
    size?: Size;
    /** The name of the person */
    name?: string;
    /** Initials of person to display */
    initials?: string;
    /** Whether the avatar is for a customer */
    customer?: boolean;
    /** URL of the avatar image which falls back to initials if the image fails to load */
    source?: string;
    /** Accessible label for the avatar image */
    accessibilityLabel?: string;
}
export interface State {
    hasError: boolean;
    hasLoaded: boolean;
    prevSource?: string;
}
export declare type CombinedProps = Props & WithAppProviderProps;
export declare class Avatar extends React.PureComponent<CombinedProps, State> {
    static getDerivedStateFromProps(props: Props, state: State): {
        prevSource: string | undefined;
        hasError: boolean;
        hasLoaded: boolean;
    } | null;
    state: State;
    render(): JSX.Element;
    handleError: () => void;
    handleLoad: () => void;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Avatar;
export default _default;
