import * as React from 'react';
import { Action, DisableableAction, LoadableAction } from '../../types';
import { Props as IconProps } from '../Icon';
export declare type Status = 'success' | 'info' | 'warning' | 'critical';
export interface Props {
    /** Title content for the banner. */
    title?: string;
    /** Icon to display in the banner. Use only major, duotone icons */
    icon?: IconProps['source'];
    /** Sets the status of the banner. */
    status?: Status;
    /** The child elements to render in the banner. */
    children?: React.ReactNode;
    /** Action for banner */
    action?: DisableableAction & LoadableAction;
    /** Action | Displays a secondary action */
    secondaryAction?: Action;
    /** Callback when banner is dismissed */
    onDismiss?(): void;
}
export default class Banner extends React.PureComponent<Props, never> {
    static contextTypes: React.ValidationMap<any>;
    private wrapper;
    focus(): void;
    render(): JSX.Element;
}
