import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
import { Props as IconProps } from '../Icon';
export declare type Size = 'slim' | 'medium' | 'large';
export declare type IconSource = IconProps['source'];
export interface Props {
    /** The content to display inside the button */
    children?: string | string[];
    /** A destination to link to, rendered in the href attribute of a link */
    url?: string;
    /** A unique identifier for the button */
    id?: string;
    /** Provides extra visual weight and identifies the primary action in a set of buttons */
    primary?: boolean;
    /** Indicates a dangerous or potentially negative action */
    destructive?: boolean;
    /** Disables the button, disallowing merchant interaction */
    disabled?: boolean;
    /** Replaces button text with a spinner while a background action is being performed */
    loading?: boolean;
    /**
     * Changes the size of the button, giving it more or less padding
     * @default 'medium'
     */
    size?: Size;
    /** Gives the button a subtle alternative to the default button styling, appropriate for certain backdrops */
    outline?: boolean;
    /** Allows the button to grow to the width of its container */
    fullWidth?: boolean;
    /** Displays the button with a disclosure icon */
    disclosure?: boolean;
    /** Allows the button to submit a form */
    submit?: boolean;
    /** Renders a button that looks like a link */
    plain?: boolean;
    /** Makes `plain` and `outline` Button colors (text, borders, icons) the same as the current text color. Also adds an underline to `plain` Buttons */
    monochrome?: boolean;
    /** Forces url to open in a new tab */
    external?: boolean;
    /** Tells the browser to download the url instead of opening it. Provides a hint for the downloaded filename if it is a string value. */
    download?: string | boolean;
    /** Icon to display to the left of the button content */
    icon?: React.ReactNode | IconSource;
    /** Visually hidden text for screen readers */
    accessibilityLabel?: string;
    /** Id of the element the button controls */
    ariaControls?: string;
    /** Tells screen reader the controlled element is expanded */
    ariaExpanded?: boolean;
    /** Tells screen reader the element is pressed */
    ariaPressed?: boolean;
    /** Callback when clicked */
    onClick?(): void;
    /** Callback when button becomes focussed */
    onFocus?(): void;
    /** Callback when focus leaves button */
    onBlur?(): void;
    /** Callback when a keypress event is registered on the button */
    onKeyPress?(event: React.KeyboardEvent<HTMLButtonElement>): void;
    /** Callback when a keyup event is registered on the button */
    onKeyUp?(event: React.KeyboardEvent<HTMLButtonElement>): void;
    /** Callback when a keydown event is registered on the button */
    onKeyDown?(event: React.KeyboardEvent<HTMLButtonElement>): void;
}
export declare type CombinedProps = Props & WithAppProviderProps;
declare function Button({ id, url, disabled, loading, children, accessibilityLabel, ariaControls, ariaExpanded, ariaPressed, onClick, onFocus, onBlur, onKeyDown, onKeyPress, onKeyUp, external, download, icon, primary, outline, destructive, disclosure, plain, monochrome, submit, size, fullWidth, polaris: { intl }, }: CombinedProps): JSX.Element;
export declare function IconWrapper({ children }: any): JSX.Element;
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Button;
export default _default;
